#include <windows.h>
#include <stdio.h>
#include "appmain.h"
#include "dxproto.h"
#include "appfuncs.h"

DXDevice        Dev;
WINAPP			WinApp;

int RenderLoop(DXDevice *Dv);
int InitApp(DXDevice *Dv);

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInst, LPSTR cmdString, int cmdShow)
{
	HWND        MainWnd;
	MSG         msg;
	WNDCLASS    WndClass;
	
	WinApp.hInstance = hInstance;
	WinApp.hPrevInst = hPrevInst;
	WinApp.cmdShow   = cmdShow;

	WndClass.style          = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc    = WndProc;
	WndClass.cbClsExtra     = 0;
	WndClass.cbWndExtra     = 0;
	WndClass.hInstance      = hInstance;
	WndClass.hIcon          = LoadIcon(WinApp.hInstance, IDI_APPLICATION);
	WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
	WndClass.hbrBackground  = (HBRUSH)(GetStockObject(BLACK_BRUSH));
	WndClass.lpszMenuName   = NULL;
	WndClass.lpszClassName  = "MAINWND";
	RegisterClass(&WndClass);

	MainWnd = CreateWindowEx(
				WS_EX_TOPMOST,
				"MAINWND",
				"Direct3D Engine",
				WS_POPUP,
		        0,
				0,
				GetSystemMetrics(SM_CXSCREEN),
				GetSystemMetrics(SM_CYSCREEN),
				NULL,
				NULL,
				hInstance,
				NULL);
	ShowWindow(MainWnd, SW_MAXIMIZE);
	UpdateWindow(MainWnd);
	
    if(!InitDDInterface(MainWnd, &Dev))
        return FALSE;
	InitD3DInterface(&Dev);

	Dev.NumTextures = 0;
	InitScene(&Dev);
	InitApp(&Dev);

	for (;;)
	{
		if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			if(msg.message == WM_QUIT)
				break;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
            RenderLoop(&Dev);
		}
	}
	cmdString = cmdString;
    return 0;
};

LRESULT CALLBACK _export WndProc(HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_SETCURSOR:
			ShowCursor(NULL);
			return 0;
		case WM_COMMAND:
			return(DefWindowProc(hWindow, message, wParam, lParam));
		case WM_CLOSE:
		case WM_DESTROY:
			ReleaseView(Dev.lpD3DViewport);
			ReleaseScene(&Dev);
			EndD3DInterface(&Dev);
			EndDDInterface(&Dev);
			PostQuitMessage(0);
			return 0;
		default:
			return(DefWindowProc(hWindow, message, wParam, lParam));
	}
};

int RenderLoop(DXDevice *Dv)
{
	D3DRECT DirtyR;
	
	DirtyR = RenderScene(Dv->lpD3DDevice, Dv->lpD3DViewport);
	PageFlip(Dv);
	ClearViewport(Dv, &DirtyR);
    return TRUE;
};

int InitApp(DXDevice *Dv)
{
	D3DRECT r;

	SetRenderParms(Dv);
	InitView(Dv->lpDD, Dv->lpD3D, Dv->lpD3DDevice, Dv->lpD3DViewport,
			 Dv->NumTextures - 1, Dv->TextureHandle);
	r.x1 = 0;		 
	r.y1 = 0;		 
	r.x2 = Dv->Mode.Width;
	r.y2 = Dv->Mode.Height;
	ClearViewport(Dv, &r);
    return TRUE;
};
