#include <windows.h>
#include <ddraw.h>
#include "dxproto.h"
#include "d3dmacs.h"

D3DVALUE FogStart, FogEnd;

HRESULT PageFlip(DXDevice *Dev)
{
	HRESULT Result;

	while(1)
    {
		Result = Dev->lpFrontBuffer->lpVtbl->Flip(Dev->lpFrontBuffer,
												  NULL,
												  0);
        if(Result == DDERR_SURFACELOST )
        {
			Dev->lpFrontBuffer->lpVtbl->Restore(Dev->lpFrontBuffer);
			Dev->lpBackBuffer->lpVtbl->Restore(Dev->lpBackBuffer);
			break;
		}
		else
        {
            break;
        }
    }

	return Result;
};

HRESULT ClearViewport(DXDevice *Dev, LPD3DRECT dirtyr)
{
	HRESULT Result;
	D3DRECT r;

	r = *dirtyr;
	Result = Dev->lpD3DViewport->lpVtbl->Clear(Dev->lpD3DViewport,
											   1, &r,
											   D3DCLEAR_TARGET |
											   D3DCLEAR_ZBUFFER);
	return Result;
};

BOOL SetRenderParms(DXDevice *Dev)
{
	HRESULT Result;
	D3DEXECUTEBUFFERDESC debDesc;
    D3DEXECUTEDATA d3dExData;
    LPDIRECT3DEXECUTEBUFFER lpD3DExCmdBuf = NULL;
    LPVOID lpBuffer, lpInsStart;
    size_t size;

    if(!Dev->lpD3DViewport)
        return TRUE;

	FogStart = D3DVAL(160.0);
	FogEnd = D3DVAL(210.0);
    size = 0;
    size += sizeof(D3DINSTRUCTION) * 3;
    size += sizeof(D3DSTATE) * 21;
    memset(&debDesc, 0, sizeof(D3DEXECUTEBUFFERDESC));
    debDesc.dwSize = sizeof(D3DEXECUTEBUFFERDESC);
    debDesc.dwFlags = D3DDEB_BUFSIZE;
    debDesc.dwBufferSize = size;
    Result = Dev->lpD3DDevice->lpVtbl->CreateExecuteBuffer(Dev->lpD3DDevice,
             	                                  		   &debDesc,
													  	   &lpD3DExCmdBuf,
													  	   NULL);
    if(Result != D3D_OK)
    {
		MessageBox(GetFocus(), "Cannot Create Execute Buffer",
				   "CRITICAL ERROR", MB_OK | MB_ICONEXCLAMATION);
		return FALSE;
	}

    Result = lpD3DExCmdBuf->lpVtbl->Lock(lpD3DExCmdBuf, &debDesc);
    if(Result != D3D_OK)
    {
		MessageBox(GetFocus(), "Cannot Lock Execute Buffer",
				   "CRITICAL ERROR", MB_OK | MB_ICONEXCLAMATION);
		lpD3DExCmdBuf->lpVtbl->Release(lpD3DExCmdBuf);
		return FALSE;
	}

    memset(debDesc.lpData, 0, size);
    lpInsStart = debDesc.lpData;
    lpBuffer = lpInsStart;

    OP_STATE_RENDER(16, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_MODULATEALPHA, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_SHADEMODE, D3DSHADE_GOURAUD, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_BLENDENABLE, TRUE, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_STIPPLEDALPHA, FALSE, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_ZENABLE, TRUE, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_ZWRITEENABLE, TRUE, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_ZFUNC, D3DCMP_LESS, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_TEXTUREMAG, D3DFILTER_NEAREST, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_TEXTUREMIN, D3DFILTER_NEAREST, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_FILLMODE, D3DFILL_SOLID, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_DITHERENABLE, TRUE, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_SPECULARENABLE, TRUE, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_ANTIALIAS, FALSE, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_FOGENABLE, FALSE, lpBuffer);
      STATE_DATA(D3DRENDERSTATE_FOGCOLOR, RGB_MAKE(0, 0, 0), lpBuffer);

    OP_STATE_LIGHT(5, lpBuffer);
      STATE_DATA(D3DLIGHTSTATE_FOGMODE, D3DFOG_LINEAR, lpBuffer);
      STATE_DATA(D3DLIGHTSTATE_COLORMODEL, D3DCOLOR_RGB, lpBuffer);
      STATE_DATA(D3DLIGHTSTATE_FOGSTART, *(unsigned long *)&FogStart, lpBuffer);
      STATE_DATA(D3DLIGHTSTATE_FOGEND, *(unsigned long *)&FogEnd, lpBuffer);
      STATE_DATA(D3DLIGHTSTATE_AMBIENT, RGBA_MAKE(40, 40, 40, 40), lpBuffer);
    OP_EXIT(lpBuffer);

    Result = lpD3DExCmdBuf->lpVtbl->Unlock(lpD3DExCmdBuf);
    if(Result != D3D_OK)
    {
		MessageBox(GetFocus(), "Cannot Unlock Execute Buffer",
				   "CRITICAL ERROR", MB_OK | MB_ICONEXCLAMATION);
		lpD3DExCmdBuf->lpVtbl->Release(lpD3DExCmdBuf);
		return FALSE;
	}

    memset(&d3dExData, 0, sizeof(D3DEXECUTEDATA));
    d3dExData.dwSize = sizeof(D3DEXECUTEDATA);
    d3dExData.dwInstructionOffset = (ULONG) 0;
    d3dExData.dwInstructionLength = (ULONG) ((char*)lpBuffer -
                                                          (char*)lpInsStart);
    lpD3DExCmdBuf->lpVtbl->SetExecuteData(lpD3DExCmdBuf, &d3dExData);
    Result = Dev->lpD3DDevice->lpVtbl->BeginScene(Dev->lpD3DDevice);
    if(Result != D3D_OK)
    {
		MessageBox(GetFocus(), "Cannot Begin Scene",
				   "CRITICAL ERROR", MB_OK | MB_ICONEXCLAMATION);
		lpD3DExCmdBuf->lpVtbl->Release(lpD3DExCmdBuf);
		return FALSE;
	}
    Result = Dev->lpD3DDevice->lpVtbl->Execute(Dev->lpD3DDevice,
                                               lpD3DExCmdBuf,
                                               Dev->lpD3DViewport,
                                               D3DEXECUTE_UNCLIPPED);
    if(Result != D3D_OK)
    {
		MessageBox(GetFocus(), "Cannot Execute Buffer",
				   "CRITICAL ERROR", MB_OK | MB_ICONEXCLAMATION);
		lpD3DExCmdBuf->lpVtbl->Release(lpD3DExCmdBuf);
		return FALSE;
	}

	Result = Dev->lpD3DDevice->lpVtbl->EndScene(Dev->lpD3DDevice);
    if(Result != D3D_OK)
    {
		MessageBox(GetFocus(), "Cannot End Scene",
				   "CRITICAL ERROR", MB_OK | MB_ICONEXCLAMATION);
		lpD3DExCmdBuf->lpVtbl->Release(lpD3DExCmdBuf);
		return FALSE;
	}

    lpD3DExCmdBuf->lpVtbl->Release(lpD3DExCmdBuf);

	return Result;
};

BOOL LoadPPMTexture(DXDevice *Dev, char *file)
{
	lstrcpy(Dev->TextureFile[Dev->NumTextures], file);
	LoadTextureSurf(Dev, Dev->NumTextures);
	GetTextureHandle(Dev, Dev->NumTextures);
	Dev->NumTextures++;
	return TRUE;
};
