#ifndef DXPROTO_H
#define DXPROTO_H

#define INITGUID
#include <windows.h>
#include <ddraw.h>
#include "d3d.h"

#ifdef __cplusplus
	#define PREFIX extern "C"
#else
	#define PREFIX
#endif

#define MAX_TEXTURES 10

typedef struct
{
	WORD		Width;
	WORD		Height;
	BYTE		BPP;
	BYTE		Dev3D;
	DWORD		RedShift;
	DWORD		GreenShift;
	DWORD		BlueShift;
} DDMODE;

typedef struct
{
	GUID			Guid;
	D3DDEVICEDESC	Desc;
	BOOL			bHardware;
	BOOL			bTextureMap;
	BOOL			bZBuffer;
} D3DDEVICE;

typedef struct
{
	DDSURFACEDESC	Desc;
	BYTE			BPP;
	BYTE			RBPP;
	BYTE			GBPP;
	BYTE			BBPP;
	BYTE			ABPP;
} TEXTUREDESC;

typedef struct
{
// The handle of the application's window
    HWND                hWindow;

// Objects needed for the creation of the DirectDraw side of the interface
	DDMODE				Mode;
    LPDIRECTDRAW        lpDD;
    LPDIRECTDRAWSURFACE lpFrontBuffer;
    LPDIRECTDRAWSURFACE lpBackBuffer;

// Objects needed for the creation of the Direct3D side of the interface
	D3DDEVICE			D3DDevice;
	LPDIRECT3D          lpD3D;
    LPDIRECT3DDEVICE    lpD3DDevice;
    LPDIRECT3DVIEWPORT  lpD3DViewport;
    LPDIRECTDRAWSURFACE lpZBuffer;

    DWORD               NumTextures;
    TEXTUREDESC			TextureDesc;
	char				TextureFile[MAX_TEXTURES][255];
    D3DTEXTUREHANDLE    TextureHandle[MAX_TEXTURES];
    LPDIRECTDRAWSURFACE TextureSurface[MAX_TEXTURES];
    LPDIRECT3DTEXTURE   D3DTexture[MAX_TEXTURES];

} DXDevice;

/*
// Initializes the DirectDraw aspect of our application.  It creates the
// Front and Back buffers as well as polling the system for available
// display modes.
*/
PREFIX int InitDDInterface(HWND hWnd, DXDevice *Dev);

/*
// Ends the DirectDraw aspect of our application.  It kills everything
// created by the call to InitDDInterface.
*/
PREFIX int EndDDInterface(DXDevice *Dev);

/*
// Initializes the Direct3D aspect of our application (if used).  It
// creates the devices, objects and viewport(s) associated with a
// Direct3D application.
*/
PREFIX int InitD3DInterface(DXDevice *Dev);

/*
// Ends the Direct3D interface objects created by the call to
// InitD3DInterface.  As such it frees the z-buffer and viewport and other
// such created items.
*/
PREFIX int EndD3DInterface(DXDevice *Dev);

/*
// This function polls the system collecting information about available
// display modes.  It is the callback function for EnumDisplayModes.
*/
PREFIX HRESULT CALLBACK
	DDModeCallback(LPDDSURFACEDESC lpSurfaceDesc, LPVOID lpVoid);

/*
// This function loops through the enumerated display modes and picks the
// one we define.  If it is not available, it selects the first available
// mode.
*/
PREFIX int ChooseMode(DXDevice *Dev);

/*
// This function loops through the enumerated D3D devices and picks the
// best one.  It looks for a hardware mode first, basing the decision on
// what features the device has.
*/
PREFIX int ChooseDevice(DXDevice *Dev);

/*
// This function is a callback function that determines the available
// direct draw hardware devices installed.  It searches for hardware
// capable of 3D in 640 x 480 x 16 bit color.  If this criteria is not
// met, then the HEL is chosen by default.
*/
PREFIX BOOL CALLBACK
	DDDeviceCallback(GUID FAR *lpGUID, LPSTR lpDriverDesc,
					 LPSTR lpDriverName, LPVOID lpContext);

/*
// This is the callback function that determines the available D3D devices
// on the system.  This gathers info about each devices and stores them in
// an array.  Later we will choose which device to use.
*/
PREFIX HRESULT CALLBACK
	D3DDeviceCallback(LPGUID lpGuid, LPSTR lpDDescription,
					  LPSTR lpDName, LPD3DDEVICEDESC lpHWDesc,
					  LPD3DDEVICEDESC lpHELDesc, LPVOID lpContext);

/*
// This is the callback function that determines the available texture
// formats for a given D3D device.  The formats are stored in a global
// array.
*/
PREFIX HRESULT CALLBACK
	EnumTextures(LPDDSURFACEDESC lpDesc, LPVOID lpContext);

// Flips the front and back buffers
PREFIX HRESULT PageFlip(DXDevice *Dev);
// Clears the viewport
PREFIX HRESULT ClearViewport(DXDevice *Dev, LPD3DRECT DirtyR);
// Sets the render state
PREFIX BOOL SetRenderParms(DXDevice *Dev);
// Chooses from the texture formats
PREFIX void ChooseTextureFormat(DXDevice *Dev);
PREFIX BOOL LoadTextureSurf(DXDevice *Dev, int n);
PREFIX BOOL ReloadTextureSurf(DXDevice *Dev, int n);
PREFIX BOOL GetTextureHandle(DXDevice *Dev, int n);
PREFIX void ReleaseTexture(DXDevice *Dev, int n);
PREFIX void ReleaseAllTextures(DXDevice *Dev);
PREFIX BOOL LoadAllTextures(DXDevice *Dev);
PREFIX LPDIRECTDRAWSURFACE LoadSurface(LPDIRECTDRAW lpDD, LPCSTR lpName,
                        	  		   LPDDSURFACEDESC lpFormat, DWORD memoryflag);
PREFIX BOOL LoadPPMTexture(DXDevice *Dev, char *file);

#endif
