#include <windows.h>
#include <ddraw.h>
#include <stdio.h>
#include "d3d.h"
#include "dxproto.h"
#include "d3dmacs.h"

BOOL LoadTextureSurf(DXDevice *Dev, int n)
{
    DDSURFACEDESC ddsd;
    LPDIRECTDRAWSURFACE lpSrcTextureSurf = NULL;
    LPDIRECT3DTEXTURE lpSrcTexture = NULL;

    RELEASE(Dev->TextureSurface[n]);
	lpSrcTextureSurf = LoadSurface(Dev->lpDD, Dev->TextureFile[n],
                                   &Dev->TextureDesc.Desc,
                                   DDSCAPS_SYSTEMMEMORY);
    lpSrcTextureSurf->lpVtbl->QueryInterface(lpSrcTextureSurf,
                                             &IID_IDirect3DTexture,
                                             (LPVOID*)&lpSrcTexture);
    memset(&ddsd, 0, sizeof(DDSURFACEDESC));
    ddsd.dwSize = sizeof(DDSURFACEDESC);
    lpSrcTextureSurf->lpVtbl->GetSurfaceDesc(lpSrcTextureSurf, &ddsd);

    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_PIXELFORMAT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_TEXTURE | DDSCAPS_ALLOCONLOAD;

    Dev->lpDD->lpVtbl->CreateSurface(Dev->lpDD, &ddsd,
                                     &Dev->TextureSurface[n], NULL);

    Dev->TextureSurface[n]->lpVtbl->QueryInterface(Dev->TextureSurface[n],
    		                                         &IID_IDirect3DTexture,
		                                             (LPVOID*)&Dev->D3DTexture[n]);
    Dev->D3DTexture[n]->lpVtbl->Load(Dev->D3DTexture[n], lpSrcTexture);

    RELEASE(lpSrcTexture);
    RELEASE(lpSrcTextureSurf);
    return TRUE;
}

BOOL ReloadTextureSurf(DXDevice *Dev, int n)
{
    LPDIRECTDRAWSURFACE lpSrcTextureSurf = NULL;
    LPDIRECT3DTEXTURE lpSrcTexture = NULL;

    lpSrcTextureSurf = LoadSurface(Dev->lpDD, Dev->TextureFile[n],
                                   &Dev->TextureDesc.Desc,
                                   DDSCAPS_SYSTEMMEMORY);
    lpSrcTextureSurf->lpVtbl->QueryInterface(lpSrcTextureSurf,
                                             &IID_IDirect3DTexture,
                                             (LPVOID*)&lpSrcTexture);

    Dev->D3DTexture[n]->lpVtbl->Load(Dev->D3DTexture[n], lpSrcTexture);

    RELEASE(lpSrcTexture);
    RELEASE(lpSrcTextureSurf);

    return TRUE;
}

BOOL GetTextureHandle(DXDevice *Dev, int n)
{
    Dev->D3DTexture[n]->lpVtbl->GetHandle(Dev->D3DTexture[n],
    				                     Dev->lpD3DDevice,
										 &Dev->TextureHandle[n]);
    return TRUE;
}

void ReleaseTexture(DXDevice *Dev, int n)
{
    RELEASE(Dev->D3DTexture[n]);
    RELEASE(Dev->TextureSurface[n]);
    Dev->TextureHandle[n] = 0;
}

void ReleaseAllTextures(DXDevice *Dev)
{
    int i;

	for (i = 0; i < Dev->NumTextures; i++)
        ReleaseTexture(Dev, i);
}

BOOL LoadAllTextures(DXDevice *Dev)
{
    int i;

    for (i = 0; i < Dev->NumTextures; i++)
	{
	    LoadTextureSurf(Dev, i);
        GetTextureHandle(Dev, i);
    }
    return TRUE;
}

LPDIRECTDRAWSURFACE LoadSurface(LPDIRECTDRAW lpDD, LPCSTR lpName,
                   	  		    LPDDSURFACEDESC lpFormat, DWORD memoryflag)
{
    LPDIRECTDRAWSURFACE lpDDS;
    DDSURFACEDESC ddsd, format;
    DWORD dwWidth, dwHeight;
    FILE *fp;
    CHAR buf[100];
    DWORD *lpLP;
    WORD *lpSP;
    DWORD m;
    int i, j, s;
    int red_shift, red_scale;
    int green_shift, green_scale;
    int blue_shift, blue_scale;
	int alpha_shift = 0, alpha_scale = 0;
	
    fp = fopen(lpName, "rb");
    fgets(buf, sizeof buf, fp);
    if(lstrcmp(buf, "P6\n"))
	{
        fclose(fp);
        return NULL;
    }
    do
	{
        fgets(buf, sizeof buf, fp);
    } while (buf[0] == '#');
    sscanf(buf, "%d %d\n", &dwWidth, &dwHeight);
    fgets(buf, sizeof buf, fp);

	memset(&ddsd, 0, sizeof(DDSURFACEDESC));
	memcpy(&format, lpFormat, sizeof(DDSURFACEDESC));
	memcpy(&ddsd, lpFormat, sizeof(DDSURFACEDESC));
    ddsd.dwSize = sizeof(DDSURFACEDESC);
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_PIXELFORMAT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_TEXTURE | DDSCAPS_SYSTEMMEMORY;
    ddsd.dwHeight = dwHeight;
    ddsd.dwWidth = dwWidth;

    lpDD->lpVtbl->CreateSurface(lpDD, &ddsd, &lpDDS, NULL);
    memset(&ddsd, 0, sizeof(DDSURFACEDESC));
    ddsd.dwSize = sizeof(DDSURFACEDESC);
    lpDDS->lpVtbl->Lock(lpDDS, NULL, &ddsd, 0, NULL);

    for(s = 0, m = format.ddpfPixelFormat.dwRBitMask; !(m & 1);
                                                       s++, m >>= 1);
    red_shift = s;
    red_scale = 255 / (format.ddpfPixelFormat.dwRBitMask >> s);
    for (s = 0, m = format.ddpfPixelFormat.dwGBitMask; !(m & 1);
                                                       s++, m >>= 1);
    green_shift = s;
    green_scale = 255 / (format.ddpfPixelFormat.dwGBitMask >> s);
    for (s = 0, m = format.ddpfPixelFormat.dwBBitMask; !(m & 1);
                                                       s++, m >>= 1);
    blue_shift = s;
    blue_scale = 255 / (format.ddpfPixelFormat.dwBBitMask >> s);

	if(format.ddpfPixelFormat.dwRGBAlphaBitMask)
	{
		for (s = 0, m = format.ddpfPixelFormat.dwRGBAlphaBitMask; !(m & 1);
	                                                       s++, m >>= 1);
		alpha_shift = s;
		alpha_scale = 255 / (format.ddpfPixelFormat.dwRGBAlphaBitMask >> s);
	}
	
    switch (format.ddpfPixelFormat.dwRGBBitCount)
	{
	    case 32 :
    	    for (j = 0; j < (int)dwHeight; j++)
			{
            	lpLP = (unsigned long*)(((char*)ddsd.lpSurface) +
                                                ddsd.lPitch * j);
                for (i = 0; i < (int)dwWidth; i++)
				{
	                int r, g, b, a;
                    r = getc(fp) / red_scale;
                    g = getc(fp) / green_scale;
                    b = getc(fp) / blue_scale;
					if(format.ddpfPixelFormat.dwRGBAlphaBitMask)
						a = 127 / alpha_scale;
					else
						a = 0;
					*lpLP = (r << red_shift) | (g << green_shift) |
                            (b << blue_shift) | (a << alpha_shift);
                    lpLP++;
                }
            }
            break;
        case 16 :
        	for (j = 0; j < (int)dwHeight; j++)
			{
	            lpSP = (unsigned short*)(((char*)ddsd.lpSurface) +
                                                 ddsd.lPitch * j);
                for (i = 0; i < (int)dwWidth; i++)
				{
    	            int r, g, b, a;
                    r = getc(fp) / red_scale;
                    g = getc(fp) / green_scale;
                    b = getc(fp) / blue_scale;
					if(format.ddpfPixelFormat.dwRGBAlphaBitMask)
						a = 255 / alpha_scale;
					else
						a = 0;
                    *lpSP = (r << red_shift) | (g << green_shift) |
                            (b << blue_shift) | (a << alpha_shift);
                    lpSP++;
                }
            }
            break;
        default:
        	lpDDS->lpVtbl->Unlock(lpDDS, NULL);
            fclose(fp);
            lpDDS->lpVtbl->Release(lpDDS);
            return NULL;
	}
    lpDDS->lpVtbl->Unlock(lpDDS, NULL);
    fclose(fp);
    return (lpDDS);
}

