#include "..\dxclass.hpp"

HRESULT DXScreen::Initialize (DWORD dwHRes, DWORD dwVRes,
                              PALETTEENTRY *lppePal)
   {
   DDSURFACEDESC ddsd;
   HRESULT res;
   DDSCAPS ddsc;
   HWND hWndActive=GetActiveWindow ();
   res=DirectDrawCreate (NULL, &lpDD, NULL);
   if (res!=DD_OK)
      {
      Destroy ();
      return res;
      }
   res=lpDD->SetCooperativeLevel (hWndActive, DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
   if (res!=DD_OK)
      {
      Destroy ();
      return res;
      }
   res=lpDD->SetDisplayMode (dwHRes, dwVRes, 8);
   if (res!=DD_OK)
      {
      Destroy ();
      return res;
      }
   setmem (&ddsd, sizeof(ddsd), 0);
   ddsd.dwSize=sizeof(ddsd);
   ddsd.dwFlags=DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
   ddsd.ddsCaps.dwCaps=DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|
                       DDSCAPS_COMPLEX;
   ddsd.dwBackBufferCount=1;
   res=lpDD->CreateSurface (&ddsd, &lpDDSPrimary, NULL);
   if (res!=DD_OK)
      {
      Destroy ();
      return res;
      }
   setmem (&ddsc, sizeof(ddsc), 0);
   ddsc.dwCaps=DDSCAPS_BACKBUFFER;
   res=lpDDSPrimary->GetAttachedSurface (&ddsc, &lpDDSBack);
   if (res!=DD_OK)
      {
      Destroy ();
      return res;
      }
   if (lppePal!=NULL)
      {
      res=lpDD->CreatePalette (DDPCAPS_8BIT, lppePal, &lpDDPalette,
                               NULL);
      if (res!=DD_OK)
         {
         Destroy ();
         return res;
         }
      res=lpDDSPrimary->SetPalette (lpDDPalette);
      if (res!=DD_OK)
         {
         Destroy ();
         return res;
         }
      }
   return DD_OK;
   }

void DXScreen::Destroy (void)
   {
   if (lpDD!=NULL)
      {
      if (lpDDSPrimary!=NULL)
         {
         lpDDSPrimary->Release ();
         lpDDSPrimary=NULL;
         }
      if (lpDDPalette!=NULL)
         {
         lpDDPalette->Release ();
         lpDDPalette=NULL;
         }
      lpDD->RestoreDisplayMode ();
      lpDD->Release ();
      lpDD=NULL;
      }
   }

