#if !defined(__DXCLASS_HPP)
#define __DXCLASS_HPP

#include <ddraw.h>
#include <windows.h>
#include <mem.h>

class DXScreen
   {
   private:
      LPDIRECTDRAW lpDD;
      LPDIRECTDRAWSURFACE lpDDSPrimary;
      LPDIRECTDRAWPALETTE lpDDPalette;
      LPDIRECTDRAWSURFACE lpDDSBack;
   public:
      DXScreen ()
         {
         lpDD=NULL;
         lpDDSPrimary=NULL;
         lpDDPalette=NULL;
         lpDDSBack=NULL;
         }
      ~DXScreen ()
         {
         lpDD=NULL;
         lpDDSPrimary=NULL;
         lpDDPalette=NULL;
         lpDDSBack=NULL;
         }
      void Destroy (void);
      HRESULT Initialize (DWORD dwHRes, DWORD dwVRes,
                          PALETTEENTRY *lppePal=NULL);
      HRESULT Flip ()
         {return lpDDSPrimary->Flip (NULL, DDFLIP_WAIT);}
      HRESULT Unlock ()
         {return lpDDSPrimary->Unlock (NULL);}
      HRESULT Restore ()
         {return lpDDSPrimary->Restore ();}
      operator unsigned char * ()
            {
            DDSURFACEDESC ddsd;
            HRESULT res;
            setmem (&ddsd, sizeof(ddsd), 0);
            ddsd.dwSize=sizeof(ddsd);
            res=lpDDSPrimary->Lock (NULL, &ddsd, DDLOCK_WAIT, NULL);
            if (res!=DD_OK)
               return NULL;
            return (unsigned char *)ddsd.lpSurface;
            }
   };

#endif

