#if defined( __BORLANDC__ ) && defined( __WIN32__ )
#undef _WIN32
#define _WIN32
#endif
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
//#include <ddraw.h>
#include <stdlib.h>
#include <mem.h>
#include <assert.h>
#include "..\dxclass.hpp"

DXScreen screen;
PALETTEENTRY palette[256];
BOOL running=TRUE;
long FAR PASCAL WindowProc(HWND hWnd, UINT msg,
                           WPARAM wParam, LPARAM lParam);
void DoPal (void);

int pascal WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow)
   {
   WNDCLASS wc;
   HWND hWnd;
   MSG msg;
   BYTE *lpBuffer;
   unsigned int i, x, y;
   unsigned int neighbors[4];
   unsigned int off;
   int temp;
   wc.style = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc = WindowProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon( hInstance, IDI_APPLICATION );
   wc.hCursor = LoadCursor( NULL, IDC_ARROW );
   wc.hbrBackground = GetStockBrush(BLACK_BRUSH);
   wc.lpszMenuName = NULL;
   wc.lpszClassName = "TestClass";
   RegisterClass(&wc);
   hWnd = CreateWindowEx(0, "TestClass", "DirectX Test", WS_POPUP,
                         0, 0, GetSystemMetrics(SM_CXSCREEN),
                         GetSystemMetrics(SM_CYSCREEN), NULL, hInstance,        hInstance,
                         NULL);
   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);
   SetActiveWindow (hWnd);
   DoPal ();
   screen.Initialize (320, 200, palette);
   lpBuffer=(unsigned char *)screen;
   SetCursor (NULL);
   setmem (lpBuffer, (320*200), 0);
   for (i=0; i<250; i++)
      lpBuffer[(64000-(rand()%320))]=255;
   while (running)
      {
      if (PeekMessage (&msg, NULL, 0, 0, PM_NOREMOVE))
         {
         running=GetMessage (&msg, NULL, 0, 0);
         TranslateMessage (&msg);
         DispatchMessage (&msg);
         }
      for (i=0; i<320; i++)
         lpBuffer[(64000-i)]=0;
      for (i=0; i<250; i++)
         lpBuffer[(64000-(rand()%320))]=255;
      for (x=318; x>0; x--)
         {
         for (y=198; y>0; y--)
            {
            off=(((y+1)<<6)+((y+1)<<8))+x;
            neighbors[0]=lpBuffer[off+320];
            neighbors[1]=lpBuffer[off-320];
            neighbors[2]=lpBuffer[off-1];
            neighbors[3]=lpBuffer[off+1];
            temp=(neighbors[0]+neighbors[1]+neighbors[2]+
                  neighbors[3])>>2;
            if (temp)
               temp-=rand()%2;
            lpBuffer[((y<<6)+(y<<8))+x]=temp;
            }
         }
      }
   screen.Unlock ();
   screen.Destroy ();
   return msg.wParam;
   }

long FAR PASCAL WindowProc(HWND hWnd, UINT msg,
                           WPARAM wParam, LPARAM lParam)
   {
   switch (msg)
      {
      case WM_SETCURSOR:
         SetCursor (NULL);
         return TRUE;
      case WM_KEYUP:
         switch (wParam)
            {
            case VK_ESCAPE:
            case VK_F12:
               running=FALSE;
               return FALSE;
            }
         break;
      case WM_DESTROY:
         running=FALSE;
         return FALSE;
         break;
      default:
         return DefWindowProc (hWnd, msg, wParam, lParam);
      }
   }

void DoPal (void)
{
int colind, index;
unsigned char colors[] = {
         0, 0, 0, 0, 0, 6, 0, 0, 6, 0, 0, 7, 0, 0, 8, 0, 0, 8, 0, 0, 9, 0, 0,10 ,
         2, 0,10, 4, 0, 9, 6, 0, 9, 8, 0, 8,10, 0, 7,12, 0, 7,14, 0, 6,16, 0, 5 ,
         18, 0, 5,20, 0, 4,22, 0, 4,24, 0, 3,26, 0, 2,28, 0, 2,30, 0, 1,32, 0, 0,
         32, 0, 0,33, 0, 0,34, 0, 0,35, 0, 0,36, 0, 0,36, 0, 0,37, 0, 0,38, 0, 0,
         39, 0, 0,40, 0, 0,40, 0, 0,41, 0, 0,42, 0, 0,43, 0, 0,44, 0, 0,45, 0, 0,
         46, 1, 0,47, 1, 0,48, 2, 0,49, 2, 0,50, 3, 0,51, 3, 0,52, 4, 0,53, 4, 0,
         54, 5, 0,55, 5, 0,56, 6, 0,57, 6, 0,58, 7, 0,59, 7, 0,60, 8, 0,61, 8, 0,
         63, 9, 0,63, 9, 0,63,10, 0,63,10, 0,63,11, 0,63,11, 0,63,12, 0,63,12, 0,
         63,13, 0,63,13, 0,63,14, 0,63,14, 0,63,15, 0,63,15, 0,63,16, 0,63,16, 0,
         63,17, 0,63,17, 0,63,18, 0,63,18, 0,63,19, 0,63,19, 0,63,20, 0,63,20, 0,
         63,21, 0,63,21, 0,63,22, 0,63,22, 0,63,23, 0,63,24, 0,63,24, 0,63,25, 0,
         63,25, 0,63,26, 0,63,26, 0,63,27, 0,63,27, 0,63,28, 0,63,28, 0,63,29, 0,
         63,29, 0,63,30, 0,63,30, 0,63,31, 0,63,31, 0,63,32, 0,63,32, 0,63,33, 0,
         63,33, 0,63,34, 0,63,34, 0,63,35, 0,63,35, 0,63,36, 0,63,36, 0,63,37, 0,
         63,38, 0,63,38, 0,63,39, 0,63,39, 0,63,40, 0,63,40, 0,63,41, 0,63,41, 0,
         63,42, 0,63,42, 0,63,43, 0,63,43, 0,63,44, 0,63,44, 0,63,45, 0,63,45, 0,
         63,46, 0,63,46, 0,63,47, 0,63,47, 0,63,48, 0,63,48, 0,63,49, 0,63,49, 0,
         63,50, 0,63,50, 0,63,51, 0,63,52, 0,63,52, 0,63,52, 0,63,52, 0,63,52, 0,
         63,53, 0,63,53, 0,63,53, 0,63,53, 0,63,54, 0,63,54, 0,63,54, 0,63,54, 0,
         63,54, 0,63,55, 0,63,55, 0,63,55, 0,63,55, 0,63,56, 0,63,56, 0,63,56, 0,
         63,56, 0,63,57, 0,63,57, 0,63,57, 0,63,57, 0,63,57, 0,63,58, 0,63,58, 0,
         63,58, 0,63,58, 0,63,59, 0,63,59, 0,63,59, 0,63,59, 0,63,60, 0,63,60, 0,
         63,60, 0,63,60, 0,63,60, 0,63,61, 0,63,61, 0,63,61, 0,63,61, 0,63,62, 0,
         63,62, 0,63,62, 0,63,62, 0,63,63, 0,63,63, 1,63,63, 2,63,63, 3,63,63, 4,
         63,63, 5,63,63, 6,63,63, 7,63,63, 8,63,63, 9,63,63,10,63,63,10,63,63,11,
         63,63,12,63,63,13,63,63,14,63,63,15,63,63,16,63,63,17,63,63,18,63,63,19,
         63,63,20,63,63,21,63,63,21,63,63,22,63,63,23,63,63,24,63,63,25,63,63,26,
         63,63,27,63,63,28,63,63,29,63,63,30,63,63,31,63,63,31,63,63,32,63,63,33,
         63,63,34,63,63,35,63,63,36,63,63,37,63,63,38,63,63,39,63,63,40,63,63,41,
         63,63,42,63,63,42,63,63,43,63,63,44,63,63,45,63,63,46,63,63,47,63,63,48,
         63,63,49,63,63,50,63,63,51,63,63,52,63,63,52,63,63,53,63,63,54,63,63,55,
         63,63,56,63,63,57,63,63,58,63,63,59,63,63,60,63,63,61,63,63,62,63,63,63,
         };
colind=0;
for (index=0; index<256; index++)
   {
   palette[index].peRed = 4*colors[colind];
   colind++;
   palette[index].peGreen = 4*colors[colind];
   colind++;
   palette[index].peBlue = 4*colors[colind];
   colind++;
   palette[index].peFlags=PC_NOCOLLAPSE;
   }
}
