#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include <mmsystem.h>
#include <defines.h>
#include <wgclass.h>
#include <appmain.h>
#include <world.h>
#include <dlgproc.h>
#include <mem.h>
#include <ctl3d.h>
#include <types.h>
#include <cameras.h>
#include <digitalv.h>

int                     WinApp::cmdShow;
HINSTANCE               WinApp::hInstance;
HINSTANCE               WinApp::hPrevInst;

TBBUTTON				TBButtons[2];
float                   Fps;
HDC                     MainDC;
WORLD                   *World3D;
char	               	WorldFile[80];
BOOL                    OpenWorld = FALSE;
BOOL		   			First = TRUE;
BOOL					UseOverlay = FALSE;
BOOL					DispFPS = TRUE;
BOOL					ShowVisPoly = TRUE;
BOOL					MMTest = FALSE;
DWORD 		   			NewTimerCounter;
DWORD 		   			TimerCounter;
static HPALETTE			SavePal;

char 					buf[255];
int 					PrevMode;
RECT					r;
WGDIB					LOGO1, Overlay;
KEYBRD					CamStruct;

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInst, LPSTR cmdLine, int cmdShow)
{
	HWND            MainWnd;
	MSG             msg;
	WNDCLASS        WndClass;
	HMENU           hMenuInit;

	WinApp::hInstance = hInstance;
	WinApp::hPrevInst = hPrevInst;
	WinApp::cmdShow   = cmdShow;

	if(WinApp::hPrevInst)
	{
		MessageBox(GetFocus(), "There is already one Application of this type running.\nWe are now switching to that application.",
					"Enigmatic Experience", MB_OK | MB_ICONEXCLAMATION);
		BringWindowToTop(FindWindow("MAINWND", NULL));
		return FALSE;
	}
	memset(WorldFile, '\0', sizeof(char) * 80);
	sprintf(WorldFile, "%s", (LPSTR)cmdLine);

	if(!WinApp::hPrevInst)
	{
		WndClass.style         = CS_BYTEALIGNCLIENT | CS_HREDRAW | CS_VREDRAW;
		WndClass.lpfnWndProc   = WndProc;
		WndClass.cbClsExtra    = 0;
		WndClass.cbWndExtra    = 0;
		WndClass.hInstance     = hInstance;
		WndClass.hIcon         = LoadIcon(WinApp::hInstance, "LOGO");
		WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
		WndClass.hbrBackground = GetStockBrush(GRAY_BRUSH);
		WndClass.lpszMenuName  = NULL;
		WndClass.lpszClassName = "MAINWND";

		RegisterClass(&WndClass);
	}

	ClearSystemPalette();
	Ctl3dRegister(hInstance);
	hMenuInit = LoadMenu(WinApp::hInstance, "MAINMENU");
	MainWnd   = CreateWindow("MAINWND", "Enigmatic Experience",
							 WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
							 0, 0, 328, 271,
							 NULL, hMenuInit, hInstance, NULL);
	ShowWindow(MainWnd, cmdShow);
	UpdateWindow(MainWnd);

	for (;;)
	{
		if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			if(msg.message == WM_QUIT)
				break;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
			if(AppIdle(MainWnd))
				WaitMessage();
		}
	}
	Ctl3dUnregister(hInstance);
	return msg.wParam;
};

void DrawBMP(HDC DC, char *BMP, int x, int y)
{
	HBITMAP bm, obm;
	BITMAP ibm;
	HDC memDC;

	memDC = CreateCompatibleDC(DC);

	bm = LoadBitmap(WinApp::hInstance, BMP);
	obm = SelectBitmap(memDC, bm);
	GetObject((HBITMAP)bm, sizeof(BITMAP), &ibm);
	BitBlt(DC, x, y, ibm.bmWidth, ibm.bmHeight, memDC, 0, 0, SRCCOPY);
	SelectBitmap(memDC, obm);
	DeleteDC(memDC);
	DeleteObject(bm);
};

#pragma argsused
BOOL AppIdle(HWND hWindow)
{
	if(!OpenWorld)
		return TRUE;

//	World3D->Camera[World3D->CurrentCamera]->CameraFunction(&World3D->Camera[World3D->CurrentCamera]);
	CAMERA *c;
	c = &World3D->Camera[World3D->CurrentCamera];
	c->CameraFunction(c);
	World3D->DrawWorld();
	if(UseOverlay)
		World3D->WinGDrv->TDisplayBitmap(Overlay, 0, 0, 0);
	DisplayFPS(hWindow);
	World3D->WinGDrv->StretchToScreen(MainDC, r.left, r.top, r.right, r.bottom - 24);
	World3D->WinGDrv->Clear();
	return 0;
};

void DisplayTextOnStatusBar(char *text)
{
	DrawStatusBar();
	HBRUSH  Brush, OBrush;
	HPEN    Pen;
	HBITMAP Bmp, OBm;
	HDC		MemDC;

	MemDC = CreateCompatibleDC(MainDC);
	Bmp = CreateCompatibleBitmap(MainDC, r.right - r.left - 4, 20);
	SetBkMode(MemDC, TRANSPARENT);
	OBm = SelectObject(MemDC, Bmp);
	Brush = CreateSolidBrush(RGB(192, 192, 192));
	OBrush = SelectObject(MemDC, Brush);
	Pen = SelectObject(MemDC, GetStockObject(NULL_PEN));

	Rectangle(MemDC, 0, 0, r.right - r.left - 2, 20);
	SelectObject(MemDC, OBrush);
	DeleteObject(Brush);
	Pen = SelectObject(MemDC, Pen);
	DeleteObject(Pen);
	TextOut(MemDC, 2, 2, text, lstrlen(text));
	BitBlt(MainDC, r.left + 2, r.bottom - 22, r.right - r.left - 6, 19, MemDC, 0, 0, SRCCOPY);
	SelectObject(MemDC, OBm);
	DeleteObject(Bmp);
	DeleteDC(MemDC);
};

#pragma argsused
void DisplayFPS(HWND hWindow)
{
	if(!OpenWorld)
		return;

	HBRUSH  Brush, OBrush;
	HPEN    Pen;
	HBITMAP Bmp, OBm;
	HDC		MemDC;

	MemDC = CreateCompatibleDC(MainDC);
	Bmp = CreateCompatibleBitmap(MainDC, r.right - r.left - 4, 20);
	SetBkMode(MemDC, TRANSPARENT);
	OBm = SelectObject(MemDC, Bmp);
	Brush = CreateSolidBrush(RGB(192, 192, 192));
	OBrush = SelectObject(MemDC, Brush);
	Pen = SelectObject(MemDC, GetStockObject(NULL_PEN));

	Rectangle(MemDC, 0, 0, r.right - r.left - 4, 20);
	SelectObject(MemDC, OBrush);
	DeleteObject(Brush);
	Pen = SelectObject(MemDC, Pen);
	DeleteObject(Pen);

	NewTimerCounter = timeGetTime() - TimerCounter;
	Fps = (float)1000 / (NewTimerCounter == 0 ? 1 : NewTimerCounter);
	TimerCounter += NewTimerCounter;

	if(ShowVisPoly && DispFPS)
		sprintf(buf, "%.1f Frames/sec      %d Visible Polygons", Fps, World3D->PolygonList.NumPolygons);
	else if(DispFPS && !ShowVisPoly)
		sprintf(buf, "%.1f Frames/sec", Fps);
	else if(!DispFPS && ShowVisPoly)
		sprintf(buf, "%d Visible Polygons", World3D->PolygonList.NumPolygons);
	else
		sprintf(buf, "");
	TextOut(MemDC, 2, 2, buf, lstrlen(buf));
	BitBlt(MainDC, r.left + 2, r.bottom - 22, r.right - r.left - 6, 19, MemDC, 0, 0, SRCCOPY);
	SelectObject(MemDC, OBm);
	DeleteObject(Bmp);
	DeleteDC(MemDC);
};

#pragma argsused
void SetupWorld(HWND hWindow)
{
	int i;
	i = World3D->LoadWorld(WorldFile);

	if(!i)
	{
		OpenWorld = FALSE;
		return;
	}
	OpenWorld = TRUE;
	First = FALSE;
	TimerCounter = timeGetTime();
	World3D->OldTime = timeGetTime();
	World3D->WinGDrv->UseWinGPalette(MainDC);
};

void DisplayBitmap(WGDIB Title, long time)
{
	DWORD		Timer;
	HPALETTE	Pal,Oldpal;

	Pal = World3D->WinGDrv->LoadBitmapPalette(Title);
	Oldpal = SelectPalette(MainDC, Pal, FALSE);
	RealizePalette(MainDC);
	World3D->WinGDrv->DisplayBitmap(Title, 0, 0);
	World3D->WinGDrv->StretchToScreen(MainDC, r.left, r.top, r.right, r.bottom - 24);
	SelectPalette(MainDC, Oldpal, FALSE);
	Timer = timeGetTime();
	for(;;)
	{
		if(timeGetTime() - Timer > time)
			break;
	}
//	RealizePalette(MainDC);
	DeleteObject(Pal);
};

int HandleKeyboard(KEYBRD keybd, WPARAM Key, int UpDown)
{
	long i;
	char buf[250];
	switch(Key)
	{
		case VK_LEFT:
		case VK_NUMPAD4:
			keybd[LEFT] = UpDown;
			break;
		case VK_RIGHT:
		case VK_NUMPAD6:
			keybd[RIGHT] = UpDown;
			break;
		case VK_DOWN:
		case VK_NUMPAD2:
			keybd[DOWN] = UpDown;
			break;
		case VK_UP:
		case VK_NUMPAD8:
			keybd[UP] = UpDown;
			break;
		case VK_PRIOR:
		case VK_NUMPAD9:
			keybd[UPRIGHT] = UpDown;
			break;
		case VK_NEXT:
		case VK_NUMPAD3:
			keybd[DOWNRIGHT] = UpDown;
			break;
		case VK_HOME:
		case VK_NUMPAD7:
			keybd[UPLEFT] = UpDown;
			break;
		case VK_END:
		case VK_NUMPAD1:
			keybd[DOWNLEFT] = UpDown;
			break;
		case VK_NUMPAD5:
		case '5':
			i = World3D->CurrentCamera++;
			if(World3D->CurrentCamera >= World3D->NumCameras)
				World3D->CurrentCamera = 0;
			sprintf(buf, "Current camera is now %s.", World3D->Camera[World3D->CurrentCamera].Name);
			MessageBox(GetFocus(), buf, "", MB_OK);
			break;
	}
// Handle the math for the camera
	return 0;
};

void DrawStatusBar()
{
	HBRUSH Brush, OBrush;
	HPEN   Pen, OPen;
	Brush = CreateSolidBrush(RGB(192, 192, 192));
	OBrush = SelectObject(MainDC, Brush);
	Pen = SelectObject(MainDC, GetStockObject(NULL_PEN));

	Rectangle(MainDC, r.left, r.top, r.right + 1, r.bottom + 1);

	OPen = SelectObject(MainDC, Pen);
	DeleteObject(OPen);
	Pen = SelectObject(MainDC, GetStockObject(WHITE_PEN));
	MoveToEx(MainDC, 0, r.bottom - 24, NULL);
	LineTo(MainDC, r.right, r.bottom - 24);
	OPen = SelectObject(MainDC, Pen);
	DeleteObject(OPen);
	SelectObject(MainDC, OBrush);
	DeleteObject(Brush);
};

LRESULT CALLBACK _export WndProc(HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
{
	char		*file;
	HPALETTE 	OldPal;

	switch(message)
	{
		case WM_CREATE:
			DefWindowProc(hWindow, message, wParam, lParam);
			GetClientRect(hWindow, &r);
			InitCommonControls();
			World3D = new WORLD(320, 200);
			MainDC = GetDC(hWindow);
			LOGO1 = World3D->WinGDrv->LoadBitmap("c:\\enigma~1\\Bitmaps\\enigma.bmp");
			Overlay = World3D->WinGDrv->LoadBitmap("c:\\enigma~1\\Bitmaps\\overlay.bmp");
			SavePal = SelectPalette(MainDC, World3D->WinGDrv->GetPal(), FALSE);
			RealizePalette(MainDC);
			World3D->WinGDrv->Clear();
			SetBkMode(MainDC, TRANSPARENT);
			if(WorldFile[0] == '\0')
				return 0;
			SetupWorld(hWindow);
			return 0;
		case WM_PAINT:
			PAINTSTRUCT ps;
			GetClientRect(hWindow, &r);
			BeginPaint(hWindow, &ps);
				DrawStatusBar();
				if(!OpenWorld)
					DisplayBitmap(LOGO1, 1);
				DefWindowProc(hWindow, message, wParam, lParam);
			EndPaint(hWindow, &ps);
			return 0;
		case WM_COMMAND:
			switch(wParam)
			{
				case OPEN:
					if(OpenWorld)
					{
						if(MessageBox(GetFocus(), "There is already an open world in session.  Do you want to close it and open another?\n(Selecting Yes will close the currently opened world.)", "Enigmatic Experience", MB_YESNO | MB_ICONQUESTION) == IDNO)
							return 0;
						World3D->DrawType = GT_ASDEFINED;
						World3D->CloseWorld();
						OpenWorld = FALSE;
					}
					file = CustomOpen(hWindow);
					memset(WorldFile, '\0', sizeof(char) * 80);
					if(file)
						memcpy(WorldFile, file, lstrlen(file));
					else
						return 0;
					if(WorldFile)
					{
						SetupWorld(hWindow);
					}
					return 0;
				case CLOSE:
					if(OpenWorld)
					{
						World3D->DrawType = GT_ASDEFINED;
						OpenWorld = FALSE;
						World3D->CloseWorld();
						InvalidateRect(hWindow, NULL, TRUE);
					}
					return 0;
				case EXIT:
					SendMessage(hWindow, WM_DESTROY, 0, 0L);
					return 0;
				case 102:
					if(OpenWorld == TRUE)
						MMTest = TRUE;
					OpenWorld = FALSE;
					static UINT wDeviceID;
					DWORD dwReturn;
					MCI_DGV_OPEN_PARMS mciOpenParms;
					MCI_DGV_WINDOW_PARMS mciWindowParms;
					MCI_DGV_PUT_PARMS mciPutParms;
					MCI_DGV_PLAY_PARMS mciPlayParms;

					mciOpenParms.lpstrDeviceType = "AVIVideo";
					mciOpenParms.lpstrElementName = "c:\\enigma~1\\bitmaps\\logo.avi";
					mciSendCommand(wDeviceID, MCI_OPEN,
						MCI_OPEN_TYPE | MCI_OPEN_ELEMENT,
						(DWORD)(LPVOID)&mciOpenParms);
					wDeviceID = mciOpenParms.wDeviceID;

					mciWindowParms.hWnd = hWindow;
					mciSendCommand(wDeviceID, MCI_WINDOW,
						MCI_DGV_WINDOW_HWND,
						(DWORD)(LPVOID)&mciWindowParms);

					mciPutParms.rc.left = r.left;
					mciPutParms.rc.right = r.right - r.left;
					mciPutParms.rc.top = r.top;
					mciPutParms.rc.bottom = r.bottom - r.top;
					mciSendCommand(wDeviceID,  MCI_PUT,
						MCI_DGV_PUT_DESTINATION,
						(DWORD)(LPVOID)&mciPutParms);

					mciPlayParms.dwCallback = (DWORD)hWindow;
					mciPlayParms.dwFrom = 0;
					mciSendCommand(wDeviceID, MCI_PLAY,
						MCI_FROM | MCI_NOTIFY,
						(DWORD)(LPVOID)&mciPlayParms);

					return 0;
				case 106:
					if(!UseOverlay)
					{
						CheckMenuItem(GetMenu(hWindow), 106, MF_CHECKED);
						UseOverlay = TRUE;
					}
					else
					{
						CheckMenuItem(GetMenu(hWindow), 106, MF_UNCHECKED);
						UseOverlay = FALSE;
					}
					return 0;
				case 107:
					if(!DispFPS)
					{
						CheckMenuItem(GetMenu(hWindow), 107, MF_CHECKED);
						DispFPS = TRUE;
					}
					else
					{
						CheckMenuItem(GetMenu(hWindow), 107, MF_UNCHECKED);
						DispFPS = FALSE;
					}
					return 0;
				case 109:
					if(!ShowVisPoly)
					{
						CheckMenuItem(GetMenu(hWindow), 109, MF_CHECKED);
						ShowVisPoly = TRUE;
					}
					else
					{
						CheckMenuItem(GetMenu(hWindow), 109, MF_UNCHECKED);
						ShowVisPoly = FALSE;
					}
					return 0;
				case 111:
					ExecuteDialog(hWindow, AboutProc, "ACKNOWLEDGEMENTS");
					InvalidateRect(hWindow, NULL, TRUE);
					return 0;
				case ABOUT:
					ExecuteDialog(hWindow, AboutProc, "ABOUT");
					InvalidateRect(hWindow, NULL, TRUE);
					return 0;
				case 101:
					ExecuteDialog(hWindow, OptionsProc, "OPTIONS");
					InvalidateRect(hWindow, NULL, TRUE);
					return 0;
				case 105:
					WinHelp(hWindow, "C:\\Enigma~1\\help\\Judges.hlp", HELP_FORCEFILE, 0L);
					return 0;
				default:
					return(DefWindowProc(hWindow, message, wParam, lParam));
		}
		case MM_MCINOTIFY:
			mciSendCommand(LOWORD(lParam), MCI_CLOSE, 0, 0L);
			if(MMTest == FALSE)
				OpenWorld = FALSE;
			else
				OpenWorld = TRUE;
			MMTest = FALSE;
			InvalidateRect(hWindow, NULL, TRUE);
			return 0;
		case WM_SYSCOMMAND:
			DefWindowProc(hWindow, message, wParam, lParam);
			GetClientRect(hWindow, &r);
			return 0;
		case WM_KEYDOWN:
			HandleKeyboard(CamStruct, (int)wParam, 1);
			return 0;
		case WM_KEYUP:
			HandleKeyboard(CamStruct, (int)wParam, 0);
			return 0;
		case WM_PALETTECHANGED:
			if((HWND)wParam == hWindow)
				break;
		case WM_QUERYNEWPALETTE:
			if(SavePal)
				DeleteObject(SavePal);
			SavePal = SelectPalette(MainDC, World3D->WinGDrv->GetPal(), FALSE);
			RealizePalette(MainDC);
			return TRUE;
		case WM_SETFOCUS:
			if(SavePal)
				DeleteObject(SavePal);
			SelectPalette(MainDC, WinGCreateHalftonePalette(), FALSE);
			RealizePalette(MainDC);
			InvalidateRect(hWindow, NULL, TRUE);
			return 0;
		case WM_KILLFOCUS:
			OldPal = SelectPalette(MainDC, SavePal, FALSE);
			DeleteObject(OldPal);
			RealizePalette(MainDC);
			InvalidateRect(hWindow, NULL, TRUE);
			return 0;
		case WM_DESTROY:
			OldPal = SelectPalette(MainDC, SavePal, FALSE);
			DeleteObject(OldPal);
			RealizePalette(MainDC);
			ReleaseDC(hWindow, MainDC);
			World3D->WinGDrv->FreeBitmap(LOGO1);
			World3D->WinGDrv->FreeBitmap(Overlay);
			PostQuitMessage(0);
			if(OpenWorld)
            	World3D->CloseWorld();
			delete World3D;
			return 0;
		case WM_COMPACTING:
			MessageBox(hWindow, "Windows has detected that the system memory is getting low. You should save your work now and exit OR close some opened windows to free memory.", "Enigmatic Experience", MB_OK | MB_ICONEXCLAMATION);
			return 0;
		default:
			return(DefWindowProc(hWindow, message, wParam, lParam));
	}
	return TRUE;
};


