#include <windows.h>
#include <math.h>
#include <math3d.h>
#include <world.h>
#include <types.h>
#include <cameras.h>


extern WORLD	*World3D;
extern KEYBRD 	CamStruct;

void DefCameraFunction(char *String, CAMERA *c)
{
	if(stricmp(String, "None") == 0)
		c->CameraFunction = None;

	else if(stricmp(String, "xyzCamera") == 0)
		c->CameraFunction = xyzCamera;

	else if(stricmp(String, "xyCamera") == 0)
		c->CameraFunction = xyCamera;

	else if(stricmp(String, "rawCamera") == 0)
		c->CameraFunction = rawCamera;

	else if(stricmp(String, "fastCamera") == 0)
		c->CameraFunction = fastCamera;


//	else if(stricmp(String, "Seek") == 0)
//		c->CameraFunction = Seek;

//	else if(stricmp(String, "User1") == 0)
//		c->CameraFunction = User1;

//	else if(stricmp(String, "User2") == 0)
//		c->CameraFunction = User2;
}

#pragma argsused
int None(CAMERA *Camera)
{
	return TRUE;
};


#pragma argsused
int xyzCamera(CAMERA *Camera)
{
	float	sinRoll, cosRoll;
	float	sinYaw, cosYaw;
	float	sinPitch, cosPitch;

	sinRoll = sin(World3D->Camera[World3D->CurrentCamera].Roll);
	cosRoll = cos(World3D->Camera[World3D->CurrentCamera].Roll);

	sinYaw = sin(World3D->Camera[World3D->CurrentCamera].Yaw);
	cosYaw = cos(World3D->Camera[World3D->CurrentCamera].Yaw);

	sinPitch = sin(World3D->Camera[World3D->CurrentCamera].Pitch);
	cosPitch = cos(World3D->Camera[World3D->CurrentCamera].Pitch);

	if(CamStruct[UP])
	{
		World3D->Camera[World3D->CurrentCamera].xTranslate += (sinYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].yTranslate -= (sinPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].zTranslate += (cosYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWN])
	{
		World3D->Camera[World3D->CurrentCamera].xTranslate -= (sinYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].yTranslate += (sinPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].zTranslate -= (cosYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[LEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Yaw -= (0.01745329 * cosRoll * cosPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Pitch += (0.01745329 * sinRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Roll -= (0.01745329 * sinPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[RIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Yaw += (0.01745329 * cosRoll * cosPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Pitch -= (0.01745329 * sinRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Roll += (0.01745329 * sinPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[UPRIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Pitch += (0.01745329 * cosRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Yaw += (0.01745329 * sinRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Roll += (0.01745329 * sinPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWNRIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Pitch -= (0.01745329 * cosRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Yaw -= (0.01745329 * sinRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Roll -= (0.01745329 * sinPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[UPLEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Roll += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWNLEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Roll -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}

	if(World3D->Camera[World3D->CurrentCamera].Roll > 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Roll -= 2 * M_PI;
	if(World3D->Camera[World3D->CurrentCamera].Roll < 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Roll += 2 * M_PI;

	if(World3D->Camera[World3D->CurrentCamera].Yaw > 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Yaw -= 2 * M_PI;
	if(World3D->Camera[World3D->CurrentCamera].Yaw < 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Yaw += 2 * M_PI;

	if(World3D->Camera[World3D->CurrentCamera].Pitch > 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Pitch -= 2 * M_PI;
	if(World3D->Camera[World3D->CurrentCamera].Pitch < 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Pitch += 2 * M_PI;
	return TRUE;
};

#pragma argsused
int xyCamera(CAMERA *Camera)
{
	float	sinYaw, cosYaw;
	float	sinPitch;

	sinYaw = sin(World3D->Camera[World3D->CurrentCamera].Yaw);
	cosYaw = cos(World3D->Camera[World3D->CurrentCamera].Yaw);
	sinPitch = sin(World3D->Camera[World3D->CurrentCamera].Pitch);

	if(CamStruct[UP])
	{
		World3D->Camera[World3D->CurrentCamera].xTranslate += (sinYaw * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].yTranslate -= (sinPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].zTranslate += (cosYaw * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWN])
	{
		World3D->Camera[World3D->CurrentCamera].xTranslate -= (sinYaw * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].yTranslate += (sinPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].zTranslate -= (cosYaw * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[LEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Yaw -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[RIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Yaw += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[UPRIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Pitch += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWNRIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Pitch -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[UPLEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Roll += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWNLEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Roll -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	return TRUE;
};

#pragma argsused
int rawCamera(CAMERA *Camera)
{
	float	sinRoll, cosRoll;
	float	sinYaw, cosYaw;
	float	sinPitch, cosPitch;

	sinRoll = sin(World3D->Camera[World3D->CurrentCamera].Roll);
	cosRoll = cos(World3D->Camera[World3D->CurrentCamera].Roll);

	sinYaw = sin(World3D->Camera[World3D->CurrentCamera].Yaw);
	cosYaw = cos(World3D->Camera[World3D->CurrentCamera].Yaw);

	sinPitch = sin(World3D->Camera[World3D->CurrentCamera].Pitch);
	cosPitch = cos(World3D->Camera[World3D->CurrentCamera].Pitch);

	if(CamStruct[UP])
	{
		World3D->Camera[World3D->CurrentCamera].xTranslate += (sinYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].yTranslate -= (sinPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].zTranslate += (cosYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWN])
	{
		World3D->Camera[World3D->CurrentCamera].xTranslate -= (sinYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].yTranslate += (sinPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].zTranslate -= (cosYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[LEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Yaw -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[RIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Yaw += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[UPRIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Pitch += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWNRIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Pitch -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[UPLEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Roll += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWNLEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Roll -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}

	if(World3D->Camera[World3D->CurrentCamera].Roll > 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Roll -= 2 * M_PI;
	if(World3D->Camera[World3D->CurrentCamera].Roll < 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Roll += 2 * M_PI;

	if(World3D->Camera[World3D->CurrentCamera].Yaw > 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Yaw -= 2 * M_PI;
	if(World3D->Camera[World3D->CurrentCamera].Yaw < 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Yaw += 2 * M_PI;

	if(World3D->Camera[World3D->CurrentCamera].Pitch > 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Pitch -= 2 * M_PI;
	if(World3D->Camera[World3D->CurrentCamera].Pitch < 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Pitch += 2 * M_PI;
	return TRUE;
};

#pragma argsused
int fastCamera(CAMERA *Camera)
{
	float	sinRoll, cosRoll;
	float	sinYaw, cosYaw;
	float	sinPitch, cosPitch;

	sinRoll = sin(World3D->Camera[World3D->CurrentCamera].Roll);
	cosRoll = cos(World3D->Camera[World3D->CurrentCamera].Roll);

	sinYaw = sin(World3D->Camera[World3D->CurrentCamera].Yaw);
	cosYaw = cos(World3D->Camera[World3D->CurrentCamera].Yaw);

	sinPitch = sin(World3D->Camera[World3D->CurrentCamera].Pitch);
	cosPitch = cos(World3D->Camera[World3D->CurrentCamera].Pitch);

	if(CamStruct[UP])
	{
		World3D->Camera[World3D->CurrentCamera].xTranslate += (sinYaw * cosPitch * World3D->DeltaTime / 1000) * 50000000000;
		World3D->Camera[World3D->CurrentCamera].yTranslate -= (sinPitch * World3D->DeltaTime / 1000) * 50000000000;
		World3D->Camera[World3D->CurrentCamera].zTranslate += (cosYaw * cosPitch * World3D->DeltaTime / 1000) * 50000000000;
	}
	if(CamStruct[DOWN])
	{
		World3D->Camera[World3D->CurrentCamera].xTranslate -= (sinYaw * cosPitch * World3D->DeltaTime / 1000) * 50000000000;
		World3D->Camera[World3D->CurrentCamera].yTranslate += (sinPitch * World3D->DeltaTime / 1000) * 50000000000;
		World3D->Camera[World3D->CurrentCamera].zTranslate -= (cosYaw * cosPitch * World3D->DeltaTime / 1000) * 50000000000;
	}
	if(CamStruct[LEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Yaw -= (0.01745329 * cosRoll * cosPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Pitch += (0.01745329 * sinRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Roll -= (0.01745329 * sinPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[RIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Yaw += (0.01745329 * cosRoll * cosPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Pitch -= (0.01745329 * sinRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Roll += (0.01745329 * sinPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[UPRIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Pitch += (0.01745329 * cosRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Yaw += (0.01745329 * sinRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Roll += (0.01745329 * sinPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWNRIGHT])
	{
		World3D->Camera[World3D->CurrentCamera].Pitch -= (0.01745329 * cosRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Yaw -= (0.01745329 * sinRoll * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].Roll -= (0.01745329 * sinPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[UPLEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Roll += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWNLEFT])
	{
		World3D->Camera[World3D->CurrentCamera].Roll -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}

	if(World3D->Camera[World3D->CurrentCamera].Roll > 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Roll -= 2 * M_PI;
	if(World3D->Camera[World3D->CurrentCamera].Roll < 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Roll += 2 * M_PI;

	if(World3D->Camera[World3D->CurrentCamera].Yaw > 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Yaw -= 2 * M_PI;
	if(World3D->Camera[World3D->CurrentCamera].Yaw < 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Yaw += 2 * M_PI;

	if(World3D->Camera[World3D->CurrentCamera].Pitch > 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Pitch -= 2 * M_PI;
	if(World3D->Camera[World3D->CurrentCamera].Pitch < 2 * M_PI)
		World3D->Camera[World3D->CurrentCamera].Pitch += 2 * M_PI;
	return TRUE;
};



/*
#pragma argsused
int tmpCamera(CAMERA *Camera)
{
	float	sinRoll, cosRoll;
	float	sinYaw, cosYaw;
	float	sinPitch, cosPitch;
	CAMERA tempCamera;



	if(CamStruct[LEFT])
	{
		tempCamera.Yaw -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[RIGHT])
	{
		tempCamera.Yaw += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[UPRIGHT])
	{
		tempCamera.Pitch += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWNRIGHT])
	{
		tempCamera.Pitch -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[UPLEFT])
	{
		tempCamera.Roll += (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWNLEFT])
	{
		tempCamera.Roll -= (0.01745329 * World3D->DeltaTime / 1000) * 50;
	}

	if(tempCamera.Roll > 2 * M_PI)
		tempCamera.Roll -= 2 * M_PI;
	if(tempCamera.Roll < 2 * M_PI)
		tempCamera.Roll += 2 * M_PI;

	if(tempCamera.Yaw > 2 * M_PI)
		tempCamera.Yaw -= 2 * M_PI;
	if(tempCamera.Yaw < 2 * M_PI)
		tempCamera.Yaw += 2 * M_PI;

	if(tempCamera.Pitch > 2 * M_PI)
		tempCamera.Pitch -= 2 * M_PI;
	if(tempCamera.Pitch < 2 * M_PI)
		tempCamera.Pitch += 2 * M_PI;

		tempCamera.Yaw = (tempCamera.Yaw * (*(UpdateMatrix.MainMatrix.Ptr))) +
						(tempCamera.Pitch * (*(UpdateMatrix.MainMatrix.Ptr + 4))) +
						(tempCamera.Roll * (*(UpdateMatrix.MainMatrix.Ptr + 8))) +
						(*(UpdateMatrix.MainMatrix.Ptr + 12));

		tempCamera.Pitch = (tempCamera.Yaw * (*(UpdateMatrix.MainMatrix.Ptr + 1))) +
						(tempCamera.Pitch * (*(UpdateMatrix.MainMatrix.Ptr + 5))) +
						(tempCamera.Roll * (*(UpdateMatrix.MainMatrix.Ptr + 9))) +
						(*(UpdateMatrix.MainMatrix.Ptr + 13));

		tempCamera.Roll = (tempCamera.Yaw * (*(UpdateMatrix.MainMatrix.Ptr + 2))) +
						(tempCamera.Pitch * (*(UpdateMatrix.MainMatrix.Ptr + 6))) +
						(tempCamera.Roll * (*(UpdateMatrix.MainMatrix.Ptr + 10))) +
						(*(UpdateMatrix.MainMatrix.Ptr + 14));


World3D->Camera[World3D->CurrentCamera].Yaw = tempCamera.Yaw;
World3D->Camera[World3D->CurrentCamera].Pitch = tempCamera.Pitch;
World3D->Camera[World3D->CurrentCamera].Roll = tempCamera.Roll;


	sinRoll = sin(World3D->Camera[World3D->CurrentCamera].Roll);
	cosRoll = cos(World3D->Camera[World3D->CurrentCamera].Roll);

	sinYaw = sin(World3D->Camera[World3D->CurrentCamera].Yaw);
	cosYaw = cos(World3D->Camera[World3D->CurrentCamera].Yaw);

	sinPitch = sin(World3D->Camera[World3D->CurrentCamera].Pitch);
	cosPitch = cos(World3D->Camera[World3D->CurrentCamera].Pitch);


	if(CamStruct[UP])
	{
		World3D->Camera[World3D->CurrentCamera].xTranslate += (sinYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].yTranslate -= (sinPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].zTranslate += (cosYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
	}
	if(CamStruct[DOWN])
	{
		World3D->Camera[World3D->CurrentCamera].xTranslate -= (sinYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].yTranslate += (sinPitch * World3D->DeltaTime / 1000) * 50;
		World3D->Camera[World3D->CurrentCamera].zTranslate -= (cosYaw * cosPitch * World3D->DeltaTime / 1000) * 50;
	}


	return TRUE;
};
*/
