#include <windows.h>
#include <commdlg.h>
#include <appmain.h>
#include <dlgproc.h>
#include <ctl3d.h>
#include <world.h>
#include <mmsystem.h>

extern WORLD *World3D;

void ExecuteDialog(HWND Parent, void far PASCAL *Procedure, char *Template)
{
	DLGPROC dlgproc;

	dlgproc = (DLGPROC)MakeProcInstance((FARPROC)Procedure, WinApp::hInstance);
	DialogBox(WinApp::hInstance, Template, Parent, dlgproc);
	FreeProcInstance((FARPROC)dlgproc);
};

#pragma argsused
BOOL CALLBACK AboutProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
   	{
		case WM_INITDIALOG:
			Ctl3dSubclassDlgEx(hDlg, CTL3D_ALL);
			return(TRUE);
		case WM_COMMAND:
			if(wParam == IDOK)
			{
				EndDialog(hDlg, TRUE);
				World3D->OldTime = timeGetTime();
				return(TRUE);
			}
			break;
	}
	return(FALSE);
};

WORLDDRAW DrawSave;
MAPPING MapSave;

#pragma argsused
BOOL CALLBACK OptionsProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
			Ctl3dSubclassDlgEx(hDlg, CTL3D_ALL);
			DrawSave = World3D->DrawType;
			MapSave = World3D->PolyMap;

			if(World3D->DrawType == GT_WIREFRAME)
				CheckRadioButton(hDlg, 103, 107, 103);
			if(World3D->DrawType == GT_SOLID)
				CheckRadioButton(hDlg, 103, 107, 104);
			if(World3D->DrawType == GT_LAMBERT)
				CheckRadioButton(hDlg, 103, 107, 105);
			if(World3D->DrawType == GT_TEXTURE)
				CheckRadioButton(hDlg, 103, 107, 106);
			if(World3D->DrawType == GT_ASDEFINED)
				CheckRadioButton(hDlg, 103, 107, 107);
			if(World3D->PolyMap == MP_ZSORT)
				CheckRadioButton(hDlg, 101, 102, 101);
			if(World3D->PolyMap == MP_ZBUFFER)
				CheckRadioButton(hDlg, 101, 102, 102);
			return(TRUE);
		case WM_COMMAND:
			switch(wParam)
			{
				case IDOK:
					EndDialog(hDlg, TRUE);
					World3D->OldTime = timeGetTime();
					return(TRUE);
				case IDCANCEL:
					World3D->DrawType = DrawSave;
					World3D->PolyMap = MapSave;
					EndDialog(hDlg, TRUE);
					World3D->OldTime = timeGetTime();
					return(TRUE);
				case 101:
					World3D->PolyMap = MP_ZSORT;
					return(TRUE);
				case 102:
					World3D->PolyMap = MP_ZBUFFER;
					return(TRUE);
				case 103:
					World3D->DrawType = GT_WIREFRAME;
					return(TRUE);
				case 104:
					World3D->DrawType = GT_SOLID;
					return(TRUE);
				case 105:
					World3D->DrawType = GT_LAMBERT;
					return(TRUE);
				case 106:
					World3D->DrawType = GT_TEXTURE;
					return(TRUE);
				case 107:
					World3D->DrawType = GT_ASDEFINED;
					return(TRUE);
			}
			break;
	}
	return(FALSE);
};

char *CustomOpen(HWND hWindow)
{
	OPENFILENAME ofnTemp;
	char szTemp[] = "World Files (*.wld)\0*.wld\0Old World Files (*.vwf)\0*.vwf\0All Files (*.*)\0*.*\0\0";
	char szName[256];

	memset(szName, '\0', sizeof(char) * 256);
	ofnTemp.lStructSize = sizeof(OPENFILENAME);
	ofnTemp.hwndOwner = hWindow;
	ofnTemp.hInstance = 0;
	ofnTemp.lpstrFilter = (LPSTR)szTemp;
	ofnTemp.lpstrCustomFilter = NULL;
	ofnTemp.nMaxCustFilter = 0;
	ofnTemp.nFilterIndex = 1;
	ofnTemp.lpstrFile = (LPSTR)szName;
	ofnTemp.nMaxFile = sizeof(szName);
	ofnTemp.lpstrFileTitle = NULL;
	ofnTemp.nMaxFileTitle = 0;
	ofnTemp.lpstrInitialDir = NULL;
	ofnTemp.lpstrTitle = "Open World";
	ofnTemp.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;
	ofnTemp.nFileOffset = 0;
	ofnTemp.nFileExtension = 0;
	ofnTemp.lpstrDefExt = "*";
	ofnTemp.lCustData = NULL;
	ofnTemp.lpfnHook = NULL;
	ofnTemp.lpTemplateName = NULL;
	if(GetOpenFileName(&ofnTemp))
	{
		InvalidateRect(hWindow, NULL, TRUE);
		return((char *)szName);
	}
	else
	{
		InvalidateRect(hWindow, NULL, TRUE);
		return NULL;
    }
};

