#include <types.h>
#include <wgclass.h>
#include <math.h>
#include <world.h>
#include <mem.h>
#include <cycles.h>

typedef struct
{
	long	StartX;
	long	EndX;
	long	StartZ;
	long	EndZ;
	POINT	TextStart;
	POINT	TextEnd;

} zTBUFFER_SCAN;

void WORLD::ManualDrawPoly(CLIPPOLY *cp)
{
	int startx[200];
	int endx[200];
	int tmp, y;
	long x, m, val;
	int i, j;
	char *c;
	int x1, y1, x2, y2;

	for(i = 0; i < 200; i++)
	{
		startx[i] = -32000;
		endx[i] = -32000;
	}
//	memset(&startx, -32000, sizeof(int) * 200);
//	memset(&endx, -32000, sizeof(int) * 200);

	j = cp->NumVertices - 1;
	for(i = 0; i < cp->NumVertices; i++)
	{
		x1 = cp->Vertex[j].xRaster;
		y1 = cp->Vertex[j].yRaster;
		x2 = cp->Vertex[i].xRaster;
		y2 = cp->Vertex[i].yRaster;
		if(y2 != y1)
		{
			if(y2 < y1)
			{
				tmp = y2;
				y2 = y1;
				y1 = tmp;

				tmp = x2;
				x2 = x1;
				x1 = tmp;
			}

			x = (long)x1 << 8;
			m = ((long)(x2 - x1) << 8) / ((long)(y2 - y1));
			x += m;
			y1++;

			for(y = y1; y <= y2; y++)
			{
				if((y >= 0) && (y < 200))
				{
					if(startx[y] == -32000)
					{
						if((x >> 8) < 0)
							startx[y] = 0;
						else if((x >> 8) > 320)
							startx[y] = 320;
						else
							startx[y] = x >> 8;
					}
					else
					{
						if((x >> 8) < 0)
							endx[y] = 0;
						else if((x >> 8) > 320)
							endx[y] = 320;
						else
							endx[y] = x >> 8;
					}
				}
				x += m;
			}
		}

		j = i;
	}

	for(i = 0; i < 200; i++)
	{
		if(startx[i] != -32000)
		{
			if(endx[i] == -32000)
				endx[i] = startx[i];
			if(endx[i] < startx[i])
			{
				tmp = endx[i];
				endx[i] = startx[i];
				startx[i] = tmp;
			}
			c = (char *)WinGDrv->Surface + i * 320 + startx[i];
			for(j = 0; j < ((endx[i] - startx[i]) >> 2); j++)
			{
				val = (long)(cp->Color << 24) + (long)(cp->Color << 16) + (long)(cp->Color << 8) + (long)(cp->Color);
				*(long *)c = (long)val;
				c += 4;
			}

			if(((endx[i] - startx[i]) & 0x03))
			{
				for(j = 0; j < ((endx[i] - startx[i]) & 0x03); j++)
					*c++ = cp->Color;
			}
		}
	}
};

typedef struct
{
	long StartX;
	long StartZ;
	long EndX;
	long EndZ;
} zBUFFER_SCAN;

int WORLD::DrawZSolidPolygon(CLIPPOLY *p)
{
	zBUFFER_SCAN Scan[200];
	long tmp, y;
	long x, m;
	long z, zs;
	int i, j;
	char *c;
	long *d;
	long x1, y1, x2, y2, z1, z2;

	for(i = 0; i < 200; i++)
	{
		Scan[i].StartX = -32000;
		Scan[i].EndX = -32000;
	}

	j = p->NumVertices - 1;
	for(i = 0; i < p->NumVertices; i++)
	{
		x1 = (long)p->Vertex[j].xRaster;
		y1 = (long)p->Vertex[j].yRaster;
		z1 = (long)(p->Vertex[j].zCamera * 4096);
		x2 = (long)p->Vertex[i].xRaster;
		y2 = (long)p->Vertex[i].yRaster;
		z2 = (long)(p->Vertex[i].zCamera * 4096);
		if(y2 != y1)
		{
			if(y2 < y1)
			{
				tmp = y2;
				y2 = y1;
				y1 = tmp;

				tmp = x2;
				x2 = x1;
				x1 = tmp;

				tmp = z2;
				z2 = z1;
				z1 = tmp;
			}

			x = (long)(x1 << 8);
			m = ((long)((x2 - x1) << 8)) / ((long)(y2 - y1));
			z = (long)(z1);
			zs = ((long)((z2 - z1))) / ((long)(y2 - y1));
			x += m;
			z += zs;
			y1++;

			for(y = y1; y <= y2; y++)
			{
				if((y >= 0) && (y < 200))
				{
					if(Scan[y].StartX == -32000)
					{
						Scan[y].StartX = x >> 8;
						Scan[y].StartZ = z >> 8;
					}
					else
					{
						Scan[y].EndX = x >> 8;
						Scan[y].EndZ = z >> 8;
					}
				}
				x += m;
				z += zs;
			}
		}

		j = i;
	}

	for(i = 0; i < 200; i++)
	{
		if(Scan[i].StartX != -32000)
		{
			if(Scan[i].EndX == -32000)
			{
				Scan[i].EndX = Scan[i].StartX;
				Scan[i].EndZ = Scan[i].StartZ;
			}

			if(Scan[i].EndX < Scan[i].StartX)
			{
				tmp = Scan[i].EndX;
				Scan[i].EndX = Scan[i].StartX;
				Scan[i].StartX = tmp;

				tmp = Scan[i].EndZ;
				Scan[i].EndZ = Scan[i].StartZ;
				Scan[i].StartZ = tmp;
			}

			z = (Scan[i].StartZ << 8);
			if((Scan[i].EndX - Scan[i].StartX) == 0)
				zs = 0;
			else
				zs = ((Scan[i].EndZ - Scan[i].StartZ) << 8) / (Scan[i].EndX - Scan[i].StartX);

			if((Scan[i].StartX > 320) || (Scan[i].EndX < 0))
				continue;

			if(Scan[i].StartX < 0)
			{
				z += ((zs * -Scan[i].StartX));
				Scan[i].StartX = 0;
			}

			if(Scan[i].EndX > 320)
				Scan[i].EndX = 320;

			c = (char *)WinGDrv->Surface + i * 320 + Scan[i].StartX;
			d = (long *)zBuffer + i * 320 + Scan[i].StartX;

			for(j = 0; j < ((Scan[i].EndX - Scan[i].StartX)); j++)
			{
				if((*d >= (int)(z >> 8)) && ((z >> 8) > Camera[CurrentCamera].NearClipPlane))
				{
					*c++ = p->Color;
					*d++ = (int)(z >> 8);
					z += zs;
				}
				else
				{
					z += zs;
					c++; d++;
				}

			}
		}
	}

	return TRUE;
};

int WORLD::DrawTexturedPolygon(CLIPPOLY *p)
{
	zTBUFFER_SCAN Scan[200];
	long tmp, y;
	long x, m;
	long ts1, ts2, tslope1, tslope2;
	int i, j;
	char *c;
	long x1, y1, x2, y2;
	long val;
	POINT t1, t2, tp;

	for(i = 0; i < 200; i++)
	{
		Scan[i].StartX = -32000;
		Scan[i].EndX = -32000;
	}

	j = p->NumVertices - 1;
	for(i = 0; i < p->NumVertices; i++)
	{
		x1 = (long)p->Vertex[j].xRaster;
		y1 = (long)p->Vertex[j].yRaster;
		x2 = (long)p->Vertex[i].xRaster;
		y2 = (long)p->Vertex[i].yRaster;
		t1.x = p->TextPt[j].x;
		t2.x = p->TextPt[i].x;
		t1.y = p->TextPt[j].y;
		t2.y = p->TextPt[i].y;

		if(y2 != y1)
		{
			if(y2 < y1)
			{
				tmp = y2;
				y2 = y1;
				y1 = tmp;

				tmp = x2;
				x2 = x1;
				x1 = tmp;

				tp = t2;
				t2 = t1;
				t1 = tp;
			}

			x = (long)(x1 << 14);
			m = ((long)((x2 - x1) << 14)) / ((long)(y2 - y1));
			ts1 = (long)(t1.y << 14);
			ts2 = (long)(t1.x << 14);
			tslope1 = ((t2.y - t1.y) << 14) / ((long)(y2 - y1));
			tslope2 = ((t2.x - t1.x) << 14) / ((long)(y2 - y1));

			x += m;
			ts1 += tslope1;
			ts2 += tslope2;
			y1++;

			for(y = y1; y <= y2; y++)
			{
				if((y >= 0) && (y < 200))
				{
					if(Scan[y].StartX == -32000)
					{
						Scan[y].StartX = x >> 14;
						Scan[y].TextStart.x = ts2 >> 14;
						Scan[y].TextStart.y = ts1 >> 14;
					}
					else
					{
						Scan[y].EndX = x >> 14;
						Scan[y].TextEnd.x = ts2 >> 14;
						Scan[y].TextEnd.y = ts1 >> 14;
					}
				}
				x += m;
				ts1 += tslope1;
				ts2 += tslope2;
			}
		}

		j = i;
	}

	for(i = 0; i < 200; i++)
	{
		if(Scan[i].StartX != -32000)
		{
			if(Scan[i].EndX == -32000)
			{
				Scan[i].EndX = Scan[i].StartX;
				Scan[i].TextEnd = Scan[i].TextStart;
			}

			if(Scan[i].EndX < Scan[i].StartX)
			{
				tmp = Scan[i].EndX;
				Scan[i].EndX = Scan[i].StartX;
				Scan[i].StartX = tmp;

				tp = Scan[i].TextEnd;
				Scan[i].TextEnd = Scan[i].TextStart;
				Scan[i].TextStart = tp;
			}

			if((Scan[i].StartX > 320) || (Scan[i].EndX < 0))
				continue;

			DibTexture[p->Texture - 1].Data = (LPSTR)GlobalLock(DibTexture[p->Texture - 1].Handle);
			ts1 = (Scan[i].TextStart.x << 14);
			ts2 = (Scan[i].TextStart.y << 14);
			if((Scan[i].EndX - Scan[i].StartX) == 0)
			{
				tslope1 = 0;
				tslope2 = 0;
			}
			else
			{
				tslope1 = ((Scan[i].TextEnd.x - Scan[i].TextStart.x) << 14) / (Scan[i].EndX - Scan[i].StartX);
				tslope2 = ((Scan[i].TextEnd.y - Scan[i].TextStart.y) << 14) / (Scan[i].EndX - Scan[i].StartX);
			}

			if(Scan[i].StartX < 0)
			{
				ts1 += ((tslope1 * -Scan[i].StartX));
				ts2 += ((tslope2 * -Scan[i].StartX));
				Scan[i].StartX = 0;
			}

			if(Scan[i].EndX > 320)
				Scan[i].EndX = 320;

			long indx = i * 320 + Scan[i].StartX;
			c = (char *)WinGDrv->Surface + indx;
			char *tx = (LPSTR)DibTexture[p->Texture - 1].Data;
			long Width = DibTexture[p->Texture - 1].BitmapInfo.biWidth;

			for(j = 0; j < ((Scan[i].EndX - Scan[i].StartX) >> 2); j++)
			{
				if((*(tx + ((ts2 >> 14) * Width) + (ts1 >> 14))) != 0)
					*c  = *(tx + ((ts2 >> 14) * Width) + (ts1 >> 14));
				c++;
				ts1 += tslope1;
				ts2 += tslope2;

				if((*(tx + ((ts2 >> 14) * Width) + (ts1 >> 14))) != 0)
					*c  = *(tx + ((ts2 >> 14) * Width) + (ts1 >> 14));
				c++;
				ts1 += tslope1;
				ts2 += tslope2;

				if((*(tx + ((ts2 >> 14) * Width) + (ts1 >> 14))) != 0)
					*c  = *(tx + ((ts2 >> 14) * Width) + (ts1 >> 14));
				c++;
				ts1 += tslope1;
				ts2 += tslope2;

				if((*(tx + ((ts2 >> 14) * Width) + (ts1 >> 14))) != 0)
					*c  = *(tx + ((ts2 >> 14) * Width) + (ts1 >> 14));
				c++;
				ts1 += tslope1;
				ts2 += tslope2;

			}

			if((Scan[i].EndX - Scan[i].StartX) & 0x3)
			{
				val = (Scan[i].EndX - Scan[i].StartX) & 0x3;
				while(val--)
				{
					if((*(tx + ((ts2 >> 14) * Width) + (ts1 >> 14))) != 0)
						*c  = *(tx + ((ts2 >> 14) * Width) + (ts1 >> 14));
					c++;
					ts1 += tslope1;
					ts2 += tslope2;
				}
			}

		}
	}
	GlobalUnlock(DibTexture[p->Texture - 1].Handle);
	return TRUE;
};

int WORLD::DrawZTexturedPolygon(CLIPPOLY *p)
{
	zTBUFFER_SCAN Scan[200];
	long tmp, y;
	long x, m;
	long z, zs;
	long ts1, ts2, tslope1, tslope2;
	int i, j;
	char *c;
	int *d;
	long x1, y1, x2, y2, z1, z2;
	POINT t1, t2, tp;

	for(i = 0; i < 200; i++)
	{
		Scan[i].StartX = -32000;
		Scan[i].EndX = -32000;
	}

	j = p->NumVertices - 1;
	for(i = 0; i < p->NumVertices; i++)
	{
		x1 = (long)p->Vertex[j].xRaster;
		y1 = (long)p->Vertex[j].yRaster;
		z1 = (long)(p->Vertex[j].zCamera + 0.5);
		x2 = (long)p->Vertex[i].xRaster;
		y2 = (long)p->Vertex[i].yRaster;
		z2 = (long)(p->Vertex[i].zCamera + 0.5);
		t1.x = p->TextPt[j].x;
		t2.x = p->TextPt[i].x;
		t1.y = p->TextPt[j].y;
		t2.y = p->TextPt[i].y;

		if(y2 != y1)
		{
			if(y2 < y1)
			{
				tmp = y2;
				y2 = y1;
				y1 = tmp;

				tmp = x2;
				x2 = x1;
				x1 = tmp;

				tmp = z2;
				z2 = z1;
				z1 = tmp;

				tp = t2;
				t2 = t1;
				t1 = tp;
			}

			x = (long)(x1 << 14);
			m = ((long)((x2 - x1) << 14)) / ((long)(y2 - y1));
			z = (long)(z1 << 14);
			zs = ((long)((z2 - z1) << 14)) / ((long)(y2 - y1));
			ts1 = (long)(t1.y << 14);
			ts2 = (long)(t1.x << 14);
			tslope1 = ((t2.y - t1.y) << 14) / ((long)(y2 - y1));
			tslope2 = ((t2.x - t1.x) << 14) / ((long)(y2 - y1));

			x += m;
			z += zs;
			ts1 += tslope1;
			ts2 += tslope2;
			y1++;

			for(y = y1; y <= y2; y++)
			{
				if((y >= 0) && (y < 200))
				{
					if(Scan[y].StartX == -32000)
					{
						Scan[y].StartX = x >> 14;
						Scan[y].StartZ = z >> 14;
						Scan[y].TextStart.x = ts2 >> 14;
						Scan[y].TextStart.y = ts1 >> 14;
					}
					else
					{
						Scan[y].EndX = x >> 14;
						Scan[y].EndZ = z >> 14;
						Scan[y].TextEnd.x = ts2 >> 14;
						Scan[y].TextEnd.y = ts1 >> 14;
					}
				}
				x += m;
				z += zs;
				ts1 += tslope1;
				ts2 += tslope2;
			}
		}

		j = i;
	}

	for(i = 0; i < 200; i++)
	{
		if(Scan[i].StartX != -32000)
		{
			if(Scan[i].EndX == -32000)
			{
				Scan[i].EndX = Scan[i].StartX;
				Scan[i].EndZ = Scan[i].StartZ;
				Scan[i].TextEnd = Scan[i].TextStart;
			}

			if(Scan[i].EndX < Scan[i].StartX)
			{
				tmp = Scan[i].EndX;
				Scan[i].EndX = Scan[i].StartX;
				Scan[i].StartX = tmp;

				tmp = Scan[i].EndZ;
				Scan[i].EndZ = Scan[i].StartZ;
				Scan[i].StartZ = tmp;

				tp = Scan[i].TextEnd;
				Scan[i].TextEnd = Scan[i].TextStart;
				Scan[i].TextStart = tp;
			}

			if((Scan[i].StartX > 320) || (Scan[i].EndX < 0))
				continue;

			DibTexture[p->Texture - 1].Data = (LPSTR)GlobalLock(DibTexture[p->Texture - 1].Handle);
			char *tx = (LPSTR)DibTexture[p->Texture - 1].Data;
			long Width = DibTexture[p->Texture - 1].BitmapInfo.biWidth;

			z = (Scan[i].StartZ << 14);
			ts1 = (Scan[i].TextStart.x << 14);
			ts2 = (Scan[i].TextStart.y << 14);
			if((Scan[i].EndX - Scan[i].StartX) == 0)
			{
				tslope1 = 0;
				tslope2 = 0;
				zs = 0;
			}
			else
			{
				tslope1 = ((Scan[i].TextEnd.x - Scan[i].TextStart.x) << 14) / (Scan[i].EndX - Scan[i].StartX);
				tslope2 = ((Scan[i].TextEnd.y - Scan[i].TextStart.y) << 14) / (Scan[i].EndX - Scan[i].StartX);
				zs = ((Scan[i].EndZ - Scan[i].StartZ) << 14) / (Scan[i].EndX - Scan[i].StartX);
			}

			if(Scan[i].StartX < 0)
			{
				ts1 += ((tslope1 * -Scan[i].StartX));
				ts2 += ((tslope2 * -Scan[i].StartX));
				z += ((zs * -Scan[i].StartX) >> 14);
				Scan[i].StartX = 0;
			}

			if(Scan[i].EndX > 320)
				Scan[i].EndX = 320;

			c = (char *)WinGDrv->Surface + i * 320 + Scan[i].StartX;
			d = (int *)zBuffer + i * 320 + Scan[i].StartX;
			long Nw = Scan[i].EndX - Scan[i].StartX;

			for(j = 0; j < (Nw >> 1); j++)
			{
				if(*(int *)d >= (int)(z >> 14))
				{
					if(*(tx + ((ts2 >> 14) * Width) + (ts1 >> 14)) != 0)
					{
						*c = *(tx + ((ts2 >> 14) * Width) + (ts1 >> 14));
						*(int *)d = (int)(z >> 14);
					}
				}

				c++; d++; z += zs;
				ts1 += tslope1;
				ts2 += tslope2;

				if(*(int *)d >= (int)(z >> 14))
				{
					if(*(tx + ((ts2 >> 14) * Width) + (ts1 >> 14)) != 0)
					{
						*c = *(tx + ((ts2 >> 14) * Width) + (ts1 >> 14));
						*(int *)d = (int)(z >> 14);
					}
				}

				c++; d++; z += zs;
				ts1 += tslope1;
				ts2 += tslope2;
			}

			if(Nw & 0x1)
			{
				if(*(int *)d >= (int)(z >> 14))
				{
					if(*(tx + ((ts2 >> 14) * Width) + (ts1 >> 14)) != 0)
					{
						*c = *(tx + ((ts2 >> 14) * Width) + (ts1 >> 14));
						*(int *)d = (int)(z >> 14);
					}
				}

				c++; d++; z += zs;
				ts1 += tslope1;
				ts2 += tslope2;
			}
		}
	}
	GlobalUnlock(DibTexture[p->Texture - 1].Handle);
	return TRUE;
};

