#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <types.h>
#include <world.h>
#include <math3D.h>
#include <update.h>
#include <cameras.h>
#include <appmain.h>
#include <mmsystem.h>

int WORLD::LoadWorld(char *filename)
{
	FILE    *fp;
	char    buf[100];
	char    String[100];
	int     i;
	DWORD	prop;

	NumObjects = 0;
	NumCameras = 0;
	NumLights = 0;
	Number_Textures = 0;
	fp = fopen(filename, "rt");
	if(!fp)
	{
		MessageBox(GetFocus(), "File error on open.", "Error Opening File", MB_OK | MB_ICONEXCLAMATION);
		fclose(fp);
		return -1;
	}

	while(GetLine(buf, sizeof(buf), fp) != -1)
	{
		sscanf(buf, "%s", String);
		for(i = 0; i < strlen(String); i++)
			String[i] = (char)toupper(String[i]);

		if(stricmp(String, "NAME") == 0)
		{
			sscanf(buf, "%*s %s", WorldName);
			DisplayTextOnStatusBar("Now parsing the world...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
		}

		else if(stricmp(String, "CURRENT_CAMERA") == 0)
		{
			sscanf(buf, "%*s %s", String);
			SetCurrentCamera(String);
			DisplayTextOnStatusBar("Initializing current camera...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
		}

		else if(stricmp(String, "BACKCOLOR") == 0)
		{
			int r, g, b;
			sscanf(buf, "%*s %d %d %d", &r, &g, &b);
			BackColor = RGB(r, g, b);
			DisplayTextOnStatusBar("Loading backdrop color...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
		}

		else if(stricmp(String, "DITHERING") == 0)
		{
			sscanf(buf, "%*s %s", String);
			if(stricmp(String, "ON") == 0)
				DitherFlag = TRUE;
			else
				DitherFlag = FALSE;
			DisplayTextOnStatusBar("Setting dithering values...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
		}

		else if(stricmp(String, "NUMBER_OBJECTS") == 0)
		{
			sscanf(buf, "%*s %d", &i);
			Object = new OBJECT[i];
			DisplayTextOnStatusBar("Allocating object memory...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
		}

		else if(stricmp(String, "NUMBER_CAMERAS") == 0)
		{
			sscanf(buf, "%*s %d", &i);
			Camera = new CAMERA[i];
			DisplayTextOnStatusBar("Allocating camera memory...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
		}

		else if(stricmp(String, "NUMBER_LIGHTS") == 0)
		{
			sscanf(buf, "%*s %d", &i);
			Light = new LIGHT[i];
			DisplayTextOnStatusBar("Allocating light memory...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
		}

		else if(stricmp(String, "AMBIENT_LIGHT") == 0)
		{
			sscanf(buf, "%*s %f", &AmbientLight);
			DisplayTextOnStatusBar("Setting ambient light factor...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
		}

		else if(stricmp(String, "NUMBER_TEXTURES") == 0)
		{
			sscanf(buf, "%*s %d", &i);
			DibTexture = new WGDIB[i];
			DisplayTextOnStatusBar("Allocating texture memory...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
		}

		else if(stricmp(String, "TEXTURE") == 0)
		{
			if(DibTexture == NULL)
				MessageBox(GetFocus(), "Memory not allocated for textures.", "Enigmatic Experience", MB_OK);
			sscanf(buf, "%*s %s", String);
			DibTexture[Number_Textures++] = WinGDrv->LoadBitmap(String);
			DisplayTextOnStatusBar("Loading textures...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
		}

		else if(stricmp(String, "OBJECT") == 0)
		{
			if(Object == NULL)
				MessageBox(GetFocus(), "Memory not allocated for objects.", "Enigmatic Experience", MB_OK);

			DisplayTextOnStatusBar("Parsing object...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
			sscanf(buf, "%*s %s", String);
			memcpy(Object[NumObjects].Name, String, strlen(String));
			GetLine(buf, sizeof(buf), fp);
			sscanf(buf, "%s", String);
			if(stricmp(String, "START") != 0)
			{
				MessageBox(GetFocus(), "Error reading object.", "Enigmatic Experience", MB_OK);
				fclose(fp);
				return -1;
			}

			for(;;)
			{
				GetLine(buf, sizeof(buf), fp);
				sscanf(buf, "%s", String);
				for(i = 0; i < strlen(String); i++)
					String[i] = (char)toupper(String[i]);

				if(stricmp(String, "OBJFORMAT") == 0)
				{
					sscanf(buf, "%*s %s", String);
				}

				else if(stricmp(String, "FILENAME") == 0)
				{
					sscanf(buf, "%*s %s", String);
					LoadOBJFile(&Object[NumObjects], String);
				}

				else if(stricmp(String, "SCALE") == 0)
				{
					sscanf(buf, "%*s %f %f %f", &Object[NumObjects].xScale, &Object[NumObjects].yScale, &Object[NumObjects].zScale);
				}

				else if(stricmp(String, "ANGLE") == 0)
				{
					sscanf(buf, "%*s %f %f %f", &Object[NumObjects].Pitch, &Object[NumObjects].Yaw, &Object[NumObjects].Roll);
				}

				else if(stricmp(String, "TRANSLATE") == 0)
				{
					sscanf(buf, "%*s %f %f %f", &Object[NumObjects].xTranslate, &Object[NumObjects].yTranslate, &Object[NumObjects].zTranslate);
				}

				else if(stricmp(String, "LINEAR_VELOCITY") == 0)
					sscanf(buf, "%*s %f %f %f", &Object[NumObjects].LinearVelocity.xComp, &Object[NumObjects].LinearVelocity.yComp, &Object[NumObjects].LinearVelocity.zComp);

				else if(stricmp(String, "ROTATIONAL_VELOCITY") == 0)
					sscanf(buf, "%*s %f %f %f", &Object[NumObjects].RotationalVelocity.xComp, &Object[NumObjects].RotationalVelocity.yComp, &Object[NumObjects].RotationalVelocity.zComp);

				else if(stricmp(String, "MASS") == 0)
					sscanf(buf, "%*s %f", &Object[NumObjects].Mass);

				else if(stricmp(String, "ELASTICITY") == 0)
					sscanf(buf, "%*s %f", &Object[NumObjects].Elasticity);

				else if(stricmp(String, "LINEAR_ACCELERATION") == 0)
				{
					sscanf(buf, "%*s %f %f %f", &Object[NumObjects].LinearAccel.xComp, &Object[NumObjects].LinearAccel.yComp, &Object[NumObjects].LinearAccel.zComp);
				}

				else if(stricmp(String, "ROTATIONAL_ACCELERATION") == 0)
				{
					sscanf(buf, "%*s %f %f %f", &Object[NumObjects].RotationalAccel.xComp, &Object[NumObjects].RotationalAccel.yComp, &Object[NumObjects].RotationalAccel.zComp);
				}

				else if(stricmp(String, "FUNCTION") == 0)
				{
					sscanf(buf, "%*s %s", String);
						DefObjectFunction(String, &Object[NumObjects]);
				}

				else if(stricmp(String, "SPECIAL") == 0)
				{
					sscanf(buf, "%*s %ld", &Object[NumObjects].Special);
				}

				else if(stricmp(String, "END") == 0)
					break;
			}
			NumObjects++;
		}

		else if(stricmp(String, "CAMERA") == 0)
		{
			if(Camera == NULL)
					MessageBox(GetFocus(), "Memory not allocated for cameras.", "Enigmatic Experience", MB_OK);

			DisplayTextOnStatusBar("Parsing camera...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
			sscanf(buf, "%*s %s", String);
			memset(Camera[NumCameras].Name, '\0', strlen(Camera[NumCameras].Name));
			memcpy(Camera[NumCameras].Name, String, strlen(String));
			GetLine(buf, sizeof(buf), fp);

			if(stricmp(buf, "START") != 0)
			{
				MessageBox(GetFocus(), "Error reading camera.", "Enigmatic Experience", MB_OK);
				fclose(fp);
				return -1;
			}

			else
			{
				for(;;)
				{
					GetLine(buf, sizeof(buf), fp);
					sscanf(buf, "%s", String);
					for(i = 0; i < strlen(String); i++)
						String[i] = (char)toupper(String[i]);

					if(stricmp(String, "ZOOM") == 0)
					{
						sscanf(buf, "%*s %d", &Camera[NumCameras].ViewPlane);
						continue;
					}

					else if(stricmp(String, "HITHER") == 0)
					{
						sscanf(buf, "%*s %ld", &Camera[NumCameras].NearClipPlane);
						continue;
					}

					else if(stricmp(String, "YON") == 0)
					{
						sscanf(buf, "%*s %ld", &Camera[NumCameras].FarClipPlane);
						continue;
					}

					else if(stricmp(String, "ANGLE") == 0)
					{
						sscanf(buf, "%*s %f %f %f", &Camera[NumCameras].Pitch, &Camera[NumCameras].Yaw, &Camera[NumCameras].Roll);
						continue;
					}

					else if(stricmp(String, "TRANSLATE") == 0)
					{
						sscanf(buf, "%*s %f %f %f", &Camera[NumCameras].xTranslate, &Camera[NumCameras].yTranslate, &Camera[NumCameras].zTranslate);
						continue;
					}

					else if(stricmp(String, "FUNCTION") == 0)
					{
						sscanf(buf, "%*s %s", String);
							DefCameraFunction(String, &Camera[NumCameras]);
						continue;
					}

					else if(stricmp(String, "END") == 0)
						break;
				}
				NumCameras++;
			}
		}

		else if(stricmp(String, "LIGHT") == 0)
		{
			if(Light == NULL)
				MessageBox(GetFocus(), "Memory not allocated for lights.", "Enigmatic Experience", MB_OK);

			DisplayTextOnStatusBar("Parsing light...");
			prop = timeGetTime();
			while(timeGetTime() < (prop + 100)) {}
			sscanf(buf, "%*s %s", String);
			memcpy(Light[NumLights].Name, String, strlen(String));
			GetLine(buf, sizeof(buf), fp);
			sscanf(buf, "%s", String);

			if(stricmp(String, "START") != 0)
			{
				MessageBox(GetFocus(), "Error reading light.", "Enigmatic Experience", MB_OK);
				fclose(fp);
				return -1;
			}

			for(;;)
			{
				GetLine(buf, sizeof(buf), fp);
				sscanf(buf, "%s", String);
				for(i = 0; i < strlen(String); i++)
					String[i] = (char)toupper(String[i]);

				if(stricmp(String, "DEVIATION") == 0)
					sscanf(buf, "%*s %ld", &Light[NumLights].Deviation);

				else if(stricmp(String, "COLOR") == 0)
					sscanf(buf, "%*s %d %d %d", &Light[NumLights].RedLight, &Light[NumLights].GreenLight, &Light[NumLights].BlueLight);

				else if(stricmp(String, "DIRECTION") == 0)
				{
					sscanf(buf, "%*s %f %f %f", &Light[NumLights].Vector.xComp, &Light[NumLights].Vector.yComp, &Light[NumLights].Vector.zComp);
					Normalize(&Light[NumLights].Vector);
				}

				else if(stricmp(String, "SWITCH") == 0)
				{
					sscanf(buf, "%*s %s", String);
					if(stricmp(String, "ON") == 0)
						Light[NumLights].Switch = TRUE;
					else
						Light[NumLights].Switch = FALSE;
				}

				else if(stricmp(String, "END") == 0)
					break;
			}
			NumLights++;
		}
	}

	int j = 0;
	for(i = 0; i < NumObjects; i++)
	{
		Object[i].Update = TRUE;
		j += Object[i].NumPolygons;
	}

	PolygonList.Polygon = new CLIPPOLY[j];
	for(i = 0; i < j; i++)
	{
		PolygonList.Polygon[i].Vertex = new VERTEX[20];
		PolygonList.Polygon[i].TextPt = new POINT[20];
	}

	PolygonList.NumPolygons = 0;
	CurrentCamera = 0;
	DrawType = GT_ASDEFINED;
    PolyMap = MP_ZSORT;
	fclose(fp);
	WorldOpen = TRUE;
	DisplayTextOnStatusBar("Finished!");
	prop = timeGetTime();
	while(timeGetTime() < (prop + 100)) {}
	return 1;
};

int WORLD::LoadOBJFile(OBJECT *o, char *filename)
{
	FILE    *fp2;
	char    *pp;
	char    buf[100];
	char    String[100];
	int     i;
	long    pt;
	int     CVert = 0;
	int     CPoly = 0;

	o->NumVertices = 0;
	o->NumPolygons = 0;

	fp2 = fopen(filename, "rt");
	if(!fp2)
		return -1;

	while(GetLine(buf, sizeof(buf), fp2) != -1)
	{
		sscanf(buf, "%s", String);
		for(i = 0; i < strlen(String); i++)
			String[i] = (char)toupper(String[i]);

		if(stricmp(String, "NUMBER_VERTICES") == 0)
		{
			sscanf(buf, "%*s %d", &o->NumVertices);
			o->Vertex = new VERTEX[o->NumVertices];
		}

		else if(stricmp(String, "NUMBER_POLYGONS") == 0)
		{
			sscanf(buf, "%*s %d", &o->NumPolygons);
			o->Polygon = new POLYGON[o->NumPolygons];
		}

		else if(stricmp(String, "VERTEX") == 0)
		{
			if(o->NumVertices == 0)
			{
				MessageBox(GetFocus(), "Memory for vertices not defined!", "Enigmatic Experience", MB_OK);
				fclose(fp2);
				return -1;
			}

			GetLine(buf, sizeof(buf), fp2);
			sscanf(buf, "%s", String);

			if(stricmp(String, "START") != 0)
			{
				MessageBox(GetFocus(), "Error reading vertex.", "Enigmatic Experience", MB_OK);
				fclose(fp2);
				return -1;
			}

			for(;;)
			{
				GetLine(buf, sizeof(buf), fp2);
				sscanf(buf, "%s", String);
				for(i = 0; i < strlen(String); i++)
					String[i] = (char)toupper(String[i]);

				if(stricmp(String, "OBJ_COORDINATES") == 0)
					sscanf(buf, "%*s %f %f %f", &o->Vertex[CVert].xObject, &o->Vertex[CVert].yObject, &o->Vertex[CVert].zObject);

				else if(stricmp(String, "END") == 0)
					break;
			}
			CVert++;
		}

		else if(stricmp(String, "POLYGON") == 0)
		{
			if(o->NumPolygons == 0)
			{
				MessageBox(GetFocus(), "Memory for polygons not defined yet!", "Enigmatic Experience", MB_OK);
				fclose(fp2);
				return -1;
			}

			GetLine(buf, sizeof(buf), fp2);
			sscanf(buf, "%s", String);

			if(stricmp(String, "START") != 0)
			{
				MessageBox(GetFocus(), "Error reading polygon.", "Enigmatic Experience", MB_OK);
				fclose(fp2);
				return -1;
			}

			else
			{
				for(;;)
				{
					GetLine(buf, sizeof(buf), fp2);
					sscanf(buf, "%s", String);
					for(i = 0; i < strlen(String); i++)
						String[i] = (char)toupper(String[i]);

					if(stricmp(String, "NUMBER_VERTICES") == 0)
					{
						sscanf(buf, "%*s %d", &o->Polygon[CPoly].NumVertices);
						o->Polygon[CPoly].Vertex = new VERTEX *[o->Polygon[CPoly].NumVertices];
						o->Polygon[CPoly].TextPt = new POINT[o->Polygon[CPoly].NumVertices];
						continue;
					}

					else if(stricmp(String, "VERTICES") == 0)
					{
						pt = 0;
						for(i = 0; i < strlen(buf); i++)
						{
							if(isspace(buf[i]) || isdigit(buf[i]))
							{
								String[pt] = buf[i];
								pt++;
							}
						}
						String[pt] = '\0';
						pt = strtoul(String, &pp, (int)0);
						o->Polygon[CPoly].Vertex[0] = &o->Vertex[pt];

						for(i = 1; i < o->Polygon[CPoly].NumVertices; i++)
						{
							pt = strtoul(pp, &pp, (int)0);
							o->Polygon[CPoly].Vertex[i] = &o->Vertex[pt];
						}
						continue;
					}

					else if(stricmp(String, "TEXTURE") == 0)
					{
						sscanf(buf, "%*s %d", &o->Polygon[CPoly].Texture);
						continue;
					}

					else if(stricmp(String, "TEXTURE_COORDINATES") == 0)
					{
						GetLine(buf, sizeof(buf), fp2);
						sscanf(buf, "%s", String);
						if(stricmp(String, "{") != 0)
						{
							MessageBox(GetFocus(), "Error reading polygon.", "Enigmatic Experience", MB_OK);
							fclose(fp2);
							return -1;
						}

						for(i = 0; i < o->Polygon[CPoly].NumVertices; i++)
						{
							GetLine(buf, sizeof(buf), fp2);
							pt = strtoul(buf, &pp, (int)0);
							o->Polygon[CPoly].TextPt[i].x = pt;
							pt = strtoul(pp, &pp, (int)0);
							o->Polygon[CPoly].TextPt[i].y = pt;
						}
						GetLine(buf, sizeof(buf), fp2);
						sscanf(buf, "%s", String);
						if(stricmp(String, "}") != 0)
						{
							MessageBox(GetFocus(), "Error reading polygon.", "Enigmatic Experience", MB_OK);
							fclose(fp2);
							return -1;
						}
					}

					else if(stricmp(String, "BACKFACE") == 0)
					{
						sscanf(buf, "%*s %s", String);
						if(stricmp(String, "NEVER") == 0)
							o->Polygon[CPoly].BackfaceType = 0;
						else if(stricmp(String, "CLOCKWISE") == 0)
							o->Polygon[CPoly].BackfaceType = -1;
						else
							o->Polygon[CPoly].BackfaceType = 1;
					}

					else if(stricmp(String, "SURFACE") == 0)
					{
						sscanf(buf, "%*s %s", String);
						if(stricmp(String, "WIREFRAME") == 0)
							o->Polygon[CPoly].DrawType = PD_WIREFRAME;
						else if(stricmp(String, "SOLID") == 0)
							o->Polygon[CPoly].DrawType = PD_SOLID;
						else if(stricmp(String, "LAMBERT") == 0)
							o->Polygon[CPoly].DrawType = PD_LAMBERT;
						else if(stricmp(String, "TEXTURE") == 0)
							o->Polygon[CPoly].DrawType = PD_TEXTURE;
					}

					else if(stricmp(String, "COLOR") == 0)
					{
						sscanf(buf, "%*s %d", &o->Polygon[CPoly].Color);
						continue;
					}

					else if(stricmp(String, "SPECIAL") == 0)
					{
						sscanf(buf, "%*s %ld", &o->Polygon[CPoly].Special);
						continue;
					}

					else if(stricmp(String, "END") == 0)
						break;
				}
				CPoly++;
			}
		}
	}

	fclose(fp2);
	return 1;
};

int WORLD::GetLine(char *buff, int n, FILE *in)
{
	char *p;

	do
	{
		if (fgets(buff, n, in) == 0)
			return -1;
		if ((p = strchr(buff, '\n')) != NULL)
			*p = '\0';
		if ((p = strchr(buff, ';')) != NULL)
			*p = '\0';
		for (p = buff; isspace(*p); ++p);

	} while (p[0] == '\0');

	return 0;
};