#include <math.h>
#include <math3D.h>
#include <world.h>
#include <types.h>
#include <defines.h>

void WORLD::DrawPolygon(CLIPPOLY *p)
{
	POINT    *PT;
	HPEN     pen, hpen;
	HBRUSH   brush, hbrush;
	int      Counter1;
	BYTE     rgb[3];
	int 	 i, j;

	if(p->NumVertices <= 2)
		return;

	switch(DrawType)
	{
		case GT_WIREFRAME:
			xyClipPolygon(p);
			PT = new POINT[p->NumVertices];

			for(Counter1 = 0; Counter1 < p->NumVertices; Counter1++)
			{
				PT[Counter1].x = p->Vertex[Counter1].xRaster;
				PT[Counter1].y = p->Vertex[Counter1].yRaster;
			}
			pen = GetStockObject(BLACK_PEN);
			hpen = (HPEN)SelectObject(WinGDrv->WinGDC, pen);
			j = p->NumVertices - 1;
			for(i = 0; i < p->NumVertices; i++)
			{
				MoveToEx(WinGDrv->WinGDC, PT[j].x, PT[j].y, NULL);
				LineTo(WinGDrv->WinGDC, PT[i].x, PT[i].y);
				j = i;
			}
			SelectObject(WinGDrv->WinGDC, hpen);
			DeleteObject(pen);
			DeleteObject(hpen);
			delete PT;
			break;
		case GT_SOLID:
			if(p->Special == 1)
				ManualDrawPoly(p);
			else
			{
				if(PolyMap == MP_ZSORT)
					ManualDrawPoly(p);
				else
					DrawZSolidPolygon(p);
			}
			break;
		case GT_LAMBERT:
			float illum;
			int rillum;
			int gillum;
			int billum;

			xyClipPolygon(p);
			PT = new POINT[p->NumVertices];

			for(Counter1 = 0; Counter1 < p->NumVertices; Counter1++)
			{
				PT[Counter1].x = p->Vertex[Counter1].xRaster;
				PT[Counter1].y = p->Vertex[Counter1].yRaster;
			}

			CalcPolyNormal(p);
			Normalize(&p->Normal);

			rillum = gillum = billum = 0;

			for(Counter1 = 0; Counter1 < NumLights; Counter1++)
			{
				illum = (p->Normal DOT Light[Counter1].Vector);
				illum += AmbientLight;

				if(illum < AmbientLight)
					illum = AmbientLight;

				if(illum > 1.0)
					illum = 1.0;

				rillum += Light[Counter1].RedLight * illum;
				gillum += Light[Counter1].GreenLight * illum;
				billum += Light[Counter1].BlueLight * illum;

				rillum &= 255;
				gillum &= 255;
				billum &= 255;

			}
			rgb[0] = (BYTE)((PalEntry[p->Color].peRed) * rillum / 255);
			rgb[1] = (BYTE)((PalEntry[p->Color].peGreen) * gillum / 255);
			rgb[2] = (BYTE)((PalEntry[p->Color].peBlue) * billum / 255);

/*			i = GetNearestPaletteIndex(WinGDrv->GetPal(), RGB(rgb[0], rgb[1], rgb[2]));
			if(!DitherFlag)
			{
				j = p->Color;
				p->Color = i;
				ManualDrawPoly(p);
				p->Color = j;
				return;
			}*/

			brush = WinGCreateHalftoneBrush(WinGDrv->WinGDC, RGB(rgb[0], rgb[1], rgb[2]), WING_DISPERSED_4x4);
			pen = (HPEN)GetStockObject(NULL_PEN);
			hpen = SelectPen(WinGDrv->WinGDC, pen);
			hbrush = SelectBrush(WinGDrv->WinGDC, brush);
			Polygon(WinGDrv->WinGDC, PT, p->NumVertices);
			SelectObject(WinGDrv->WinGDC, hbrush);
			DeleteObject(brush);
			DeleteObject(hbrush);
			SelectPen(WinGDrv->WinGDC, hpen);
			DeleteObject(pen);
			DeleteObject(hpen);
			delete PT;
			break;
		case GT_TEXTURE:
			if(p->Special == 1)
				ManualDrawPoly(p);
			else
			{
				if(PolyMap == MP_ZSORT)
					DrawTexturedPolygon(p);
				else
					DrawZTexturedPolygon(p);
			}
			break;
		case GT_ASDEFINED:
			if(p->Special == 1)
				ManualDrawPoly(p);
			else
			{
				switch(p->DrawType)
				{
					case PD_WIREFRAME:
						xyClipPolygon(p);
						PT = new POINT[p->NumVertices];
						for(Counter1 = 0; Counter1 < p->NumVertices; Counter1++)
						{
							PT[Counter1].x = p->Vertex[Counter1].xRaster;
							PT[Counter1].y = p->Vertex[Counter1].yRaster;
						}
						pen = GetStockObject(BLACK_PEN);
						hpen = (HPEN)SelectObject(WinGDrv->WinGDC, pen);
						j = p->NumVertices - 1;
						for(i = 0; i < p->NumVertices; i++)
						{
							MoveToEx(WinGDrv->WinGDC, PT[j].x, PT[j].y, NULL);
							LineTo(WinGDrv->WinGDC, PT[i].x, PT[i].y);
							j = i;
						}
						SelectObject(WinGDrv->WinGDC, hpen);
						DeleteObject(pen);
						DeleteObject(hpen);
						delete PT;
						break;
					case PD_SOLID:
						if(p->Special == 1)
							ManualDrawPoly(p);
						else
						{
							if(PolyMap == MP_ZSORT)
								ManualDrawPoly(p);
							else
								DrawZSolidPolygon(p);
						}
						break;
					case PD_LAMBERT:
						float illum;
						int rillum;
						int gillum;
						int billum;
						xyClipPolygon(p);
						PT = new POINT[p->NumVertices];
						for(Counter1 = 0; Counter1 < p->NumVertices; Counter1++)
						{
							PT[Counter1].x = p->Vertex[Counter1].xRaster;
							PT[Counter1].y = p->Vertex[Counter1].yRaster;
						}
						CalcPolyNormal(p);
						Normalize(&p->Normal);
						rillum = gillum = billum = 0;
						for(Counter1 = 0; Counter1 < NumLights; Counter1++)
						{
							illum = (p->Normal DOT Light[Counter1].Vector);
							illum += AmbientLight;
							if(illum < AmbientLight)
								illum = AmbientLight;
							if(illum > 1.0)
								illum = 1.0;
							rillum += Light[Counter1].RedLight * illum;
							gillum += Light[Counter1].GreenLight * illum;
							billum += Light[Counter1].BlueLight * illum;
							rillum &= 255;
							gillum &= 255;
							billum &= 255;
						}
						rgb[0] = (BYTE)((PalEntry[p->Color].peRed) * rillum / 255);
						rgb[1] = (BYTE)((PalEntry[p->Color].peGreen) * gillum / 255);
						rgb[2] = (BYTE)((PalEntry[p->Color].peBlue) * billum / 255);
						brush = WinGCreateHalftoneBrush(WinGDrv->WinGDC, RGB(rgb[0], rgb[1], rgb[2]), WING_CLUSTERED_4x4);
						pen = (HPEN)GetStockObject(NULL_PEN);
						hpen = SelectPen(WinGDrv->WinGDC, pen);
						hbrush = SelectBrush(WinGDrv->WinGDC, brush);
						Polygon(WinGDrv->WinGDC, PT, p->NumVertices);
						SelectObject(WinGDrv->WinGDC, hbrush);
						DeleteObject(brush);
						DeleteObject(hbrush);
						SelectPen(WinGDrv->WinGDC, hpen);
						DeleteObject(pen);
						DeleteObject(hpen);
						delete PT;
						break;
					case PD_TEXTURE:
						if(p->Special == 1)
							ManualDrawPoly(p);
						else
						{
							if(PolyMap == MP_ZSORT)
								DrawTexturedPolygon(p);
							else
								DrawZTexturedPolygon(p);
						}
						break;
					}
				}
			}
};

BOOL WORLD::VertexOnRaster(VERTEX *v)
{
	if( (v->xRaster >= 0) && (v->xRaster <= ScreenInfo.Width) &&
		(v->yRaster >= 0) && (v->yRaster <= ScreenInfo.Width))
		return TRUE;

	return FALSE;
};

