#include <wgclass.h>
#include <cameras.h>
#include <types.h>

#define OPEN				100
#define CLOSE				110
#define EXIT				120

#define RENDER				200
#define INFO				210

#define WIRE				300
#define SOLID				310
#define LAMBERT				320
#define ASDEFN				108

#define ABOUT				400

struct WinApp
{
	static HINSTANCE 	hInstance;
    static HINSTANCE 	hPrevInst;
	static int			cmdShow;
};

inline BOOL     AppIdle(HWND);
inline void     DisplayFPS(HWND);
void            SetupWorld(HWND);
void            DrawBMP(HDC, char *, int, int);
void            DisplayBitmap(WGDIB Title, long time);
void			DisplayTextOnStatusBar(char *text);
void            PaintBack(HWND wnd, HDC dc, int w, int h, COLORREF Color);
int             HandleKeyboard(KEYBRD keybd, WPARAM Key, int UpDown);
void            DrawStatusBar(void);

LRESULT CALLBACK _export WndProc(HWND, UINT, WPARAM, LPARAM);
