#ifndef MATRIX_H

#define MATRIX_H    1 
#include <types.h>

#define DOT		%
#define CROSS 	^

typedef struct
{

// The actual 4 x 4 matrix
	float Element[4][4];
// The pointer to the elements
	float *Ptr;

} MATRIX4x4;

class MATRIX
{
public:
	MATRIX4x4		MainMatrix;
	MATRIX4x4		UsageMatrix;
	MATRIX4x4		TempMatrix;

				MATRIX();
	inline void Identity();
	void        Transform(OBJECT *object);
	void        TransformWithCamera(OBJECT *object);
	inline void Scale(float sx, float sy, float sz);
	inline void Rotate(float ax, float ay, float az);
	inline void RotateX(float x);
	inline void RotateY(float y);
	inline void RotateZ(float z);
	inline void Translate(float xt, float yt, float zt);
	void		Multiply(float *dest, float *mat1, float *mat2);
    void		Copy(float *dest, float *src);
};

float  		operator%(VECTOR Vector1, VECTOR Vector2);
VECTOR		operator^(VECTOR Vector1, VECTOR Vector2);
void 		VectorLength(VECTOR *Vector);
void 		Normalize(VECTOR *Vector);

#endif
