#ifndef TYPES_H
#define TYPES_H     1

#include <windows.h>

#define LEFT	0
#define RIGHT	1
#define UP		2
#define DOWN	3
#define UPRIGHT	4
#define UPLEFT	5
#define DOWNRIGHT	6
#define DOWNLEFT	7
#define CENTER		8

typedef int KEYBRD[101];

enum WORLDDRAW
{
	GT_WIREFRAME,
	GT_SOLID,
	GT_LAMBERT,
	GT_TEXTURE,
	GT_ASDEFINED
};

enum POLYGONDRAW
{
	PD_WIREFRAME,
	PD_SOLID,
	PD_LAMBERT,
	PD_TEXTURE
};

enum MAPPING
{
	MP_ZSORT,
	MP_ZBUFFER
};

typedef struct
{
	int     Width;
	int     Height;

} SCREEN;

typedef struct
{

// These are the vertex's object coordinates
	float    xObject, yObject, zObject;
// These are the vertex's world coordinates
	float    xWorld, yWorld, zWorld;
// These are the coordinates relative to the camera
	float    xCamera, yCamera, zCamera;
// These are the structural coordinates relative to another object
	float	xStruct, yStruct, zStruct;
// These are the vertex's screen (2D) coordinates
	long    xRaster, yRaster;

} VERTEX;

typedef struct
{

// These are the X, Y and Z components of the vector.
	float   xComp, yComp, zComp;
// This is the length of the vector.
	float   Length;

} VECTOR;

typedef struct LIGHT
{

// This is the lights directional heading
	VECTOR  Vector;
// The distance over which it completely spreads out
	long    Deviation;
// The amount of red light
	BYTE    RedLight;
// The amount of green light
	BYTE    GreenLight;
// The amount of blue light
	BYTE    BlueLight;
// The name of the light
	char	Name[36];
//	The light switch
	BOOL	Switch;

} LIGHT;

typedef struct
{

// This is the polygons color
	BYTE    Color;
// This is the number of vertices in the polygon
	UINT    NumVertices;
// This is the pointer to the vertices located in the object.
	VERTEX  **Vertex;
// This is the normal for the polygon
	VECTOR  Normal;
// Whether Backface culling should be done (counter - )clockwise
	int     BackfaceType;
// This is the distance from the Camera
	float   Distance;
// This is its ability to reflect
	float   Reflection;
// These are also for sorting (maximum values)
	float    xMax, yMax, zMax;
// Minimum values
	float    xMin, yMin, zMin;
// This is the drawing type of the polygon
	POLYGONDRAW DrawType;
//	This is a long to add any extra special properties
	long	Special;
// This is the index into the texture list
	UINT	Texture;
//	These are the texture coordinates
	POINT	*TextPt;

} POLYGON;

typedef struct
{

// This is the polygons color
	BYTE    Color;
// This is the number of vertices in the polygon
	UINT    NumVertices;
// This is the pointer to the vertices located in the object.
	VERTEX  *Vertex;
// This is the normal for the polygon
	VECTOR  Normal;
// Whether Backface culling should be done (counter - )clockwise
	int     BackfaceType;
// This is the distance from the Camera
	float   Distance;
// This is its ability to reflect
	float   Reflection;
// These are also for sorting (maximum values)
	float    xMax, yMax, zMax;
// Minimum values
	float    xMin, yMin, zMin;
// This is the drawing type of the polygon
	POLYGONDRAW DrawType;
// This is a long to add any extra special properties
	long	Special;
// This is the index into the texture list
	UINT	Texture;
//	These are the texture coordinates
	POINT	*TextPt;

} CLIPPOLY;

typedef struct
{

// These are the polygons
	CLIPPOLY *Polygon;
// This is the number of drawable polygons
	UINT     NumPolygons;

} POLYLIST;

typedef struct OBJECT
{

// These are the objects scaling factors
	float   xScale, yScale, zScale;
// These are the objects initial angle factors
	float     Pitch, Yaw, Roll;
// These are the translating values
	float    xTranslate, yTranslate, zTranslate;
// These are the old translating values
	float    Old_xTranslate, Old_yTranslate, Old_zTranslate;
// This is the number of polygons in the object
	UINT    NumPolygons;
// This is the number of vertices in the object
	UINT    NumVertices;
// These are the object's vertices
	VERTEX  *Vertex;
// These are the object's polygons
	POLYGON *Polygon;
// This is the objects mass in Megagrams
	float    Mass;
// This is a vector representing velocity
	VECTOR  LinearVelocity;
// This is a vector representing rotational velocity
	VECTOR  RotationalVelocity;
// This is its linear acceleration
	VECTOR  LinearAccel;
// This is its rotational acceleration
	VECTOR  RotationalAccel;
// This is the objects elasticity
	float   Elasticity;
// The function pointer for the objects behaviour
	int     (*ObjFunction)(OBJECT *);
// Do we need to update the object?
	BOOL     Update;
// The defined name of the object
	char	Name[36];
// This is a long to add any extra special properties
	long  Special;
} OBJECT;

typedef struct CAMERA
{

// This is the cameras translation
	float    xTranslate, yTranslate, zTranslate;
// This is the cameras angles of rotation
	float     Pitch, Yaw, Roll;
// This is the viewplane distance
	int     ViewPlane;
// This is the near clipping plane
	long    NearClipPlane;
// This is the far clipping plane
	long    FarClipPlane;
// The name of the camera
	char 	Name[36];
	VECTOR	Velocity;
	VECTOR	LinearAccel;
	VECTOR	RotateAccel;
// The camera's function
	int		(*CameraFunction)(CAMERA *);

} CAMERA;

#endif
