#ifndef _WIN_G_
#define _WIN_G_

#include <windows.h>
#include "wing.h"

typedef struct
{
	LPSTR				Data;
	HGLOBAL				Handle;
	RGBQUAD				Palette[256];
	BITMAPINFOHEADER	BitmapInfo;

} WGDIB;

class WIN_G
{
private:
	WORD        Width, Height;
	int         Orientation;
	HPALETTE    MainPal;
public:
	BMPINFO     BmpInfo;
	HDC         WinGDC;
	HBITMAP     WinGBMP;
	HBITMAP     OldBMP;
	void far    *Surface;

// Functions to initialize and destroy the WIN_G screen
	WIN_G(int width, int height);
	~WIN_G();

// The main functions that WIN_G handles
	int 	BltToScreen(HDC Screen, int x, int y);
	int 	StretchToScreen(HDC Screen, int x, int y, int w, int h);
	int 	Clear(COLORREF Col);
	int 	Clear();

// Bitmap routines and functions
	WGDIB	 LoadBitmap(char *file);
	HPALETTE LoadBitmapPalette(WGDIB Dib);
    int		 UseWinGPalette(HDC dc);
	int		 RemapBitmap(WGDIB Bitmap);
	int		 DisplayBitmap(WGDIB Dib, int xPos, int yPos);
	int		 TDisplayBitmap(WGDIB Dib, int xPos, int yPos, BYTE TCol);
	int		 FreeBitmap(WGDIB Bitmap);

// Some useful inline functions
	WORD GetWidth() {return Width;};
	WORD GetHeight() {return Height;};
	int  GetType() {return Orientation;};
	HPALETTE GetPal() {return MainPal;};
};

void    ClearSystemPalette(void);

#endif
