#ifndef WORLD_H
#define WORLD_H     1

#include <wgclass.h>
#include <types.h>
#include <math3D.h>
#include <stdio.h>

class WORLD
{
public:
//---------------------- World Globals -------------------
	UINT        NumObjects;
	OBJECT      *Object;

	UINT		Number_Textures;
	WGDIB		*DibTexture;

	UINT        CurrentCamera;
	UINT        NumCameras;
	CAMERA      *Camera;

	UINT        NumLights;
	LIGHT       *Light;

	void*		zBuffer;

	MATRIX	    *UpdateMatrix;
	char	    WorldName[36];
	float       AmbientLight;
	POLYLIST    PolygonList;
	WORLDDRAW   DrawType;
	MAPPING		PolyMap;
	DWORD		CurrentTime;
	DWORD		DeltaTime;
	DWORD		OldTime;


	BOOL        WorldOpen;
	BOOL		DitherFlag;
	DWORD		BackColor;

	PALETTEENTRY PalEntry[256];
	SCREEN       ScreenInfo;
	WIN_G       *WinGDrv;

//--------------------- Class Functions ------------------
				WORLD(int W, int H);
				~WORLD();
	void		CloseWorld(void);

//--------------------- File Functions -------------------
	int         LoadWorld(char *file);
	int  		GetLine(char *b, int n, FILE *fp);
	int			LoadOBJFile(OBJECT *o, char *file);

//----------------- Database Manipulation ----------------
	void        MakeList(void);
	void        SortList(void);
	void        DrawList(void);
	void		BubbleSort(void);
	void	    QSort(CLIPPOLY *item, int left, int right);

//----------------- Camera Functions ---------------------
	void		AlignWithCamera(void);
	void        Project(CLIPPOLY *poly);
	BOOL        FrontOfCamera(OBJECT *o);
	void		SetCurrentCamera(char *camera);

//----------------- Clipping Functions -------------------
	void        xyClipPolygon(CLIPPOLY *);
	void        zClipPolygon(POLYGON *, CLIPPOLY *);

//------------------ Raster Functions --------------------
	inline void DrawWorld(void);
	void        DrawPolygon(CLIPPOLY *p);
	void		ManualDrawPoly(CLIPPOLY *p);
	int			DrawZSolidPolygon(CLIPPOLY *p);
	int			DrawTexturedPolygon(CLIPPOLY *p);
	int			DrawZTexturedPolygon(CLIPPOLY *p);

//------------------ Test Functions ----------------------
	int         OnRaster(CLIPPOLY *p);
	inline BOOL BackfaceCull(POLYGON *p);
	inline BOOL VertexOnRaster(VERTEX *v);

//------------------ Pipeline Functions ------------------
	void        UpdateWorld(void);
	inline void UpdateObjects(void);

//--------------- Polygon Help Functions -----------------
	inline void CalcPolyNormal(CLIPPOLY *p);
	long        FindPolygonDistance(POLYGON *p);
	inline void TransferPolyData(POLYGON *src, CLIPPOLY *dst);
};

#endif

