#include <math.h>
#include <defines.h>
#include <world.h>
#include <types.h>
#include <math3D.h>
#include <kinimat.h>

extern WORLD 	*World3D;

VECTOR CalcForce(OBJECT *o, OBJECT *a)
{
	float G = 6.672 * pow10(-5);
	float Acceleration = 0;
	VECTOR Result;

	Result.xComp = a->Old_xTranslate - o->xTranslate;
	Result.yComp = a->Old_yTranslate - o->yTranslate;
	Result.zComp = a->Old_zTranslate - o->zTranslate;

	Result.Length = sqrt((Result.xComp * Result.xComp) + (Result.yComp * Result.yComp) + (Result.zComp * Result.zComp));

	if(Result.Length != 0)
	{
		Acceleration = G * a->Mass / (Result.Length * Result.Length);

		Result.xComp /= Result.Length;
		Result.yComp /= Result.Length;
		Result.zComp /= Result.Length;
	}
	else
	{
		Result.xComp = 0;
		Result.yComp = 0;
		Result.zComp = 0;
	}

	Result.xComp *= Acceleration;
	Result.yComp *= Acceleration;
	Result.zComp *= Acceleration;

	return Result;
};

#pragma argsused
BOOL DetectCollision(OBJECT *o)
{
	if(o->Special == 1)
	{
		if(o->yTranslate >= 0)
			return TRUE;
	}
	else if(o->Special == 2)
	{
		register int Counter1;
		for(Counter1 = 0; Counter1 < o->NumVertices; Counter1++)
		{
			if(o->Vertex[Counter1].yWorld >=0)
				return TRUE;
		}
	}
	else if(o->Special == 3)
	{
		register int Counter1;
		for(Counter1 = 0; Counter1 < o->NumVertices; Counter1++)
		{
			if(o->Vertex[Counter1].yWorld >=0)
				return TRUE;
		}
	}
	return FALSE;
};

void Collision(OBJECT *o)
{
	if(o->Special == 0)
		return;
	if(o->Special == 1)
	{
		o->yTranslate *= -1;
		o->LinearVelocity.yComp *= -1 * o->Elasticity;
	}
	else if(o->Special == 2)
	{
		register int Counter1;
		for(Counter1 = 0; Counter1 < o->NumVertices; Counter1++)
		{
			if(o->Vertex[Counter1].yWorld >=0)
			{
				o->yTranslate -= 2 * o->Vertex[Counter1].yWorld;
				o->LinearVelocity.yComp *= -1 * o->Elasticity;
				return;
			}
		}
	}
	else if(o->Special == 3)
	{
		register int Counter1;
		for(Counter1 = 0; Counter1 < o->NumVertices; Counter1++)
		{
			if(o->Vertex[Counter1].yWorld >=0)
			{
// I still can't make the rotation change correctly on a bounce
			}
		}
		o->yTranslate -= 2 * o->Vertex[Counter1].yWorld;
		o->LinearVelocity.yComp *= -1 * o->Elasticity;
	}
};
