#include <stdio.h>
#include <math.h>
#include <mem.h>
#include <math3D.h>
#include <types.h>

MATRIX::MATRIX()
{
	MainMatrix.Ptr = *MainMatrix.Element;
	TempMatrix.Ptr = *TempMatrix.Element;
	UsageMatrix.Ptr = *UsageMatrix.Element;

	Identity();
};

void MATRIX::Identity()
{
	memset(MainMatrix.Ptr, 0, sizeof(float) * 15);
	*(MainMatrix.Ptr)       =
	*(MainMatrix.Ptr + 5)   =
	*(MainMatrix.Ptr + 10)  =
	*(MainMatrix.Ptr + 15)  = 1;
};

void MATRIX::Multiply(float *ptr1, float *ptr2, float *ptr3)
{
	register int    i;
	register int    j;
	register int 	t;

	for(i = 0; i < 4; i++)
	{
		t = i * 4;
		for(j = 0; j < 4; j++)
		{
			*(ptr1 + t + j) =

					( (*(ptr2 + t)) * (*(ptr3 + j)))
				+   ( (*(ptr2 + t + 1)) * (*(ptr3 + 4 + j)))
				+   ( (*(ptr2 + t + 2)) * (*(ptr3 + 8 + j)))
				+   ( (*(ptr2 + t + 3)) * (*(ptr3 + 12 + j)));
		}
	}
};

void MATRIX::Copy(float *dest, float *src)
{
	memcpy(dest, src, sizeof(float) * 16);
};

void MATRIX::Scale(float sx, float sy, float sz)
{
	memset(UsageMatrix.Ptr, 0, sizeof(float) * 15);
	*(UsageMatrix.Ptr)      = (float)sx;
	*(UsageMatrix.Ptr + 5)  = (float)sy;
	*(UsageMatrix.Ptr + 10) = (float)sz;
	*(UsageMatrix.Ptr + 15) = (float)1;
	Multiply(TempMatrix.Ptr, UsageMatrix.Ptr, MainMatrix.Ptr);

	Copy(MainMatrix.Ptr, TempMatrix.Ptr);
};

void MATRIX::Rotate(float x, float y, float z)
{
	memset(UsageMatrix.Ptr, 0, sizeof(float) * 15);
	*(UsageMatrix.Ptr)      = cos(y);
	*(UsageMatrix.Ptr + 2)  = -sin(y);
	*(UsageMatrix.Ptr + 5)  = 1;
	*(UsageMatrix.Ptr + 8)  = sin(y);
	*(UsageMatrix.Ptr + 10) = cos(y);
	*(UsageMatrix.Ptr + 15) = 1;
	Multiply(TempMatrix.Ptr, MainMatrix.Ptr, UsageMatrix.Ptr);
	Copy(MainMatrix.Ptr, TempMatrix.Ptr);

	memset(UsageMatrix.Ptr, 0, sizeof(float) * 15);
	*(UsageMatrix.Ptr)      = 1;
	*(UsageMatrix.Ptr + 5)  = cos(x);
	*(UsageMatrix.Ptr + 6)  = sin(x);
	*(UsageMatrix.Ptr + 9)  = -sin(x);
	*(UsageMatrix.Ptr + 10) = cos(x);
	*(UsageMatrix.Ptr + 15) = 1;
	Multiply(TempMatrix.Ptr, MainMatrix.Ptr, UsageMatrix.Ptr);
	Copy(MainMatrix.Ptr, TempMatrix.Ptr);

	memset(UsageMatrix.Ptr, 0, sizeof(float) * 15);
	*(UsageMatrix.Ptr)      = cos(z);
	*(UsageMatrix.Ptr + 1)  = sin(z);
	*(UsageMatrix.Ptr + 4)  = -sin(z);
	*(UsageMatrix.Ptr + 5)  = cos(z);
	*(UsageMatrix.Ptr + 10) = 1;
	*(UsageMatrix.Ptr + 15) = 1;
	Multiply(TempMatrix.Ptr, MainMatrix.Ptr, UsageMatrix.Ptr);
	Copy(MainMatrix.Ptr, TempMatrix.Ptr);
};

void MATRIX::RotateX(float x)
{
	memset(UsageMatrix.Ptr, 0, sizeof(float) * 15);
	*(UsageMatrix.Ptr)      = 1;
	*(UsageMatrix.Ptr + 5)  = cos(x);
	*(UsageMatrix.Ptr + 6)  = sin(x);
	*(UsageMatrix.Ptr + 9)  = -sin(x);
	*(UsageMatrix.Ptr + 10) = cos(x);
	*(UsageMatrix.Ptr + 15) = 1;
	Multiply(TempMatrix.Ptr, MainMatrix.Ptr, UsageMatrix.Ptr);
	Copy(MainMatrix.Ptr, TempMatrix.Ptr);
};

void MATRIX::RotateY(float y)
{
	memset(UsageMatrix.Ptr, 0, sizeof(float) * 15);
	*(UsageMatrix.Ptr)      = cos(y);
	*(UsageMatrix.Ptr + 2)  = -sin(y);
	*(UsageMatrix.Ptr + 5)  = 1;
	*(UsageMatrix.Ptr + 8)  = sin(y);
	*(UsageMatrix.Ptr + 10) = cos(y);
	*(UsageMatrix.Ptr + 15) = 1;
	Multiply(TempMatrix.Ptr, MainMatrix.Ptr, UsageMatrix.Ptr);
	Copy(MainMatrix.Ptr, TempMatrix.Ptr);
};

void MATRIX::RotateZ(float z)
{
	memset(UsageMatrix.Ptr, 0, sizeof(float) * 15);
	*(UsageMatrix.Ptr)      = cos(z);
	*(UsageMatrix.Ptr + 1)  = sin(z);
	*(UsageMatrix.Ptr + 4)  = -sin(z);
	*(UsageMatrix.Ptr + 5)  = cos(z);
	*(UsageMatrix.Ptr + 10) = 1;
	*(UsageMatrix.Ptr + 15) = 1;
	Multiply(TempMatrix.Ptr, MainMatrix.Ptr, UsageMatrix.Ptr);
	Copy(MainMatrix.Ptr, TempMatrix.Ptr);
};

void MATRIX::Translate(float xt, float yt, float zt)
{
	memset(UsageMatrix.Ptr, 0, sizeof(float) * 15);
	*(UsageMatrix.Ptr)      =
	*(UsageMatrix.Ptr + 5)  =
	*(UsageMatrix.Ptr + 10) = 
	*(UsageMatrix.Ptr + 15) = 1;
	*(UsageMatrix.Ptr + 12) = (float)xt;
	*(UsageMatrix.Ptr + 13) = (float)yt;
	*(UsageMatrix.Ptr + 14) = (float)zt;
	Multiply(TempMatrix.Ptr, MainMatrix.Ptr, UsageMatrix.Ptr);

	Copy(MainMatrix.Ptr, TempMatrix.Ptr);
};

void MATRIX::Transform(OBJECT *object)
{
	register UINT   v;
	register VERTEX *vptr;

	for(v = 0; v < (*object).NumVertices; v++)
	{
		vptr = &(*object).Vertex[v];

		vptr->xWorld = (vptr->xObject * (*(MainMatrix.Ptr)))     +
					   (vptr->yObject * (*(MainMatrix.Ptr + 4))) +
					   (vptr->zObject * (*(MainMatrix.Ptr + 8))) +
					   (*(MainMatrix.Ptr + 12));

		vptr->yWorld = (vptr->xObject * (*(MainMatrix.Ptr + 1))) +
					   (vptr->yObject * (*(MainMatrix.Ptr + 5))) +
					   (vptr->zObject * (*(MainMatrix.Ptr + 9))) +
					   (*(MainMatrix.Ptr + 13));

		vptr->zWorld = (vptr->xObject * (*(MainMatrix.Ptr + 2)))  +
					   (vptr->yObject * (*(MainMatrix.Ptr + 6)))  +
					   (vptr->zObject * (*(MainMatrix.Ptr + 10))) +
					   (*(MainMatrix.Ptr + 14));
	}
};

void MATRIX::TransformWithCamera(OBJECT *object)
{
	register UINT   v;
	register VERTEX *vptr;

	for(v = 0; v < (*object).NumVertices; v++)
	{
		vptr = &(*object).Vertex[v];

		vptr->xCamera = (vptr->xWorld * (*(MainMatrix.Ptr))) +
						(vptr->yWorld * (*(MainMatrix.Ptr + 4))) +
						(vptr->zWorld * (*(MainMatrix.Ptr + 8))) +
						(*(MainMatrix.Ptr + 12));

		vptr->yCamera = (vptr->xWorld * (*(MainMatrix.Ptr + 1))) +
						(vptr->yWorld * (*(MainMatrix.Ptr + 5))) +
						(vptr->zWorld * (*(MainMatrix.Ptr + 9))) +
						(*(MainMatrix.Ptr + 13));

		vptr->zCamera = (vptr->xWorld * (*(MainMatrix.Ptr + 2))) +
						(vptr->yWorld * (*(MainMatrix.Ptr + 6))) +
						(vptr->zWorld * (*(MainMatrix.Ptr + 10))) +
						(*(MainMatrix.Ptr + 14));
	}
};

float operator%(VECTOR Vector1, VECTOR Vector2)
{
	return((Vector1.xComp * Vector2.xComp) +
		   (Vector1.yComp * Vector2.yComp) +
		   (Vector1.zComp * Vector2.zComp));
};

VECTOR operator^(VECTOR Vector1, VECTOR Vector2)
{
	register VECTOR Resultant;

	Resultant.xComp = ( (Vector1.yComp * Vector2.zComp) - (Vector1.zComp * Vector2.yComp) );
	Resultant.yComp = ( (Vector1.zComp * Vector2.xComp) - (Vector1.xComp * Vector2.zComp) );
	Resultant.zComp = ( (Vector1.xComp * Vector2.yComp) - (Vector1.yComp * Vector2.xComp) );

	return Resultant;
};

void VectorLength(VECTOR *Vect)
{
	Vect->Length = sqrt((Vect->xComp * Vect->xComp)
				+ (Vect->yComp * Vect->yComp)
				+ (Vect->zComp * Vect->zComp));
};

void Normalize(VECTOR *Vect)
{
	Vect->Length = sqrt((Vect->xComp * Vect->xComp)
				+ (Vect->yComp * Vect->yComp)
				+ (Vect->zComp * Vect->zComp));

	Vect->xComp = (Vect->Length == 0 ? 0 : Vect->xComp / Vect->Length);
	Vect->yComp = (Vect->Length == 0 ? 0 : Vect->yComp / Vect->Length);
	Vect->zComp = (Vect->Length == 0 ? 0 : Vect->zComp / Vect->Length);
};

