#include <types.h>
#include <world.h>

void WORLD::zClipPolygon(POLYGON *p, CLIPPOLY *clipp)
{
	register int    cp;
	register int	v1, v2;
	long    		hither;
	float			t;

	hither = Camera[CurrentCamera].NearClipPlane;
	cp = 0;
	TransferPolyData(p, clipp);

	v1 = p->NumVertices - 1;

	for(v2 = 0; v2 < p->NumVertices; v2++)
	{
		if( (p->Vertex[v1]->zCamera >= hither) && (p->Vertex[v2]->zCamera >= hither) )
		{
			clipp->Vertex[cp].xCamera = p->Vertex[v2]->xCamera;
			clipp->Vertex[cp].yCamera = p->Vertex[v2]->yCamera;
			clipp->Vertex[cp].zCamera = p->Vertex[v2]->zCamera;
			clipp->TextPt[cp] = p->TextPt[v2];
			cp++;
		}

		if( (p->Vertex[v1]->zCamera < hither) && (p->Vertex[v2]->zCamera < hither) )
		{
		}

		if( (p->Vertex[v1]->zCamera >= hither) && (p->Vertex[v2]->zCamera < hither) )
		{
			t = (float)(hither - p->Vertex[v1]->zCamera) / (float)(p->Vertex[v2]->zCamera - p->Vertex[v1]->zCamera);
			clipp->Vertex[cp].xCamera = p->Vertex[v1]->xCamera + (p->Vertex[v2]->xCamera - p->Vertex[v1]->xCamera) * t;
			clipp->Vertex[cp].yCamera = p->Vertex[v1]->yCamera + (p->Vertex[v2]->yCamera - p->Vertex[v1]->yCamera) * t;
			clipp->Vertex[cp].zCamera = hither;
			clipp->TextPt[cp].x = p->TextPt[v1].x + ((p->TextPt[v2].x - p->TextPt[v1].x) * t);
			clipp->TextPt[cp].y = p->TextPt[v1].y + ((p->TextPt[v2].y - p->TextPt[v1].y) * t);
			cp++;
		}

		if( (p->Vertex[v1]->zCamera < hither) && (p->Vertex[v2]->zCamera >= hither) )
		{
			t = (float)(hither - p->Vertex[v1]->zCamera) / (float)(p->Vertex[v2]->zCamera - p->Vertex[v1]->zCamera);
			clipp->Vertex[cp].xCamera = p->Vertex[v1]->xCamera + (p->Vertex[v2]->xCamera - p->Vertex[v1]->xCamera) * t;
			clipp->Vertex[cp].yCamera = p->Vertex[v1]->yCamera + (p->Vertex[v2]->yCamera - p->Vertex[v1]->yCamera) * t;
			clipp->Vertex[cp].zCamera = hither;
			clipp->TextPt[cp].x = p->TextPt[v1].x + ((p->TextPt[v2].x - p->TextPt[v1].x) * t);
			clipp->TextPt[cp].y = p->TextPt[v1].y + ((p->TextPt[v2].y - p->TextPt[v1].y) * t);
			cp++;
			clipp->Vertex[cp].xCamera = p->Vertex[v2]->xCamera;
			clipp->Vertex[cp].yCamera = p->Vertex[v2]->yCamera;
			clipp->Vertex[cp].zCamera = p->Vertex[v2]->zCamera;
			clipp->TextPt[cp] = p->TextPt[v2];
			cp++;
		}
		v1 = v2;
	}
	clipp->NumVertices = cp;
/*	clipp->TextPt = new POINT[clipp->NumVertices];

	int j = 0;
	for(int i = 0; i < clipp->NumVertices; i++)
	{
		if(j > p->NumVertices)
			j = 0;
		clipp->TextPt[i] = p->TextPt[j++];
	}*/
};

void WORLD::xyClipPolygon(CLIPPOLY *p)
{
	UINT     			NumVerts;
	register int      	cp;
	register int      	v1, v2;
	float    			slope;
	float    			DeltaX, DeltaY;
	register CLIPPOLY 	*Temp;

	Temp = new CLIPPOLY;
	Temp->Vertex = new VERTEX[20];

	cp = 0;
	NumVerts = p->NumVertices;
	v1 = NumVerts - 1;

	for(v2 = 0; v2 < NumVerts; v2++)
	{
		DeltaY = p->Vertex[v2].yRaster - p->Vertex[v1].yRaster;
		DeltaX = p->Vertex[v2].xRaster - p->Vertex[v1].xRaster;
		if( (p->Vertex[v1].xRaster >= 0) && (p->Vertex[v2].xRaster >= 0) )
		{
			Temp->Vertex[cp].xRaster = p->Vertex[v2].xRaster;
			Temp->Vertex[cp].yRaster = p->Vertex[v2].yRaster;
			cp++;
		}

		if( (p->Vertex[v1].xRaster < 0) && (p->Vertex[v2].xRaster < 0) )
		{
		}

		if( (p->Vertex[v1].xRaster >= 0) && (p->Vertex[v2].xRaster < 0) )
		{
			if(DeltaX != 0)
			{
				slope = (float)(DeltaY / DeltaX);
				Temp->Vertex[cp].yRaster = p->Vertex[v1].yRaster + slope * (-p->Vertex[v1].xRaster);
			}
			else
				Temp->Vertex[cp].yRaster = p->Vertex[v1].yRaster;
			Temp->Vertex[cp].xRaster = 0;
			cp++;
		}

		if( (p->Vertex[v1].xRaster < 0) && (p->Vertex[v2].xRaster >= 0) )
		{
			if(DeltaX != 0)
			{
				slope = (float)(DeltaY / DeltaX);
				Temp->Vertex[cp].yRaster = p->Vertex[v1].yRaster + slope * (-p->Vertex[v1].xRaster);
			}
			else
			   Temp->Vertex[cp].yRaster = p->Vertex[v1].yRaster;
			Temp->Vertex[cp].xRaster = 0;
			cp++;

			Temp->Vertex[cp].xRaster = p->Vertex[v2].xRaster;
			Temp->Vertex[cp].yRaster = p->Vertex[v2].yRaster;
			cp++;
		}
		v1 = v2;
	}
	p->NumVertices = cp;

	cp = 0;
	NumVerts = p->NumVertices;
	v1 = NumVerts - 1;

	for(v2 = 0; v2 < NumVerts; v2++)
	{
		DeltaY = Temp->Vertex[v2].yRaster - Temp->Vertex[v1].yRaster;
		DeltaX = Temp->Vertex[v2].xRaster - Temp->Vertex[v1].xRaster;
		if( (Temp->Vertex[v1].xRaster <= ScreenInfo.Width) && (Temp->Vertex[v2].xRaster <= ScreenInfo.Width) )
		{
			p->Vertex[cp].xRaster = Temp->Vertex[v2].xRaster;
			p->Vertex[cp].yRaster = Temp->Vertex[v2].yRaster;
			cp++;
		}

		if( (Temp->Vertex[v1].xRaster > ScreenInfo.Width) && (Temp->Vertex[v2].xRaster > ScreenInfo.Width) )
		{
		}

		if( (Temp->Vertex[v1].xRaster <= ScreenInfo.Width) && (Temp->Vertex[v2].xRaster > ScreenInfo.Width) )
		{
			if(DeltaX != 0)
			{
				slope = (float)(DeltaY / DeltaX);
				p->Vertex[cp].yRaster = Temp->Vertex[v1].yRaster + slope * (ScreenInfo.Width - Temp->Vertex[v1].xRaster);
          	}
          	else
				p->Vertex[cp].yRaster = Temp->Vertex[v1].yRaster;
			p->Vertex[cp].xRaster = ScreenInfo.Width;
			cp++;
		}

		if( (Temp->Vertex[v1].xRaster > ScreenInfo.Width) && (Temp->Vertex[v2].xRaster <= ScreenInfo.Width) )
		{
			if(DeltaX != 0)
		  	{
				slope = (float)(DeltaY / DeltaX);
				p->Vertex[cp].yRaster = Temp->Vertex[v1].yRaster + slope * (ScreenInfo.Width - Temp->Vertex[v1].xRaster);
          	}
          	else
            	p->Vertex[cp].yRaster = Temp->Vertex[v1].yRaster;
			p->Vertex[cp].xRaster = ScreenInfo.Width;
			cp++;
			p->Vertex[cp].xRaster = Temp->Vertex[v2].xRaster;
			p->Vertex[cp].yRaster = Temp->Vertex[v2].yRaster;
			cp++;
		}
		v1 = v2;
	}
	p->NumVertices = cp;

	cp = 0;
	NumVerts = p->NumVertices;
	v1 = NumVerts - 1;

	for(v2 = 0; v2 < NumVerts; v2++)
	{
		DeltaY = p->Vertex[v2].yRaster - p->Vertex[v1].yRaster;
		DeltaX = p->Vertex[v2].xRaster - p->Vertex[v1].xRaster;
		if( (p->Vertex[v1].yRaster >= 0) && (p->Vertex[v2].yRaster >= 0) )
		{
			Temp->Vertex[cp].xRaster = p->Vertex[v2].xRaster;
			Temp->Vertex[cp].yRaster = p->Vertex[v2].yRaster;
			cp++;
		}

		if( (p->Vertex[v1].yRaster < 0) && (p->Vertex[v2].yRaster < 0) )
		{
		}

		if( (p->Vertex[v1].yRaster >= 0) && (p->Vertex[v2].yRaster < 0) )
		{
			if(DeltaX != 0)
			{
				slope = (float)(DeltaY / DeltaX);
				Temp->Vertex[cp].xRaster = p->Vertex[v1].xRaster + (-p->Vertex[v1].yRaster) / slope;
            }
            else
				Temp->Vertex[cp].xRaster = p->Vertex[v1].xRaster;
			Temp->Vertex[cp].yRaster = 0;
			cp++;
		}

		if( (p->Vertex[v1].yRaster < 0) && (p->Vertex[v2].yRaster >= 0) )
		{
			if(DeltaX != 0)
			{
				slope = (float)(DeltaY / DeltaX);
				Temp->Vertex[cp].xRaster = p->Vertex[v1].xRaster + (-p->Vertex[v1].yRaster) / slope;
            }
            else
				Temp->Vertex[cp].xRaster = p->Vertex[v1].xRaster;
			Temp->Vertex[cp].yRaster = 0;
			cp++;

			Temp->Vertex[cp].xRaster = p->Vertex[v2].xRaster;
			Temp->Vertex[cp].yRaster = p->Vertex[v2].yRaster;
			cp++;
		}
		v1 = v2;
	}
	p->NumVertices = cp;

	cp = 0;
	NumVerts = p->NumVertices;
	v1 = NumVerts - 1;

	for(v2 = 0; v2 < NumVerts; v2++)
	{
		DeltaY = Temp->Vertex[v2].yRaster - Temp->Vertex[v1].yRaster;
		DeltaX = Temp->Vertex[v2].xRaster - Temp->Vertex[v1].xRaster;

		if( (Temp->Vertex[v1].yRaster <= ScreenInfo.Height) && (Temp->Vertex[v2].yRaster <= ScreenInfo.Height) )
		{
			p->Vertex[cp].xRaster = Temp->Vertex[v2].xRaster;
			p->Vertex[cp].yRaster = Temp->Vertex[v2].yRaster;
			cp++;
		}

		if( (Temp->Vertex[v1].yRaster > ScreenInfo.Height) && (Temp->Vertex[v2].yRaster > ScreenInfo.Height) )
		{
		}

		if( (Temp->Vertex[v1].yRaster <= ScreenInfo.Height) && (Temp->Vertex[v2].yRaster > ScreenInfo.Height) )
		{
			if(DeltaX != 0)
			{
				slope = (float)(DeltaY / DeltaX);
				p->Vertex[cp].xRaster = Temp->Vertex[v1].xRaster + (ScreenInfo.Height - Temp->Vertex[v1].yRaster) / slope;
            }
            else
				p->Vertex[cp].xRaster = Temp->Vertex[v1].xRaster;
			p->Vertex[cp].yRaster = ScreenInfo.Height;
			cp++;
		}

		if( (Temp->Vertex[v1].yRaster > ScreenInfo.Height) && (Temp->Vertex[v2].yRaster <= ScreenInfo.Height) )
		{
			if(DeltaX != 0)
			{
				slope = (float)(DeltaY / DeltaX);
				p->Vertex[cp].xRaster = Temp->Vertex[v1].xRaster + (ScreenInfo.Height - Temp->Vertex[v1].yRaster) / slope;
            }
            else
            	p->Vertex[cp].xRaster = Temp->Vertex[v1].xRaster;
			p->Vertex[cp].yRaster = ScreenInfo.Height;
			cp++;
			p->Vertex[cp].xRaster = Temp->Vertex[v2].xRaster;
			p->Vertex[cp].yRaster = Temp->Vertex[v2].yRaster;
			cp++;
		}
		v1 = v2;
	}

	p->NumVertices = cp;
	delete Temp->Vertex;
	delete Temp;
};

void WORLD::TransferPolyData(POLYGON *ps, CLIPPOLY *pd)
{
	register int i;

	pd->Color        = ps->Color;
	pd->Normal       = ps->Normal;
	pd->BackfaceType = ps->BackfaceType;
	pd->Distance     = ps->Distance;
	pd->xMax         = ps->xMax;
	pd->xMin         = ps->xMin;
	pd->yMax         = ps->yMax;
	pd->yMin         = ps->yMin;
	pd->zMax         = ps->zMax;
	pd->zMin         = ps->zMin;
	pd->DrawType     = ps->DrawType;
	pd->Texture      = ps->Texture;
	pd->Special		= ps->Special;
	pd->NumVertices = ps->NumVertices;
	for(i = 0; i < ps->NumVertices; i++)
	{
		pd->Vertex[i] = *ps->Vertex[i];
		pd->TextPt[i] = ps->TextPt[i];
	}
};
