#include <string.h>
#include <math.h>
#include <defines.h>
#include <world.h>
#include <types.h>
#include <math3D.h>
#include <kinimat.h>
#include <update.h>

extern WORLD 	*World3D;

void DefObjectFunction(char *String, OBJECT *o)
{
	if(stricmp(String, "None") == 0)
		o->ObjFunction = None;

	else if(stricmp(String, "Default") == 0)
		o->ObjFunction = Default;

	else if(stricmp(String, "Kinimat") == 0)
		o->ObjFunction = Kinimat;

	else if(stricmp(String, "Seek") == 0)
		o->ObjFunction = Seek;

//	else if(stricmp(String, "User1") == 0)
//		o->ObjFunction = User1;

//	else if(stricmp(String, "User2") == 0)
//		o->ObjFunction = User2;
};

int None(OBJECT *o)
{
		if(!o->Update)
			return 0;

		World3D->UpdateMatrix->Identity();

		if(o->Pitch > 2 * M_PI)
			o->Pitch -= 2 * M_PI;
		if(o->Pitch < 0)
			o->Pitch += 2 * M_PI;

		if(o->Yaw > 2 * M_PI)
			o->Yaw -= 2 * M_PI;
		if(o->Yaw < 0)
			o->Yaw += 2 * M_PI;

		if(o->Roll > 2 * M_PI)
			o->Roll -= 2 * M_PI;
		if(o->Roll < 0)
			o->Roll += 2 * M_PI;

		World3D->UpdateMatrix->Scale(o->xScale, o->yScale, o->zScale);
		World3D->UpdateMatrix->Rotate(o->Pitch, o->Yaw, o->Roll);
		World3D->UpdateMatrix->Translate(o->xTranslate, o->yTranslate, o->zTranslate);
		World3D->UpdateMatrix->Transform(o);
		o->Update = FALSE;

	return 0;
};


int Default(OBJECT *o)
{
	if(DetectCollision(o) == TRUE)
		Collision(o);

	World3D->UpdateMatrix->Identity();

	o->LinearVelocity.xComp += (o->LinearAccel.xComp * ((float)World3D->DeltaTime/1000));
	o->LinearVelocity.yComp += (o->LinearAccel.yComp * ((float)World3D->DeltaTime/1000));
	o->LinearVelocity.zComp += (o->LinearAccel.zComp * ((float)World3D->DeltaTime/1000));

	o->xTranslate += (o->LinearVelocity.xComp * ((float)World3D->DeltaTime/1000));
	o->yTranslate += (o->LinearVelocity.yComp * ((float)World3D->DeltaTime/1000));
	o->zTranslate += (o->LinearVelocity.zComp * ((float)World3D->DeltaTime/1000));

	o->RotationalVelocity.xComp += (o->RotationalAccel.xComp * ((float)World3D->DeltaTime/1000));
	o->RotationalVelocity.yComp += (o->RotationalAccel.yComp * ((float)World3D->DeltaTime/1000));
	o->RotationalVelocity.zComp += (o->RotationalAccel.zComp * ((float)World3D->DeltaTime/1000));

	o->Pitch += (o->RotationalVelocity.xComp * ((float)World3D->DeltaTime/1000));
	if(o->Pitch > 2 * M_PI) o->Pitch -= (2 * M_PI);
	if(o->Pitch < 0) o->Pitch += (2 * M_PI);
	o->Yaw += (o->RotationalVelocity.yComp * ((float)World3D->DeltaTime/1000));
	if(o->Yaw > 2 * M_PI) o->Yaw -= (2 * M_PI);
	if(o->Yaw < 0) o->Yaw += (2 * M_PI);
	o->Roll += (o->RotationalVelocity.zComp * ((float)World3D->DeltaTime/1000));
	if(o->Roll > 2 * M_PI) o->Roll -= (2 * M_PI);
	if(o->Roll < 0) o->Roll += (2 * M_PI);

	World3D->UpdateMatrix->Scale(o->xScale, o->yScale, o->zScale);
	World3D->UpdateMatrix->Rotate(o->Pitch, o->Yaw, o->Roll);
	World3D->UpdateMatrix->Translate(o->xTranslate, o->yTranslate, o->zTranslate);
	World3D->UpdateMatrix->Transform(o);

	return 0;
};

int Kinimat(OBJECT *o)
{
	VECTOR		 Temp, Accel;
	register int Counter1;
	OBJECT		 *a;

	Temp.xComp = 0;
	Temp.yComp = 0;
	Temp.zComp = 0;

	Accel.xComp = 0;
	Accel.yComp = 0;
	Accel.zComp = 0;

		for(Counter1 = 0; Counter1 < World3D->NumObjects ; Counter1++)
		{
			a = &World3D->Object[Counter1];

			if(a!=o)
				Temp = CalcForce(o, a);

			Accel.xComp += Temp.xComp;
			Accel.yComp += Temp.yComp;
			Accel.zComp += Temp.zComp;
		}

	if(DetectCollision(o) == TRUE)
		Collision(o);

	World3D->UpdateMatrix->Identity();

	o->LinearVelocity.xComp += (o->LinearAccel.xComp + Accel.xComp * ((float)World3D->DeltaTime/1000));
	o->LinearVelocity.yComp += (o->LinearAccel.yComp + Accel.yComp * ((float)World3D->DeltaTime/1000));
	o->LinearVelocity.zComp += (o->LinearAccel.zComp + Accel.zComp * ((float)World3D->DeltaTime/1000));

	o->xTranslate += (o->LinearVelocity.xComp * ((float)World3D->DeltaTime/1000));
	o->yTranslate += (o->LinearVelocity.yComp * ((float)World3D->DeltaTime/1000));
	o->zTranslate += (o->LinearVelocity.zComp * ((float)World3D->DeltaTime/1000));

	o->RotationalVelocity.xComp += (o->RotationalAccel.xComp * ((float)World3D->DeltaTime/1000));
	o->RotationalVelocity.yComp += (o->RotationalAccel.yComp * ((float)World3D->DeltaTime/1000));
	o->RotationalVelocity.zComp += (o->RotationalAccel.zComp * ((float)World3D->DeltaTime/1000));

	o->Pitch += (o->RotationalVelocity.xComp * ((float)World3D->DeltaTime/1000));
	if(o->Pitch > 2 * M_PI) o->Pitch -= 2 * M_PI;
	if(o->Pitch < 0) o->Pitch += 2 * M_PI;

	o->Yaw += (o->RotationalVelocity.yComp * ((float)World3D->DeltaTime/1000));
	if(o->Yaw > 2 * M_PI) o->Yaw -= 2 * M_PI;
	if(o->Yaw < 0) o->Yaw += 2 * M_PI;

	o->Roll += (o->RotationalVelocity.zComp * ((float)World3D->DeltaTime/1000));
	if(o->Roll > 2 * M_PI) o->Roll -= 2 * M_PI;
	if(o->Roll < 0) o->Roll += 2 * M_PI;

	World3D->UpdateMatrix->Scale(o->xScale, o->yScale, o->zScale);
	World3D->UpdateMatrix->Rotate(o->Pitch, o->Yaw, o->Roll);
	World3D->UpdateMatrix->Translate(o->xTranslate, o->yTranslate, o->zTranslate);
	World3D->UpdateMatrix->Transform(o);

	return 0;
};

int Seek(OBJECT *o)
{
	VECTOR		Temp;
	VECTOR		Accel;

	Temp.xComp = World3D->Camera[World3D->CurrentCamera].xTranslate - o->xTranslate;
	Temp.yComp = World3D->Camera[World3D->CurrentCamera].yTranslate - o->yTranslate;
	Temp.zComp = World3D->Camera[World3D->CurrentCamera].zTranslate - o->zTranslate;

	Accel.Length = sqrt((Temp.xComp * Temp.xComp) + (Temp.yComp * Temp.yComp) + (Temp.zComp * Temp.zComp));
	if(Accel.Length != 0)
	{
	Accel.xComp = Temp.xComp/Accel.Length*10;
	Accel.yComp = Temp.yComp/Accel.Length*10;
	Accel.zComp = Temp.zComp/Accel.Length*10;
	}

	if(DetectCollision(o) == TRUE)
			Collision(o);

	World3D->UpdateMatrix->Identity();

	o->LinearVelocity.xComp += (o->LinearAccel.xComp + Accel.xComp * ((float)World3D->DeltaTime/1000));
	o->LinearVelocity.yComp += (o->LinearAccel.yComp + Accel.yComp * ((float)World3D->DeltaTime/1000));
	o->LinearVelocity.zComp += (o->LinearAccel.zComp + Accel.zComp * ((float)World3D->DeltaTime/1000));

	o->xTranslate += (o->LinearVelocity.xComp * ((float)World3D->DeltaTime/1000));
	o->yTranslate += (o->LinearVelocity.yComp * ((float)World3D->DeltaTime/1000));
	o->zTranslate += (o->LinearVelocity.zComp * ((float)World3D->DeltaTime/1000));

	o->RotationalVelocity.xComp += (o->RotationalAccel.xComp * ((float)World3D->DeltaTime/1000));
	o->RotationalVelocity.yComp += (o->RotationalAccel.yComp * ((float)World3D->DeltaTime/1000));
	o->RotationalVelocity.zComp += (o->RotationalAccel.zComp * ((float)World3D->DeltaTime/1000));

	o->Pitch += (o->RotationalVelocity.xComp * ((float)World3D->DeltaTime/1000));
	if(o->Pitch > 2 * M_PI) o->Pitch -= 2 * M_PI;
	if(o->Pitch < 0) o->Pitch += 2 * M_PI;

	o->Yaw += (o->RotationalVelocity.yComp * ((float)World3D->DeltaTime/1000));
	if(o->Yaw > 2 * M_PI) o->Yaw -= 2 * M_PI;
	if(o->Yaw < 0) o->Yaw += 2 * M_PI;

	o->Roll += (o->RotationalVelocity.zComp * ((float)World3D->DeltaTime/1000));
	if(o->Roll > 2 * M_PI) o->Roll -= 2 * M_PI;
	if(o->Roll < 0) o->Roll += 2 * M_PI;

	World3D->UpdateMatrix->Scale(o->xScale, o->yScale, o->zScale);
	World3D->UpdateMatrix->Rotate(o->Pitch, o->Yaw, o->Roll);
	World3D->UpdateMatrix->Translate(o->xTranslate, o->yTranslate, o->zTranslate);
	World3D->UpdateMatrix->Transform(o);

	return 0;
};