#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <ctl3d.h>
#include "entcnvrt.h"

HINSTANCE       WinApp::hInstance;
HINSTANCE       WinApp::hPrevInst;
int             WinApp::cmdShow;
HMENU           hMenuInit;

void Convert(char *plgfile, char *entfile);
int  GetLine(char *buf, int n, FILE *fp);
void CreateWindows(HWND hWindow);
HFONT		SFont;

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInst, LPSTR, int cmdShow)
{
	HWND        MainWnd;
	MSG         msg;    
	WNDCLASS    WndClass;

	WinApp::hInstance = hInstance;
	WinApp::hPrevInst = hPrevInst;
	WinApp::cmdShow   = cmdShow;

	if(!WinApp::hPrevInst)
	{
		WndClass.style          = CS_HREDRAW | CS_VREDRAW;
		WndClass.lpfnWndProc    = WndProc;
		WndClass.cbClsExtra     = 0;    
		WndClass.cbWndExtra     = 0;
		WndClass.hInstance      = hInstance;
		WndClass.hIcon          = LoadIcon(WinApp::hInstance, "ENTCNVRT");
		WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
		WndClass.hbrBackground  = (HBRUSH)(GetStockObject(GRAY_BRUSH));
		WndClass.lpszMenuName   = NULL;
		WndClass.lpszClassName  = "MAINWND";

		RegisterClass(&WndClass);
	}
	Ctl3dRegister(hInstance);

	hMenuInit = LoadMenu(WinApp::hInstance, "MAINMENU");
	MainWnd   = CreateWindow("MAINWND", "Entity Convert v1.0b",
							 WS_OVERLAPPEDWINDOW,
							 0, 0, 380, 200,
							 NULL, hMenuInit, hInstance, NULL);
	ShowWindow(MainWnd, WinApp::cmdShow);
	UpdateWindow(MainWnd);

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	Ctl3dUnregister(hInstance);
	return msg.wParam;
};

LRESULT CALLBACK _export WndProc(HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
{
	char Input[255], Output[255];
	LOGFONT 	*lf;
	HFONT		OFont;
	PAINTSTRUCT	ps;
	HCURSOR 	OCur; 

	switch(message)
	{
		case WM_CREATE:
			lf = (LOGFONT *)LocalAlloc(LPTR, sizeof(LOGFONT));
			lf->lfHeight = 55;
			lf->lfWidth = 0;
			lf->lfEscapement = 220;
			lf->lfWeight = FW_NORMAL;
			lf->lfItalic = 1;
			strcpy(lf->lfFaceName, "Times New Roman");
			SFont = CreateFontIndirect((LOGFONT far *)lf);
			LocalFree((HLOCAL)lf);
			CreateWindows(hWindow);
			return 0;
		case WM_COMMAND:
			switch(wParam)
			{
				case 10:
					OCur = SetCursor(LoadCursor(NULL, IDC_WAIT));
					SendMessage(GetDlgItem(hWindow, 20), WM_GETTEXT, sizeof(Input), (LPARAM)Input);
					SendMessage(GetDlgItem(hWindow, 22), WM_GETTEXT, sizeof(Output), (LPARAM)Output);
					Convert(Input, Output);
					SetCursor(OCur);
					break;
				case 12:
					PostQuitMessage(0);
					break;
			}
			return(DefWindowProc(hWindow, message, wParam, lParam));
		case WM_PAINT:
			BeginPaint(hWindow, &ps);
				SetTextColor(ps.hdc, RGB(127, 0, 0));
				OFont = (HFONT)SelectObject(ps.hdc, SFont);
				SetBkMode(ps.hdc, TRANSPARENT);
				TextOut(ps.hdc, 20, 100, "Entity Convert", 14);
				SelectObject(OFont, ps.hdc);
				DeleteObject(OFont);
			EndPaint(hWindow, &ps);
			return 0;

		case WM_CTLCOLOR:
			switch(HIWORD(lParam))
			{
				case CTLCOLOR_BTN:
					return(GetStockObject(NULL_BRUSH));
			}
			return(DefWindowProc(hWindow, message, wParam, lParam));
		case WM_DESTROY:
			DeleteObject(SFont);
			PostQuitMessage(0);
			return 0;
		default:
			return(DefWindowProc(hWindow, message, wParam, lParam));
	}
};

void CreateWindows(HWND hWindow)
{
	HWND Edit1, Edit2;

	CreateWindow("BUTTON", "Convert",
				 WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE | WS_TABSTOP,
				 20, 120, 80, 30,
				 hWindow, (HMENU)10, WinApp::hInstance, NULL);
	CreateWindow("BUTTON", "Exit",
				 WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE | WS_TABSTOP,
				 280, 120, 80, 30,
				 hWindow, (HMENU)12, WinApp::hInstance, NULL);
	Ctl3dSubclassCtl(Edit1);
	Edit1 = CreateWindow("EDIT", "C:\\NorthCAD\\default.plg",
				 WS_CHILD | ES_LOWERCASE | ES_OEMCONVERT | ES_CENTER | ES_AUTOHSCROLL | WS_VISIBLE | WS_BORDER | WS_TABSTOP,
				 20, 40, 160, 25,
				 hWindow, (HMENU)20, WinApp::hInstance, NULL);
	Ctl3dSubclassCtl(Edit2);
	Edit2 = CreateWindow("EDIT", "C:\\Engima~1\\World\\Entity\\default.ent",
				 WS_CHILD | ES_LOWERCASE | ES_OEMCONVERT | ES_CENTER | ES_AUTOHSCROLL | WS_VISIBLE | WS_BORDER | WS_TABSTOP,
				 200, 40, 160, 25,
				 hWindow, (HMENU)22, WinApp::hInstance, NULL);
};

int GetLine(char *buff, int n, FILE *in)
{
	char *p;
	do
	{
		if (fgets(buff, n, in) == 0)
			return -1;
		if ((p = strchr(buff, '\n')) != NULL)
			*p = '\0';
		if ((p = strchr(buff, '#')) != NULL)
			*p = '\0';
		for (p = buff; isspace(*p); ++p);
	} while (p[0] == '\0'); 

	return 0;
};

void Convert(char *plgfile, char *entfile)
{
	FILE *plgf, *entf;
	char buf[100];
	long num[10];
	long i, v, p;
	char *pp;
	int numpts, pt;
    char name[40];
	int Color;

	plgf = fopen(plgfile, "rt");
	if(plgf == NULL)
    	return;
	entf = fopen(entfile, "wt");

	GetLine(buf, sizeof(buf), plgf);

	sscanf(buf, "%s %ld %ld", name, &num[0], &num[1]);
	fprintf(entf, "NUMBER_VERTICES %ld\n", num[0]);
	fprintf(entf, "NUMBER_POLYGONS %ld\n\n", num[1]);

	v = num[0]; p = num[1];

	for(i = 0; i < v; i++)
	{
		GetLine(buf, sizeof(buf), plgf);
		sscanf(buf, "%ld %ld %ld", &num[0], &num[1], &num[2]);
		fprintf(entf, "VERTEX\n");
		fprintf(entf, "START\n");
		fprintf(entf, "\tOBJ_COORDINATES %ld %ld %ld\n", num[0], num[1], num[2]);
        fprintf(entf, "END\n\n");
	}

	for(i = 0; i < p; i++)
	{
		GetLine(buf, sizeof(buf), plgf);
		Color = (int)strtoul(buf, &pp, (int)0);
		numpts = (int)strtoul(pp, &pp, (int)0);
		fprintf(entf, "POLYGON\n");
		fprintf(entf, "START\n");
		fprintf(entf, "\tNUMBER_VERTICES %d\n", numpts);
		fprintf(entf, "\tVERTICES ");

		for(v = 0; v < numpts; v++)
		{
			pt = (int)strtoul(pp, &pp, 0);
			fprintf(entf, "%d ", pt);
		}
		fprintf(entf, "\n");
		fprintf(entf, "\tBACKFACE COUNTERCLOCKWISE\n");
		fprintf(entf, "\tSURFACE WIREFRAME\n");
		fprintf(entf, "\tTEXTURE 1\n");
		fprintf(entf, "\tTEXTURE_COORDINATES\n\t{");
		for(v = 0; v < numpts; v++)
			fprintf(entf, "\n\t\t0 0");
		fprintf(entf, "\n\t}\n");
		fprintf(entf, "\tCOLOR %d\n", Color & 255);
		fprintf(entf, "END\n\n");

	}
	fclose(plgf);
	fclose(entf);
};
