#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "worldgen.h"

HINSTANCE       WinApp::hInstance;
HINSTANCE       WinApp::hPrevInst;
int             WinApp::cmdShow;
HMENU           hMenuInit;

int				NumObjects;
int				NumCameras;
int				NumLights;

void CreateWindows(HWND hWindow);
void GenerateWorld(char *file);

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInst, LPSTR, int cmdShow)
{
	HWND        MainWnd;
	MSG         msg;    
	WNDCLASS    WndClass;

	WinApp::hInstance = hInstance;
	WinApp::hPrevInst = hPrevInst;
	WinApp::cmdShow   = cmdShow;  

	if(!WinApp::hPrevInst)
	{
		WndClass.style          = CS_HREDRAW | CS_VREDRAW;
		WndClass.lpfnWndProc    = WndProc;
		WndClass.cbClsExtra     = 0;    
		WndClass.cbWndExtra     = 0;
		WndClass.hInstance      = hInstance;
		WndClass.hIcon          = LoadIcon(WinApp::hInstance, "WORLDGEN");
		WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW); 
		WndClass.hbrBackground  = (HBRUSH)(GetStockObject(GRAY_BRUSH));
		WndClass.lpszMenuName   = NULL;             
		WndClass.lpszClassName  = "MAINWND";

		RegisterClass(&WndClass);                   
	}

	hMenuInit = LoadMenu(WinApp::hInstance, "MAINMENU");
	MainWnd   = CreateWindow("MAINWND", "WorldGen v1.0b",
							 WS_OVERLAPPEDWINDOW,
							 200, 100, 300, 200,
							 NULL, hMenuInit, hInstance, NULL);
	ShowWindow(MainWnd, WinApp::cmdShow);
	UpdateWindow(MainWnd);

	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
};

LRESULT CALLBACK _export WndProc(HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
{
	char 		buf[255];
	LOGFONT 	*lf;
	HFONT		SFont;
	HFONT		OFont;
    PAINTSTRUCT	ps; 
	HCURSOR 	OCur;

	switch(message)
	{
		case WM_CREATE:
			CreateWindows(hWindow);
			return 0;
		case WM_PAINT:
            BeginPaint(hWindow, &ps);
				SetTextColor(ps.hdc, RGB(127, 0, 0));
				lf = (LOGFONT *)LocalAlloc(LPTR, sizeof(LOGFONT));
				lf->lfHeight = 75;
				lf->lfWidth = 0;
				lf->lfEscapement = 250;
				lf->lfWeight = FW_NORMAL;
				lf->lfItalic = 1;
				strcpy(lf->lfFaceName, "Times New Roman");
				SFont = CreateFontIndirect((LOGFONT far *)lf);
				OFont = (HFONT)SelectObject(ps.hdc, SFont);
				SetBkMode(ps.hdc, TRANSPARENT);
				TextOut(ps.hdc, 20, 100, "WorldGen", 8);
				SelectObject(OFont, ps.hdc);
				DeleteObject(SFont);
				DeleteObject(OFont);
				LocalFree((HLOCAL)lf);
			EndPaint(hWindow, &ps);
            return 0;
		case WM_COMMAND:
			switch(wParam)
			{
				case 10:
					OCur = SetCursor(LoadCursor(NULL, IDC_WAIT));
					SendMessage(GetDlgItem(hWindow, 20), WM_GETTEXT, sizeof(buf), (LPARAM)buf);
					GenerateWorld(buf);
					SetCursor(OCur);
					break;
				case 12:
					PostQuitMessage(0);
					break;
			}
			return(DefWindowProc(hWindow, message, wParam, lParam));
		case WM_CTLCOLOR:
			switch(HIWORD(lParam))
			{
				case CTLCOLOR_BTN:
					return(GetStockObject(NULL_BRUSH));
			}
			return(DefWindowProc(hWindow, message, wParam, lParam));
		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;
		default:
			return(DefWindowProc(hWindow, message, wParam, lParam));
	}
};

void CreateWindows(HWND hWindow)
{
	CreateWindow("BUTTON", "Generate",
				 WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
				 20, 120, 80, 30,
				 hWindow, (HMENU)10, WinApp::hInstance, NULL);
	CreateWindow("BUTTON", "Exit",
				 WS_CHILD | BS_PUSHBUTTON | WS_VISIBLE,
				 200, 120, 80, 30,
				 hWindow, (HMENU)12, WinApp::hInstance, NULL);
	CreateWindow("EDIT", "default.wld",
				 WS_CHILD | ES_LOWERCASE | ES_OEMCONVERT | ES_CENTER | ES_AUTOHSCROLL | WS_VISIBLE | WS_BORDER,
				 70, 40, 160, 25,
				 hWindow, (HMENU)20, WinApp::hInstance, NULL);
};

void GenerateWorld(char *file)
{
	FILE *fp;

	fp = fopen(file, "wt");
	if(!fp)
		return;

	fprintf(fp, "; -------------------- EE3D World File -------------------\n");
	fprintf(fp, ";                 Generated by WorldGen v1.0b\n\n");

	fprintf(fp, "; This name of the World (Up to 35 chars)\n");
	fprintf(fp, "; Usage (NAME 'WorldName')\n");
	fprintf(fp, "NAME GenericWorld\n\n");

	fprintf(fp, "; Whether or not an horizon should be used\n");
	fprintf(fp, "; Usage (HORIZON ON | OFF)\n");
	fprintf(fp, "HORIZON Off\n\n");

	fprintf(fp, "; Whether or not an dithering should be used\n");
	fprintf(fp, "; Usage (DITHERING ON | OFF)\n");
	fprintf(fp, "DITHERING OFF\n\n");

	fprintf(fp, "; The Background color\n");
	fprintf(fp, "; Usage (BACKCOLOR RedValue GreenValue BlueValue)\n");
	fprintf(fp, "BACKCOLOR 0 204 255\n\n");

	fprintf(fp, "; The amount of memory to allocate for the objects database\n");
	fprintf(fp, "; Usage (NUMBER_OBJECTS Num)\n");
	fprintf(fp, "NUMBER_OBJECTS 1\n\n");

	fprintf(fp, "; The amount of memory to allocate for the cameras database\n");
	fprintf(fp, "; Usage (NUMBER_CAMERAS Num)\n");
	fprintf(fp, "NUMBER_CAMERAS 1\n\n");

	fprintf(fp, "; The amount of memory to allocate for the lights database\n");
	fprintf(fp, "; Usage (NUMBER_LIGHTS Num)\n");
	fprintf(fp, "NUMBER_LIGHTS 1\n\n");

	fprintf(fp, "; The amount of memory to allocate for the textures\n");
	fprintf(fp, "; Usage (NUMBER_TEXTURES Num)\n");
	fprintf(fp, "NUMBER_TEXTURES 1\n");
	fprintf(fp, "TEXTURE c:\enigma~1\bitmaps\texture1.bmp\n\n");

	fprintf(fp, "; A generic object\n");
	fprintf(fp, "; Usage (OBJECT ObjectName)\n");
	fprintf(fp, "OBJECT Object1\n");
	fprintf(fp, "; Signifies the start of the object\n");
	fprintf(fp, "START\n");
	fprintf(fp, "; The format for the object file (Not Used)\n");
	fprintf(fp, "\tOBJFORMAT ENIGMA_OBJECT\n");
	fprintf(fp, "; The filename of the object to load\n");
	fprintf(fp, "\tFILENAME object1.ent\n");
	fprintf(fp, "; The X Y Z scaling factors\n");
	fprintf(fp, "\tSCALE 1.0 1.0 1.0\n");
	fprintf(fp, "; The initial angles of rotation for the object\n");
	fprintf(fp, "\tANGLE 3.141592 0 0\n");
	fprintf(fp, "; The X Y Z translation\n");
	fprintf(fp, "\tTRANSLATE 0 0 0\n");
	fprintf(fp, "; The mass of the object in grams\n");
	fprintf(fp, "\tMASS 1000\n");
	fprintf(fp, "; The velocity vector for the object\n");
	fprintf(fp, "\tVELOCITY 0 0 0\n");
	fprintf(fp, "; The objects elasticity\n");
	fprintf(fp, "\tELASTICITY 0.45\n");
	fprintf(fp, "; The linear acceleration vector\n");
	fprintf(fp, "\tLINEAR_ACCELERATION 0 0 0\n");
	fprintf(fp, "; The rotational acceleration vector\n");
	fprintf(fp, "\tROTATIONAL_ACCELERATION 0 0 0\n");
	fprintf(fp, "; The objects function (can be NONE)\n");
	fprintf(fp, "\tFUNCTION NONE\n");
	fprintf(fp, "; Signifies the end of the object\n");
	fprintf(fp, "END\n\n");

	fprintf(fp, "; A generic camera\n");
	fprintf(fp, "; Usage (CAMERA CameraName)\n");
	fprintf(fp, "CAMERA Camera1\n");
	fprintf(fp, "; Signifies the start of the camera\n");
	fprintf(fp, "START\n");
	fprintf(fp, "; The zoom factor for the camera (the ViewPlane)\n");
	fprintf(fp, "\tZOOM 500\n");
	fprintf(fp, "; The near clipping plane\n");
	fprintf(fp, "\tHITHER 2\n");
	fprintf(fp, "; The far clipping plane\n");
	fprintf(fp, "\tYON 3000\n");
	fprintf(fp, "; The initial angles of rotation for the camera\n");
	fprintf(fp, "\tANGLE 0 0 0\n");
	fprintf(fp, "; The X Y Z translation\n");
	fprintf(fp, "\tTRANSLATE 0 0 0\n");
	fprintf(fp, "; The cameras function (can be NONE)\n");
	fprintf(fp, "\tFUNCTION NONE\n");
	fprintf(fp, "; Signifies the end of the camera\n");
	fprintf(fp, "END\n\n");

	fprintf(fp, "; A generic light\n");
	fprintf(fp, "; Usage (LIGHT LightName)\n");
	fprintf(fp, "LIGHT Light1\n");
	fprintf(fp, "; Signifies the start of the light\n");
	fprintf(fp, "START\n");
	fprintf(fp, "; The deviation for the light\n");
	fprintf(fp, "\tDEVIATION 1000\n");
	fprintf(fp, "; The color of the light\n");
	fprintf(fp, "\tCOLOR 255 255 255\n");
	fprintf(fp, "; The direction of the light\n");
	fprintf(fp, "\tDIRECTION 1 1 1\n");
	fprintf(fp, "; The on/off switch for the light\n");
	fprintf(fp, "\tSWITCH ON\n");
	fprintf(fp, "; Signifies the end of the light\n");
	fprintf(fp, "END\n\n");

	fprintf(fp, "; This is the current camera\n");
	fprintf(fp, "CURRENT_CAMERA Camera1\n\n");

	fprintf(fp, "; The amount of ambient light in the world\n");
	fprintf(fp, "AMBIENT_LIGHT 0.50\n");

	fclose(fp);
};
