#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include "wing.h"
#include "wgclass.h"

WIN_G::WIN_G(int width, int height)
{
	BMPINFO Info;

	Width = (WORD)width;
	Height = (WORD)height;

	if(WinGRecommendDIBFormat((BITMAPINFO FAR *)&Info) == FALSE)
		MessageBox(GetFocus(), "Cannot Recommend Format", "Class Error", MB_OK);

	Orientation = -1;//(int)Info.bmiHeader.biHeight;
// Use Top-Down for easier access to bytes

	Info.bmiHeader.biHeight = -height;
	Info.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	Info.bmiHeader.biCompression = BI_RGB;
	Info.bmiHeader.biWidth = width;

	MainPal = WinGCreateHalftonePalette();
	WinGDC = WinGCreateDC();

	GetPaletteEntries(MainPal, 0, 256, (PALETTEENTRY far *)Info.bmiColors);
	for(int Counter = 0; Counter < 256; Counter++)
	{
		BYTE Temp = Info.bmiColors[Counter].rgbBlue;
		Info.bmiColors[Counter].rgbBlue = Info.bmiColors[Counter].rgbRed;
		Info.bmiColors[Counter].rgbRed = Temp;
	}

	WinGBMP = WinGCreateBitmap(WinGDC, (BITMAPINFO FAR *)&Info, &Surface);
	OldBMP = (HBITMAP)SelectObject(WinGDC, WinGBMP);
	PatBlt(WinGDC, 0, 0, width, height, WHITENESS);

	BmpInfo = Info;
};

WIN_G::~WIN_G()
{
	SelectObject(WinGDC, OldBMP);
	DeleteObject(WinGBMP);
	DeleteDC(WinGDC);
	DeleteObject(MainPal);
};

int WIN_G::BltToScreen(HDC Screen, int x, int y)
{
	WinGBitBlt(Screen, x, y, Width, Height, WinGDC, 0, 0);
	return 0;
};

int WIN_G::StretchToScreen(HDC Screen, int x, int y, int w, int h)
{
	WinGStretchBlt(Screen, x, y, w, h, WinGDC, 0, 0, Width, Height);
	return 0;
};

int WIN_G::Clear()
{
	PatBlt(WinGDC, 0, 0, Width, Height, BLACKNESS);
	return 0;
};

int WIN_G::Clear(COLORREF Col)
{
	HBRUSH Brush, Oldbrush;

	Brush = CreateSolidBrush(Col);
	Oldbrush = SelectObject(WinGDC, Brush);
	PatBlt(WinGDC, 0, 0, Width, Height, PATCOPY);
	SelectObject(WinGDC, Oldbrush);
	DeleteObject(Brush);
	return 0;
};

// The following are extra WinG functions that are here to
// deal with bitmaps.

WGDIB WIN_G::LoadBitmap(char *file)
{
	FILE	*fp;
	char	buf[127];
	WGDIB	TDib;
	int		NumColors;
	BYTE	*TempData;

	fp = fopen(file, "rb");
	if(!fp)
	{
		sprintf(buf, "Cannot find file %s.", file);
		MessageBox(GetFocus(), buf, "Error Message", MB_OK | MB_ICONEXCLAMATION);
		fclose(fp);
	}

// This will be the bitmap's info
	fseek(fp, sizeof(BITMAPFILEHEADER), SEEK_SET);
	fread(&TDib.BitmapInfo, sizeof(BITMAPINFOHEADER), 1, fp);
	TDib.BitmapInfo.biSizeImage = ((DWORD)(UINT)TDib.BitmapInfo.biWidth * (DWORD)(UINT)TDib.BitmapInfo.biHeight);
	TDib.Handle = GlobalAlloc(GPTR, TDib.BitmapInfo.biSizeImage);
	TDib.Data = (LPSTR)GlobalLock(TDib.Handle);
	TempData = new BYTE[TDib.BitmapInfo.biSizeImage];

// This should be the palette for the bitmap
	NumColors = (TDib.BitmapInfo.biClrUsed == 0 ? 256 : (int)TDib.BitmapInfo.biClrUsed);
	fread(TDib.Palette, sizeof(RGBQUAD), NumColors, fp);
	TDib.BitmapInfo.biClrUsed = NumColors;

// And this will be the rest of the bitmap data
	fread((BYTE *)TempData, sizeof(char), (int)TDib.BitmapInfo.biSizeImage, fp);

	for(long s = TDib.BitmapInfo.biSizeImage - 1; s >= 0; s--)
		TDib.Data[s] = TempData[TDib.BitmapInfo.biSizeImage - 1 - s];
	delete TempData;

	TempData = new BYTE[TDib.BitmapInfo.biWidth];
	for(long h = 0; h < TDib.BitmapInfo.biHeight; h++)
	{
		for(long w = 0; w < TDib.BitmapInfo.biWidth; w++)
			TempData[w] = TDib.Data[h * TDib.BitmapInfo.biWidth + TDib.BitmapInfo.biWidth - w - 1];
		for(w = 0; w < TDib.BitmapInfo.biWidth; w++)
			TDib.Data[h * TDib.BitmapInfo.biWidth + w] = TempData[w];
	}
	delete TempData;

	TDib.Data = (LPSTR)GlobalUnlock(TDib.Handle);
	fclose(fp);
	return TDib;
};

int WIN_G::UseWinGPalette(HDC hdc)
{
	HPALETTE Pal, Old;
	RGBQUAD	Colors[256];

	Pal = WinGCreateHalftonePalette();
	Old = SelectPalette(hdc, Pal, FALSE);
	RealizePalette(hdc);
	DeleteObject(Old);

	GetPaletteEntries(Pal, 0, 256, (PALETTEENTRY far *)Colors);
	for(int i = 0; i < 256; i++)
	{
		BYTE Temp = Colors[i].rgbBlue;
		Colors[i].rgbBlue = Colors[i].rgbRed;
		Colors[i].rgbRed = Temp;
	}
	WinGSetDIBColorTable(WinGDC, 0, 256, Colors);
	return 0;
};

HPALETTE WIN_G::LoadBitmapPalette(WGDIB Bitmap)
{
	NPLOGPALETTE  	LogPal;
	HPALETTE		Pal;
	RGBQUAD			Colors[256];

	LogPal = (NPLOGPALETTE)LocalAlloc(LPTR,
		sizeof(LOGPALETTE) + ((int)Bitmap.BitmapInfo.biClrUsed * sizeof(PALETTEENTRY)));
	LogPal->palNumEntries = (WORD)Bitmap.BitmapInfo.biClrUsed;
	LogPal->palVersion = 0x300;

	for(int i = 0; i < (int)Bitmap.BitmapInfo.biClrUsed; i++)
	{
		LogPal->palPalEntry[i].peRed = Bitmap.Palette[i].rgbRed;
		LogPal->palPalEntry[i].peGreen = Bitmap.Palette[i].rgbGreen;
		LogPal->palPalEntry[i].peBlue = Bitmap.Palette[i].rgbBlue;
		LogPal->palPalEntry[i].peFlags = 0;
	}
	if((Pal = CreatePalette(LogPal)) == NULL)
		MessageBeep(0);
	GetPaletteEntries(Pal, 0, 256, (PALETTEENTRY far *)Colors);
	for(i = 0; i < 256; i++)
	{
		BYTE Temp = Colors[i].rgbBlue;
		Colors[i].rgbBlue = Colors[i].rgbRed;
		Colors[i].rgbRed = Temp;
	}
	WinGSetDIBColorTable(WinGDC, 0, 256, Colors);
	LocalFree(LogPal);
	return Pal;
};

int WIN_G::DisplayBitmap(WGDIB Bitmap, int xPos, int yPos)
{
	char 			*c, *d;
	int 			WidthCnt, HeightCnt;
	int 			WidthIndex, HeightIndex;
	int				i;

	WidthCnt = (int)Bitmap.BitmapInfo.biWidth;
	WidthIndex = 0;
	HeightCnt = (int)Bitmap.BitmapInfo.biHeight;
	HeightIndex = 0;

	if(xPos < 0)
	{
		WidthCnt = (int)Bitmap.BitmapInfo.biWidth + xPos;
		WidthIndex = -xPos;
	}
	if(xPos >= Width)
		return 2;
	if(xPos + (int)Bitmap.BitmapInfo.biWidth >= Width)
		WidthCnt = (int)Bitmap.BitmapInfo.biWidth - (xPos + (int)Bitmap.BitmapInfo.biWidth - Width);

	if(yPos < 0)
	{
		HeightCnt = (int)Bitmap.BitmapInfo.biHeight + yPos;
		HeightIndex = -yPos;
	}
	if(yPos >= Height)
		return 3;
	if(yPos + (int)Bitmap.BitmapInfo.biHeight >= Height)
		HeightCnt = (int)Bitmap.BitmapInfo.biHeight - (yPos + (int)Bitmap.BitmapInfo.biHeight - Height);

	Bitmap.Data = (LPSTR)GlobalLock(Bitmap.Handle);
	c = (char *)Surface + ( (yPos + HeightIndex) * Width) + (xPos + WidthIndex);
	d = (LPSTR)Bitmap.Data + (HeightIndex) * (int)Bitmap.BitmapInfo.biWidth + WidthIndex;
	for(i = 0; i < HeightCnt; i++)
	{
		memcpy(c, d, sizeof(char) * WidthCnt);
		c += Width;
		d += Bitmap.BitmapInfo.biWidth;
	}
	GlobalUnlock(Bitmap.Handle);
	return 1;
};

#pragma argsused
int WIN_G::TDisplayBitmap(WGDIB Bitmap, int xPos, int yPos, BYTE TColor)
{
	char 			*c, *d;
	int 			WidthCnt, HeightCnt;
	int 			WidthIndex, HeightIndex;
	int				i, j;

	WidthCnt = (int)Bitmap.BitmapInfo.biWidth;
	WidthIndex = 0;
	HeightCnt = (int)Bitmap.BitmapInfo.biHeight;
	HeightIndex = 0;

	if(xPos < 0)
	{
		WidthCnt = (int)Bitmap.BitmapInfo.biWidth + xPos;
		WidthIndex = -xPos;
	}
	if(xPos >= Width)
		return 2;
	if(xPos + (int)Bitmap.BitmapInfo.biWidth >= Width)
		WidthCnt = (int)Bitmap.BitmapInfo.biWidth - (xPos + (int)Bitmap.BitmapInfo.biWidth - Width);

	if(yPos < 0)
	{
		HeightCnt = (int)Bitmap.BitmapInfo.biHeight + yPos;
		HeightIndex = -yPos;
	}
	if(yPos >= Height)
		return 3;
	if(yPos + (int)Bitmap.BitmapInfo.biHeight >= Height)
		HeightCnt = (int)Bitmap.BitmapInfo.biHeight - (yPos + (int)Bitmap.BitmapInfo.biHeight - Height);

	Bitmap.Data = (LPSTR)GlobalLock(Bitmap.Handle);

	c = (char *)Surface + (yPos + HeightIndex) * Width + (xPos + WidthIndex);
	d = (LPSTR)Bitmap.Data + (HeightIndex) * Bitmap.BitmapInfo.biWidth + WidthIndex;
	for(i = 0; i < HeightCnt; i++)
	{
		for(j = 0; j < (WidthCnt >> 3); j++)
		{
			if(*d != TColor)
				*c = *d;
			c++; d++;
			if(*d != TColor)
				*c = *d;
			c++; d++;
			if(*d != TColor)
				*c = *d;
			c++; d++;
			if(*d != TColor)
				*c = *d;
			c++; d++;
			if(*d != TColor)
				*c = *d;
			c++; d++;
			if(*d != TColor)
				*c = *d;
			c++; d++;
			if(*d != TColor)
				*c = *d;
			c++; d++;
			if(*d != TColor)
				*c = *d;
			c++; d++;
		}
		c += Width - WidthCnt;
		d += Bitmap.BitmapInfo.biWidth - WidthCnt;
	}
	GlobalUnlock(Bitmap.Handle);
	return TRUE;
};

#pragma argsused
int WIN_G::RemapBitmap(WGDIB Bitmap)
{
	return 1;
};

int WIN_G::FreeBitmap(WGDIB Bitmap)
{
	GlobalFree((HGLOBAL)Bitmap.Handle);
	return 1;
}

// A useful function
void ClearSystemPalette(void)
{
	HDC 		 TempDC;
	HPALETTE     Pal, SavePal;
	NPLOGPALETTE Palette;

	TempDC = GetDC(0);
	Palette = (NPLOGPALETTE) LocalAlloc(LMEM_FIXED,
		(sizeof(LOGPALETTE) + (sizeof(PALETTEENTRY) * (256))));
	Palette->palVersion = 0x300;
	Palette->palNumEntries = 256;

	for (WORD Index = 0; Index < (WORD)256; Index++)
	{
		Palette->palPalEntry[Index].peRed =0;
		Palette->palPalEntry[Index].peGreen = 0;
		Palette->palPalEntry[Index].peBlue = 0;
		Palette->palPalEntry[Index].peFlags = (BYTE)PC_NOCOLLAPSE;
	}

	Pal = CreatePalette((LPLOGPALETTE)Palette);
	LocalFree((NPLOGPALETTE)Palette);
	SavePal = SelectPalette(TempDC, Pal, FALSE);
	RealizePalette(TempDC);
	Pal = SelectPalette(TempDC, SavePal, FALSE);
	ReleaseDC(0, TempDC);
	DeleteObject(Pal);
	DeleteObject(SavePal);
};


