// rm.h - 12-13-96 - Jason Zisk
// Include file for rm.cpp, include this wherever you want to access the variables
// and functions in rm.cpp.  Duh.

// The following macros are used for proper error handling for DirectDraw,
// Direct3D and Direct3D retained mode
#define TRY_DD(exp) { { HRESULT rval = exp; if (rval != DD_OK) { TraceErrorDD(rval, __FILE__, __LINE__); return FALSE; } } }
#define TRY_D3D(exp) { { HRESULT rval = exp; if (rval != D3D_OK) { TraceErrorD3D(rval, __FILE__, __LINE__); return FALSE; } } }
#define TRY_D3DRM(exp) { { HRESULT rval = exp; if (rval != D3DRM_OK) { TraceErrorD3DRM(rval, __FILE__, __LINE__); return FALSE; } } }

// Externals, these are in rm.cpp, and may be needed by the main program
extern LPDIRECTDRAW				g_lpDD;			// DirectDraw object
extern LPDIRECT3D				g_lpD3D;		// Direct3D object
extern LPDIRECT3DRM				g_lpD3DRM;		// Direct3D RM object
extern LPDIRECT3DRMDEVICE		g_lpD3DRMDevice;// Direct3D RM Device

extern LPDIRECTDRAWSURFACE		g_lpPrimary;    // Primary surface
extern LPDIRECTDRAWSURFACE		g_lpBackBuffer;	// BackBuffer surface
extern LPDIRECTDRAWSURFACE		g_lpZBuffer;	// ZBuffer

extern DWORD					g_vidModeX;     // Current X video resolution
extern DWORD					g_vidModeY;     // Current Y video resolution
extern DWORD					g_vidModeBIT;   // Current video bit depth
extern D3DCOLORMODEL			g_colorModel;	// Current color model
extern BOOL						g_bHardware3D;	// Do we have hardware?

// Error handling
void TraceErrorDD(HRESULT hErr, char *sFile, int nLine);
void TraceErrorDS(HRESULT hErr, char *sFile, int nLine);
void TraceErrorD3D(HRESULT hErr, char *sFile, int nLine);
void TraceErrorD3DRM(HRESULT hErr, char *sFile, int nLine);
void __cdecl ErrorMsg( LPSTR fmt, ... );
BOOL FinalWord(void);

// Initialization
BOOL InitDirectX(int W=0, int H=0, int BD=0, D3DCOLORMODEL cm=(D3DCOLORMODEL)-1);

// Video mode handling(so much more than the old Floater!)
BOOL EnterVideoMode(int mode);
BOOL EnterVideoModeWHBD(int width, int height, int bitdepth);
BOOL EnterReqVideoMode(int W, int H, int BD);
BOOL EnterNextVideoMode();
BOOL EnterPrevVideoMode();
BOOL EnterLowestVideoMode();
BOOL EnterHighestVideoMode();
BOOL ReenterCurrentVideoMode();

// Checking stuff
BOOL CheckSurfaces();

// Termination
void KillDirectX();

