#include <windows.h>
#include <stdio.h>
#include <math.h>
#include "appmain.h"
#include "hscreen.h"

typedef struct
{
	float x, y, z;
} VECTOR;

HDC				MainDC;
WINAPP			WinApp;
BYTE			*hmap;
BYTE			*vmap;
BYTE			*tmap;
HIDDEN_SCREEN	*hScreen;
static HPALETTE	Pal;
VECTOR			Light;
int GetLine(char *buff, int n, FILE *in);

void SetGrayPalette();
void ShowHMAP();
void GenerateVectors();
VECTOR CrossProduct(VECTOR v1, VECTOR v2);
float DotProduct(VECTOR v1, VECTOR v2);
void Normalize(VECTOR *v1);

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInst, LPSTR cmdString, int cmdShow)
{
	HWND        MainWnd;
	MSG         msg;
	WNDCLASS    WndClass;
    HMENU       hMenu;

	WinApp.hInstance = hInstance;
	WinApp.hPrevInst = hPrevInst;
	WinApp.cmdShow   = cmdShow;

	WndClass.style          = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc    = WndProc;
	WndClass.cbClsExtra     = 0;
	WndClass.cbWndExtra     = 0;
	WndClass.hInstance      = hInstance;
	WndClass.hIcon          = LoadIcon(WinApp.hInstance, "GOURAUD");
	WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
	WndClass.hbrBackground  = (HBRUSH)(GetStockObject(GRAY_BRUSH));
	WndClass.lpszMenuName   = NULL;
	WndClass.lpszClassName  = "MAINWND";
	RegisterClass(&WndClass);

    hMenu = LoadMenu(WinApp.hInstance, "MAINMENU");
	MainWnd   = CreateWindow("MAINWND", "Gouraud Vectors",
							 WS_OVERLAPPED | WS_MINIMIZEBOX | WS_SYSMENU,
                             0, 0, 256, 256,
                             NULL, hMenu, hInstance, NULL);
	AdjustClientRegion(MainWnd, 0, 0, 256, 256);
	ShowWindow(MainWnd, WinApp.cmdShow);
	UpdateWindow(MainWnd);

	for (;;)
	{
		if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			if(msg.message == WM_QUIT)
				break;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
				WaitMessage();
		}
	}
    return 0;
};

LRESULT CALLBACK WndProc(HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
{
	FILE *fp;
	PAINTSTRUCT ps;
	char buf[120];
		
	switch(message)
	{
		case WM_CREATE:
			hmap = new BYTE[65536];
			vmap = new BYTE[65536];
			tmap = new BYTE[255 * 255 * 2];
			fp = fopen("hmap.raw", "rb");
			fread(hmap, sizeof(BYTE), 65536, fp);
			fclose(fp);
			MainDC = GetDC(hWindow);
			SetSystemPaletteUse(MainDC, SYSPAL_NOSTATIC);
			SetSystemPaletteUse(MainDC, SYSPAL_STATIC);
			SetGrayPalette();
			hScreen = new HIDDEN_SCREEN(MainDC, 256, 256);
			hScreen->UseDCPal(MainDC);
			ShowHMAP();
			fp = fopen("options.ini", "rt");
			GetLine(buf, 100, fp);
			sscanf(buf, "%f %f %f", &Light.x, &Light.y, &Light.z);
			fclose(fp);
			Normalize(&Light);
			return 0;
		case WM_PAINT:
			BeginPaint(hWindow, &ps);
			SetSystemPaletteUse(MainDC, SYSPAL_NOSTATIC);
			SetSystemPaletteUse(MainDC, SYSPAL_STATIC);
			SetGrayPalette();
			hScreen->BltToScreen(MainDC, 0, 0);
			EndPaint(hWindow, &ps);
			return 0;
		case WM_LBUTTONDOWN:
			GenerateVectors();
			fp = fopen("gvects.vec", "wb");
			fwrite(vmap, sizeof(BYTE), 65536, fp);
			fclose(fp);
			return 0;
		case WM_COMMAND:
			switch(wParam)
			{
				case 101:
					SendMessage(hWindow, WM_DESTROY, 0, 0L);
					return 0;
			}
			return(DefWindowProc(hWindow, message, wParam, lParam));
		case WM_DESTROY:
			ReleaseDC(hWindow, MainDC);
			delete hScreen;
			delete hmap;
			delete vmap;
			delete tmap;
			PostQuitMessage(0);
			return 0;
		default:
			return(DefWindowProc(hWindow, message, wParam, lParam));
	}
};

void SetGrayPalette()
{
	NPLOGPALETTE Palette;

	Palette = (NPLOGPALETTE)LocalAlloc(LMEM_FIXED,
		(sizeof(LOGPALETTE) + (sizeof(PALETTEENTRY) * (256))));
	Palette->palVersion = 0x300;
	Palette->palNumEntries = 256;

	for(int i = 0; i < 256; i++)
	{
		Palette->palPalEntry[i].peRed = (BYTE)i;
		Palette->palPalEntry[i].peGreen = (BYTE)i;
		Palette->palPalEntry[i].peBlue = (BYTE)i;
		Palette->palPalEntry[i].peFlags = (BYTE)PC_RESERVED;
	}

	Pal = CreatePalette((LPLOGPALETTE)Palette);
	LocalFree((NPLOGPALETTE)Palette);
	SelectPalette(MainDC, Pal, FALSE);
	RealizePalette(MainDC);
};

void ShowHMAP()
{
	int i, j;
	char *screen;
	
	screen = (char *)hScreen->Surface;
	for(i = 0; i < 256; i++)
		for(j = 0; j < 256; j++)
			*screen++ = ((hmap[(i << 8) + j] * 236) >> 8) + 10;
};

void GenerateVectors()
{
	VECTOR v1, v2, v3, tmp1, tmp2, norm;
	int i, j;
	float illum;
	long in;
	char *c;
	FILE *fp;
					
	c = (char *)hScreen->Surface;
	for(i = 0; i < 255; i++)
	{
		for(j = 0; j < 255; j++)
		{
			v1.x = (float)(j << 10);
			v1.z = (float)(i << 10);
			v1.y = (float)(hmap[(i << 8) + j] * -50);
			v2.x = (float)((j + 1) << 10);
			v2.z = (float)(i << 10);
			v2.y = (float)(hmap[(i << 8) + j + 1] * -50);
			v3.x = (float)(j << 10);
			v3.z = (float)((i + 1) << 10);
			v3.y = (float)(hmap[((i + 1) << 8) + j] * -50);
			tmp1.x = v2.x - v1.x;
			tmp1.y = v2.y - v1.y;
			tmp1.z = v2.z - v1.z;
			tmp2.x = v3.x - v1.x;
			tmp2.y = v3.y - v1.y;
			tmp2.z = v3.z - v1.z;
			norm = CrossProduct(tmp1, tmp2);
			Normalize(&norm);
			illum = DotProduct(norm, Light);
			if(illum < 0) illum = 0;
			if(illum >= 1.0) illum = 1.0;
			in = (long)(illum * 33);
			if(in > 32) in = 32;
			if(in < 0) in = 0;
			tmap[(i << 1) * 255 + (j << 1)] = (BYTE)in;

			v1.x = (float)(j << 10);
			v1.z = (float)((i + 1) << 10);
			v1.y = (float)(hmap[((i + 1) << 8) + j] * -50);
			v2.x = (float)((j + 1) << 10);
			v2.z = (float)(i << 10);
			v2.y = (float)(hmap[(i << 8) + j + 1] * -50);
			v3.x = (float)((j + 1) << 10);
			v3.z = (float)((i + 1) << 10);
			v3.y = (float)(hmap[((i + 1) << 8) + j + 1] * -50);
			tmp1.x = v2.x - v1.x;
			tmp1.y = v2.y - v1.y;
			tmp1.z = v2.z - v1.z;
			tmp2.x = v3.x - v1.x;
			tmp2.y = v3.y - v1.y;
			tmp2.z = v3.z - v1.z;
			norm = CrossProduct(tmp1, tmp2);
			Normalize(&norm);
			illum = DotProduct(norm, Light);
			if(illum < 0) illum = 0;
			if(illum >= 1.0) illum = 1.0;
			in = (long)(illum * 33);
			if(in > 32) in = 32;
			if(in < 0) in = 0;
			tmap[(i << 1) * 255 + (j << 1) + 1] = (BYTE)in;
		}
		memset(c, 254, 256);
		c += 256;
		hScreen->BltToScreen(MainDC, 0, 0);
	}
	ShowHMAP();
	hScreen->BltToScreen(MainDC, 0, 0);
	int ave;
	int m, n;
	c = (char *)hScreen->Surface;
	for(i = 0; i < 256; i++)
	{
		for(j = 0; j < 256; j++)
		{
			ave = 0;
			m = j - 1;
			if(m < 0) m = 0;
			n = i - 1;
			if(n < 0) n = 0;
			ave += tmap[(n << 1) * 255 + (m << 1) + 1];
			m = j;
			if(m > 254) m = 254;
			ave += tmap[(n << 1) * 255 + (m << 1)];
			ave += tmap[(n << 1) * 255 + (m << 1) + 1];
			m = j - 1;
			if(m < 0) m = 0;
			n = i;
			if(n > 254) n = 254;
			ave += tmap[(n << 1) * 255 + (m << 1)];
			ave += tmap[(n << 1) * 255 + (m << 1) + 1];
			m = j;
			if(m > 254) m = 254;
			n = i;
			if(n > 254) n = 254;
			ave += tmap[(n << 1) * 255 + (m << 1)];
			ave /= 6;
			if(ave < 0) ave = 0;
			if(ave > 32) ave = 32;
			vmap[(i << 8) + j] = ave;
		}
		memset(c, 250, 256);
		c += 256;
		hScreen->BltToScreen(MainDC, 0, 0);
	}
	ShowHMAP();
	hScreen->BltToScreen(MainDC, 0, 0);
};

VECTOR CrossProduct(VECTOR v1, VECTOR v2)
{
	VECTOR res;

	res.x = (v1.y * v2.z) - (v1.z * v2.y);
	res.y = (v1.z * v2.x) - (v1.x * v2.z);
	res.z = (v1.x * v2.y) - (v1.y * v2.x);

	return(res);
};

float DotProduct(VECTOR v1, VECTOR v2)
{
	return((v1.x * v2.x) +
           (v1.y * v2.y) +
           (v1.z * v2.z));
};

void Normalize(VECTOR *v1)
{
	float length;
	length = sqrt((v1->x * v1->x)
                + (v1->y * v1->y)
                + (v1->z * v1->z));

	length = 1.0 / length;
	v1->x = v1->x * length;
	v1->y = v1->y * length;
	v1->z = v1->z * length;
};

int GetLine(char *buff, int n, FILE *in)
{
	char *p;

	do
	{
		if (fgets(buff, n, in) == 0)
	        return -1;
        if ((p = strchr(buff, '\n')) != NULL)
	        *p = '\0';
        if ((p = strchr(buff, ';')) != NULL)
	        *p = '\0';
        for (p = buff; isspace(*p); ++p);
	} while (p[0] == '\0');

	return 0;
};

