#include "header.h"

extern BYTE				ShadeTable[33][256];
enum SHADETYPE			{ DARK, FOG, HAZE };

BOOL					bWorldOpen = FALSE;
SHADETYPE				ShadeType = HAZE;
BYTE					BackColor = 236;
DWORD					Time1, Time2;
UINT					KeyBuf[10];
float					CameraTilt;
WINAPP					WinApp;
WORLD					*World;
long					Speed;
DirectDraw				*DD;

int CameraMove();
void DrawSpeedBar(BYTE *scr);
void BltBitmaps();
void SetShadeTable(SHADETYPE st);

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInst, LPSTR, int cmdShow)
{
	HWND        MainWnd;
	MSG         msg;
	WNDCLASS    WndClass;

	WinApp.hInstance = hInstance;
	WinApp.hPrevInst = hPrevInst;
	WinApp.cmdShow   = cmdShow;

	WndClass.style          = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc    = WndProc;
	WndClass.cbClsExtra     = 0;
	WndClass.cbWndExtra     = 0;
	WndClass.hInstance      = hInstance;
	WndClass.hIcon          = LoadIcon(WinApp.hInstance, IDI_APPLICATION);
	WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
	WndClass.hbrBackground  = (HBRUSH)(GetStockObject(BLACK_BRUSH));
	WndClass.lpszMenuName   = NULL;
	WndClass.lpszClassName  = "MAINWND";
	RegisterClass(&WndClass);

	DD = new DirectDraw();
    MainWnd = CreateWindowEx(
        WS_EX_TOPMOST,
        "MAINWND",
        "Direct Draw Example",
        WS_POPUP,
        0, 0,
        GetSystemMetrics(SM_CXSCREEN),
        GetSystemMetrics(SM_CYSCREEN),
		NULL,
        NULL,
        hInstance,
        NULL );

	ShowWindow(MainWnd, WinApp.cmdShow);
	UpdateWindow(MainWnd);

	DD->SetDefaults(MainWnd, 1);
	DD->SetMode(M640x480x8);
	DD->CreateViewBuffers();
	SetupData();
				
	while(1)
	{
		if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			if(msg.message == WM_QUIT)
				break;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else if(bWorldOpen)
			Heartbeat();
		else
			WaitMessage();
	}
	delete DD;
    return 0;
};

LRESULT CALLBACK _export WndProc(HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_CREATE:
			World = new WORLD();
			World->LoadWorld("land.wld");
			bWorldOpen = TRUE;
			Time2 = 0; Time1 = timeGetTime();
			Speed = 16;
			return 0;
		case WM_SETCURSOR:
			ShowCursor(NULL);
			return 0;
		case WM_KEYDOWN:
			switch(wParam)
			{
				case VK_LEFT: KeyBuf[LEFT] = 1; break;
				case VK_RIGHT: KeyBuf[RIGHT] = 1; break;
				case VK_UP: KeyBuf[UP] = 1; break;
				case VK_DOWN: KeyBuf[DOWN] = 1; break;
				case VK_ADD: KeyBuf[SPEEDUP] = 1; break;
				case VK_SUBTRACT: KeyBuf[SPEEDDOWN] = 1; break;
			}
			return 0;
		case WM_KEYUP:
			switch(wParam)
			{
				case VK_LEFT: KeyBuf[LEFT] = 0; break;
				case VK_RIGHT: KeyBuf[RIGHT] = 0; break;
				case VK_UP: KeyBuf[UP] = 0; break;
				case VK_DOWN: KeyBuf[DOWN] = 0; break;
				case VK_ADD: KeyBuf[SPEEDUP] = 0; break;
				case VK_SUBTRACT: KeyBuf[SPEEDDOWN] = 0; break;
				case VK_F2: SetShadeTable(DARK); break;
				case VK_F3: SetShadeTable(FOG); break;
				case VK_F4: SetShadeTable(HAZE); break;
			}
			return 0;
		case WM_COMMAND:
			switch(wParam)
			{
				case 101:
					SendMessage(hWindow, WM_DESTROY, 0, 0L);
					return 0;
			}
			return(DefWindowProc(hWindow, message, wParam, lParam));
		case WM_CLOSE:
		case WM_DESTROY:
			bWorldOpen = FALSE;
			ShowCursor(TRUE);
			World->FreeWorld();
			delete World;
			PostQuitMessage(0);
			return 0;
		default:
			return(DefWindowProc(hWindow, message, wParam, lParam));
	}
};

int SetupData()
{
	HDIB Dib;

	Dib.Load("ALLBMPS.BMP");
	DD->lpPal = DD->ExtractPalette(Dib);
	DD->lpFront->SetPalette(DD->lpPal);
	Dib.Free();
	//DD->AddBitmap("earth.bmp");
	DD->AddBitmap("statbar.bmp");
	return 0;
};

int Heartbeat()
{
	DDSURFACEDESC Desc;
	HRESULT	Result;
    BYTE *scr;

	Time2 = timeGetTime() - Time1;
	Time1 = timeGetTime();
	DD->Clear(BackColor);
	CameraMove();
	BltBitmaps();
	World->UpdateWorld();
	World->ProjectWorld(450.0);
	memset(&Desc, 0, sizeof(Desc));
	Desc.dwSize = sizeof(Desc);
	Result = DD->lpBack->Lock(NULL, &Desc, DDLOCK_WAIT, NULL);
	DD->Pitch = Desc.lPitch;
    scr = (BYTE *)Desc.lpSurface;
	World->DrawWorld(scr);
	DrawSpeedBar(scr);
	DD->lpBack->Unlock(NULL);
	DD->Flip();

	return(0);
};

int CameraMove()
{
	float newp, newc, tspeed;
		
	tspeed = 0.0006 * Time2;
	if(KeyBuf[LEFT])
	{
		World->Camera[World->Current_Camera].yAngle -= tspeed;
		if(CameraTilt > -0.50) CameraTilt -= tspeed;
	}
	
	if(KeyBuf[RIGHT])
	{	
		World->Camera[World->Current_Camera].yAngle += tspeed;
		if(CameraTilt < 0.50) CameraTilt += tspeed;
	}

	if(KeyBuf[UP])
		World->Camera[World->Current_Camera].xAngle -= tspeed;
	
	if(KeyBuf[DOWN])
		World->Camera[World->Current_Camera].xAngle += tspeed;
	
	tspeed = 0.0002 * Time2;
	if(!KeyBuf[RIGHT] && !KeyBuf[LEFT])
	{
		if(CameraTilt < -0.0001)
		{
			CameraTilt += tspeed;
			if(CameraTilt > -0.0001)
				CameraTilt = 0;
		}
		else if(CameraTilt > 0.0001)
		{
			CameraTilt -= tspeed;
			if(CameraTilt < 0.0001)
				CameraTilt = 0;
		}
	}
	World->Camera[World->Current_Camera].zAngle = CameraTilt;
	
	if(KeyBuf[SPEEDUP]) Speed += 2;
	if(KeyBuf[SPEEDDOWN]) Speed -= 2;
	if(Speed < 0) Speed = 0;
	if(Speed > 106) Speed = 106;

	if(World->Camera[World->Current_Camera].yAngle < 0.0)
		World->Camera[World->Current_Camera].yAngle += 6.28;
	if(World->Camera[World->Current_Camera].yAngle > 6.28)
		World->Camera[World->Current_Camera].yAngle -= 6.28;
	if(World->Camera[World->Current_Camera].xAngle < 0.0)
		World->Camera[World->Current_Camera].xAngle += 6.28;
	if(World->Camera[World->Current_Camera].xAngle > 6.28)
		World->Camera[World->Current_Camera].xAngle -= 6.28;
		
	tspeed = (float)(Time2 / 24.0) * (float)Speed;
	World->Camera[World->Current_Camera].yTrans -= tspeed * 
		sin(World->Camera[World->Current_Camera].xAngle);

	newp = tspeed * cos(World->Camera[World->Current_Camera].yAngle)
		 * cos(World->Camera[World->Current_Camera].xAngle);
	
	newc = World->Camera[World->Current_Camera].zTrans + newp;
	if(newc >= 0 && newc < 261120)
		World->Camera[World->Current_Camera].zTrans += newp;

	newp = tspeed * sin(World->Camera[World->Current_Camera].yAngle)
		 * cos(World->Camera[World->Current_Camera].xAngle);
	
	newc = World->Camera[World->Current_Camera].xTrans + newp;
	if(newc >= 0 && newc < 261120)
		World->Camera[World->Current_Camera].xTrans += newp;
	return(0);
};

void DrawSpeedBar(BYTE *Screen)
{
	int i;
    BYTE *start;

	for(i = 0; i < Speed >> 1; i++)
	{
        start = (BYTE *)Screen + ((474 - i) * DD->Pitch) + 74;
		memset(start, 64, 13);
	}
};

void BltBitmaps()
{
	RECT src, des;
//	float angle;

/*	if(ShadeType == DARK)
	{
		src.left = 0; src.right = 64;
		src.top = 0; src.bottom = 56;
		angle = World->Camera[World->Current_Camera].yAngle;
		if(angle > 3.14159) angle -= 6.28;
		des.left = -256 * angle;
		des.right = 64 + des.left;
		angle = World->Camera[World->Current_Camera].xAngle;
		if(angle > 3.14159) angle -= 6.28;
		des.top = 256 * angle;
		des.bottom = 56 + des.top;
		if(des.right > 640)
		{
			src.right -= des.right - 640;
			des.right = 640;
		}
		if(des.left < 0)
		{
			src.left -= des.left;
			des.left = 0;
		}
		DD->BltBitmap(DD->lpDib[0], src, des);
	}*/

	src.left = 0; src.right = 640;
	src.top = 0; src.bottom = 64;
	des.left = 0; des.right = 640;
	des.top = 480 - 64;	des.bottom = 480;
	DD->BltBitmap(DD->lpDib[0], src, des);
};
	
void SetShadeTable(SHADETYPE st)
{
	FILE *fp;
	if(ShadeType == st)
		return;
	
	ShadeType = st;
	switch(st)
	{
	case DARK:
		fp = fopen("dark.dat", "rb");
		fread(ShadeTable, 1, 33 << 8, fp);
		fclose(fp);
		BackColor = 0;
		break;
	case FOG:
		fp = fopen("fog.dat", "rb");
		fread(ShadeTable, 1, 33 << 8, fp);
		fclose(fp);
		BackColor = 255;
		break;
	case HAZE:
		fp = fopen("haze.dat", "rb");
		fread(ShadeTable, 1, 33 << 8, fp);
		fclose(fp);
		BackColor = 236;
		break;
	}
}
