#include "header.h"

extern DirectDraw 	*DD;
extern BYTE ShadeTable[33][256];

inline int LeftSection();
inline int RightSection();
int shlidiv(int x, int y);
void InnerLoop(BYTE *Screen, BYTE *Bitmap, int u, int v, int c, int width);
int CalcVect(POLYGON *p);

// Some globals to interface with the left and right section functions
VERTEX *lva[3], *rva[3];
FPOINT *lpa[3], *rpa[3];
int ls, rs, lsh, rsh;
int lu, dlu, lv, dlv, lc, dlc;
int lx, dlx, rx, drx;
int dudx, dvdx, dcdx;
	
int WORLD::DrawTriangle(POLYGON *p, void *Screen)
{
    VERTEX	*v1, *v2, *v3, *tv;
	FPOINT	*p1, *p2, *p3, *tp;
	int		height, temp, longest;
    BYTE    *scrptr, *scrtemp;
	int		x1, width, index;
	int		u, v, ys, ye, i, c;
    BYTE    *bitmap;
	
	CalcVect(p);
    v1 = &p->Vertex[0]; v2 = &p->Vertex[1]; v3 = &p->Vertex[2];
	p1 = &p->TextPt[0]; p2 = &p->TextPt[1];	p3 = &p->TextPt[2];

    if(v1->sy > v2->sy)
	{
		tv = v1; v1 = v2; v2 = tv;
		tp = p1; p1 = p2; p2 = tp;
	}
    if(v1->sy > v3->sy)
	{
		tv = v1; v1 = v3; v3 = tv;
		tp = p1; p1 = p3; p3 = tp;
	}
    if(v2->sy > v3->sy)
	{
		tv = v2; v2 = v3; v3 = tv;
		tp = p2; p2 = p3; p3 = tp;
	}

	height = v3->sy - v1->sy;
	if(!height) return 0;
	temp = ((v2->sy - v1->sy) << 16) / height;
	longest = temp * (v3->sx - v1->sx) + ((v1->sx - v2->sx) << 16);
	if(!longest) return 0;

// Vertices now sorted and the length of the longest scanline is calculated

	if(longest < 0)
	{
		rva[0] = v3; rva[1] = v2; rva[2] = v1; rs = 2;
		lva[0] = v3; lva[1] = v1; ls = 1;
		rpa[0] = p3; rpa[1] = p2; rpa[2] = p1;
		lpa[0] = p3; lpa[1] = p1;
	
		if(LeftSection() <= 0)
			return 0;
		if(RightSection() <= 0)
		{
			rs--;
			if(RightSection() <= 0)
				return 0;
		}
		if(longest > -0x10000) longest = -0x10000;
	}

	else
	{
		lva[0] = v3; lva[1] = v2; lva[2] = v1; ls = 2;
		rva[0] = v3; rva[1] = v1; rs = 1;
		lpa[0] = p3; lpa[1] = p2; lpa[2] = p1;
		rpa[0] = p3; rpa[1] = p1;

		if(RightSection() <= 0)
			return 0;
		if(LeftSection() <= 0)
		{
			ls--;
			if(LeftSection() <= 0)
				return 0;
		}
		if(longest < 0x10000) longest = 0x10000;
	}

	dudx = shlidiv(temp * (p3->x - p1->x) + ((p1->x - p2->x) << 16),
                   longest);
	dvdx = shlidiv(temp * (p3->y - p1->y) + ((p1->y - p2->y) << 16),
                   longest);
	dcdx = shlidiv(temp * (v3->Vect - v1->Vect) + ((v1->Vect - v2->Vect) << 16),
                   longest);
	ys = v1->sy; ye = v3->sy;
	if(ye > (DD->Screen.y - 64)) ye = DD->Screen.y - 64;
    scrptr = (BYTE *)Screen + ys * DD->Pitch;
    bitmap = (BYTE *)Texture[0].Data + ((p->Texture - 1) << 5);
	for(i = ys; i < ye; i++)
	{
// Find and clip the scanlines
		if(i >= 0)
		{
	        u = lu; v = lv;	c = lc;
			x1 = lx >> 16;

			if(x1 < 0)
			{
				while(x1 < 0)
				{
					u += dudx;
					v += dvdx;
					c += dcdx;
					x1++;
				}
			}
			width = (rx >> 16) - x1;
			if((x1 + width) > (DD->Screen.x))
				width -= (x1 + width) - (DD->Screen.x);
			scrtemp = scrptr + x1;

			if(width > 0)
				InnerLoop(scrtemp, bitmap, u, v, c, width);
		}

		scrptr += DD->Pitch;

		if(--lsh <= 0)
		{
			if(--ls <= 0) return 0;
			if(LeftSection() <= 0)
				return 0;
		}
		else
		{
			lx += dlx; lu += dlu; 
			lv += dlv; lc += dlc;
		}

		if(--rsh <= 0)
		{
			if(--rs <= 0) return 0;
			if(RightSection() <= 0)	
				return 0;
		}
		else
			rx += drx;
	}

	return 0;
};

inline int LeftSection()
{
	VERTEX	*v1, *v2;
	FPOINT	*p1, *p2;
	int 	height;
	
	v1 = lva[ls]; v2 = lva[ls - 1];
	p1 = lpa[ls]; p2 = lpa[ls - 1];
	height = v2->sy - v1->sy;
	if(!height) return 0;

	dlx = ((v2->sx - v1->sx) << 16);
	lx = v1->sx << 16;
	dlu = ((p2->x - p1->x) << 16);
	lu = p1->x << 16;
	dlv = ((p2->y - p1->y) << 16);
	lv = p1->y << 16;
	dlc = ((v2->Vect - v1->Vect) << 16);
	lc = v1->Vect << 16;
	if(height == 1) {}
	else if(height == 2) { dlx >>= 1; dlu >>= 1; dlv >>= 1; dlc >>= 1;}
	else if(height == 4) { dlx >>= 2; dlu >>= 2; dlv >>= 2; dlc >>= 2;}
	else if(height == 8) { dlx >>= 3; dlu >>= 3; dlv >>= 3; dlc >>= 3;}
	else if(height == 16) { dlx >>= 4; dlu >>= 4; dlv >>= 4; dlc >>= 4;}
	else if(height == 32) { dlx >>= 5; dlu >>= 5; dlv >>= 5; dlc >>= 5;}
	else { dlx /= height; dlu /= height; dlv /= height; dlc /= height;}
	lsh = height;
	return height;
};

inline int RightSection()
{
	VERTEX	*v1, *v2;
	int 	height;

	v1 = rva[rs]; v2 = rva[rs - 1];
	height = v2->sy - v1->sy;
	if(!height) return 0;

	drx = ((v2->sx - v1->sx) << 16);
	drx	/= height;
	rx = v1->sx << 16;
	rsh = height;
	return height;
};

void InnerLoop(BYTE *Screen, BYTE *Bitmap, int u, int v, int c, int width)
{
// This loop needs to be improved dramatically
	do
	{
		*Screen++ = ShadeTable[c >> 16][*(Bitmap + ((v >> 16) << 9) + (u >> 16))];
        u += dudx;
        v += dvdx;
        c += dcdx;
	} while(--width);
};

// Use this for Watcom C++
/*#pragma aux shlidiv = \
	"mov edx, eax"\
	"sar edx, 16"\
	"shl eax, 16"\
	"idiv ebx"\
	"shld edx, eax, 16"\
	parm [eax][ebx]\
	modify exact [eax edx]\
    value [eax]*/

//This will work with Visual C++, and probably Borland
int shlidiv(int x, int y)
{
    __asm {
        mov eax, x
        mov edx, eax
        sar edx, 16
        shl eax, 16
        idiv y
        shld edx, eax, 16
		ret
    }
};

int CalcVect(POLYGON *p)
{
	float src;
	float dist;
	int tmp, i, j;
	
	for(i = 0; i < 3; i++)
	{
		dist = p->Vertex[i].vz;
		tmp = (int)(dist - 12000.0);
		if(tmp < 0) tmp = 0;
		tmp >>= 6;
		j = 32 - tmp;
		if(j <= 0) j = 1;
		if(j > 31) j = 31;
		p->Vertex[i].Vect = j;
	}
	
	return(0);
};

