#include "header.h"

DirectDraw::DirectDraw()
{
// Using emulation only so there shouldn't be a problem
	lpDD = NULL;
	DirectDrawEnumerate(DDDeviceCallback, &lpDD);

	if(lpDD == NULL)
		DirectDrawCreate(NULL, &lpDD, NULL);
};

DirectDraw::~DirectDraw()
{
	DeleteViewBuffers();
	if(lpDD != NULL)
	{
		lpDD->Release();
		lpDD = NULL;
 	}
};
	
BOOL DirectDraw::SetDefaults(HWND hWnd, DWORD nDibs)
{
	hWindow = hWnd;
	NewDib = 0;
	NumDibs = nDibs;
	lpDib = new LPDIRECTDRAWSURFACE[nDibs];
	return(TRUE);	
};

BOOL DirectDraw::SetMode(enum VIDEOMODE Mode)
{
	HRESULT Result;

	Result = lpDD->SetCooperativeLevel(hWindow, DDSCL_EXCLUSIVE |
												DDSCL_FULLSCREEN |
												DDSCL_ALLOWMODEX);
	switch(Mode)
	{
		case M320x240x8:
			Result = lpDD->SetDisplayMode(320, 240, 8);
			Screen.x = 320;	Screen.y = 240;
			HalfScreen.x = 160;	HalfScreen.y = 120;
			break;
		case M640x480x8:
			Result = lpDD->SetDisplayMode(640, 480, 8);
			Screen.x = 640;	Screen.y = 480;
			HalfScreen.x = 320;	HalfScreen.y = 240;
			break;
		case M800x600x8:
			Result = lpDD->SetDisplayMode(800, 600, 8);
			Screen.x = 800;	Screen.y = 600;
			HalfScreen.x = 400;	HalfScreen.y = 300;
			break;
		case M1024x768x8:
			Result = lpDD->SetDisplayMode(1024, 768, 8);
			Screen.x = 1024; Screen.y = 768;
			HalfScreen.x = 512;	HalfScreen.y = 384;
			break;
		default:
			Result = lpDD->SetDisplayMode(640, 480, 8);
			Screen.x = 640;	Screen.y = 480;
			HalfScreen.x = 320;	HalfScreen.y = 240;
			break;
	}
	return(TRUE);	
};

BOOL DirectDraw::CreateViewBuffers(void)
{
    DDSURFACEDESC       Desc;
    DDSCAPS             Caps;
    HRESULT             Result;
	
	memset(&Desc, 0, sizeof(Desc));
	Desc.dwSize = sizeof(Desc);
	Desc.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    Desc.dwBackBufferCount = 1;
    Desc.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
                          DDSCAPS_FLIP | 
                          DDSCAPS_COMPLEX;
	Result = lpDD->CreateSurface(&Desc, &lpFront, NULL);
	
    Caps.dwCaps = DDSCAPS_BACKBUFFER;
    Result = lpFront->GetAttachedSurface(&Caps, &lpBack);
	Result = lpDD->CreateClipper(0, &lpClip, NULL);
    Result = lpClip->SetHWnd(0, hWindow);
    Result = lpBack->SetClipper(lpClip);
	Pitch = Desc.lPitch;
	
	return(TRUE);	
};

BOOL DirectDraw::DeleteViewBuffers(void)
{
	if(lpFront)
    {
    	lpFront->Release();
        lpFront = NULL;
    }
	if(lpClip)
    {
    	lpClip->Release();
        lpClip = NULL;
    }
	if(lpPal)
    {
    	lpPal->Release();
        lpPal = NULL;
    }
	for(int i = 0; i < NumDibs; i++)
		FreeBitmap(lpDib[i]);
	if(lpDib)
		delete lpDib;
	return(TRUE);	
};

IDirectDrawPalette *DirectDraw::ExtractPalette(HDIB Dib)
{
	PALETTEENTRY pe[256];
	IDirectDrawPalette *lpP;
	int i;

	for(i = 0; i < 256; i++)
	{
		pe[i] = Dib.Palette[i];
		pe[i].peFlags = PC_RESERVED;
	}
	
	lpDD->CreatePalette(DDPCAPS_8BIT, pe, &lpP, NULL);
	return(lpP);
};

BOOL DirectDraw::Flip(void)
{
	HRESULT Result;
		
	while(1)
    {
		Result = lpFront->Flip(NULL, DDFLIP_WAIT);

        if(Result == DD_OK)
        {
            break;
        }

		if(Result == DDERR_SURFACELOST)
        {
			lpFront->Restore();
			lpBack->Restore();
        }

		if(Result != DDERR_WASSTILLDRAWING)
        {
            break;
        }
    }
	return(TRUE);	
};

BOOL DirectDraw::Clear(BYTE PalIndex)
{
	DDBLTFX ddbltfx;
	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = PalIndex;
	lpBack->Blt(NULL, NULL, NULL,
				DDBLT_COLORFILL | DDBLT_WAIT,
				&ddbltfx);
	return(TRUE);	
};

BOOL DirectDraw::AddBitmap(char *file)
{
	HDIB db;
	DDSURFACEDESC ddsd;
	HRESULT Result;
	DDSURFACEDESC Desc;
	int dWidth, dHeight;
	int h, i;
	LPBYTE Src, Dest;
	DWORD dPtch;
		
	if((NewDib >= NumDibs) || (!lpDib))
		return(FALSE);

	db.Load(file);
    memset(&ddsd, 0, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwHeight = db.Info.biHeight;
    ddsd.dwWidth = db.Info.biWidth;
	Result = lpDD->CreateSurface(&ddsd, &lpDib[NewDib], NULL);
	if(Result != DD_OK)
		MessageBeep(0);
//	DIB2Surface(db, lpDib[NewDib]);
	
	dWidth = db.Info.biWidth;
	dHeight = db.Info.biHeight;
	Desc.dwSize = sizeof(Desc);
	lpDib[NewDib]->Lock(NULL, &Desc, DDLOCK_WAIT, NULL);

	Dest = (LPBYTE)Desc.lpSurface;
	Src = (LPBYTE)db.Data;
	dPtch = Desc.lPitch - dWidth;

	for(h = 0; h < dHeight; h++)
	{
		for(i = 0; i < dWidth; i++)
			*Dest++ = *Src++;
		Dest += dPtch;
	}

	lpDib[NewDib]->Unlock(NULL);
	DDCOLORKEY ddck;
	ddck.dwColorSpaceLowValue = 0;
	ddck.dwColorSpaceHighValue = 0;
	lpDib[NewDib]->SetColorKey(DDCKEY_SRCBLT, &ddck);

	NewDib++;
	db.Free();
	return(TRUE);
};

BOOL DirectDraw::FreeBitmap(LPDIRECTDRAWSURFACE lpSurf)
{
	if(lpSurf)
	{
		lpSurf->Release();
		lpSurf = NULL;
	}
	return(TRUE);
};

BOOL DirectDraw::BltBitmap(LPDIRECTDRAWSURFACE lpSurf, RECT Src, RECT Dest)
{
	lpBack->Blt(&Dest, lpSurf, &Src, DDBLT_WAIT | DDBLT_KEYSRC, NULL);
	return(TRUE);
};

BOOL CALLBACK DDDeviceCallback(GUID FAR *lpGUID, LPSTR lpDriverDesc,
							   LPSTR lpDriverName, LPVOID lpContext)
{
	LPDIRECTDRAW lpDD = NULL;
	HRESULT Result;
	
	lpDriverDesc = lpDriverDesc;
	lpDriverName = lpDriverName;
	
	if(!lpGUID)
		return DDENUMRET_OK;

	Result = DirectDrawCreate(lpGUID, &lpDD, NULL);
	if(Result != DD_OK)
	{
		lpDD = NULL;
		return DDENUMRET_OK;
	}

	*(LPDIRECTDRAW *)lpContext = lpDD;
	return DDENUMRET_CANCEL;
};

