#include <ddraw.h>
#include "hdib.h"

enum VIDEOMODE {M320x240x8, M640x480x8, M800x600x8, M1024x768x8};

BOOL CALLBACK DDDeviceCallback(GUID FAR *lpGUID, LPSTR lpDriverDesc,
							   LPSTR lpDriverName, LPVOID lpContext);

class DirectDraw
{
public:
	
	HWND				hWindow;
	RECT				RefreshArea;
	POINT				Screen;
	POINT				HalfScreen;
	DWORD				Pitch;
	DWORD				NewDib;
	DWORD				NumDibs;
	LPDIRECTDRAW 		lpDD;
	LPDIRECTDRAWSURFACE lpFront;
	LPDIRECTDRAWSURFACE lpBack;
	LPDIRECTDRAWSURFACE *lpDib;
	LPDIRECTDRAWCLIPPER lpClip;
	LPDIRECTDRAWPALETTE lpPal;

public:

	DirectDraw();
	~DirectDraw();
	
	BOOL SetDefaults(HWND hWindow, DWORD nDibs);
	BOOL SetMode(enum VIDEOMODE Mode);
	BOOL CreateViewBuffers(void);
	BOOL DeleteViewBuffers(void);
	IDirectDrawPalette *ExtractPalette(HDIB Dib);
	BOOL Flip(void);
	BOOL Clear(BYTE PalIndex);
    BOOL AddBitmap(char *file);
	BOOL FreeBitmap(LPDIRECTDRAWSURFACE lpBmp);
	BOOL BltBitmap(LPDIRECTDRAWSURFACE lpSurf, RECT Src, RECT Dest);
};
