#include "header.h"

extern DirectDraw *DD;
int GetLine(char *buff, int n, FILE *in);

int WORLD::LoadWorld(char *filename)
{
	FILE    *fp;
	char    buf[100];
	char    String[100];
	char    String2[100];
	int     i, j;

	Number_Cameras = 0;
	Number_Textures = 0;

	fp = fopen(filename, "rt");
	if(!fp)
	{
		MessageBox(GetFocus(), "File error on open.",
			"Error Opening File", MB_OK | MB_ICONEXCLAMATION);
		fclose(fp);
		return -1;
	}

	while(GetLine(buf, sizeof(buf), fp) != -1)
	{
		sscanf(buf, "%s", String);
		for(i = 0; i < strlen(String); i++)
			String[i] = (BYTE)toupper(String[i]);

		if(stricmp(String, "NUMBER_TEXTURES") == 0)
		{
			sscanf(buf, "%*s %d", &i);
			Texture = new HDIB[i];
		}

		else if(stricmp(String, "NUMBER_CAMERAS") == 0)
		{
			sscanf(buf, "%*s %d", &i);
			Camera = new CAMERA[i];
		}

		else if(stricmp(String, "TEXTURE") == 0)
		{
			sscanf(buf, "%*s %s", String);
			Texture[Number_Textures].Load(String);
			Number_Textures++;
		}

		else if(stricmp(String, "LANDSCAPE") == 0)
		{
			sscanf(buf, "%*s %s %s", String, String2);
			LoadLandScapeFile(String, String2);
		}


		else if(stricmp(String, "CAMERA") == 0)
		{
			if(!Camera)
				MessageBox(GetFocus(),
					"Memory not allocated for cameras.",
					"Enigmatic Experience", MB_OK);

			GetLine(buf, sizeof(buf), fp);
			sscanf(buf, "%s", String);
			if(stricmp(String, "{") != 0)
			{
				MessageBox(GetFocus(), 
					"Error reading camera.", 
					"Critical Error", MB_OK);
				fclose(fp);
				return -1;
			}

			for(;;)
			{
				GetLine(buf, sizeof(buf), fp);
				sscanf(buf, "%s", String);
				for(i = 0; i < strlen(String); i++)
					String[i] = (BYTE)toupper(String[i]);

				if(stricmp(String, "ANGLE") == 0)
					sscanf(buf, "%*s %f %f %f", 
						&Camera[Number_Cameras].xAngle,
						&Camera[Number_Cameras].yAngle,
						&Camera[Number_Cameras].zAngle);

				else if(stricmp(String, "SCALE") == 0)
					sscanf(buf, "%*s %f %f %f", 
						&Camera[Number_Cameras].xScale,
						&Camera[Number_Cameras].yScale,
						&Camera[Number_Cameras].zScale);

				else if(stricmp(String, "TRANSLATE") == 0)
					sscanf(buf, "%*s %f %f %f", 
					&Camera[Number_Cameras].xTrans,
					&Camera[Number_Cameras].yTrans,
					&Camera[Number_Cameras].zTrans);

				else if(stricmp(String, "}") == 0)
					break;
			}
			Number_Cameras++;
		}
	}

	Current_Camera = 0;
	j = X_DIR * 2 * Z_DIR * 2;
	PolyList = new POLYGON[j];
	Number_Polygons = 0;
	WorldOpen = TRUE;
	fclose(fp);
	return 1;
};

int WORLD::LoadLandScapeFile(char *RAWFile1, char *RAWFile2)
{
	FILE	*fp, *fp2;
	int		i, j, c;
	int		width, height;

	fp = fopen(RAWFile1, "rb");
	fp2 = fopen(RAWFile2, "rb");
	if(!fp) return 0;
	if(!fp2) return 0;

	fread((BYTE *)ImageMap, 65536, 1, fp2);
	LandScape.Width = 256; LandScape.Height = 256;
	LandScape.log2Width = 8; LandScape.log2Height = 8;
	width = 256; height = 256;
	LandScape.Number_Vertices = width * height;
    LandScape.Vertex = new VERTEX[LandScape.Number_Vertices];

	for(i = 0; i < height; i++)
	{
		for(j = 0; j < width; j++)
		{
			c = fgetc(fp);
			LandScape.Vertex[i * width + j].ox = j * 1024;
			LandScape.Vertex[i * width + j].oy = c * -50;
			LandScape.Vertex[i * width + j].oz = i * 1024;
		}
	}

	fclose(fp);
	fclose(fp2);
	return 0;
};
	
int GetLine(char *buff, int n, FILE *in)
{
    char *p;

	do
	{
		if (fgets(buff, n, in) == 0)
	        return -1;
        if ((p = strchr(buff, '\n')) != NULL)
	        *p = '\0';
        if ((p = strchr(buff, ';')) != NULL)
	        *p = '\0';
        for (p = buff; isspace(*p); ++p);
	} while (p[0] == '\0');

	return 0;
};

