#include "header.h"

int HDIB::Load(char *file)
{
	FILE	*fp;
	int		NumColors;
	BYTE	*TempData;
    BYTE    *d;
	int		i, j;
	BYTE	Temp;
	int		Rem;
		
	fp = fopen(file, "rb");
	if(!fp)
	{
		MessageBeep(0);
		fclose(fp);
		return 0;
	}

// This will be the bitmap's info
	fseek(fp, sizeof(BITMAPFILEHEADER), SEEK_SET);
	fread(&Info, sizeof(BITMAPINFOHEADER), 1, fp);
	Rem = 4 - Info.biWidth & 3;
	Info.biSizeImage = ((DWORD)(UINT)Info.biWidth * (DWORD)(UINT)Info.biHeight);
	Data = (BYTE *)GlobalAlloc(GPTR, Info.biSizeImage);
	TempData = new BYTE[Info.biSizeImage];
    d = (BYTE *)Data;

// This should be the palette for the bitmap
	NumColors = (Info.biClrUsed == 0 ? 256 : (int)Info.biClrUsed);
	fread(Palette, sizeof(RGBQUAD), NumColors, fp);
	for(i = 0; i < 256; i++)
	{
		Temp = Palette[i].peRed;
		Palette[i].peRed = Palette[i].peBlue;
		Palette[i].peBlue = Temp;
	}
	Info.biClrUsed = NumColors;

// And this will be the rest of the bitmap data
	for(i = 0; i < Info.biHeight; i++)
	{
        fread((BYTE *)&TempData[i * Info.biWidth], sizeof(BYTE), (int)Info.biWidth, fp);
		for(j = 0; j < Rem; j++)
			fgetc(fp);
	}

	for(long s = Info.biSizeImage - 1; s >= 0; s--)
		*(d + s) = TempData[Info.biSizeImage - 1 - s];
	delete TempData;

	TempData = new BYTE[Info.biWidth];
	for(long h = 0; h < Info.biHeight; h++)
	{
		for(long w = 0; w < Info.biWidth; w++)
			TempData[w] = *(d + h * Info.biWidth + Info.biWidth - w - 1);
		for(w = 0; w < Info.biWidth; w++)
			*(d + h * Info.biWidth + w) = TempData[w];
	}
	delete TempData;

	fclose(fp);
	return 0;
};

int HDIB::Free()
{
	GlobalFree((BYTE *)Data);
	return 0;
};

HPALETTE HDIB::ReturnPalette()
{
	LOGPALETTE	*LogPal;
	HPALETTE	Pal;
	int			i;
	
	LogPal = (LOGPALETTE *)LocalAlloc(LPTR, sizeof(LOGPALETTE) + 236 * sizeof(PALETTEENTRY));
	LogPal->palNumEntries = 236;
	LogPal->palVersion = 0x300;
	
	for(i = 0; i < 236; i++)
	{
		LogPal->palPalEntry[i] = Palette[i + 10];
		LogPal->palPalEntry[i].peFlags = PC_RESERVED;
	}
	
	Pal = CreatePalette((LOGPALETTE *)LogPal);
	LocalFree((LOGPALETTE *)LogPal);
	return(Pal);
};

