#include "header.h"

extern WORLD *World;

MATRIX::MATRIX()
{
	Identity();
};

//Maybe optimize memset function
int MATRIX::Identity()
{
    memset(MMat, 0, sizeof(float) * 15);
    MMat[0][0] = MMat[1][1] = MMat[2][2] = MMat[3][3] = 1.0;
	return 0;
};

//Definitely needs to be optimized, maybe assembly
void MATRIX::Multiply(float *ptr1, float *ptr2, float *ptr3)
{
	int    i, j, t;
	
	for(i = 0; i < 4; i++)
	{
		for(j = 0; j < 4; j++)
		{
			*(ptr1 + (i << 2) + j) = 0;
			for(t = 0; t < 4; t++)
			{
				*(ptr1 + (i << 2) + j) +=
				*(ptr2 + (i << 2) + t) *
				*(ptr3 + (t << 2) + j);
			}
		}
	}
};

void MATRIX::Copy(float *dest, float *src)
{
    memcpy(dest, src, sizeof(float) * 16);
};

int MATRIX::Scale(float sx, float sy, float sz)
{
    MMat[0][0] = sx; MMat[1][2] = sy;
    MMat[2][2] = sz; MMat[3][3] = 1.0;
	return 0;
};

int MATRIX::Rotate(float x, float y, float z)
{
        float cval, sval;

        cval = cos(y); sval = sin(y);
        memset(UMat, 0, sizeof(float) * 15);
        UMat[0][0] = cval; UMat[0][2] = -sval;
        UMat[1][1] = 1.0; UMat[2][0] = sval;
        UMat[2][2] = cval; UMat[3][3] = 1.0;
        Multiply(&TMat[0][0], &MMat[0][0], &UMat[0][0]);
        Copy(&MMat[0][0], &TMat[0][0]);

        cval = cos(x); sval = sin(x);
        memset(UMat, 0, sizeof(float) * 15);
        UMat[0][0] = 1.0; UMat[1][1] = cval;
        UMat[1][2] = sval; UMat[2][1] = -sval;
        UMat[2][2] = cval; UMat[3][3] = 1.0;
        Multiply(&TMat[0][0], &MMat[0][0], &UMat[0][0]);
        Copy(&MMat[0][0], &TMat[0][0]);

        cval = cos(z); sval = sin(z);
        memset(UMat, 0, sizeof(float) * 15);
        UMat[0][0] = cval; UMat[0][1] = sval;
        UMat[1][0] = -sval; UMat[1][1] = cval;
        UMat[2][2] = 1.0; UMat[3][3] = 1.0;
        Multiply(&TMat[0][0], &MMat[0][0], &UMat[0][0]);
        Copy(&MMat[0][0], &TMat[0][0]);
        return 0;
};

int MATRIX::Translate(float xt, float yt, float zt)
{
        memset(UMat, 0, sizeof(float) * 15);
        UMat[0][0] = UMat[1][1] = UMat[2][2] = UMat[3][3] = 1.0;
        UMat[3][0] = xt; UMat[3][1] = yt; UMat[3][2] = zt;
        Multiply(&TMat[0][0], &MMat[0][0], &UMat[0][0]);
        Copy(&MMat[0][0], &TMat[0][0]);
        return 0;
};

int MATRIX::TransformWithCamera(LANDSCAPE *land)
{
	UINT v, w;
	VERTEX *vptr;
	int sx, ex;
	int sz, ez;
		
	sx = ((long)World->Camera[World->Current_Camera].xTrans >> 10);
	sz = ((long)World->Camera[World->Current_Camera].zTrans >> 10);
	ex = ( ((sx + X_DIR) < land->Width) ? (sx + X_DIR) : (land->Width - 1));
	sx = ( ((sx - X_DIR) < 0) ? (0) : (sx - X_DIR));
	ez = ( ((sz + Z_DIR) < land->Height) ? (sz + Z_DIR) : (land->Height - 1));
	sz = ( ((sz - Z_DIR) < 0) ? (0) : (sz - Z_DIR));

	for(v = sx; v < ex; v++)
    {
		for(w = sz; w < ez; w++)
        {
			vptr = &land->Vertex[(w << 8) + v];

            vptr->vx = (vptr->ox * MMat[0][0]) +
                       (vptr->oy * MMat[1][0]) +
                       (vptr->oz * MMat[2][0]) +
                                   MMat[3][0];

            vptr->vy = (vptr->ox * MMat[0][1]) +
                       (vptr->oy * MMat[1][1]) +
                       (vptr->oz * MMat[2][1]) +
                                   MMat[3][1];

            vptr->vz = (vptr->ox * MMat[0][2]) +
                       (vptr->oy * MMat[1][2]) +
                       (vptr->oz * MMat[2][2]) +
                                   MMat[3][2];
		}
	}
	return 0;
};

float operator%(VECTOR Vector1, VECTOR Vector2)
{
	return((Vector1.x * Vector2.x) +
           (Vector1.y * Vector2.y) +
           (Vector1.z * Vector2.z));
};

VECTOR operator^(VECTOR Vector1, VECTOR Vector2)
{
	VECTOR Resultant;

	Resultant.x = ( (Vector1.y * Vector2.z) - (Vector1.z * Vector2.y) );
	Resultant.y = ( (Vector1.z * Vector2.x) - (Vector1.x * Vector2.z) );
	Resultant.z = ( (Vector1.x * Vector2.y) - (Vector1.y * Vector2.x) );

	return Resultant;
};

void VectorLength(VECTOR *Vect)
{
	Vect->Length = sqrt((Vect->x * Vect->x)
                      + (Vect->y * Vect->y)
                      + (Vect->z * Vect->z));
};

void Normalize(VECTOR *Vect)
{
    float Temp;

    Vect->Length = sqrt((Vect->x * Vect->x)
                      + (Vect->y * Vect->y)
                      + (Vect->z * Vect->z));
	if(Vect->Length != 0.0)
        Temp = 1.0 / Vect->Length;
    Vect->x *= Temp; Vect->y *= Temp; Vect->z *= Temp;
};

