#ifndef WORLD_H
#define WORLD_H

#include "types.h"
#include "math3d.h"
#include "hdib.h"

class WORLD
{
public:
	LANDSCAPE	LandScape;
	
	long		Number_Cameras;
	long		Current_Camera;
	CAMERA		*Camera;

	long		Number_Polygons;
    POLYGON     *PolyList;
	
	long		Number_Textures;
	HDIB		*Texture;

	MATRIX		*UpdateMatrix;
	BYTE		*ImageMap;
	BOOL		WorldOpen;
	int			hWidth, hHeight;

	WORLD();
	~WORLD();

    int LoadWorld(char *filename);
    int LoadLandScapeFile(char *heightmap, char *textures);
	int FreeWorld();

	int ProjectWorld(float Perspective);
    int BackfaceCull(POLYGON *p);
    int SortPolyList(POLYGON *p, int Start, int End);
	int DrawWorld(void *);
	int DrawLandScape(void *Screen);
	int DrawTriangle(POLYGON *p, void *Screen);
	int UpdateWorld();
};

#endif
