#include "header.h"

extern DirectDraw *DD;
int Reject(POLYGON *p);
BYTE ShadeTable[33][256];

WORLD::WORLD()
{
	FILE *fp;
	UpdateMatrix = new MATRIX;
	ImageMap = (BYTE *)GlobalAlloc(GPTR, sizeof(BYTE) * 256 * 256);
	fp = fopen("haze.dat", "rb");
	fread(ShadeTable, sizeof(BYTE), 33 << 8, fp);
	fclose(fp);
};

WORLD::~WORLD()
{
	GlobalFree((BYTE *)ImageMap);
	delete UpdateMatrix;
};

int WORLD::FreeWorld()
{
	int i, j;

	delete PolyList;
	delete LandScape.Vertex;
	for(i = 0; i < Number_Textures; i++)
		Texture[i].Free();
	delete Texture;
	delete Camera;
	return 0;
};

// Optimize in assembly
int WORLD::ProjectWorld(float Perspective)
{
	int i, j, p;
	float d, r;
	int sx, ex;
	int sz, ez;

	sx = ((long)Camera[Current_Camera].xTrans >> 10);
	sz = ((long)Camera[Current_Camera].zTrans >> 10);
	ex = ( ((sx + X_DIR) < LandScape.Width) ? (sx + X_DIR) : (LandScape.Width - 1));
	sx = ( ((sx - X_DIR) < 0) ? (0) : (sx - X_DIR));
	ez = ( ((sz + Z_DIR) < LandScape.Height) ? (sz + Z_DIR) : (LandScape.Height - 1));
	sz = ( ((sz - Z_DIR) < 0) ? (0) : (sz - Z_DIR));

	for(int v = sx; v < ex; v++)
	{
        for(int w = sz; w < ez; w++)
        {
			p = (w << 8) + v;
			r = LandScape.Vertex[p].vz;
			if(r <= 0.0)
				continue;
			d = Perspective / (float)r;
			LandScape.Vertex[p].sx = (long)(0.5 + LandScape.Vertex[p].vx * d + DD->HalfScreen.x);
			LandScape.Vertex[p].sy = (long)(0.5 + LandScape.Vertex[p].vy * d + DD->HalfScreen.y);
		}
	}

	return 0;
};

int WORLD::BackfaceCull(POLYGON *p)
{
	float X1, Y1, Z1;
	float X2, Y2, Z2;
	float X3, Y3, Z3;
	float D;

	X1 = p->Vertex[0].vx; Y1 = p->Vertex[0].vy; Z1 = p->Vertex[0].vz;
	X2 = p->Vertex[1].vx; Y2 = p->Vertex[1].vy; Z2 = p->Vertex[1].vz;
	X3 = p->Vertex[2].vx; Y3 = p->Vertex[2].vy; Z3 = p->Vertex[2].vz;

	D = (X3 * ((Z1 * Y2) - (Y1 * Z2)))
      + (Y3 * ((X1 * Z2) - (Z1 * X2)))
      + (Z3 * ((Y1 * X2) - (X1 * Y2)));

	return(D < 0);
};

int WORLD::DrawWorld(void *Screen)
{
	DrawLandScape(Screen);
	return 0;
};

int WORLD::DrawLandScape(void *Screen)
{
	int i, j, r;
	int sx, ex;
	int sz, ez;

	sx = ((long)Camera[Current_Camera].xTrans >> 10);
	sz = ((long)Camera[Current_Camera].zTrans >> 10);
	ex = ( ((sx + (X_DIR - 1)) < (LandScape.Width - 1)) ? (sx + (X_DIR - 1)) : ((LandScape.Width - 2)));
	sx = ( ((sx - (X_DIR - 1)) < 0) ? (0) : (sx - (X_DIR - 1)));
	ez = ( ((sz + (Z_DIR - 1)) < (LandScape.Height - 1)) ? (sz + (Z_DIR - 1)) : ((LandScape.Height - 2)));
	sz = ( ((sz - (Z_DIR - 1)) < 0) ? (0) : (sz - (Z_DIR - 1)));

	Number_Polygons = 0;
	for(i = sx; i < ex; i++)
	for(int k = sz; k < ez; k++)
	{
		PolyList[Number_Polygons].Vertex[0] = LandScape.Vertex[(k << 8) + i];
		PolyList[Number_Polygons].Vertex[1] = LandScape.Vertex[(k << 8) + i + 1];
		PolyList[Number_Polygons].Vertex[2] = LandScape.Vertex[((k + 1) << 8) + i];
		PolyList[Number_Polygons].TextPt[0].x = 0;
		PolyList[Number_Polygons].TextPt[0].y = 0;
		PolyList[Number_Polygons].TextPt[1].x = 31;
		PolyList[Number_Polygons].TextPt[1].y = 0;
		PolyList[Number_Polygons].TextPt[2].x = 0;
		PolyList[Number_Polygons].TextPt[2].y = 31;
		PolyList[Number_Polygons].Texture = *(ImageMap + (k << 8) + i);
		if(!Reject(&PolyList[Number_Polygons]))
			if(!BackfaceCull(&PolyList[Number_Polygons]))
				Number_Polygons++;

		PolyList[Number_Polygons].Vertex[0] = LandScape.Vertex[(k << 8) + i + 1];
		PolyList[Number_Polygons].Vertex[1] = LandScape.Vertex[((k + 1) << 8) + i + 1];
		PolyList[Number_Polygons].Vertex[2] = LandScape.Vertex[((k + 1) << 8) + i];
		PolyList[Number_Polygons].TextPt[0].x = 31;
		PolyList[Number_Polygons].TextPt[0].y = 0;
		PolyList[Number_Polygons].TextPt[1].x = 31;
		PolyList[Number_Polygons].TextPt[1].y = 31;
		PolyList[Number_Polygons].TextPt[2].x = 0;
		PolyList[Number_Polygons].TextPt[2].y = 31;
		PolyList[Number_Polygons].Texture = *(ImageMap + (k << 8) + i);
		if(!Reject(&PolyList[Number_Polygons]))
			if(!BackfaceCull(&PolyList[Number_Polygons]))
				Number_Polygons++;
	}

	if(Number_Polygons <= 1)
		return(1);

	SortPolyList(PolyList, 0, Number_Polygons - 1);
	for(i = 0; i < Number_Polygons; i++)
		DrawTriangle(&PolyList[i], Screen);
	return 0;
};

int WORLD::SortPolyList(POLYGON *item, int left, int right)
{
	int i, j;
	float x;
    POLYGON y;

	i = left; j = right;
	x = item[(left + right) >> 1].Vertex[0].vz;

	do
	{
		while(item[i].Vertex[0].vz > x && i < right) i++;
		while(x > item[j].Vertex[0].vz && j > left) j--;

		if(i <= j)
		{
			y = item[i];
			item[i] = item[j];
			item[j] = y;
			i++; j--;
		}

	} while(i <= j);

	if(left < j)
		SortPolyList(item, left, j);
	if(i < right)
		SortPolyList(item, i, right);
	return 0;
};

int WORLD::UpdateWorld()
{
	UpdateMatrix->Identity();
	UpdateMatrix->Scale(1, 1, 1);
	UpdateMatrix->Translate(-Camera[Current_Camera].xTrans,
							-Camera[Current_Camera].yTrans,
							-Camera[Current_Camera].zTrans);
	UpdateMatrix->Rotate(-Camera[Current_Camera].xAngle,
						 -Camera[Current_Camera].yAngle,
						 -Camera[Current_Camera].zAngle);

	UpdateMatrix->TransformWithCamera(&LandScape);
	return 0;
};

int Reject(POLYGON *p)
{
	int l, r, u, d, z;

	l = r = u = d = z = 0;
	for(int i = 0; i < 3; i++)
	{
		if(p->Vertex[i].sx < 0)	l++;
		if(p->Vertex[i].sx >= DD->Screen.x)	r++;
		if(p->Vertex[i].sy < 0)	u++;
		if(p->Vertex[i].sy >= DD->Screen.y)	d++;
		if(p->Vertex[i].vz <= HITHER) z++;
	}

	if(l == 3 || r == 3 || u == 3 || d == 3 || z != 0)
		return 1;
	return 0;
};
