/*
 * This file is part of the MGUI (MORELLO Graphic User Interface)
 * development tool.
 * Contains key code macro definitions.
 */

#ifndef _KEYCODES_H
#define _KEYCODES_H

#ifdef X11_MGUI
/*
 * Unix X-Window KeyCodes definitions
 */
#include <X11/keysym.h>

#define HOME		XK_Home
#define ESC		XK_Escape
#define END		XK_End
#define TAB		XK_Tab
#define BKS		XK_BackSpace
#define DEL		XK_Delete
#define RET		XK_Return
#define ENTER		XK_KP_Enter
#define INS		XK_Insert
#define PAGEUP		XK_Prior
#define PAGEDOWN	XK_Next
#define SPACEBAR	XK_space

#define U_A		XK_Up
#define D_A		XK_Down
#define R_A		XK_Right
#define L_A		XK_Left

#define C_A		0x0401
#define C_B		0x0402
#define C_C		0x0403
#define C_D		0x0404
#define C_E		0x0405
#define C_F		0x0406
#define C_G		0x0407
#define C_H		0x0408
#define C_I		0x0409
#define C_J		0x040a
#define C_K		0x040b
#define C_L		0x040c
#define C_M		0x040d
#define C_N		0x040e
#define C_O		0x040f
#define C_P		0x0410
#define C_Q		0x0411
#define C_R		0x0412
#define C_S 		0x0413
#define C_T		0x0414
#define C_U		0x0415
#define C_V		0x0416
#define C_W		0x0417
#define C_X		0x0418
#define C_Y		0x0419
#define C_Z		0x041a

#define A_A		0x0861
#define A_B		0x0862
#define A_C		0x0863
#define A_D		0x0864
#define A_E		0x0865
#define A_F		0x0866
#define A_G		0x0867
#define A_H		0x0868
#define A_I		0x0869
#define A_J		0x086a
#define A_K		0x086b
#define A_L		0x086c
#define A_M		0x086d
#define A_N		0x086e
#define A_O		0x086f
#define A_P		0x0870
#define A_Q		0x0871
#define A_R		0x0872
#define A_S 		0x0873
#define A_T		0x0874
#define A_U		0x0875
#define A_V		0x0876
#define A_W		0x0877
#define A_X		0x0878
#define A_Y		0x0879
#define A_Z		0x087a

#define F1	XK_F1
#define F2	XK_F2
#define F3	XK_F3
#define F4	XK_F4
#define F5	XK_F5
#define F6	XK_F6
#define F7	XK_F7
#define F8	XK_F8
#define F9	XK_F9
#define F10	XK_F10
#define F11	XK_F11
#define F12	XK_F12

#define C_F1	(XK_F1 & 0x7fff)
#define C_F2	(XK_F2 & 0x7fff)
#define C_F3	(XK_F3 & 0x7fff)
#define C_F4	(XK_F4 & 0x7fff)
#define C_F5	(XK_F5 & 0x7fff)
#define C_F6	(XK_F6 & 0x7fff)
#define C_F7	(XK_F7 & 0x7fff)
#define C_F8	(XK_F8 & 0x7fff)
#define C_F9	(XK_F9 & 0x7fff)
#define C_F10	(XK_F10 & 0x7fff)
#define C_F11	(XK_F11 & 0x7fff)
#define C_F12	(XK_F12 & 0x7fff)

#define A_1	0x7800
#define A_2	0x7900
#define A_3	0x7a00
#define A_4	0x7b00
#define A_5	0x7c00
#define A_6	0x7d00
#define A_7	0x7e00
#define A_8	0x7f00
#define A_9	0x8000
#define A_0	0x8100

#elif defined DJGPP_MGUI || (defined BC_MGUI && defined LIBGRX)
/*
 *  DJGPP or GRX keycodes
 */
#include "keys.h"

#define HOME		K_EHome
#define ESC		K_Escape
#define END		K_EEnd
#define TAB		(K_Tab|0x1000)

#define BKS		(K_BackSpace|0x1000)
#define DEL		K_EDelete
#define RET		(K_Return|0x1000)
#define ENTER		0xe00d
#define INS		K_EInsert
#define PAGEUP		K_EPageUp
#define PAGEDOWN	K_EPageDown
#define SPACEBAR	K_Space

#define U_A		K_EUp
#define D_A		K_EDown
#define R_A		K_ERight
#define L_A		K_ELeft

#define C_A		K_Control_A
#define C_B		K_Control_B
#define C_C		K_Control_C
#define C_D		K_Control_D
#define C_E		K_Control_E
#define C_F		K_Control_F
#define C_G		K_Control_G
#define C_H		K_Control_H
#define C_I		K_Control_I
#define C_J		K_Control_J
#define C_K		K_Control_K
#define C_L		K_Control_L
#define C_M		K_Control_M
#define C_N		K_Control_N
#define C_O		K_Control_O
#define C_P		K_Control_P
#define C_Q		K_Control_Q
#define C_R		K_Control_R
#define C_S		K_Control_S
#define C_T		K_Control_T
#define C_U		K_Control_U
#define C_V		K_Control_V
#define C_W		K_Control_W
#define C_X		K_Control_X
#define C_Y		K_Control_Y
#define C_Z		K_Control_Z

#define A_A		K_Alt_A
#define A_B		K_Alt_B
#define A_C		K_Alt_C
#define A_D		K_Alt_D
#define A_E		K_Alt_E
#define A_F		K_Alt_F
#define A_G		K_Alt_G
#define A_H		K_Alt_H
#define A_I		K_Alt_I
#define A_J		K_Alt_J
#define A_K		K_Alt_K
#define A_L		K_Alt_L
#define A_M		K_Alt_M
#define A_N		K_Alt_N
#define A_O		K_Alt_O
#define A_P		K_Alt_P
#define A_Q		K_Alt_Q
#define A_R		K_Alt_R
#define A_S		K_Alt_S
#define A_T		K_Alt_T
#define A_U		K_Alt_U
#define A_V		K_Alt_V
#define A_W		K_Alt_W
#define A_X		K_Alt_X
#define A_Y		K_Alt_Y
#define A_Z		K_Alt_Z

#define F1		K_F1
#define F2		K_F2
#define F3		K_F3
#define F4		K_F4
#define F5		K_F5
#define F6		K_F6
#define F7		K_F7
#define F8		K_F8
#define F9		K_F9
#define F10		K_F10
#define F11		K_F11
#define F12		K_F12

#define C_F1		K_Control_F1
#define C_F2		K_Control_F2
#define C_F3		K_Control_F3
#define C_F4		K_Control_F4
#define C_F5		K_Control_F5
#define C_F6		K_Control_F6
#define C_F7		K_Control_F7
#define C_F8		K_Control_F8
#define C_F9		K_Control_F9
#define C_F10		K_Control_F10
#define C_F11		K_Control_F11
#define C_F12		K_Control_F12

#define A_F1	K_Alt_F1
#define A_F2	K_Alt_F2
#define A_F3	K_Alt_F3
#define A_F4	K_Alt_F4
#define A_F5	K_Alt_F5
#define A_F6	K_Alt_F6
#define A_F7	K_Alt_F7
#define A_F8	K_Alt_F8
#define A_F9	K_Alt_F9
#define A_F10	K_Alt_F10

#define A_1	K_Alt_1
#define A_2	K_Alt_2
#define A_3	K_Alt_3
#define A_4	K_Alt_4
#define A_5	K_Alt_5
#define A_6	K_Alt_6
#define A_7	K_Alt_7
#define A_8	K_Alt_8
#define A_9	K_Alt_9
#define A_0	K_Alt_0

#else
/*
 * DOS and Windows KeyCodes definitions
 */

#define HOME		0x4700
#define ESC		0x11b
#define END		0x4f00
#define TAB		0xf09

#define BKS		0xe08
#define DEL		0x5300
#define RET		0x1c0d
#define ENTER		0xe00d
#define INS		0x5200
#define PAGEUP		0x4900
#define PAGEDOWN	0x5100
#define SPACEBAR	0x20

#define U_A		0x4800
#define D_A		0x5000
#define R_A		0x4d00
#define L_A		0x4b00

#define C_A		0x1e01
#define C_B		0x3002
#define C_C		0x2e03
#define C_D		0x2004
#define C_E		0x1205
#define C_F		0x2106
#define C_G		0x2207
#define C_H		0x2308
#define C_I		0x1709
#define C_J		0x240a
#define C_K		0x250b
#define C_L		0x260c
#define C_M		0x320d
#define C_N		0x310e
#define C_O		0x180f
#define C_P		0x1910
#define C_Q		0x1011
#define C_R		0x1312
#define C_S		0x1f13
#define C_T		0x1414
#define C_U		0x1615
#define C_V		0x2f16
#define C_W		0x1117
#define C_X		0x2d18
#define C_Y		0x1519
#define C_Z		0x2c1a

#define A_A		0x1e00
#define A_B		0x3000
#define A_C		0x2e00
#define A_D		0x2000
#define A_E		0x1200
#define A_F		0x2100
#define A_G		0x2200
#define A_H		0x2300
#define A_I		0x1700
#define A_J		0x2400
#define A_K		0x2500
#define A_L		0x2600
#define A_M		0x3200
#define A_N		0x3100
#define A_O		0x1800
#define A_P		0x1900
#define A_Q		0x1000
#define A_R		0x1300
#define A_S		0x1f00
#define A_T		0x1400
#define A_U		0x1600
#define A_V		0x2f00
#define A_W		0x1100
#define A_X		0x2d00
#define A_Y		0x1500
#define A_Z		0x2c00

#define F1		0x3b00
#define F2		0x3c00
#define F3		0x3d00
#define F4		0x3e00
#define F5		0x3f00
#define F6		0x4000
#define F7		0x4100
#define F8		0x4200
#define F9		0x4300
#define F10		0x4400
#define F11		0x5700
#define F12		0x5800

#define C_F1		0x5e00
#define C_F2		0x5f00
#define C_F3		0x6000
#define C_F4		0x6100
#define C_F5		0x6200
#define C_F6		0x6300
#define C_F7		0x6400
#define C_F8		0x6500
#define C_F9		0x6600
#define C_F10		0x6700

#ifdef WIN_MGUI
#define C_F11		0x7a00
#define C_F12		0x7b00
#else
#define C_F11		0x8900
#define C_F12		0x8a00
#endif

#define A_F1	0x6800
#define A_F2	0x6900
#define A_F3	0x6a00
#define A_F4	0x6b00
#define A_F5	0x6c00
#define A_F6	0x6d00
#define A_F7	0x6e00
#define A_F8	0x6f00
#define A_F9	0x7000
#define A_F10	0x7100

#ifdef WIN_MGUI
#define A_0	0x7800
#define A_1	0x7801
#define A_2	0x7802
#define A_3	0x7803
#define A_4	0x7804
#define A_5	0x7805
#define A_6	0x7806
#define A_7	0x7807
#define A_8	0x7808
#define A_9	0x7809
#else
#define A_1	0x7800
#define A_2	0x7900
#define A_3	0x7a00
#define A_4	0x7b00
#define A_5	0x7c00
#define A_6	0x7d00
#define A_7	0x7e00
#define A_8	0x7f00
#define A_9	0x8000
#define A_0	0x8100
#endif

#endif

#endif
