/*
 * This file is part of the MGUI (MORELLO Graphic User Interface)
 * development tool.
 * Contains all MGUI macro definitions and typedefs
 */

#ifndef _MGUIDEFS_H
#define _MGUIDEFS_H

#define MGUI_RELEASE	0x161

/*
 * Auto environment detection (if not set):
 * BC_MGUI (DOS BGI), DJGPP_MGUI and WIN_MGUI (both 16 & 32 bit) are detected.
 * WIN32 and __WIN32__ are set when compiling for Win32s, Win 95 and NT.
 * X11_MGUI is set by default. LIBGRX must be set to compile in LINUX console
 * (svgalib) or GRX under BORLANDC
 */


#if !defined DJGPP_MGUI && !defined X11_MGUI && !defined BC_MGUI && !defined WIN_MGUI
	#if defined __TURBOC__
		#ifdef _Windows
			#define WIN_MGUI
			#define WINDOWS
			#if defined __WIN32__ && !defined WIN32
				#define WIN32
			#endif
		#else
			#define BC_MGUI
			#define BORLANDC
		#endif
	#elif _WINDOWS
		#define WIN_MGUI
		#define WINDOWS
		#ifdef WIN32
			#define __WIN32__
		#endif
	#elif defined __GO32__
		#define DJGPP_MGUI
		#define LIBGRX
	#else
		#ifndef LIBGRX
			#define X11_MGUI
		#endif
		#define UNIX
	#endif
#endif

#if defined __TURBOC__ || defined WIN_MGUI
#include <time.h>
#else
#include <sys/time.h>
#endif

/*
 * This include file contains key codes definition
 */
#include "keycodes.h"

#ifdef UNIX
#define DIR_SEP   '/'
#else
#define DIR_SEP   '\\'
#endif

typedef struct {
#if defined DJGPP_MGUI || defined WIN32
	int x;
	int y;
#else
	short x;
	short y;
#endif
} MPOINT;

typedef struct {
	int	x, y, w, h;
} MRECT;

typedef struct _rlist {
	MRECT r;
	struct _rlist *next;
} RLIST;

/*
 * Integer size typedefs
 */
#ifdef X11_MGUI
#include "X11/X.h"
#include <X11/Xmd.h>
#else

	typedef long            INT32;
	typedef short           INT16;
	typedef char            INT8;
	typedef unsigned long   CARD32;
	typedef unsigned short  CARD16;
	typedef unsigned char   CARD8;
#if !defined UNIX && !defined _WINSOCKAPI_ && !defined DJGPP_MGUI
	struct timeval {
		long    tv_sec;
		long    tv_usec;
	};
#endif
#endif /* X11_MGUI */

typedef int MTFont;

/*
 * Color type definition
 */
#if defined(BC_MGUI) || defined(DJGPP_MGUI) || defined(LIBGRX)

typedef struct { MRECT r; RLIST *rl; } *Window;
typedef long MTColor;

#elif defined WIN_MGUI

typedef void *Window;
typedef CARD32 MTColor;

#elif defined X11_MGUI

typedef CARD32 MTColor;

#endif

#ifndef True

#define True	1
#define False	0

#endif

#ifndef WIN_MGUI
#define _export
#endif

/* MGUI Events */

#define E_NO_EVENT		0
#define E_KEY_PRESS		1
#define E_BUTTON_PRESS		2
#define E_BUTTON_RELEASE 	3
#define E_MOTION		4
#define E_WINDOW_ENTER		5
#define E_WINDOW_EXIT		6
#define E_EXPOSE		7
#define E_DESTROY		8
#define E_MAP			9
#define E_UNMAP			10
#define E_AUTOSIZE		11
#define E_RESIZE		12
#define E_MOVE			13
#define E_SELECT		14
#define E_DESELECT		15
#define E_TIMER			16
#define E_FOCUS_IN		17
#define E_FOCUS_OUT		18
#define E_CONFIGURE		19
#define E_PARENT_MAP		20
#define E_PARENT_UNMAP		21
#define E_SET_COLOR		22
#define E_SET_SHADOW		23
#define E_SET_TEXT		24
#define E_GET_TEXT		25
#define E_WM_CLOSE		26
#define E_SET_SENS		27
#define E_SET_PARENT_SENS	28

/*  Event Masks */

#define EM_NO_EVENT		0L
#define EM_KEY_PRESS		1L
#define EM_BUTTON_PRESS     (1L<<1)
#define EM_BUTTON_RELEASE   (1L<<2)
#define EM_MOTION           (1L<<3)
#define EM_WINDOW_ENTER     (1L<<4)
#define EM_WINDOW_EXIT      (1L<<5)
#define EM_EXPOSE           (1L<<6)
#define EM_DESTROY          (1L<<7)
#define EM_MAP              (1L<<8)
#define EM_UNMAP            (1L<<9)
#define EM_AUTOSIZE         (1L<<10)
#define EM_RESIZE           (1L<<11)
#define EM_MOVE             (1L<<12)
#define EM_SELECT           (1L<<13)
#define EM_DESELECT         (1L<<14)
#define EM_TIMER            (1L<<15)
#define EM_FOCUS_IN         (1L<<16)
#define EM_FOCUS_OUT        (1L<<17)
#define EM_CONFIGURE        (1L<<18)
#define EM_PARENT_MAP	    (1L<<19)
#define EM_PARENT_UNMAP	    (1L<<20)
#define EM_SET_COLOR	    (1L<<22)
#define EM_SET_SHADOW	    (1L<<23)
#define EM_SET_TEXT	    (1L<<24)
#define EM_GET_TEXT	    (1L<<25)
#define EM_WM_CLOSE	    (1L<<26)
#define EM_SET_SENS	    (1L<<27)
#define EM_SET_PARENT_SENS  (1L<<28)

/*
 * Mouse button bits in mouse events
 */

#ifndef X11_MGUI

#define Button1Mask		(1<<8)
#define Button2Mask		(1<<9)
#define Button3Mask		(1<<10)

#define Button1			1
#define Button2			2
#define Button3			3

/*
 * Keyboard Modifier keys
 */
#define ShiftMask	(1<<0)
#define LockMask 	(1<<1)
#define ControlMask	(1<<2)

#endif

#define AltMask		(1<<3)

/*
 * This structure contains the fields common in all system windows
 * generated events.
 */
typedef struct {
	int type;
	Window window;
} MAnyWindowEvent;

typedef struct {
	int type;
	int sensitive;
} MSetSensitivity;

typedef struct {
	int type;
	char *text;
} MSetGetTextEvent;

typedef struct {
	int type;
	MTColor bgc;
	MTColor fgc;
} MSetColorEvent;

typedef struct {
	int type;
	int shadow;
	int in_thick;
	int out_thick;
} MSetShadowEvent;

typedef struct {
	int type;
	void *id;
	void *user_data;
} MTimerEvent;

typedef struct {
	int type;
	Window window;
	unsigned int state;
	unsigned int keycode;
} MKeyEvent;

typedef struct {
	int type;
	Window window;
	int x, y;		/* pointer x, y coordinates in event window */
	int x_root, y_root;	/* coordinates relative to root */
	unsigned int state;	/* buttons and key modifiers mask */
	unsigned int button;	/* button */
} MMouseEvent;

typedef struct {
	int type;
	Window window;
	int x_off, y_off;
	int x, y;
	int width, height;
} MExposeEvent;

typedef MAnyWindowEvent MWMCloseEvent;

typedef MAnyWindowEvent MFocusEvent;

typedef MAnyWindowEvent MUnmapEvent;

typedef MAnyWindowEvent MMapEvent;

typedef MAnyWindowEvent MSelectEvent;

typedef MAnyWindowEvent MDeSelectEvent;

typedef struct {
	int type;
	Window window;
	int x, y;
	int width, height;
} MConfigureEvent;

typedef struct {
	int type;
	Window window;
	int x, y;
} MMoveEvent;

typedef struct {
	int type;
	Window window;
	int width, height;
} MResizeEvent;

typedef union _MEvent {
	int type;
	MAnyWindowEvent any_window_event;
	MKeyEvent key;
	MMouseEvent mouse;
	MExposeEvent expose;
	MWMCloseEvent wm_close;
	MFocusEvent focus;
	MUnmapEvent unmap;
	MMapEvent map;
	MDeSelectEvent deselect;
	MSelectEvent select;
	MConfigureEvent configure;
	MResizeEvent resize;
	MMoveEvent move;
	MSetColorEvent setcolor;
	MSetShadowEvent setshadow;
	MSetGetTextEvent setgettext;
	MSetSensitivity setsensitivity;
} MEvent;


/*
 * Static fonts, loaded at program start up
 */
#define DEFAULT_FONT    0
#define SMALL_FONT      1
#define MEDIUM_FONT     2
#define LARGE_FONT      3
#define TIMES_N_FONT    4
#define TIMES_L_FONT    5
#define HELV_N_FONT     6
#define HELV_L_FONT     7

/*
 * Text alignment options: for the LABEL OBJECT and DrawText primitive
 */
#define LEFT_ALIGN      0
#define RIGHT_ALIGN     1
#define CENTER_ALIGN    2

/*
 * Object shadows
 */

#define WS_NONE         0
#define WS_SHADOW_OUT   1
#define WS_SHADOW_IN    2
#define WS_ETCHED_IN	3
#define WS_ETCHED_OUT	4
/*
 * The following macros are present only for sources written for
 * release 1.4.3 or earlier. Don't use in new sources!
 */
#define WS_HATCHED_IN	WS_ETCHED_IN
#define WS_HATCHED_OUT	WS_ETCHED_OUT

/* Object Types */

#define OT_SHELL        1
#define OT_FORM         2
#define OT_LABEL        3
#define OT_PBUTTON      4
#define OT_TBUTTON      5
#define OT_RBUTTON      6
#define OT_SCROLLBAR    7
#define OT_EDIT         8
#define OT_STATUSBAR    9
#define OT_TEXT         10
#define OT_SBLIST       11
#define OT_MENU         12
#define OT_PULLDOWN     13
#define OT_DRAWAREA     14

/*
 * MPIXMAP is the Pixmap type identifier
 */
#ifndef _MGRAPH_H
typedef void *MPIXMAP;
#endif

/*
 * MOBJECT is the Object type identifier,
 * OBJECT and MPIXMAP_DESCR are obsolete types
 */
#ifdef _MGUI_OBJECT_H
	typedef struct mobj_s *MOBJECT;
#else
	typedef void *MOBJECT;
	#ifdef OLD_MGUI_DEF
		typedef void OBJECT, MPIXMAP_DESCR;
	#endif
#endif

/*
 * SHELL creation options (bitwise or-ed in the 'flags' parameter)
 */
#define SF_NO_FOCUS_CHANGE      0x1     /* Internal use (PULLDOWN MENU) */
#define SF_SAVEUNDER            0x2     /* The area under the appearing SHELL
					 * window is stored for a fast redraw
					 * when the window is deleted
					 */
#define SF_MODAL                0x4     /* Input focus is grabbed by the SHELL
					 * until it is removed
					 */
#define SF_POPUP                0x8     /* Undecorated window look (PULLDOWN) */

#define SF_IGNORE_WM_CLOSE      0x10    /* SHELL ignores the CLOSE message
					 * sent by the Window Manager
					 */
#define SF_UNMAP_ON_WM_CLOSE    0x20    /* The SHELL only unmaps itself
					 * (not destroy) when receives the
					 * CLOSE message from the Window Manager
					 */

/* SPOOL */

#define MSPOOL_OK               0
#define MSPOOL_FULL_QUEUE       -1
#define MSPOOL_NOT_READY        -2
#define MSPOOL_FILE_ERR         -3

/* Child Preferred Attachment */

#define F_PREF_ATT_NONE 0
#define F_PREF_ATT_ROW  1
#define F_PREF_ATT_COL  2

/* Child Attachment */

#define F_ATT_NONE      0
#define F_ATT_FORM      1
#define F_ATT_OBJ       2

/* DRAWAREA resize preferences (for use in the resize callback) */

typedef struct {
	int old_w, old_h;
	int new_w, new_h;
} DRAWAREA_PREF;

/* SCROLLBAR TYPE (for use in the MCreateScrollBar() */

#define SBT_HOR         0
#define SBT_VERT        1

/* SBLIST */
#define SBLT_TEXT       0
#define SBLT_LIST       1
#define SBLT_ELIST      2
#define SBLT_FILE       3
#define SBL_ITEM_SELECTED       0x1L
#define SBL_ITEM_CHECKED        0x2L

/*
 * Item structure
 */
typedef struct blist_i {
	struct blist_i  *next;		/* Points to next item */
	char            *data;		/* Points to the item text */
	long            misc;		/* Internal use */
	void            *u_data;	/* Item user data */
} XL_ITEM;

/*
 * This structure is passed by the List Object to the
 * Activate callback when the Enter key is pressed.
 */

typedef struct {
	char *item;		/* Item text */
	void *u_data;		/* Item user data */
	long pos;		/* Position in the list */
	unsigned char selected;	/* Item selection status flag */
	unsigned char checked;	/* Item check status flag */
} LIST_ACT;

/*
 *  Template structure for the EditList creation.
 */

typedef struct {
	char *head;		/* Field head */
	short len;		/* Field length */
	short vis_len;		/* Field visible len */
	short changeable;	/* Editable flag */
	MOBJECT edit;		/* EDIT Object returned */
	MOBJECT label;		/* LABEL heading returned */
} EL_TEMPLATE;

/*
 *  This structure is passed to the NewBlock callback by the 'Clip' and
 *  'Skip' List Objects. The first member is significant only for
 *  the 'Skip' List. The member 'offset' is relative to the location
 *  specified by 'from'.
 *  The member 'nr' is also a return value of the callback in case of
 *  'Skip' List Object. It specifies the number of rows actually returned.
 */

typedef struct {
	int from;       /* SEEK_SET, SEEK_CUR, SEEK_END */
	long offset;    /* Starting offset position */
	int nc;         /* Item length */
	int nr;         /* Number of row (to supply/returned) */
	XL_ITEM *pi;    /* POinter to destination item list */
} SBL_NEW_BLOCK;

/*
 *  This structure is used by the ItemSeek callback for 'Clip' and 'Skip' lists
 *  The second member specifies the searching substring.
 *  The first is the callback returned item position. It should be set to
 *  -1L if not found, 0 in case of Skip List, the actual item position
 *  otherwise.
 */

typedef struct {
	long pos;		/* returnd item position */
	char *sub_item;		/* item to seek to substring */
} SBL_ITEM_SEEK;


#define XLItemCheck(pxl)        ((pxl)->misc |= SBL_ITEM_CHECKED)
#define XLItemUncheck(pxl)      ((pxl)->misc &= ~SBL_ITEM_CHECKED)

/* Basic EDIT filter value */

#define NOCHAR          0
#define ANYCHAR         0x1
#define ALPHA           0x2
#define DIGIT           0x4
#define SPACE           0x8

/* Basic filter modifiers */

#define SIGNED          0x100
#define DOT             0x200
#define UPPER           0x400
#define LOWER           0x800

/* Composed fiter values */

#define ALPHANUM        (ALPHA|DIGIT)
#define UPALPHA         (ALPHA|UPPER)
#define LOWALPHA        (ALPHA|LOWER)
#define U_INT            DIGIT
#define INT             (DIGIT|SIGNED)
#define U_FLOAT         (DIGIT|DOT)
#define FLOAT           (DIGIT|DOT|SIGNED)

/*
 *  This structure is passed to the CursorPosition callback
 *  by the EDIT Object.
 */

typedef struct {
	int pos;	/* cursor position in the text stream */
	int pos_x;	/* cursor x position */
	int pos_y;	/* cursor y position */
} EDIT_CURS;

/*
 *  The EDIT Object passes this structure to the ValueChange callback
 *  when its text changes. Last member is a return flag.
 */

typedef struct {
	char *current_text;     /* EDIT text before the change */
	char *change;           /* New text */
	int pos;                /* New text insert position */
	int len;                /* Current text to substitute */
	int change_len;         /* New text lenght */
	unsigned validate;      /* Validation flag */
	unsigned exec;          /* Reject the change if False */
} EDIT_CHANGE;

/*
 *  The EDIT Object passes this structure to the Validation callback when
 *  it's about to lose the input focus. Last three members are return flags.
 */
typedef struct {
	char *text;		/* EDIT text */
	short len;		/* Text lenght */
	int key;		/* Key code originator (0 if not applicable) */
	unsigned focus_lost;    /* If True, EDIT will lose the focus anyway */
	unsigned focus_leave;   /* If set to False, EDIT will keep focus */
	unsigned text_changed;  /* If set to True EDIT redraws itself */
	unsigned text_validated; /* If set to True EDIT becomes validated */
} EDIT_VAL;

/* MENU */

typedef void *PULLDOWN_ITEM;

/* RS232 */

#define RS232_PARITY_NONE       0
#define RS232_PARITY_EVEN       1
#define RS232_PARITY_ODD        2

#define RS232_GEN_ERROR         (-1)
#define RS232_NO_SUCH_PORT      (-20)
#define RS232_PORT_BUSY         (-21)
#define RS232_BAD_PARAM         (-22)
#define RS232_NO_MORE_ID        (-23)

typedef CARD32  TIMEOUT_ID;

typedef void (*TIMEOUT_CB)(TIMEOUT_ID id, void *data);

typedef int (*STRCMP_CB)(const char *, const char *);
typedef void (*APP_TIMER_CB)(void *data);
typedef void (*RS232_CB)(int id, void *u_data);
typedef INT32 MVALUE;

#ifdef NO_MGUI_CB_PROTO
typedef void (*MGUI_CB)();
#else
typedef void (*MGUI_CB)(MOBJECT obj, void *od, void *ad);
#endif

#if defined UNIQUE_CB_PROTO || defined NO_MGUI_CB_PROTO
typedef MGUI_CB OBJ_EVENT_CB;
typedef MGUI_CB OBJ_STRING_CB;
typedef MGUI_CB OBJ_VALUE_CB;
typedef MGUI_CB WM_CLOSE_CB;
typedef MGUI_CB NEW_BLOCK_CB;
typedef MGUI_CB ITEM_SEEK_CB;
typedef MGUI_CB EDIT_VAL_CB;
typedef MGUI_CB EDIT_CURS_CB;
typedef MGUI_CB EDIT_CHANGE_CB;
typedef MGUI_CB LIST_ACT_CB;
typedef MGUI_CB DRAWAREA_PREF_CB;
#else
typedef void (*OBJ_EVENT_CB)(MOBJECT obj, MEvent *e, void *ad);
typedef void (*OBJ_STRING_CB)(MOBJECT obj, char *str, void *ad);
typedef void (*OBJ_VALUE_CB)(MOBJECT obj, MVALUE value, void *ad);
typedef void (*WM_CLOSE_CB)(MOBJECT obj, void *odata, void *cdata);
typedef void (*NEW_BLOCK_CB)(MOBJECT obj, SBL_NEW_BLOCK *nbs, void *ad);
typedef void (*ITEM_SEEK_CB)(MOBJECT obj, SBL_ITEM_SEEK *iss, void *ad);
typedef void (*EDIT_VAL_CB)(MOBJECT edit, EDIT_VAL *ev, void *ad);
typedef void (*EDIT_CURS_CB)(MOBJECT edit, EDIT_CURS *ev, void *ad);
typedef void (*EDIT_CHANGE_CB)(MOBJECT edit, EDIT_CHANGE *ec, void *ad);
typedef void (*LIST_ACT_CB)(MOBJECT list, LIST_ACT *la, void *ad);
typedef void (*DRAWAREA_PREF_CB)(MOBJECT drawa, DRAWAREA_PREF *dp, void *ad);
#endif /* UNIQUE_CB_PROTO */

#endif
