/*
 * 	File fontview.c
 *	Demonstrates the Font loading technique
 */

#include <stdio.h>
#include <stdlib.h>

#include "mgui.h"

extern void CloseDialogCB(MOBJECT p, void *s, void *v);
extern MTColor black, white, darkblue, cadetblue, seagreen;
extern int LowRes;

MOBJECT drawa, e_fname, e_fsize;

MTFont font = DEFAULT_FONT;
int bold = False;
int italic = False;

/***************************************************************
 *	This callback toggles the Bold attribute
 ***************************************************************/
static void SetBoldCB(MOBJECT obj, MVALUE a, void *data)
{
	bold = (int)a;
}

/***************************************************************
 *	This callback toggles the Italic attribute
 ***************************************************************/
static void SetItalicCB(MOBJECT obj, MVALUE a, void *data)
{
	italic = (int)a;
}

/***************************************************************
 *	This callback Unloads the latest loaded font and
 *	destroys the dialog
 ***************************************************************/
static void CloseFontViewCB(MOBJECT p, void *a, void *data)
{
	if (font != DEFAULT_FONT)
		MUnloadFont(font);
	font = DEFAULT_FONT;
	p = MObjectShell(p);

	MShellUnrealize(p);
	MShellDestroy(p);
}

/***************************************************************
 *	This callback tries to load the specified font
 ***************************************************************/
static void LoadFontCB(MOBJECT obj, void *a, void *data)
{
	MTFont newfont;
	int size;
        char family[32], buff[8];
/*
 * Get user preferences from the EDIT Objects
 */
	MObjectGetText(e_fname, family);
	MObjectGetText(e_fsize, buff);
	size = atoi(buff);
	newfont = MLoadFont(family, size, bold, italic);
/*
 * The function returns DEFAULT_FONT on failure
 */
	if (newfont != DEFAULT_FONT) {
		if (font != DEFAULT_FONT)
			MUnloadFont(font);
		font = newfont;
		MObjectRedraw(drawa);
	}
	else
		MBeep();
}

/***************************************************************
 *	This callback draws strings using the selected font
 ***************************************************************/
static void DrawAreaExposeCB(MOBJECT obj, MEvent *pe, void *data)
{
	MDrawText(obj,
		0, 0, MObjectWidth(obj), MObjectHeight(obj)/2,
		"AaBbCcDdEeFfGgHhIiJjKkLlMm",
		font, black, CENTER_ALIGN);
	MDrawText(obj,
		0, MObjectHeight(obj)/2, MObjectWidth(obj), MObjectHeight(obj)/2,
		"NnOoPpQqRrSsTtUuWwYyXxZz",
		font, black, CENTER_ALIGN);
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void FontViewCB(MOBJECT o, void *o_data, void *a_data)
{
	MOBJECT pbutton, shell, form, form0;
	MOBJECT form1, form2, tbutton, sfile, list;

	shell = MCreateShell("Font Browser", SF_MODAL);

        form = MCreateColForm(shell);
	drawa = MCreateDrawArea(form, 400, 120);
	MDrawAreaSetExposeCallback(drawa, DrawAreaExposeCB, 0L);

	form0 = MCreateRowForm(form);
	form1 = MCreateColForm(form0);

	tbutton = MCreateTButton(form0, "Bold", HELV_L_FONT);
        MTButtonSetCallback(tbutton, SetBoldCB, 0L);

	tbutton = MCreateTButton(form0, "Italic", HELV_L_FONT);
	MTButtonSetCallback(tbutton, SetItalicCB, 0L);

	pbutton = MCreatePButton(form0, "Test", TIMES_L_FONT);
	MPButtonSetCallback(pbutton, LoadFontCB, 0L);

	form2 = MCreateRowForm(form1);
	MCreateLabel(form2, "Name:", HELV_N_FONT);
	MCreateLabel(form2, "Dim:", HELV_N_FONT);

	form2 = MCreateRowForm(form1);
/*
 * The Option Edit contains the known font families
 */
	e_fname = MCreateOptionEdit(form2, "Times", 32, 10, 5, DEFAULT_FONT);
	list = MOptionEditGetList(e_fname);
	MSListAddItem(list, "Times", 0L);
	MSListAddItem(list, "Helvetica", 0L);
	MSListAddItem(list, "Courier", 0L);
	MSListAddItem(list, "Symbol", 0L);

	e_fsize = MCreateEdit(form2, "34", 2, DEFAULT_FONT);
	MRightAttach(e_fsize, F_ATT_NONE, 0,NULL);

	sfile = MCreateSFile(shell, __FILE__,
			(LowRes ? SMALL_FONT : DEFAULT_FONT),
			12, 60);
	MObjectSetColor(sfile, darkblue, white);

	pbutton = MCreatePButton(shell, "Close", TIMES_L_FONT);
	MPButtonSetCallback(pbutton, CloseFontViewCB, 0L);

	MShellRealize(shell);
}
