
//local function defs
void glCirclePoints(int x,int cx,int y,int cy,int odd,UCHAR col);
void glCircleFilledPoints1(int x,int cx,int y,int cy,int odd,UCHAR col);
void glCircleFilledPoints2(int x,int cx,int y,int cy,int odd,UCHAR col);


//DRAW FUNCTIONS - all clipped except glPutPixel

void glPutPixel(UCHAR col,int x,int y) {
  glPTR[(y*glDWw)+x]=col;
}

void glPutPixelClip(UCHAR col,int x,int y)
{
  if (x>=glXMIN&&y>=glYMIN&&x<=glXMAX&&y<=glYMAX) glPTR[(y*glDWw)+x]=col;
}

 //HORIZONTAL OPTIMIZED LINE
void glHLine(UCHAR col,int x1,int x2,int y)
{
  int a;
  //make line left to right
  if (x2<x1) {a=x1; x1=x2; x2=a;}

  //if line in buffer - draw
  if (y>=glYMIN && y<=glYMAX && x1<=glXMAX && x2>=glXMIN) {
    //clip line
    if (x1<glXMIN) x1=glXMIN;
    if (x2>glXMAX) x2=glXMAX;
    memset(glPTR+(y*glDWw)+x1, col, x2-x1+1);
  }
}

 //LINE
int glLine(UCHAR col,int x1,int y1,int x2,int y2)
{
  int dx=x2-x1,dy=y2-y1;
  int d,incrS,incrD,yplus,xp,yp;
  int x=x1,y=y1;

  //check line is left to right - swap coordinates if not
  if (dx<0) {
    dx=-dx; dy=-dy;
    x1=x2; y1=y2; x2=x; y2=y;
    x=x1; y=y1;
  }
  //get y increment -   + or - 1
  if (y2>=y1) yplus=1; else yplus=-1;

  //is line horizontal?
  if (y1==y2) {
    //for(d=x1; d<=x2; d++) glPutPixelClip(col,d,y1);
    glHLine(col,x1,x2,y1);
    return(0);
  }
  //is line vertical?
  if (x1==x2) {
    for(d=y1; d!=y2; d+=yplus) glPutPixelClip(col,x1,d);
    glPutPixelClip(col,x1,y2);//do last point because loop was to !=y2
    return(0);
  }

  //else -
  if (yplus==-1) dy=-dy;
  xp=dx; yp=dy;
  if (xp<0) xp=-xp; if (yp<0) yp=-yp;

  //calculate & draw line
  glPutPixelClip(col,x,y);//first point

  //is line all in buffer?
  if ( (y1<y2&&glAreaInBuffer(x1,y1,x2,y2)) ||
   (y1>y2&&glAreaInBuffer(x1,y2,x2,y1)) )
  {
    if (xp>=yp) {
      d=(2*dy)-dx; incrS=2*dy; incrD=2*(dy-dx);
      while(x<x2) {
        if (d<=0) {d+=incrS; x++;} else {d+=incrD; x++; y+=yplus;}
        glPTR[(y*glDWw)+x]=col;
      }
    }
    else {
      d=(2*dx)-dy; incrS=2*dx; incrD=2*(dx-dy);
      while(y!=y2) {
        if (d<=0) {d+=incrS; y+=yplus;} else {d+=incrD; x++; y+=yplus;}
        glPTR[(y*glDWw)+x]=col;
      }
    }
    //end
  }
  //if not - USE CLIPPING
  else {
    if (xp>=yp) {
      d=(2*dy)-dx; incrS=2*dy; incrD=2*(dy-dx);
      while(x<x2) {
        if (d<=0) {d+=incrS; x++;} else {d+=incrD; x++; y+=yplus;}
        glPutPixelClip(col,x,y);
      }
    }
    else {
      d=(2*dx)-dy; incrS=2*dx; incrD=2*(dx-dy);
      while(y!=y2) {
        if (d<=0) {d+=incrS; y+=yplus;} else {d+=incrD; x++; y+=yplus;}
        glPutPixelClip(col,x,y);
      }
    }
    //end
  }

  //END
  return(0);
}



//RECTANGLES

void glRectangle(UCHAR col,int x,int y,int w,int h)
{
  int a,right=x+w-1;

  glHLine(col,x,right,y);
  for(a=y+1; a<y+h-1; a++) {
    glPutPixelClip(col,x,a);
    glPutPixelClip(col,right,a);
  }
  glHLine(col,x,right,y+h-1);
}

void glRectangleFilled(UCHAR col,int x,int y,int w,int h)
{
  int a,right=x+w-1;
  for(a=y; a<y+h; a++) glHLine(col,x,right,a);
}




//CIRCLES

int glCircle(UCHAR col,int cx,int cy,int diameter)
{
  int radius=diameter>>1,odd=0;
  int x=0,y=radius,d=1-radius,deltaE=3,deltaSE=(-2*radius)+5;

  if ((radius<<1)!=diameter) odd=1;
  if (odd==0) {cx--; cy--;}

  glCirclePoints(x,cx,y,cy,odd,col);

  while(y>x) {
    if (d<0) {
      d+=deltaE;
      deltaE+=2; deltaSE+=2;
    }
    else {
      d+=deltaSE;
      deltaE+=2; deltaSE+=4;
      y--;
    }
    x++;
    glCirclePoints(x,cx,y,cy,odd,col);
  }
  return(0);
}

//draw 8 points around circle based on 45' symmetry
void glCirclePoints(int x,int cx,int y,int cy,int odd,UCHAR col)
{
  if (odd==1) {
    glPutPixelClip(col,x+cx,y+cy);
    glPutPixelClip(col,y+cx,x+cy);
    glPutPixelClip(col,y+cx,-x+cy);
    glPutPixelClip(col,x+cx,-y+cy);
    glPutPixelClip(col,-x+cx,-y+cy);
    glPutPixelClip(col,-y+cx,-x+cy);
    glPutPixelClip(col,-y+cx,x+cy);
    glPutPixelClip(col,-x+cx,y+cy);
  }
  else {
    glPutPixelClip(col,x+cx,y+cy);
    glPutPixelClip(col,y+cx,x+cy);
    glPutPixelClip(col,y+cx,-x+cy+1);
    glPutPixelClip(col,x+cx,-y+cy+1);
    glPutPixelClip(col,-x+cx+1,-y+cy+1);
    glPutPixelClip(col,-y+cx+1,-x+cy+1);
    glPutPixelClip(col,-y+cx+1,x+cy);
    glPutPixelClip(col,-x+cx+1,y+cy);
  }
}


//FILLED CIRCLE
int glCircleFilled(UCHAR col,int cx,int cy,int diameter)
{
  int radius=diameter>>1,odd=0;
  int x=0,y=radius,d=1-radius,deltaE=3,deltaSE=(-2*radius)+5;

  if ((radius<<1)!=diameter) odd=1;
  if (odd==0) {cx--; cy--;}

  glCircleFilledPoints1(x,cx,y,cy,odd,col);
  glCircleFilledPoints2(x,cx,y,cy,odd,col);

  while(y>x) {
    if (d<0) {
      d+=deltaE;
      deltaE+=2; deltaSE+=2;
    }
    else {
      d+=deltaSE;
      deltaE+=2; deltaSE+=4;
      glCircleFilledPoints1(x,cx,y,cy,odd,col);//fill lines before y change
      y--;
    }
    x++;
    glCircleFilledPoints2(x,cx,y,cy,odd,col);
  }
  return(0);
}

//Fill top and bottom 1/4 of circle
void glCircleFilledPoints1(int x,int cx,int y,int cy,int odd,UCHAR col)
{
  if (odd==1) {
    glHLine(col,-x+cx,x+cx,y+cy);
    glHLine(col,-x+cx,x+cx,-y+cy);
  }
  else {
    glHLine(col,-x+cx+1,x+cx,y+cy);
    glHLine(col,-x+cx+1,x+cx,-y+cy+1);
  }
}
//Fill middle two circle quarters
void glCircleFilledPoints2(int x,int cx,int y,int cy,int odd,UCHAR col)
{
  if (odd==1) {
    glHLine(col,-y+cx,y+cx,x+cy);
    glHLine(col,-y+cx,y+cx,-x+cy);
  }
  else {
    glHLine(col,-y+cx+1,y+cx,x+cy);
    glHLine(col,-y+cx+1,y+cx,-x+cy+1);
  }
}


