//windows graphics lib.

#include "glmheadr.h"//windows.h included in header
#include <stdlib.h>
#include <stdio.h>
#include <mem.h>

//sub-files
#include "gldraw.c"
#include "glimage.c"

//GLOBAL VARIABLES
gl_image_array glbmp[MAXIMAGES];//global loaded images array
LOGPALETTE *gllogpalette;

//graphics target
int glXMIN,glXMAX,glYMIN,glYMAX,glw,glh,glDWw;
UCHAR *glPTR;
BITMAPINFO *glbmi;

//clipping variables
int glx1clip,glx2clip,gly1clip,gly2clip;

//image file headers
PCXHEADER glPCXHead;
BITMAPINFO *glBMPinfo;



//FUNCTIONS

//Library Init./close

int glInit(void)
{
  int a;
  //allocate memory for BMP header
  if ((glBMPinfo=(BITMAPINFO *)malloc(sizeof(BITMAPINFOHEADER)+(sizeof(RGBQUAD)*256)))==NULL)
   return(0);
  //alloc. memory for logpalette
  gllogpalette = (LOGPALETTE *)malloc((sizeof(WORD)*2)+(sizeof(PALETTEENTRY)*256));
  if (gllogpalette==NULL) {free(glBMPinfo); return(0);}
  //clear image array
  for(a=0; a<MAXIMAGES; a++) glbmp[a].type=0;
  glPTR=NULL;
  return(1);
}

void glClose(void)
{
  int a;
  //free image data
  for(a=0; a<MAXIMAGES; a++) {
    if (glbmp[a].type) {
      free(glbmp[a].data); glbmp[a].type=0;
    }
  }
  //free BMP header
  free(glBMPinfo);
  free(gllogpalette);//free logpalette
}


//MISC. functions

//get Double WORD aligned width
int glDWORDwidth(int w)
{
  int i;
  do {
    i=w>>2;
    if ((i<<2)!=w) w++; else break;
  } while(1);
  return(w);
}

//check if a rectangular area is all inside current buffer clip area
int glAreaInBuffer(int x1,int y1,int x2,int y2)
{
  if (x1>=glXMIN && x2<=glXMAX && y1>=glYMIN && y2<=glYMAX) return(1);
  return(0);
}

//get clipping info for specified rectangle - returns 0 if outside current
//buffer clip area
int glGetClipInfo(int x,int y,int w,int h)
{
  glx1clip=0; glx2clip=0; gly1clip=0; gly2clip=0;
  //is area in buffer at all?
  if (x+w<=glXMIN || x>glXMAX || y+h<=glYMIN || y>glYMAX) return(0);
  //get clipping
  if (x<glXMIN) glx1clip=glXMIN-x;
  if (y<glYMIN) gly1clip=glYMIN-y;
  if (x+w-1>glXMAX) glx2clip=x+w-1-glXMAX;
  if (y+h-1>glYMAX) gly2clip=y+h-1-glYMAX;
  return(1);
}

//BUFFER functions

int glCreateBuffer(glbuffer *buff,HDC hdc)
{
  int a,c;

  if (buff->width<=0||buff->height<=0) return(0);

  buff->DWwidth=glDWORDwidth(buff->width);//get DWORD width

  //set clip rect to whole of buffer
  buff->xmin=0; buff->ymin=0;
  buff->xmax=buff->width-1; buff->ymax=buff->height-1;

  //allocate memory for header
  if ( (buff->bmi=(BITMAPINFO *)
   malloc(sizeof(BITMAPINFOHEADER)+(sizeof(RGBQUAD)*256))) == NULL) return(0);

  //fill in buffer header
  buff->bmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
  buff->bmi->bmiHeader.biWidth = buff->width;
  buff->bmi->bmiHeader.biHeight = -buff->height;
  // Height is negative to create bitmap right-side up!
  buff->bmi->bmiHeader.biPlanes = 1;        buff->bmi->bmiHeader.biBitCount = 8;
  buff->bmi->bmiHeader.biCompression = 0;   buff->bmi->bmiHeader.biSizeImage = 0;
  buff->bmi->bmiHeader.biXPelsPerMeter = 0; buff->bmi->bmiHeader.biYPelsPerMeter = 0;
  buff->bmi->bmiHeader.biClrUsed = 256;     buff->bmi->bmiHeader.biClrImportant = 256;
  //buffer's palette
  c=0;
  for(a=0; a<256; a++) {
    buff->bmi->bmiColors[a].rgbRed = buff->palette[c];
    buff->bmi->bmiColors[a].rgbGreen = buff->palette[c+1];
    buff->bmi->bmiColors[a].rgbBlue = buff->palette[c+2];
    c+=3;
    buff->bmi->bmiColors[a].rgbReserved = 0;
  }

  buff->data=NULL;

  //Create buffer
  buff->handle = CreateDIBSection (
    hdc, buff->bmi, DIB_RGB_COLORS,(void **)&buff->data, NULL, 0
  );
  if (buff->handle==NULL) {free(buff->bmi); return(0);}
  if (buff->data==NULL)
   {DeleteObject(buff->handle); free(buff->bmi); return(0);}

  //finalize
  buff->type=1;
  memset(buff->data,0,buff->DWwidth*buff->height);//clear buffer
  return(1);
}


int glKillBuffer(glbuffer *buff)
{
  DeleteObject(buff->handle);
  free(buff->bmi);
  return(1);
}

//set target for graphics functions - copy details to gltbuff
void glSetTarget(glbuffer *buff)
{
  //memcpy(&gltbuff,buff,sizeof(gltbuff));
  //set global graphics target variables
  glXMIN=buff->xmin; glYMIN=buff->ymin;
  glXMAX=buff->xmax; glYMAX=buff->ymax;
  glPTR=buff->data;
  glbmi=buff->bmi;
  glw=buff->width; glDWw=buff->DWwidth;
  glh=buff->height;
}

int glDisplayBuffer(HDC hdc,glbuffer *buff,int dx,int dy)
{
  return(
   StretchDIBits(hdc,dx,dy,buff->width,buff->height,
    0,0,buff->width,buff->height,
     buff->data, buff->bmi, DIB_RGB_COLORS, SRCCOPY)
  );
}

int glDisplayBufferArea(HDC hdc,glbuffer *buff,int dx,int dy,int dw,int dh,
 int sx,int sy,int sw,int sh)
{
  return(
   StretchDIBits(hdc,dx,dy,dw,dh,
    sx,buff->height-sy-sh,sw,sh,
     buff->data, buff->bmi, DIB_RGB_COLORS, SRCCOPY)
  );
}

//clear current target buffer to specified color
void glClear(UCHAR col)
{
  memset(glPTR,col,glDWw*glh);
}

//create window palette from buffer's
HPALETTE glCreateHPALETTE(glbuffer *buff)
{
  int a,c;
  
  gllogpalette->palVersion=0x300; gllogpalette->palNumEntries=256;

  c=0;
  for(a=0; a<256; a++) {
    gllogpalette->palPalEntry[a].peRed = buff->palette[c];
    gllogpalette->palPalEntry[a].peGreen = buff->palette[c+1];
    gllogpalette->palPalEntry[a].peBlue = buff->palette[c+2];
    c+=3;
    gllogpalette->palPalEntry[a].peFlags=PC_NOCOLLAPSE;
  }
  for(a=0; a<10; a++) {
    gllogpalette->palPalEntry[a].peFlags=NULL;
    gllogpalette->palPalEntry[a+246].peFlags=NULL;
  }

  //select logical pal into Window DC
  return(CreatePalette(gllogpalette));
}

