//windows grahics lib.
//main header
#include "windows.h"


//general defines
#define MAXIMAGES 500

//TYPE DEFs
typedef unsigned char UCHAR;

//buffer structure
typedef struct {
  int width,DWwidth,height,type;
  int xmin,xmax,ymin,ymax;//current clipping area
  HBITMAP handle;//handle to dibsection
  UCHAR *data; //pointer to buffer data
  UCHAR palette[768];//rgb palette
  BITMAPINFO *bmi;//dib header
} glbuffer;

//global image structure typedef
typedef struct {
  int type,width,height;
  UCHAR *data;
} gl_image_array;

//PCX header structure
typedef struct {
  char manufacturer,version,encoding,bits_per_pixel;
  short xmin,ymin,xmax,ymax;
  short hres,vres;
  char palette[48];
  char reserved;
  char planes;
  short bytes_per_line;
  short palette_type;
  char filler[58];
} PCXHEADER;

//VARIABLES
extern gl_image_array glbmp[MAXIMAGES];//global loaded images array
extern LOGPALETTE *gllogpalette;

//graphics target
extern int glXMIN,glXMAX,glYMIN,glYMAX,glw,glh,glDWw;
extern UCHAR *glPTR;
extern BITMAPINFO *glbmi;

//clipping variables
extern int glx1clip,glx2clip,gly1clip,gly2clip;

//headers
extern PCXHEADER glPCXHead;
extern BITMAPINFO *glBMPinfo;


//FUNCTIONS
int glInit(void);
void glClose(void);

//misc.
int glDWORDwidth(int w);
int glAreaInBuffer(int x1,int y1,int x2,int y2);
int glGetClipInfo(int x,int y,int w,int h);

//buffer
int glCreateBuffer(glbuffer *buff,HDC hdc);
int glKillBuffer(glbuffer *buff);
void glSetTarget(glbuffer *buff);
int glDisplayBuffer(HDC hdc,glbuffer *buff,int dx,int dy);
int glDisplayBufferArea(HDC hdc,glbuffer *buff,int dx,int dy,int dw,int dh,
 int sx,int sy,int sw,int sh);
void glClear(UCHAR col);
HPALETTE glCreateHPALETTE(glbuffer *buff);

//draw
void glPutPixel(UCHAR col,int x,int y);
void glPutPixelClip(UCHAR col,int x,int y);
void glHLine(UCHAR col,int x1,int x2,int y);
int glLine(UCHAR col,int x1,int y1,int x2,int y2);
void glRectangle(UCHAR col,int x,int y,int w,int h);
void glRectangleFilled(UCHAR col,int x,int y,int w,int h);
int glCircle(UCHAR col,int cx,int cy,int diameter);
int glCircleFilled(UCHAR col,int cx,int cy,int diameter);

//images
int glPutImage(int n,int x,int y);
int glPutImageMasked(int n,int x,int y);
int glLoadBMP(char *filename);
int glLoadPCX(char *filename);
void glDeleteImage(int n);
int glLoadBMPPal(char *filename,glbuffer *buff);
int glLoadPCXPal(char *filename,glbuffer *buff);





