/* ----------------------------- MNI Header -----------------------------------
@NAME       : mpeg.h
@INPUT      : 
@OUTPUT     : 
@RETURNS    : 
@DESCRIPTION: Types and function prototypes needed for applications to
              use the Berkely MPEG decoding engine via the MNI front
              end.
@METHOD     : 
@GLOBALS    : Types defined:
                 ImageDesc  - structure giving height, width, etc.
                 DitherEnum - the different dither types supported by
                              the decoding engine
@CALLS      : 
@CREATED    : Greg Ward, 94/6/16.
@MODIFIED   : Greg Ward, 94/9/12 (based on John Cristy's fixes): made
              more amenable to use with other libraries that also
	      happen to define TRUE, FALSE, [Bb]oolean, and added
	      PROTO macro
---------------------------------------------------------------------------- */

#ifndef __MPEG_H
#define __MPEG_H

#include <stdio.h>

/* An attempt at a portable and integrable boolean type... */

#if (!defined(TRUE) || !defined(FALSE))
# define TRUE 1
# define FALSE 0
#endif

#if (!defined (BOOLEAN_TYPE_EXISTS))
typedef unsigned int Boolean;
#endif

typedef struct
{
   int	Height,			/* in pixels */
        Width,
        Depth,			/* image depth (bits) */
        PixelSize,              /* bits actually stored per pixel */
        Size,			/* bytes for whole image */
        BitmapPad;              /* "quantum" of a scanline -- each scanline */
				/* starts on an even interval of this */
                                /* many bits */
} ImageDesc;

typedef enum 
{
   GRAY_DITHER,
   FULL_COLOR_DITHER,
   NO_DITHER,
   ORDERED_DITHER,
} DitherEnum;


typedef enum
{
   MPEG_DITHER,
   MPEG_QUIET,
   MPEG_LUM_RANGE,
   MPEG_CR_RANGE,
   MPEG_CB_RANGE
} MPEGOptionEnum;

/* Kludge so we can compile under ANSI or K&R */

#undef PROTO
#if __STDC__
#define PROTO(formal_parameters) formal_parameters
#else
#define const
#define PROTO(formal_parameters) ()
#endif

/* Function prototypes (all are defined in wrapper.c) */

extern Boolean OpenMPEG(FILE *MPEGfile, ImageDesc *ImgInfo);
void   CloseMPEG (void);
void   RewindMPEG (FILE *MPEGfile, ImageDesc *Image);
void   SetMPEGOption (MPEGOptionEnum Option, int value);
extern Boolean GetMPEGFrame (char *Frame);

#endif   /* __MPEG_H */
