{===============================================================================
File name:              GR-E2P.PAS
Author:                 Isaac Marino Bavaresco
Description:            Writes files to EEPROM memories thru parallel port
                        (requires specific hardware)
Creation date:          10 jan 1996
Last modified:          4 ago 1996
Modified by:            author
===============================================================================}
Uses
   Crt, Dos;
{==============================================================================}
Const
   NOP_WRITE    = 0;
   LD_DATA      = 1;
   LD_ADDR_L    = 2;
   LD_ADDR_H    = 3;
   NOP_READ1    = 4;
   NOP_READ2    = 5;
   READ_DATA    = 6;
   NOP_READ3    = 7;
   WRITE_DATA   = 8;

   DELAY1       = 5;
   DELAY2       = 5;
   DELAY3       = 5;
   DELAY4       = 5;
{==============================================================================}
Procedure WriteByte( Address: Word; Data: Byte; LPTPort: Word );

Var
   AddrHigh, AddrLow: Byte;

Label
   L1, L2, L3, L4, L5, L6, L7, L8, L9;

Begin
AddrHigh := Address Shr 8;
AddrLow  := Address And $ff;
Asm
   cli

   mov  dx,LPTPort

   add  dx,2
   mov  al,LD_ADDR_L
   out  dx,al

   mov  cx,DELAY1
L1:in   al,dx
   loop L1

   sub   dx,2
   mov  al,AddrLow
   out  dx,al

   mov  cx,DELAY1
L2:in   al,dx
   loop L2

   add  dx,2
   mov  al,LD_ADDR_H
   out  dx,al

   mov  cx,DELAY1
L3:in   al,dx
   loop L3

   sub  dx,2
   mov  al,AddrHigh
   out  dx,al

   mov  cx,DELAY1
L4:in   al,dx
   loop L4

   add  dx,2
   mov  al,LD_DATA
   out  dx,al

   mov  cx,DELAY1
L5:in   al,dx
   loop L5

   sub  dx,2
   mov  al,Data
   out  dx,al

   mov  cx,DELAY1
L6:in   al,dx
   loop L6

   add  dx,2

   mov  al,NOP_WRITE
   out  dx,al

   mov  cx,DELAY1
L7:in   al,dx
   loop  L7

   mov  al,WRITE_DATA
   out  dx,al

   mov  cx,DELAY2
L8:in   al,dx
   loop  L8

   mov  al,NOP_WRITE
   out  dx,al

   mov  cx,DELAY1
L9:in   al,dx
   loop  L9

   sti
   End;
End;
{==============================================================================}
Function ReadByte( Address: Word; LPTPort: Word ): Byte;

Var
   AddrHigh, AddrLow, C: Byte;

Label
   L1, L2, L3, L4, L5, L6, L7;

Begin
AddrHigh := Address Shr 8;
AddrLow  := Address And $ff;
Asm
   cli

   mov  dx,LPTPort

   add  dx,2
   mov  al,LD_ADDR_L
   out  dx,al

   mov  cx,DELAY3
L1:in   al,dx
   loop  L1

   sub   dx,2
   mov  al,AddrLow
   out  dx,al

   mov  cx,DELAY3
L2:in   al,dx
   loop  L2

   add   dx,2
   mov  al,LD_ADDR_H
   out  dx,al

   mov  cx,DELAY3
L3:in   al,dx
   loop  L3

   sub   dx,2
   mov  al,AddrHigh
   out  dx,al

   mov  cx,DELAY3
L4:in   al,dx
   loop  L4

   add   dx,2

   mov  al,NOP_READ3
   out  dx,al

   mov  cx,DELAY3
L5:in   al,dx
   loop  L5

   mov  al,READ_DATA
   out  dx,al

   mov  cx,DELAY4
L6:in   al,dx
   loop  L6

   dec   dx
   in   al,dx
   mov  C,al

   inc  dx
   mov  al,NOP_READ1
   out  dx,al

   mov  cx,DELAY3
L7:in   al,dx
   loop  L7

   sti
   End;

ReadByte := ( C Shl 1 ) And $f0
End;
{==============================================================================}
Function Verify( Address: Word; Data: Byte; LPTPort: Word ): Boolean;

Begin
Verify := ReadByte( Address, LPTPort ) = Data And $f0;
End;
{==============================================================================}
{==============================================================================}
Const
   Bars: String = '|/-\';
   LPTPort: Word = $0378;   { Change here if your parallel port resides on }
                            { different address                            }

Type
   TBuffer = Array[0..8192] of Byte;

Var
   I: Word;
   InFile: File of Byte;
   PBuffer: ^TBuffer;
   Size: Word;
   FileName: String;
{==============================================================================}
Begin

WriteLn;
WriteLn( 'GR-E2P v2.0 - Programs EEPROM memories thru parallel port.' );
WriteLn( 'Copyright (c) 1996 Isaac Marino Bavaresco (imb@etfgo.br).' );
WriteLn;

If ParamCount > 1
Then
   Begin
   WriteLn( 'Error: Excessive number of parameters.' );
   Halt( 1 );
   End
Else
   If ParamCount = 1
   Then
      FileName := ParamStr( 1 )
   Else
      Begin
      Write( 'Enter name of file to write: ' );
      ReadLn( FileName );
      End;

If FileName = ''
Then
   Begin
   WriteLn( 'It''s necessary to supply a file name.' );
   Halt( 1 );
   End;

FileName := FExpand( FileName );

Assign( InFile, FileName );
Reset( InFile );
If IOResult <> 0
Then
   Begin
   WriteLn( 'Error opening file ', FileName );
   Halt( 1 );
   End;

Size := FileSize( InFile );
If  Size > 32768
Then
   Begin
   WriteLn( 'File too big. Maximum size 32Kb' );
   Close( InFile );
   Halt( 1 );
   End;

If  Size = 0
Then
   Begin
   WriteLn( 'File empty, no data to write' );
   Close( InFile );
   Halt( 1 );
   End;

If MaxAvail < Size
Then
   Begin
   WriteLn( 'Insufficient memory.' );
   Close( InFile );
   Halt( 1 );
   End;

GetMem( PBuffer, Size );

I := 0;
While ( Not Eof( InFile ) ) And ( IOResult = 0 ) And ( I < Size ) do
   Begin
   Read( InFile, PBuffer^[I] );
   Inc( I );
   End;
If IOResult <> 0
Then
   Begin
   WriteLn( 'Error reading file.' );
   Close( InFile );
   Dispose( PBuffer );
   Halt( 1 );
   End;

Close( InFile );

WriteLn;
WriteLn( 'Writing file, ESC interrupts...' );

Port[$027a] := NOP_WRITE;

For I := 0 to Size - 1 do
   Begin
   Write( #13, Bars[(I And 3)+1] );
   WriteByte( I, PBuffer^[I], LPTPort );
   While Not Verify( I, PBuffer^[I], LPTPort ) do
      If Keypressed
      Then
         If readKey = #27
         Then
            Begin
            WriteLn;
            WriteLn;
            WriteLn( 'Aborted by user.' );
            Dispose( PBuffer );
            Halt( 2 );
            End;
   End;

Dispose( PBuffer );

WriteLn;

End.
{==============================================================================}