#include "cell.h"

#define ZOOM0	3	/* 3x3 pixels per cell		*/
#define ZOOM1	6	/* 6x6 pixels per cell		*/
#define ZOOM2	10	/* 10x10 pixels per cell	*/
#define ZOOM3	18	/* 18x18 pixels per cell	*/

/*
** the templates assume the pixels on your screen have a 1:1 aspect ratio. for
** almost all screens, this is not true. therefore, the screen view will be
** slightly distorted (things will look like they are stretched top to bottom,
** or squashed side to side). if you really want things to look like reality,
** you could change the dimensions of the templates. for example, if your
** screen has a 2:1 aspect ratio (most are more like 1.4:1), use a [3][6]
** template instead of a [3][3] one. as long as you keep this in mind while
** viewing the results, it's probably not worth the effort.
*/

struct x { /* group the bit templates for an object */
	long t;			/* the object type	*/
	char t0[ZOOM0][ZOOM0];	/* tiny zoom template	*/
	char t1[ZOOM1][ZOOM1];	/* small zoom template	*/
	char t2[ZOOM2][ZOOM2];	/* medium zoom template	*/
	char t3[ZOOM3][ZOOM3];	/* large zoom template	*/
	};

/* these got too big to keep in one file, so i moved them to include files */

struct x y1[] = { /* hole templates */
#include "bitmap1.h"
	};

int z1 = sizeof(y1)/sizeof(y1[0]); /* number of hole types */
