#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "cell.h"

struct work { /* a unit of work is a hole-pair to connect */
	int FromRow;		/* source row		*/
	int FromCol;		/* source column	*/
	char far *FromName;	/* source name		*/
	int ToRow;		/* target row		*/
	int ToCol;		/* target column	*/
	char far *ToName;	/* target name		*/
	int ApxDist;		/* approximate distance	*/
	int Priority;		/* 0=no, 1=yes		*/
	struct work far *Next;
	};

/* pointers to the first and last item of work to do */
static struct work far *Head = NULL;
static struct work far *Tail = NULL;
static struct work far *Current = NULL;

extern int SortConnects; /* 0 = don't sort, 1 = sort */

extern int GetApxDist( int, int, int, int );
extern void Nomem( void );

void InitWork( void );
void ReInitWork( void );
void SetWork( int, int, char far *, int, int, char far *, int );
void GetWork( int *, int *, char far * far *, int *, int *, char far * far * );
void SortWork( void );

void InitWork () { /* initialize the work list */
	struct work far *p;

	while (p = Head) {
		Head = p->Next;
		_ffree( p );
		}
	Tail = Current = NULL;
	}

void ReInitWork () { /* initialize the work list */
	Current = Head;
	}

void SetWork ( r1, c1, n1, r2, c2, n2, pri )
	/* add a unit of work to the work list */
	int r1, c1, r2, c2, pri;
	char far *n1;
	char far *n2;
	{
	struct work far *p;

	if (p = (struct work far *)_fmalloc( sizeof(struct work) )) {
		p->FromRow = r1;
		p->FromCol = c1;
		p->FromName = n1;
		p->ToRow = r2;
		p->ToCol = c2;
		p->ToName = n2;
		p->ApxDist = SortConnects ? GetApxDist( r1, c1, r2, c2 ) : 0;
		p->Priority = pri;
		p->Next = NULL;
		if (Head) /* attach at end */
			Tail->Next = p;
		else /* first in list */
			Head = Current = p;
		Tail = p;
		}
	else /* can't get any more memory */
		Nomem();
	}

void GetWork ( r1, c1, n1, r2, c2, n2 )
	/* fetch a unit of work from the work list */
	int *r1, *c1, *r2, *c2;
	char far * far *n1;
	char far * far *n2;
	{
	if (Current) {
		*r1 = Current->FromRow;
		*c1 = Current->FromCol;
		*n1 = Current->FromName;
		*r2 = Current->ToRow;
		*c2 = Current->ToCol;
		*n2 = Current->ToName;
		Current = Current->Next;
		}
	else { /* none left */
		*r1 = *c1 = *r2 = *c2 = ILLEGAL;
		*n1 = *n2 = NULL;
		}
	}

void SortWork () { /* order the work items; shortest first */
	struct work far *p;
	struct work far *q0; /* put PRIORITY CONNECTs in q0 */
	struct work far *q1; /* sort other CONNECTs in q1 */
	struct work far *r;

	q0 = q1 = NULL;
	while (p = Head) { /* prioritize each work item */
		Head = Head->Next;
		if (p->Priority) { /* put at end of priority list */
			p->Next = NULL;
			if (!(r = q0)) /* empty list? */
				q0 = p;
			else { /* attach at end */
				while (r->Next) /* search for end */
					r = r->Next;
				r->Next = p; /* attach */
				}
			}
		else if (!(r = q1) || p->ApxDist < q1->ApxDist) {
			p->Next = q1;
			q1 = p;
			}
		else { /* find proper position in list */
			while (r->Next && p->ApxDist >= r->Next->ApxDist)
				r = r->Next;
			p->Next = r->Next;
			r->Next = p;
			}
		}
	if (p = q0) { /* any priority CONNECTs? */
		while (q0->Next)
			q0 = q0->Next;
		q0->Next = q1;
		}
	else
		p = q1;
	/* reposition Head and Tail */
	for (Head = Current = Tail = p; Tail && Tail->Next; Tail = Tail->Next)
		;
	}
