(*| 23:26 13/03/1997 *)
PROGRAM GoWin95;

USES
  Crt,Dos;

CONST
  LoPart = 0;
  HiPart = 3;
  BufferSize = 512;
  Dosi_Disk = $13;
  Ascii : ARRAY[0..15] OF CHAR = '0123456789ABCDEF';

TYPE
  TByteRec = ARRAY[0..BufferSize-1] OF BYTE;
  TPartInfo = RECORD
    Bootable : BYTE;
    HdStart  : BYTE;
    SecStart : BYTE;
    CylStart : BYTE;
    SysID    : BYTE;
    HdEnd    : BYTE;
    SecEnd   : BYTE;
    CylEnd   : BYTE;
    FirstSec : LongInt;
    SecCount : LongInt;
  END;
  TPartRec = RECORD
    PartCode : ARRAY[0..$1BD] OF BYTE;
    PartInfo : ARRAY[LoPart..HiPart] OF TPartInfo;
    PartSig  : ARRAY[0..1] OF BYTE;
  END;
  PRecClass = (ByteClass,PartClass);
  TPartBuffer = RECORD
    CASE PRecClass OF
      ByteClass : (ByteRec : TByteRec);
      PartClass : (PartRec : TPartRec);
    END;

VAR
  PartBuffer: TPartBuffer;
  F: File;
  NumRead: INTEGER;

FUNCTION AsciiByte(B: BYTE): String;
BEGIN
  AsciiByte := Ascii[(B SHR 4) AND $0F] + Ascii[B AND $0F];
END;

FUNCTION AsciiWord(W: WORD): String;
BEGIN
  AsciiWord := Ascii[(W SHR 12) AND $0F] + Ascii[(W SHR 8) AND $0F] +
               Ascii[(W SHR 4) AND $0F] + Ascii[W AND $0F];
END;

FUNCTION AsciiLongInt(LI: LongInt): String;
VAR
  MSB : LongInt;
BEGIN
  MSB := (LI SHR 16) AND $0000FFFF;
  AsciiLongInt := AsciiWord(MSB) + AsciiWord(LI AND $00FFFF);
END;

PROCEDURE FlushBuffers;
VAR
  I: INTEGER;
BEGIN
  FillChar(PartBuffer, BufferSize, #0);
END;

FUNCTION ResetHard: Boolean;
VAR
  Regs: Registers;
BEGIN
  WITH Regs DO BEGIN
    AX := $0000;              { Reset }
    DX := $0080;              { Drive Num = C: }
    BX := Ofs(PartBuffer);
    ES := Seg(PartBuffer);
    INTR(Dosi_Disk, Regs);
    ResetHard := ((Flags AND FCarry) = 0);
  END;
END;  { ResetHard }

PROCEDURE WriteToHard(Track,Sector,Head: Byte);
VAR
  Regs: Registers;
  Sig1,Sig2: Byte;
BEGIN
  WITH Regs DO BEGIN
    AX := $0301;              { Write, Num of Sectors }
    CH := Track;              { Track Num }
    CL := Sector;             { Sector Num }
    DH := Head;               { Head Num }
    DL := $80;                { Drive Num = C: }
    BX := Ofs(PartBuffer);
    ES := Seg(PartBuffer);
    Sig1 := PartBuffer.ByteRec[$1FE];
    Sig2 := PartBuffer.ByteRec[$1FF];
  END;
  IF (Sig1 <> $55) AND (Sig2 <> $AA) THEN
    Writeln('Invalid Signature')
  ELSE
  INTR(Dosi_Disk, Regs);
END;  { WriteToHard }

FUNCTION ReadFromHard(Track,Sector,Head: Byte): Boolean;
CONST
  MaxRetry = 3;
VAR
  Regs: Registers;
  Ok: Boolean;
  Retry: Integer;
BEGIN
  Retry := 0;
  WITH Regs DO REPEAT
    INC(Retry);
    AX := $0201;              { Read, Num of Sectors }
    CH := Track;              { Track Num }
    CL := Sector;             { Sector Num }
    DH := Head;               { Head Num }
    DL := $80;                { Drive Num = C: }
    BX := Ofs(PartBuffer);
    ES := Seg(PartBuffer);
    INTR(Dosi_Disk, Regs);
    Ok := ((Flags AND FCarry) = 0);
  UNTIL (Ok OR (Retry >= MaxRetry));
  ReadFromHard := Ok;
END;  { ReadFromHard }

PROCEDURE WriteHardError;
BEGIN
  Writeln('Error on drive C:')
END;  { WriteHardError }

PROCEDURE WriteFile(FileName: String);
VAR
  I: Integer;
BEGIN
  Assign(F,FileName);
  Rewrite(F,1);
  BlockWrite(F, PartBuffer, BufferSize);
  Close(F);
END;  { WriteFile }

PROCEDURE WriteToFile;
VAR
  FName: String;
BEGIN
  Write('Save to file. Filename : ');
  Readln(FName);
  IF Length(FName) > 0 THEN
    WriteFile(FName);
END;

PROCEDURE ShowBufferData;
VAR
  I, J, K: INTEGER;
BEGIN
  I := $0;
  FOR J := 1 TO 22 DO BEGIN
    Write(AsciiWord(I),': ');
    FOR K := 1 TO 24 DO BEGIN
      IF I < $200 THEN
        Write(AsciiByte(PartBuffer.ByteRec[I]),' ');
      INC(I);
    END;
    Writeln;
  END;
END;

PROCEDURE ShowPartInfo;
VAR
  I, J, K: INTEGER;
  B: Byte;
  ThisPart: TPartInfo;
BEGIN
  Writeln('           Hd Sec Cyl   Hd Sec Cyl   First      Count    MB');
  FOR I := LoPart TO HiPart DO BEGIN
    ThisPart := PartBuffer.PartRec.PartInfo[I];
    Write(I+1,': ');
    WITH ThisPart DO BEGIN
      Write(AsciiByte(Bootable),' ');
      Write(AsciiByte(SysID),' ');
      Write(' ', HdStart:3, ' ', SecStart AND $3F:2, ' ',
             ((SecStart AND $C0) SHL 2) + CylStart:4, ' ');
      Write(' ', HdEnd:3, ' ', SecEnd AND $3F:2, ' ',
             ((SecEnd AND $C0) SHL 2) +  CylEnd:4, ' ');
      Write(AsciiLongInt(FirstSec), '  ', SecCount:8);
      Write('  ',SecCount SHR 11:4);
    END;
    Writeln;
  END;
END;  { ShowPartInfo }

PROCEDURE Title;
BEGIN
  Writeln('Modify Partition Sector, by B Whitnall, v1.0');
END;  { Title }

PROCEDURE ChangeBoot(NewBoot: Integer);
VAR
  I: Integer;
BEGIN
  IF (NewBoot >= LoPart) AND (NewBoot <= HiPart) THEN BEGIN
    FOR I:= LoPart TO HiPart DO
      PartBuffer.PartRec.PartInfo[I].Bootable := 0;
    PartBuffer.PartRec.PartInfo[NewBoot].Bootable := $80;
  END;
END;  { ChangeBoot }

PROCEDURE Reboot;
BEGIN
  INLINE($EA/$F0/$FF/$00/$F0);  { jmp F000:FFF0 }
END;  { ReBoot }

PROCEDURE Command;
VAR
  C: CHAR;
BEGIN
  Window(1,1,80,25);
  ClrScr;
  Title;
  GotoXY(1,25);
  Write('Commands: Quit Part 0 Flush Reload Write to file Modify 1 2 Update disk');
  Window(1,2,80,24);
  ShowPartInfo;
  REPEAT
    C := UpCase(ReadKey);
    IF C = #0 THEN BEGIN
      C := ReadKey;
      C := '?';
    END;
    ClrScr;
    CASE C OF
      #$0D : BEGIN
               ShowPartInfo;
             END;
      'P'  : ShowPartInfo;
      'W'  : WriteToFile;
      'U'  : WriteToHard(0,1,0);
      'M'  : ChangeBoot(LoPart);
      'F'  : FlushBuffers;
      'R'  : IF ReadFromHard(0,1,0) THEN ;
      '0'  : ShowBufferData;
      '1'  : ChangeBoot(LoPart);
      '2'  : ChangeBoot(LoPart+1);
      #$1B : C := 'Q';
    ELSE
      Write('Command ',C,' unknown');
    END;
  UNTIL C = 'Q';
  Window(1,1,80,25);
  ClrScr;
END;  { Command }

PROCEDURE AutoChange(NewBootPart: Integer);
BEGIN
  Window(1,1,80,25);
  ClrScr;
  Title;
  ShowPartInfo;
  Writeln('Dos version is : ',Lo(DosVersion),'.',Hi(DosVersion));
  IF ((Lo(DosVersion) > 6) AND (NewBootPart = LoPart)) THEN
    Writeln('Already in Windows 95.  Aborting')
  ELSE IF ((Lo(DosVersion) < 7) AND (NewBootPart > LoPart)) THEN
    Writeln('Already in MS-DOS.  Aborting')
  ELSE BEGIN
    ChangeBoot(NewBootPart);
    WriteToHard(0,1,0);
    FlushBuffers;
    IF NOT ReadFromHard(0,1,0) THEN
      WriteHardError
    ELSE BEGIN
      ShowPartInfo;
      IF PartBuffer.PartRec.PartInfo[NewBootPart].Bootable <> $80 THEN
        Writeln('Chosen Partition Not Made Bootable')
      ELSE BEGIN
        Writeln('About to reboot to Chosen Partition. Press <ESC> to abort');
        IF ReadKey <> #$1B THEN
          ReBoot;
      END;
    END;
  END;
END;  { AutoChange }

BEGIN
  FlushBuffers;
  Title;
  IF ParamCount > 0 THEN BEGIN
  END;
  IF NOT ResetHard THEN
    WriteHardError
  ELSE BEGIN
    IF NOT ReadFromHard(0,1,0) THEN
      WriteHardError
    ELSE BEGIN
      IF ParamCount = 1 THEN
        IF ParamStr(1) = '2' THEN
          AutoChange(LoPart+1)
        ELSE
          Command
      ELSE BEGIN
        AutoChange(LoPart);
      END;
    END;
  END;
END.
