Article 785 of alt.sys.pdp8:
Path: news.umbc.edu!europa.eng.gtefsd.com!howland.reston.ans.net!math.ohio-state.edu!hobbes.physics.uiowa.edu!news.uiowa.edu!news
From: jones@cs.uiowa.edu (Douglas W. Jones)
Newsgroups: alt.sys.pdp8,alt.answers,news.answers
Subject: PDP-8 Summary of Models and Options (posted every other month)
Followup-To: alt.sys.pdp8
Date: Tue, 8 Aug 94 08:08:08 GMT
Organization: Computer Science, University of Iowa, Iowa City, Iowa, USA
Lines: 1317
Approved: news-answers-request@MIT.Edu
Distribution: world
Expires: 8 Oct 1994 08:08:08 GMT
Message-ID: <325b0v$2ke@nexus.uiowa.edu>
NNTP-Posting-Host: herky.cs.uiowa.edu
Summary: Descriptions of all models of the DEC PDP-8 computer.
	Those posting to alt.sys.pdp8 should read this.
Keywords: FAQ DEC PDP 8
Xref: news.umbc.edu alt.sys.pdp8:785 alt.answers:3891 news.answers:26584

Archive-name: dec-faq/pdp8-models
Last-modified: Aug 5, 1994

Frequently Asked Questions about DEC PDP-8 models and options.

	By Douglas Jones, jones@cs.uiowa.edu
	(with help from many folks)

Sites known to carry FTPable copies of this file:

	ftp://rtfm.mit.edu/pub/usenet/alt.sys.pdp8
        ftp://ftp.uu.net/usenet/news.answers/dec-faq
	ftp://src.doc.ic.ac.uk:/pub/usenet/news.answers/alt.sys.pdp8
	ftp://sunsite.unc.edu/pub/academic/computer-science/history/pdp-8/docs

Automatic translations of this document to HTML format (as used by World Wide
Web) are available from:

        http://www.cis.ohio-state.edu/hypertext/faq/usenet/dec-faq/top.html

This posting conforms to RFC1153 USENET digest format (with exceptions due
to the fact that it is not really a digest).

The purpose of this document is to supplement the material in the primary
"Frequently Asked Questions about the PDP-8" file with more detailed
information about the hardware and options of the different models of the
PDP-8 sold by DEC.

Although this document is something of a history of the DEC PDP-8 family,
the primary purpose of this document is as a guide and general outline to
the PDP-8 models and options likely to be encountered by those involved
in collecting and restoring such systems.

Contents:

	What is a PDP-5?
	What is a PDP-8?
	What is a LINC-8?
	What is a PDP-8/S?
	What is a PDP-8/I?
	What is a PDP-8/L?
	What is a PDP-12?
	What is a PDP-8/E?
	What is a PDP-8/F?
	What is a PDP-8/M?
	What is a PDP-8/A?
	What is a VT78?
	What is a DECmate I?
	What is a DECmate II?
	What is a DECmate III?
	What is a DECmate III+?

----------------------------------------------------------------------

Subject: What is a PDP-5?

Date of introduction:  Aug 11, 1963, unveiled at WESCON.
Date of withdrawal:    early 1967.
Total production run:  116.
Price: $27,000

Technology:  The PDP-5 was built with DEC System Modules, the original
	line of transistorized logic modules sold by DEC.  The supply
	voltages were +10 and -15 volts, with logic levels of -3 (logic 1)
	and 0 (logic 0).  Logic was packaged on boards that were about
	4.75 inches high with each card mounted in a metal frame with a
	22 pin edge connector.

	Input output devices were connected to the daisy-chained I/O bus
	using military-style armored cables and connectors.  Use of
	toggle switches (as opposed to slide switches) on the front
	panel was another vestige of military-style design.

Reason for introduction:  This machine was inspired by the success of
	the CDC-160, Seymour Cray's 12 bit minicomputer, and by the
	success of the LINC, a machine that was built by DEC customers
	out of System modules.  These demonstrated that there was a
	market for a small inexpensive computer, and from the start,
	DEC's advertisements were aimed at this market.  "Now you can
	own the PDP-5 computer for what a core memory alone used to
	cost: $27,000", ran one 1964 ad.

Reason for withdrawal:  The PDP-8 outperformed the PDP-5, and did so for
	a lower price.

Compatability:  The core of the PDP-8 instruction set is present, but
	memory location zero is the program counter, and interrupts are
	handled differently.  The Group 1 OPR rotate instructions cannot
	be combined with IAC or CMA; this limits the ability of the
	PDP-5 to support code from later models.

The machine does not support 3 cycle data-break (DMA transfers using
	memory to hold buffer address and word-count information), so
	many later PDP-8 peripherals can not be used on the PDP-5.  In
	addition, DMA transfers are not allowed outside the program's
	current 4K data field, severely limiting software compatability
	on systems with over 4K of memory where either interrupts or
	software initiated changes to the data field during a transfer
	would cause chaos.

Standard configuration:  CPU with 1K or 4K of memory (2K and 3K versions
	were not available).

Peripherals:
	An extended arithmetic element (EAE) was available; this was an
	I/O device, using IOT instructions to evoke EAE operations.  As
	a result, it was not compatable with the later PDP-8 EAEs.  In
	addition, machines with the EAE option had a different front
	panel from those without.

	The type 552 DECtape control and type 555 dual DECtape transports
	were originally developed for the PDP-5 and contemporaneous DEC
	systems such as the PDP-6.

	After the PDP-8 was introduced, DEC offered a bus converter that
	allowed the PDP-5 to support standard PDP-8 negibus ueripherals,
	so long as they avoided using 3-cycle data break transfers.  The
	standard 804 PDP-8 expander box was frequently sold as an
	upgrade to PDP-5 systems.

Survival:  Do any PDP-5 systems survive?

------------------------------

Subject: What is a PDP-8?

Date of introduction:  1965 (Unveiled March 22, in New York).
Date of withdrawal:    1968.
Total production run:  1450.
Also known as:
	Classic PDP-8 (to point out lack of a model suffix)
	Straight-8 (Again, points out the lack of a model suffix)
	PCP-88, an OEM label, used by Foxboro Corporation.
Price: $18500

Technology:  Mostly standard DEC R-series logic modules; these were
	originally discrete component transistor logic, but around the
	time the PDP-8 was introduced, DEC introduced the Flip Chip, a
	hybrid diode/resistor "integrated circuit" on a ceramic substrate.
	These could directly replace some of the discrete components on
	some logic modules, and DEC soon began to refer to all R-series
	modules as flip-chip modules; they even advertised the PDP-8 as
	an integrated circuit computer.  A typical flip-chip module, the
	R111, had three 2-input nand gates and cost $14, with no price
	change from 1965 to 1970.  Some special dual height R-series
	modules were designed specifically for the PDP-8.

	S and B-series logic modules were also used; these are similar
	to their R-series cousins, but with different speed/fanout
	tradeoffs in their design.  Some logic modules have trimmers
	that must be tuned to the context, making replacement of such
	modules more complex than simply swapping boards.

	As with the system modules used in the PDP-5, the supply
	voltages were +10 and -15 volts and the logic levels were -3
	(logic 1) and 0 (logic 0).  Logic was packaged on boards that
	were 2.5 inches wide by 5 inches long.  The card edge connector
	had 18 contacts on 1/8 inch centers.  Some double height cards
	were used; these had two card edge connectors and were 5 1/8
	inches high.  Machine wrapped wire-wrap technology was used on
	the backplane using 24-gauge wire.

	The "negibus" or negative logic I/O bus used -3 and 0 volt logic
	levels in 92 ohm coaxial cable, with 9 coaxial cables bundled
	per connector card and 6 bundles making up the basic bus.  5
	(later 4) more bundles were required to support data-break (DMA)
	transfers.  The total bus length was limited to 50 feet, and bus
	termination was generally kluged in with 100 ohm resistors
	clipped or wrapped into the backplane, although a bus terminator
	card was sometimes used.  Some time after the first year of
	production, flat ribbon cable made of multiple coaxial cables
	was used, and later still, shielded flat stripline cable was used
	(but this cut the allowed bus length by a factor of two).

	Core memory was used, originally made by FERROXCUBE, with a 1.5
	microsecond cycle time, giving the machine an add time of 3
	microseconds.  4K of core occupied an aluminum box 6 inches on a
	side and needed numerous auxiliary flip-chips and for support,
	as well as an array of boards from the core vendor.  It is worth
	noting that the PDP-8 was about as fast as was practical with the
	logic technology used; only by using tricks like memory
	interleaving or pipelining could the machine have been made much
	faster.

Reason for introduction:  This machine was inspired by the success of
	the PDP-5 and by the realization that, with their new Flip-Chip
	technology, DEC could make a table-top computer that could be
	powered by a single standard wall outlet; of course, adding any
	peripherals quickly increased the power requirement!

Reason for withdrawal:  The PDP-8/I was less expensive, and after
	initial production difficulties, it equalled the performance of
	the PDP-8.

Compatability:  This machine defines the core of the PDP-8 instruction
	set, but with restrictions that were lifted on later machines.
	The Group 1 OPR instruction IAC cannot be combined with any of
	the rotate instructions.  If RAR and RAL or RTR and RTL are
	combined, the results are unpredictable (simultaneous set and
	reset of bits of AC results in metastable behavior).  The IOT 0
	instruction was used for the internal type 189 ADC, and not for
	the later CAF (clear all flags) instruction.  As a result, if
	the ADC option was not present, IOT 6004 (or microcoded
	variants) would hang the machine.

	The SWP instruction (exchange AC and MQ) never works, even if
	the extended arithmetic element is present.  This works on later
	models when the EAE is present, although it was only documented
	with the introduction of the PDP-8/E.  Finally, the EAE lacks
	the SCL (shift count load) instruction that is present on later
	models.

	On machines with 8K or more, an attempt to change the data field
	to a non-existant field caused a bizarre double-indirect and
	skip instruction execution that must be accounted for in memory
	diagnostics.

Standard configuration:  The PDP-8 was sold as a CPU with 4K of memory,
	a 110 baud current loop teletype interface and an ASR 33 Teletype.
	In addition, the standard in-cabinet logic includes support for
	the full negibus interface, including data-break (DMA) transfers.

	Both a rack-mount model with rosewood trim and an elegant
	plexiglass enclosed table-top configuration were standard.  Under
	the skin, the basic machine occupies a volume 33 inches high by
	19 inches wide by 22 inches deep.  The two halves of the backplane
	are mounted vertically, like the covers of a book, with the
	spine in back and circuit modules inserted from the two sides.
	Sliding the CPU out of the relay rack or removing the plexiglass
	covers allows the backplane to swung open to access the wires-wrap.

Expandability:  In-cabinet options include the type 182 extended
	arithmetic element (EAE), the type 183 memory extension control
	subsystem, and the type 189 low performance analog to digital
	converter (ADC).  Prewired backplane slots were reserved for
	all of these.

	Expansion beyond 4K of memory requires rack space for the
	rack-mounted type 184 memory module; each such module adds one
	4K field of memory, up to a maximum of 32K.  The rack-mount CPU
	occupied a large part of one rack, allowing room for a single
	type 184 memory expansion module below the CPU; generally, a
	second rack was needed for added peripherals or memory.

	At the end of the production run, some PDP-8 systems were sold
	with PDP-8/I memory, allowing room for an additional 4K without
	need for an expansion chassis.  These nonstandard machines were
	very difficult to maintain!

Peripherals:  At the time of introduction, the following negibus
	peripherals were offered.

	-- Type 750C high speed paper tape reader and control.
	-- Type 75E high speed paper tape punch and control.
	-- Type 138E analog to digital converter.
	-- Type 139E analog multiplexor.
	-- Type 34D oscilloscope display control (dual digital to analog).
	-- Type 350B incremental (CalComp) plotter control.
	-- Type 451 card reader and control.
	-- Type 450 card punch control for IBM Type 523 punch.
	-- Type 64 (later 645) Mohawk line printer and control.
	-- Type RM08 serial magnetic drum system (up to 256K words).
	-- Type 552 DECtape control (for type 555 DECtape drives).
	-- Type 57A magnetic tape control (IBM type 729 drive).
	-- Type 580 magnetic tape system.

	By 1966, the following peripherals had been added to the line:

	-- Type AA01A three-channel digital to analog converter.
	-- Type CR01C card reader control.
	-- Type TC01 DECtape control for up to 8 TU55 transports.
	-- Type 251 drum (8-256 tracks, 8 sectors/track, 128 words/sector).
	-- Type 645 line printer control.
	-- Type 680 data communications system (allows 64 teletypes).

	By 1967, the following peripherals had been added to the line:

	-- Type AF01 analog to digital converter and multiplexor.
	-- Type AX08 parallel digital input port.
	-- Type 338 Programmed Buffered Display (vector graphics).

	By 1968, the following new peripheral had been added:

	-- Type DF32 fixed head disk system (32K to 256K words).
	-- Type BE01 OEM version of the TC01 (no blinking lights).
	-- Type BE03 dual TU55 drive for the TC01 or BE01.

	Finally, as DEC abandoned the negibus, they introduced the
	DW08B negibus to posibus converter so newer posibus
	peripherals could be used on older negibus machines, and the
	DW08A posibus to negibus converter to allow use of old
	peripherals on new machines.

Survival:  Many classic PDP-8 systems survive to this day

------------------------------

Subject: What is a LINC-8?

Date of introduction:  1966 (during or before March).
Date of withdrawal:    1969
Total production run:  142.
Price: $38,500

Technology:  DEC Flip Chip modules, as in the PDP-8, with a LINC CPU
	partially reimplemented in Flip Chips and partially emulated
	with PDP-8 instructions.  (The original LINC was built from
	the same System Modules used in the PDP-5.)

Compatability:  The PDP-8 part of the machine was identical to the PDP-8.

Reason for withdrawal:  The PDP-12 accomplished the same goals at a lower
	cost.

Standard configuration:  The combined PDP-8/LINC CPU, plus 4K of memory
	was central to the system.  The set of peripherals bundled with
	the machine was impressive:

	-- An ASR 33 Teletype modified for the LINC character set.
	-- Two LINCtape drives.
	-- 8 analog to digital converter channels with knob inputs.
	-- Another 8 ADC channels with jack inputs.
	-- 6 programmable relay outputs, good up to 60 Hz.
	-- 1 Tektronix 560 oscilliscope, somewhat modified.

	The X and Y axis control for the scope came from DACs attached
	to the LINC's AC and MB registers, respectively.

Expandability:

	In addition to standard PDP-8 peripherals, up to 3 additional
	pairs of LINCtape drives could be added, for a total of 8 drives.
	The design of the type 555 dual DECtape transport was based on
	that of the LINCtape drive.

	Up to 2 additional ranks of 8 ADC channels could be added.

	Remote oscilliscope could be added.

Survival:  One LINC-8 is known to be in operable condition today.

------------------------------

Subject: What is a PDP-8/S?

Date of introduction:  1966 (Unveiled, Aug 23, WESCON, Los Angeles).
Date of withdrawal:    1970.
Total production run:  1024.
Price: $10,000

Technology:  DEC Flip Chip modules and core memory, as in the PDP-8.
	Unlike the PDP-8, the PDP-8/S memory module was mounted between
	a pair of quad-height single-width boards that plugged into the
	standard flip-chip sockets (this was sold separately as the H201
	core memory unit, at $2000 for 4K by 13 bits).

Reason for introduction:  This machine was developed as a successful
	exercise in minimizing the cost of the machine.  It was the
	least expensive general purpose computer made with second
	generation (discrete transistor) technology, and it was one of
	the smallest such machines to be mass produced (a number of
	smaller machines were made for aerospace applications).  It was
	also incredibly slow, with a 36 microsecond add time, and some
	instructions taking as much as 78 microseconds.  By 1967, DEC
	took the then unusual step of offering this machine for off the
	shelf delivery, with one machine stocked in each field office
	available for retail sale.

Reason for withdrawal:  The PDP-8/L vastly outperformed the PDP-8/S, and
	and it did so at a lower price.

Compatability:  The core of the PDP-8 instruction set is present, but
	there are a sufficient number of incompatabilities that, as with
	the PDP-5, many otherwise portable "family of 8" programs will
	not run on the PDP-8/S.  Perhaps the worst incompatability is
	that the Group 1 OPR instruction CMA cannot be combined with any
	of the rotate instructions; as with the PDP-8, IAC also cannot
	be combined with rotate.

Standard configuration:  CPU with 4K of memory, plus PT08 110 baud current
	loop teletype interface and teletype.  Both a rack-mount and
	table-top versions were sold (both 9" high by 19" wide by 20"?
	deep).  The rack mount version included slides so it could be
	pulled out for maintenance.

Expandability:  The CPU supported the standard PDP-8 negibus, but I/O
	bandwidth was 1/5 that of the PDP-8.  Thus, most, but not all
	PDP-8 peripherals could be used.  A few DEC peripherals such as
	the DF32 came with special options such as interleaving to slow
	them down for compatability with the PDP-8/S.  The speed problems
	were such that there was never any way to attach DECtape to this
	machine.

Survival:  Because they were so slow, PDP-8/S systems were quickly
	discarded as newer machines became available for comparable prices;
	thus, they are less common today than the Classic PDP-8, even
	though comparable numbers were made.  A few survive in working
	condition.

------------------------------

Subject: What is a PDP-8/I?

Date of introduction:  1968 (announced before December '67)
Date of withdrawal:    1971.
Total production run:  3698.

Technology:  DEC M-series logic modules, called M-series flip-chips
	as the term flip-chip was applied to the module format instead
	of to DEC's hybrid integrated circuits.  M-series modules used
	TTL chips, with a +5 volt supply, packaged on the same board
	format used with the original flip-chips, but with double-sided
	card-edge connectors (36 contacts instead of 18).  Modules were
	limited to typically 4 SSI ICs each.  The M113, a typical
	M-series module, had 10 2-input nand gates and cost $23 in 1967
	(the price fell to $18 in 1970).  Wire-wrapped backplanes used
	30-gauge wire.

	The PDP-8/I, as originally sold, supported the then-standard
	PDP-8 negibus.  4K words of core were packaged in a 1 inch thick
	module made of 5 rigidly connected 5 by 5 inch two-sided printed
	circuit boards.  Connectors and support electronics occupied an
	additional 32 backplane slots.

	Nominally, the core memory (which, curiously, used a negative
	logic interface!) was supposed to run at a 1.5 microsecond cycle
	time, but many early PDP-8/I systems were delivered running at a
	slower rate because of memory quality problems.  DEC went through
	many vendors in the search for good memory!  The memory interface
	was asynchronous, allowing the CPU to delay for slow memory.  DEC
	continued to make the classic PDP-8 until the problems with
	memory speed were solved.

Reason for introduction:  This machine was developed in response to the
	introduction of DIP component packaging of TTL integrated
	circuits.  This allowed a machine of about the same performance
	as the original PDP-8 to fit in about half the volume and sell
	for a lower price.

Reason for withdrawal:  The PDP-8/E made slight performance improvements
	while undercutting the price of the PDP-8/I.

Compatability:  The core of the PDP-8 instruction set is present, and
	unlike the original PDP-8, IAC can be combined with rotate in a
	single microcoded Group 1 OPR instruction.  Combined RAR and RAL
	or RTR and RTL produce the logical and of the expected results
	from each of the combined shifts.

	If the extended arithmetic element is present, the SWP (exchange
	AC and MQ) instruction works, but this was not documented.

	On large memory configurations, memory fetches from a nonexistant
	memory field take about 30 microseconds (waiting for a bus
	timeout) and then they return either 0000 or 7777 depending on
	the memory configuration and the field that was addressed.

	A front panel bug prevented continue after load-address without
	first clearing the machine.

Standard configuration:  CPU with 4K of memory, plus 110 baud current
	loop teletype interface.  Pedestal, table-top and rack-mount
	versions were made.  The pedestal mounted version was futuristic
	looking; the table-top version split the pedistal, with the CPU
        on the table and the power supply (the base of the pedistal) on
	the floor beside the table.  The standard rack-mounted version
	had the power supply bolted to the right side of the rack while
	the CPU, mounted on slides, slid out of the left side of the rack.

Expandability: 4K of memory could be added internally, and additional
	memory could be added externally using a rack-mounted MM8I memory
	expansion module for each 4K or 8K addition over 8K.

	The backplane of the PDP-8/I was prewired to hold a Calcomp
	plotter interface, with the adjacent backplane slot reserved
	for the cable connection to the plotter.  There may be other
	built-in options.

	Initially, the CPU was sold with bus drivers for the PDP-8
	negibus, allowing this machine to support all older DEC
	peripherals, but later machines were sold with posibus interfaces,
	and many older machines were converted in the field.

	A posibus to negibus converter, the DW08A, allowed use of all
	older PDP-8 peripherals, with small modifications.  The change
	from negibus to posibus during the period of PDP-8/I production
	leads to confusion because surviving CPUs and peripherals may
	have any of three I/O bus configurations: Negibus, early posibus,
	or final posibus.  The early posibus used the same connectors
	and cables as the negibus, with only 9 conductors per connector,
	while the final posibus used both sides of the connector paddles
	for 18 bus lines per connector.  Y-shaped cables for converting
	from one physical bus layout to the other were available.  To
	add to this confusion, some negibus PDP-8/I systems were rewired
	to use 18 conductor posibus cables with negative logic!

	Eventually, an add-on box was sold that allowed PDP-8/E (OMNIBUS)
	memory to be added to a PDP-8/I.  Additionally, Fabritek sold a
	24K memory box for the 8/I and PDP-12.

Survival:  Many PDP-8/I systems are in operating condition.

------------------------------

Subject: What is a PDP-8/L?

Date of introduction:  1968 (announced before August '68)
Date of withdrawal:    1971.
Total production run:  3902.
Price: $8,500

Technology:  DEC M-series flip Chip modules, as in the PDP-8/I, with the
	same core memory as the 8/I, but with a memory cycle cycle of 1.6
	microseconds to avoid the speed problems that plagued early -8/I
	systems.

	The positive I/O bus, or posibus, was a 100 ohm bus clamped
	between 0 and 3 volts with TTL drivers and receivers.  This was
	packaged with 18 signal lines per 2-sided interconnect cable,
	using double-sided shielded mylar ribbon cable in most cases.
	Electrically, coaxial cable could be used, but the slots in the
	CPU box were too small for this.

Reason for introduction:  This machine was developed as a moderately
	successful exercise using M-series logic to produce a lower cost
	but moderately fast machine.  The idea was to cut costs by
	limiting provisions for expansion.

Reason for withdrawal:  The PDP-8/E made performance improvements while
	slightly undercutting the price of the PDP-8/L.

Compatability:  The core of the PDP-8 instruction set is present, but
	all Group 3 OPR instructions are no-ops, even the Group 3 version
	of the CLA instruction.  This is because there was no provision
	made for adding an EAE to this machine.  Microcoding RAR and RAL
	together works as in the PDP-8/I.  Finally, a new front panel
	feature was added, the protect switch.  When thrown, this makes
	the last page of the last field of memory read-only (to protect
	your bootstrap code).

	The instruction to change the data field on an 8/L becomes a
	no-op when the destination data field is non-existant; on all
	other machines, attempts to address non-existant fields are
	possible.  One option for expanding the 8/L was to add a box that
	allowed 8/E memory modules to be added to the 8/L; when this
	was done, access to nonexistant data fields becomes possible and
	always returns 0000 on read.

Standard configuration:  A CPU with 4K of memory, plus 110 baud current
	loop teletype interface was standard.  Both rack-mount and
	table-top versions were sold (both 9" high by 19" wide by 21"
	deep).  The backplane was on top, with modules plugged in from
	the bottom.  The rack-mount version could be slid out for
	maintenance.

Expandability:  The CPU supported a new bus standard, the PDP-8 posibus.
	There is little space for in-box peripherals, but an expander
	box with the same volume as the CPU was available, the BA08A;
	this was prewired to hold an additional 4K of memory and to
	support in-box peripheral interfaces for such devices as a
	Calcomp plotter interface, a card-reader interface, a 4 line
	asynch terminal interface, a real-time clock, and more.

	DEC eventually offered the BM12L, an 8K expansion box that is
	essentially the same as the MM8I, but using positive logic and
	thus incompatable with the -8/I and -12.  This allowed a total
	memory of 12K on a PDP-8/L.  This contains precisely the modules
	needed to upgrade a 4K PDP-8/I or PDP-12 to an 8K machine, or to
	populate an MM8I box to add 8K of additional memory to an 8/I or
	PDP-12.

	Finally, DEC eventually offered a box allowing PDP-8/E (OMNIBUS)
	memory to be used with the PDP-8/L.  PDP-8/L configurations with
	over 8K of memory were awkward because the front panel only
	showed one bit of the extended memory address.  As a result,
	extra lights and switches for the additional bits of the memory
	address were mounted on the front of the memory expander boxes
	for the large configurations.

	A variety of posibus peripherals were introduced, most of which
	were built with the option of negibus interface logic (the -P
	and -N suffixes on these new peripherals indicated which was
	which).  Many early PDP-8/L systems were sold with DW08A bus
	level converters to run old negibus peripherals.

	Posibus peripherals introduced after the PDP-8/L (and also used
	with posibus versions of the PDP-8/I) included:

	-- The TC08 DECtape controller (for 8 TU55 or 4 TU56).
	-- The DF32D fixed head disk controller (a posibus DF32).
	-- The FPP-12 floating point processor.
	-- The TR02 simple magnetic tape control.
	-- The RK08 disk subsystem, 4 disk packs, 831,488 words each.

Survival:  Many PDP-8/L systems are in operating condition.

------------------------------

Subject: What is a PDP-12?

Date of introduction:  1969 (February or earlier).
Date of withdrawal:    1973.
Total production run:  3500?
Price: $27,900

Technology:  DEC M-series flip Chip modules, as in the PDP-8/I.

Reason for introduction:  This machine was developed as a follow-up to
	the LINC-8.  Originally it was to be called the LINC-8/I, but
	somehow it got its own number.  In effect, it was a PDP-8/I with
	added logic to allow it to execute the LINC instruction set.

Reason for withdrawal:  The LAB-8/E and the LAB-11 (a PDP-8/E and a
	PDP-11/20 with lab peripherals) eventually proved the equal of
	the PDP-12 in practice, and LINC compatability eventually proved
	to be of insufficient value to keep the machine alive in the
	marketplace.
		
Compatability:  This machine is fully compatable with the PDP-8/I, with
	additional instructions to flip from PDP-8 mode to LINC mode and
	back.  IOT 0 could enable the API, causing trouble with later
	PDP-8 code that assumes IOT 0 is "Clear all flags".  Also, the
	DECtape instruction DTLA (6766) becomes part of a stack-oriented
	extension to the instruction set, PUSHJ, on late model (or field
	updated) machines with the KF12-B backplane.

	The PDP-12 supported trapping of those LINC functions that were
	emulated by software on the LINC-8.  This allowed it to run many
	LINC-8 bootable systems (but not all, due mostly incompatabilities
	in LINKtape support), and it allowed such things as emulation of
	LINKtape instructions for reading and writing disk.

	The TC12F Linktape controller could, with appropriate software,
	read or write DECtape.  This support is unreliable, and is not
	software compatable with the TC01 or TC08 DECtape controller.

Standard configuration:  PDP-8/LINC CPU with 4K of memory, plus 110 baud
	current loop interface, plus output relay registers.  In
	addition, the standard configuration included either two TU55 or
	one TU56 drive, with a PDP-12 only controller allowing it to
	handle LINCtape.  In addition, a 12" scope was always included,
	with a connector that can connect to a second scope.

Expandability:  An analog to digital converter and multiplexor was needed
	to fully support knob-oriented LINC software.

	Other options included:

	-- the KW12 programmable lab clock.
	-- additional TU55 or TU56 drives (up to 8 transports).
	-- the BA12 expander box
	-- the PC05 paper tape reader punch (needs the BA12).

	Fabritek made a 24K memory box that could be added to a PDP-8/I or
	PDP-12.

Survival:  A few PDP-12 systems are in operating condition.

------------------------------

Subject: What is a PDP-8/E?

Date of introduction:  1970 (during or before August).
Date of withdrawal:    1978.
Also known as:
	Industrial-8 (with a red color scheme)
	LAB-8/E (with a green color scheme)
Price: $7,390

Technology: SSI and MSI TTL logic were used on these boards, and the
	entire CPU fit on 3 boards.  Nominally, these were DEC M-series
	flip Chip modules, but in a new large format, quad-high (10.5
	inch), extended-length (9 inch, including card-edge connector,
	excluding handles).  The terms used for board height and length
	are based on the original working assumption that all flip-chips
	were plugged horizontally into a vertially mounted card-edge
	connector.  On the PDP-8/E, the cards were plugged vertically
	down into a horizontally mounted connector, so many users
	incorrectly refer to these boards as quad-wide double-high.

	Interconnection between boards was through a new bus, the OMNIBUS.
	This eliminated the need for a wire-wrapped backplane, since all
	slots in the bus were wired identically.  A new line of peripheral
	interfaces was produced, most being single cards that could be
	plugged directly into the inside the main enclosure.  These
	included a set of posibus adapters allowing use of older
	peripherals on the new machine.

	Interboard connectors were needed for some multiboard options,
	including the CPU and memory subsystems.  These used standard
	36-pin backplane connectors on the opposite side of the board
	from the backplane.  Some boards, notably memory boards, had a
	total of 8 connector fingers, 4 for the omnibus and 4 for
	interboard connectors.

	The core memory cycle time was 1.2 or 1.4 microseconds, depending
	on whether a read-modify-write cycle was involved (a jumper would
	slow all cycles to 1.4 microseconds).  A 4K core plane was
	packaged on a single quad-wide double-high board, with most of
	the drive electronics packed onto two adjacent boards.  Soon after
	the machine was introduced, an 8K core plane was released in the
	same format.

Reason for introduction:  The cost of the PDP-8/I and PDP-8/L was
	dominated by the cost of the interconnect wiring, and this cost
	was high as a result of the use of small circuit boards.  By
	packing a larger number of chips per board, similar function
	could be attained in a smaller volume because less interboard
	communication was required.  The PDP-8/E exploited this to achieve
	a new low in cost while attaining a new high in performance.

Reason for withdrawal:  This machine was slowly displaced by the PDP-8/A
	as the market for large PDP-8 configurations declined in the face
	of pressure from 16 bit mini and microcomputers.

Compatability:  As with the PDP-8/I and PDP-8/L, there are no limits on
	the combination of IAC and rotate instructions.  Unlike the early
	machines, basic Group 3 OPR operations for loading and storing
	the MQ register work even if there is no extended arithmetic
	element.  Finally, a new instruction was added, BSW; this swaps
	the left and right bytes in AC, and is encoded as a Group 1 OPR
	instruction using the "double the shift count bit".

	An odd quirk of this machine is that the RAL RAR combination ands
	the AC with the op-code, and the RTR RTL combination does an
	effective address computation loading the high 5 bits of AC with
	the current page and the lower bits of AC with the address field
	of the instruction itself!

	The EAE has a new mode, mode B.  Previous EAE designs were
	single-mode.  Mode B supports a large set of 24 bit operations
	and a somewhat more rational set of shift operations than the
	standard EAE.  All prior EAE designs would hang on the microcoded
	CLA NMI (clear/normalize) instruction applied to a nonzero AC.
	This instruction is redefined to be a mode changing instruction
	on the 8/E.

Standard configuration:  A CPU with 4K of memory, plus 110 baud current
	loop teletype interface.  Both a rack-mount table-top versions
	were sold (both 9" high by 19" wide by 21" deep).  The rack mount
	version was mounted on slides for easy maintenance.  The OMNIBUS
	backplane was on the bottom, with boards inserted from the top.

	The standard OMNIBUS backplane had 20 slots, with no fixed
	assignments, but the following conventional uses:

	-- KC8E programmer's console (lights and switches)
	-- M8300 \_ KK8E CPU registers
	-- M8310 /  KK8E CPU control
	--
	--
	-- M833  - Timing board (system clock)
	-- M865  - KL8E console terminal interface.
	--
	--
	--   -- space for more peripherals
	--
	--
	-- M849  - shield to isolate memory from CPU
	-- G104  \
	-- H220   > MM8E 4K memory
	-- G227  /
	--
	--   -- space for more memory
	--
	-- M8320 - KK8E Bus terminator

	Most of the early boards with 3 digit numbers were defective
	in one way or another, and the corrected boards added a trailing
	zero.  Thus, the M833 was generally replaced with an M8330, and
	the M865 was replaced with the M8650.

Expandability:  The following are among the OMNIBUS boards that could be
	added internally:

	-- M8650 - KL8E RS232 or current loop serial interface.
	-- M8340 \_ Extended arithmetic element.
	-- M8341 /  (must be attached in two slots adjacent to CPU.
	-- M8350 - KA8E posibus interface (excluding DMA transfers).
	-- M8360 - KD8E data break interface (one per DMA device).
	-- M837  - KM8E memory extension control (needed for over 4K).
	-- M840  - PC8E high speed paper tape reader-punch interface.
	-- M842  - XY8E X/Y plotter control.
	-- M843  - CR8E card reader interface.

	There were many other internal options.  There was room in the
	basic box for another 20 slot backplane; taking into account the
	2 slots occupied by the M935 bridge between the two backplanes,
	this allowed 38 slots, and a second box could be added to
	accomodate another 38 slot backplane, bridged to the first box by
	a pair of BC08H OMNIBUS extension cables.

	Given a M837 memory extension control, additional memory could be
	added in increments of 4K by adding G104, H220, G227 triplets.
	The suggested arrangement of boards on the OMNIBUS always
	maintained the M849 shield between memory other options.  The
	one exception was that the M8350 KA8E and M8360 KD8E external
	posibus interfaces were typically placed at the end of the
	OMNIBUS right before the terminator.

	The following options were introduced later, and there were many
	options offered by third party suppliers.

	-- G111  \
	-- H212   > MM8EJ 8K memory
	-- G233  /
	-- M8357 -- RX8E interface to RX01/02 8" diskette drives.
	-- M7104 \
	-- M7105  > RK8E RK05 Disk Interface
	-- M7106 /
	-- M8321 \
	-- M8322  \ TM8E Magtape control for 9 track tape.
	-- M8323  /
	-- M8327 /

	At one point, DEC packaged a PDP-8/E in a desk with no front panel
	controls other than power and bootstrap switch, along with an RX01
	accessable from the front and a VT50 on top.  This was sold as
	the Class-ic system, with an intended market in the classroom
	(hence the name); it was the forerunner, in terms of packaging,
	of many later DEC office products.

Survival:  It is still fairly common to find PDP-8/E systems on the
	surplus market, recently removed from service and in working
	condition or very close to it.  A modest number are no-doubt
	still in service, and there is still a limited amount of
	commercial support from both DEC and third-party vendors.

------------------------------

Subject: What is a PDP-8/F?

Date of introduction:  1972.
Date of withdrawal:    1978.

Technology:  an OMNIBUS machine, as with the PDP-8/E.  First use
	of a switching power supply in the PDP-8 family.

Reason for introduction:  The PDP-8/E had a large enough box and a large
	enough power supply to accomodate a large configuration.  By
	shortening the box and putting in a small switching power supply,
	a lower cost OMNIBUS machine was possible.

Reason for withdrawal:  The PDP-8/A 800 displaced this machine, providing
	similar expansion capability at a lower cost.

Compatability:  The PDP-8/F used the PDP-8/E CPU and peripherals.

Standard configuration:  Identical to the PDP-8/E, except that the KC8E
	front panel was replaced with a KC8M front panel that had LEDs
	instead of incandescent lights; this front panel could also be
	installed on PDP-8/E systems, but the PDP-8/E front panel could
	not be used on a PDP-8/F because of the lack of a +8 supply for
	the lights.  The original PDP-8/F box had a defective power
	supply, but a revised (slightly larger) box corrected this
	problem.

Expandability:  This machine could be expanded using all PDP-8/E OMNIBUS
	peripherals, including the external expansion chassis.  The
	relatively small internal power supply and the lack of room for
	a 20 slot bus expander inside the first box were the only
	limitations.  There were minor compatability problems with some
	options, for example, the power-fail auto-restart card, as
	originally sold, was incompatable with the PDP-8/F power supply.

Survival:  As with the PDP-8/E, these machines are moderately common on
	the surplus market, and frequently in working condition.

------------------------------

Subject: What is a PDP-8/M?

Date of introduction:  1972.
Date of withdrawal:    1978.

Technology:  This machine was a PDP-8/F (with a PDP-8/E CPU)

Reason for introduction:  DEC knew that OEM customers were an important
	market, so they packaged the PDP-8/F for this market, with no
	hardware changes behind the front panel.

Reason for withdrawal:  Same as the PDP-8/F

Compatability:  The PDP-8/M used the PDP-8/E CPU and peripherals.

Standard configuration:  Identical to the PDP-8/F, except that the KC8M
	front panel was replaced with a minimal function panel and the
	color scheme was different.  Because of this, one of the following
	options were required:

	-- M848  -- KP8E Power fail and auto-restart.
	-- M847  -- MI8E Hardware Bootstrap Loader.

	Expandability:  All options applying to the PDP-8/F applied.  In
	addition, the KC8M front panel (standard with the PDP-8/F) was
	available as an option.

Survival:  As with the PDP-8/F.

------------------------------

Subject: What is a PDP-8/A?

Date of introduction:  1975
Date of withdrawal:    1984
Also known as:
	DECdatasystem 310 (an 8/A 500 sold as a word-processor)

Technology:  This machine used the OMNIBUS with a new single-board CPU.
	The backplane was reoriented so that boards plugged into it from
	the front, with the board held horizontally.

Reason for introduction:  Using TTL MSI and LSI components, DEC was able
	to reduce the PDP-8 CPU to a single oversize board (formally, hex
	height, double width).  Similarly, they were able to make an 4K
	core memory board, and later, an 8K board in this format, and they
	were able to introduce a static RAM card using semiconductor
	memory.  The minimum system was reduced to 3 boards.

	The market for the PDP-8 was dominated by small systems, with
	fewer and fewer customers needing large-scale expandability.
	Thus, the 20 slot backplane of the early Omnibus machines was too
	big; with the new single board CPU and memory, a 12 slot backplane
	was enough, allowing further cost reductions.

Reason for withdrawal:  The market for the PDP-8 family was shrinking in
	the face of pressure from larger minicomputers and the new
	monolithic microcomputers.  After 1975, many PDP-8 sales were to
	captive customers who had sufficient software investments that
	they could not afford to move.  Only the word-processing and
	small business markets remained strong for first-time PDP-8
	sales, and in these, the specialized DEC VT-78 and DECmate
	machines were more cost effective than the open architecture
	OMNIBUS machines.
		
Compatability:  The new PDP-8/A CPU was largely compatable with the
	PDP-8/E CPU, except that the combination of RTR and RTL (Group 1
	OPR instructions) loaded the next address.  The power-fail
	auto-restart option included the standard skip on power low
	instruction, but also a new skip on battery empty instruction to
	test the battery used for back-up power on the new solid state
	memory.

	The standard parallel port on the M8316 port was not software
	compatable with the earlier line-printer interfaces used with
	device code 66.

Standard configuration:  The PDP-8/A was sold with a new short OMNIBUS
	backplane, mounted on its side above a power supply and a
	battery to back up the solid state memory.  The minimum
	configuration included a limited function control panel and the
	following components on the bus:

	-- M8315 -- KK8A CPU board
	-- M???? -- MS8A 1K to 4K solid state memory.
	-- M???? -- MR8A ROM companion for the MS8A.
	-- M8316 -- DKC8AA serial/parallel interface and clock.

	The M8316 board contained a remarkable but useful hodgepodge of
	commonly used peripherals, including the console terminal
	interface, a parallel port, the power/fail auto-restart logic,
	and a 100 Hz real time clock.

	The original configuration sold had a 10 slot backplane and a
	poor power supply.  The later base model had a 12 slot backplane,
	the 8/A 400.

Expandability:  All PDP-8/E peripherals and options could be used with
	the PDP-8/A.  The KK8A cpu was not as fast as the KK8E used in
	the PDP-8/E, but the KK8E CPU could be substituted for the KK8A
	CPU, and many PDP-8/A systems were sold with this substitution.

	A box with a 20 slot backplane, the 8/A 600, was available for
	large configurations.  A pair of PDP-8/A backplanes could be
	connected using BC08H cables, and there was a special cable,
	the BC80C, for connecting a hex wide 8A backplane to a PDP-8/E,
	-8/F or -8/M backplane.

	By late 1975, the PDP-8/A was being sold in a workstation
	configuration, with the CPU and dual 8" diskette drives in a desk
	with a video terminal (VT52) and letter quality printer on top.
	This followed the pattern set by the Class-ic packaging of the
	PDP-8/E, but it was aimed at the word-processing market.

	The following additional PDP-8/A (hex) boards were offered:

	-- G649  \_ MM8AA 8K Core stack (too slow for 8/E CPU!).
	-- H219A /  MM8AA 8K Core memory control.
	-- G650  \_ MM8AB 16K Core stack (ok for 8/E CPU!).
	-- H219B /  MM8AB 16K Core memory control.
	-- M???? -- MR8F 1K ROM (overlayable with core).
	-- M8317 -- KM8A memory extender (with variations).
	-- M8319 -- KL8A 4 channel RS232 or current loop serial I/O.
	-- M8433 -- RL8A controller for 1 to 4 RL01/RL02 disk drives.
	-- M???? -- FPP8A floating point processor.

	The PDP-8/A model 800 was the same as the model 600, but with the
	FPP8A floating point processor included as part of the package.

	-- M8416 -- KT8AA Memory management unit for up to 128K.
	--       -- KC8AA Programmer's Console (requires M8316)
	-- M8417 -- MSC8DJ 128K DRAM MOS Memory.

	Note that memory extension to 128K was a new PDP-8/A feature that
	was necessarily incompatable with the older PDP-8 memory expansion
	options, although the conventional PDP-8 memory expansion
	instructions still operate correctly on the first 32K.  Access to
	additional fields involved borrowing IOT instructions that were
	previously dedicated to other devices.

	The MM8A options require the use of a box with a -20V power supply.
	Also, the use of the MSC8 DRAM memory cards requires a CPU that
	supports the memory stall signal, early PDP-8/E CPUs did not.

Survival:  As with the PDP-8/E, these machines are moderately common on the
	surplus market and a modest number are still in use.  Because the
	original machines were less expensive than and slower than 8/E,
	they are more likely to be simply discarded instead of sold as
	surplus.

------------------------------

Subject: What is a VT78?

Date of introduction:  1978
Date of withdrawal:    1980 (Displaced by the DECmate)
Also known as:  DECstation 78 

Technology:  Based on the Intersil/Harris 6120 microprocessor, packaged
	in a VT52 case.  The 6120 processor was able to run at 4 MHz, but
	in the VT78, it was only clocked at 2.2 MHz because of the speed
	of the DRAM used and the deliberate use of graded out chips.

Reason for introduction:  Using TTL MSI and LSI components, DEC could
	pack a system into vacant space in a standard terminal case,
	allowing PDP-8 systems to compete with personal computers in the
	small business and office automation market.  This was a natural
	follow-on to the desk-mounted workstation configurations in which
	the PDP-8/A was already being sold.

Compatability:  The Group I OPR combinations RAL RAR and RTL RTR are
	no-ops.  Unlike all earlier PDP-8 models, autoindex locations
	10 to 17 (octal) only work in page zero mode; these operate like
	all other memory locations when addressed in current page mode
	from code running on page zero.  Other than this, it is fully
	PDP-8/E compatable, even at the level of I/O instructions for
	the standard periperals; this was the last PDP-8 to offer this
	level of compatability.

	It was not possible to continue from a halt without restarting
	the machine.  In addition, none of the peripherals available on
	this machine needed DMA (data break) transfers.

Standard configuration:  The VT78 was sold with 16k words of DRAM with
	the keyboard and display of the VT52 terminal.  An RX01 dual 8"
	diskette drive was standard, packaged in the pedestal under the
	terminal.  The console (device 03/04) and the serial ports
	(devices 30/31 and 32/33) are compatible with the M8650 KL8E,
	with the latter extended to allow software controlled baud rate
	selection.  There are two parallel ports; device 66 (compatible
	with the M8365 printer controller) and device 47, compatible with
	the nonstandard port on the M8316 DKC8AA.  There is also a 100Hz
	clock compatible with the clock on the M8316 DKC8AA.

	The standard ROM boots the system from the RX01 after setting the
	baud rates to match that selected by the switches on the bottom
	of the VT52 case.

Expandability:  This was a closed system, with few options.  The base
	configuration was able to support two RX01 drives (later RX02),
	for a total of 4 transports.  Various boot ROM's were available,
	including a paper-tape RIM loader ROM for loading diagnostics
	from tape.  Another ROM boots the system from a PDP-11 server in
	the client/server configuration used by WPS-11.

Survival:  There are probably many VT78 systems still in use.
	

------------------------------

Subject: What is a DECmate I?

Date of introduction:  1980
Date of withdrawal:    1984 (Phased out in favor of the DECmate II)
Also known as:  DECmate (prior to the DECmate II, no suffix was used)
		VT278

Technology:  Based on the Intersil/Harris 6120 microprocessor,
	packaged in a VT-100 box with keyboard and display.

Reason for introduction:  This machine was aimed primarily at the market
	originally opened by the VT78, using the IM6120 as a substitute
	for the older 6100 chip and optimizing for minimum cost and mass
	production efficiency.

Compatability:  A new feature was introduced in the 6120 microprocessor:
	The Group I OPR combination RAL RAR was defined as R3L, or rotate
	accumulator 3 places left, so that byte swap (BSW) is equivalent
	to R3L;R3L.  RTR RTL remained a no-op, as in the 6100.

	Also, the EAE operations not implemented in the basic CPU cause
	the CPU to hang awaiting completion of the operation by a
	coprocessor.  Unfortunately, no EAE coprocessor was ever offered.

	The printer port offered software baud-rate selection compatable
	with the VT78 baud-rate selection scheme.  The dual-port data
	communications option was flexible but completely incompatable
	with all previous PDP-8 serial ports.

	The console and printer ports are not fully compatable with the
	earlier PDP-8 serial ports.  Specifically, on earlier serial
	interfaces, it was possible to test flags without resetting them,
	but on the DECmate machines, testing the keyboard input flag
	always resets the flag as a side effect.  In addition, on the
	console port, every successful test of the flag must be followed
	by reading a character or the flag will never be set again.

	It was not possible to continue from a halt without restarting
	the machine.

	The large amount of device emulation performed by the CPU in
	supporting screen updates severely limits the ability of the
	system to run in real time.

Standard configuration:  The DECmate I was sold with 32k words of memory,
	with a small control memory added to handle control/status,
	console device emulation and boot options.  The console terminal
	keyboard and display functions are largely supported by code
	running in control memory (a less expensive alternative to
	dedicating hardware for this, as was done in the VT78).

	The DECmate I came with an integral printer port, compatable with
	the VT78 (device 32/33), and it had an RX02 dual 8 inch diskette
	drive, mounted in the short pedistal under the terminal/CPU box.
	A 100Hz clock was included, as in the VT78 and PDP-8/A.

Expandability:  This was a closed system, with limited options.
	Specifically, a second RX02 could be connected (or an RX01,
	because that had a compatable connector), the DP278A and DP278B
	communications boards (really the same board, but the DP278B had
	2 extra chips), and the RL-278 disk controller, able to accomodate
	from 1 to 4 RL02 rack mount disk drives.

	When the DP278A option is added, additional routines in control
	memory come alive to handle terminal emulaton and allow diskless
	operation.  The terminal emulator is an extended VT100 subset
	that is essentially compatable in 80 column mode.  The DP278A
	option could support both asynchronous and synchronous protocols,
	and the DP278B could handle SDLC and other nasty bit-stuffing
	protocols.

	Various pedestal and desk configurations were sold for housing
	the RX01 and RX02 drives, most being teacart style designs, but
	there was also a pedestal version that was essentially a
	repackaging of the RX02 with either 2 or 4 new 8 inch disk
	transports (physically incompatable with earlier DEC transports).

Survival:  Many DECmates are still in use, and they are fairly common on
	the surplus market.  They are found in small numbers just about
	anywhere large numbers of early PC vintage machines are found.

------------------------------

Subject: What is a DECmate II?

Date of introduction:  1982
Date of withdrawal:    1986 
Price: $1,435

Technology:  Based on the 6120 microprocessor, this shared the same
	packaging as DEC's other competitors in the PC market, the
	Rainbow (8088 based) and the PRO-325 (PDP-11 based).

Reason for introduction:  This machine was introduced in order to allow
	more flexibility than the DECmate I and to allow more sharing of
	parts with the VT220 and DEC's other personal computers.

Compatability:  Same as the DECmate I, except it could continue from a
	halt.  There was better hardware for device emulation support,
	allowing for somewhat better real-time performance.  The data
	communications port was an incompatable improvement on the
	incompatable DECmate I communications port.  No built-in terminal
	emulation was provided, and the data communications port supported
	only one line, but aside from this, the data communications port
	is essentially as powerful as the DP-278B on the DECmate I.

Standard Configuration:  The DECmate II was sold with 32K of program
	memory, plus a second full bank for dedicated control panel
	function emulation.  Code running in the second bank is sometimes
	referred to as slushware; it looks like hardware to the PDP-8
	user, but it is actually device emulation software that is loaded
	from the boot diskette.

	An integral RX50 dual 5 1/4 inch diskette drive with an 8051
	controller chip was included, along with a printer port, a 100Hz
	real-time clock, single data communications port, and interfaces
	to the monitor and keyboard.  The diskette drive can read
	single-sided 48 track-per-inch diskettes, so it might be possible
	to read (but not write) IBM PC diskettes on it.

Expandability:  This was the most open of the DECmate systems, with a
	number of disk options:  An additional pair of RX50 drives could
	be added, and with the RX78 board, it could support a pair of
	dual 8 inch drives, either RX01 or RX02.

	As an alternative to the RX78, there was a controller for an
	MFM hard drive.  The interface to the RX78 board wasn't fully
	compatable with earlier interfaces to RX01 and RX02, and there
	was no way to have both an RX78 and an MFM drive.  The MFM drive
	could be up to 64 MB, with 16 sectors per track, 512 bytes each
	and at most 8 heads and 1024 (or possibly 4096) cylinders.  A
	power supply upgrade was needed to support the MFM drive.  DEC
	sold this machine with 5, 10 and 20 meg hard drives, Seagate
	ST-506, 412, and 225 respectively.

	A graphics board supporting a color monitor could be added in
	addition to the monochrome console display; two variants of
	this board were produced during the production run, all slightly
	incompatable.

	A coprocessor board could be added, with communication to and
	from the coprocessor through device 14.  DEC sold three boards,
	an APU board (Z80 and 64K), and two XPU boards (Z80, 8086 and
	either 256K or 512K).  If these added processors are used, the
	6120 processor is usually used as an I/O server for whatever
	ran on the coprocessor.  The XPU boards used a Z80 for I/O
	support, so 8086 I/O was very indirect, particularly if it
	involved I/O to a PDP-8 device that was emulated from control
	memory.  Despite this, the DECmate version of MS/DOS is generally
	faster than MS/DOS on more recent 80286 and 80386 based IBM PCs
	because of effective use of the coprocessors (but they couldn't
	run MS/DOS code that bypasses MS/DOS for I/O).

Survival:  As with the DECmate I.

------------------------------

Subject: What is a DECmate III?

Date of introduction:  1984
Date of withdrawal:    1990 
Price: $2,695

Technology:  Same as the DECmate II.

Reason for introduction:  Again, DEC discovered that the market for large
	systems was dominated by other products, and that the PDP-8 based
	products were rarely expanded to their full potential.  Thus,
	there was no point in paying the price for expandability.

Compatability:  Same as the DECmate II, except that the printer port is
	fixed at 4800 baud.

Standard Configuration:  The DECmate III was sold with 32K of program
	memory, plus a second full bank for dedicated control panel
	functions, an integral RX50 dual 5 1/4 inch diskette drive with
	an 8051 controller chip, a printer port, a 100Hz real-time-clock,
	a data communications port, and interfaces for the VR-201 monitor
	and keyboard.

Expandability:  A revised version of the Z80 based coprocessor for the
	DECmate II was available, and a graphics board largely compatable
	with the later DECmate II graphics board could be added allowing
	the standard monochrome monitor to be replaced with a VR-241 color
	monitor.  Two monitor configurations were not supported.  An
	obscure variant of the DEC scholar modem was also supported as
	an option.

Survival:  As with the DECmate I.

------------------------------

Subject: What is a DECmate III+?

Date of introduction:  1985
Date of withdrawal:    1990 

Technology:  Same as the DECmate II.

Reason for introduction:  This machine apparently represents the last
	gasp of the PDP-8, hunting for the remains of the ever-shrinking
	market niche that the earlier DECmates had carved out.  The
	market niche was not there, and the production runs for this
	machine were short enough that UV erasable EPROM technology was
	used where earlier DECmates had used mask programmed chips.

Compatability:  Same as the DECmate II, but the machine was unable to
	read 48 track per inch IBM formatted diskettes.  Again the
	printer port was fixed at 4800 baud.

Standard Configuration:  The DECmate III+ was sold with 32K of program
	memory, plus a second bank for dedicated control panel functions,
	an integral RX33 single 5 1/4 inch diskette drive with an 8751
	controller chip, a printer port, a data communications port and
	interfaces to the monitor and keyboard.  A hard disk controller
	compatable with the optional one on the DECmate II was included,
	supporting an integral ST-225 20 MB disk; it is likely that it
	can only handle up to 1024 cylinders, but it is otherwise
	compatable with the DECmate II.

Expandability: The same coprocessor option sold with the DECmate III was
	available, but because of the difficulty of adding a second floppy
	drive, this was rarely used (the Z80 was most likely to be used
	to run CP/M, but that system requires two drives to handle the
	installation procedure; an appropriately configured bootable
	image created on a DECmate II or III could run on a DECmate III+).

	The same graphics board as used on the DECmate III was also
	available.  The circuit traces and connectors for the Scholar
	modem are present, but this option was never sold on the
	DECmate III+.

Survival:  As with the other DECmates.

------------------------------

End of PDP-8 Summary of Models and Options (posted every other month)
*********************************************************************


