

{
 Fuzzy Logic Project by Tom Davis and Mark Feeney.              1996.06.10

 What it does:

      This program attempts to simulate a furnace with a fuzzy logic
      controlled thermostat.  The initial settings are room temperature,
      the temperature of the air surrounding the room, and the target
      temperature for the furnace to maintain.

      The main loop of the program works as follows:

          time increases one interval
          the temperature of the room is "adjusted" by the equation:
              t2 = t1 + rate * time
            which is a basic rate of change equation.
          the furnace examines the environment and changes its rate of
            heating or cooling appropriately.
          output of numbers or graphics
          the loop starts again.

      We attempted to incorporate Newton's law of cooling into the
      temperature equation.  This proved far more difficult than we
      originally thought, and we are still unsure of whether or not it works.

      The furnace works on truth values for cold and hot, which are fuzzy
      sets.

      We are unsure whether or not the program is actually working.  It
      gives us strange results.  When Newton's law isn't incorporated, the
      furnace works too perfectly.  It approaches the target temperature,
      but never allows a fluctuation above that number.  We think part of the
      problem could be using the real number data type in Pascal.  It has
      accuracy +/- 2^63 (I believe).  The furnace/thermostat is too accurate.
      When we attempt to incorporate Newton's law, another interesting result
      is observed:  an equilibrium.  The furnace attempts to get to the
      target temeprature, but Newton's law won't always let it.  For example,
      if the aim is 20 degrees, an equilibrium at 19.2 might be achieved.
      The furnace isn't powerful enough to heat the room before Newton's law
      cools it.

      There is no graphical output (yet) becuase we aren't satisfied that
      its working 100% correctly.
 }
program Heat;

uses graph,crt;
const
     aim = 20;
     cold = 1;
     hot = 2;
     upper = 1;
     lower = 2;
     color = 4;
     xoffset = 0;
     yoffset = 0;
     e = 2.718281828459045;
     k = -0.020202707;
     ek = 0.98;
var{global}
           current:real;        {temp in Cel.}
           rate:real;           {rate of change of temp
                                in deg/unit of time}
           surroundTemp:real;   {the outside temp, so the room
                                naturally changes due to its
                                surroundings}
           temp: array[1..2, 1..2] of integer;
           m:array[1..2] of real;  {slopes of lines}
           b:array[1..2] of real;  {b-value of lines}

function pwr(x,y:real):real;
   var
      count:integer;
      i:longint;
      ans:real;
   begin
     i:=round(y);
     ans:=1;
     for count:=1 to i do
         ans:=ans*x;
     pwr:=ans;
   end;


procedure setUp;
var
   gd,gm:integer;
   i:integer;

begin
{
     gd:=VGA;
     gm:=VGALo;
     initgraph(gd,gm,'\tp\bgi\');
 }
     current:=12;
     surroundTemp := 15;
     rate:=0;
     temp[hot,upper]:=30;
     temp[hot,lower]:=15;
     temp[cold,upper]:=25;
     temp[cold,lower]:=10;
     for i:=1 to 2 do
         m[i]:=(pwr(-1,i-1))/(temp[i,lower]-temp[i,upper]);
     b[hot]:=1-m[hot]*temp[hot,upper];
     b[cold]:=1-m[cold]*temp[cold,lower];

end;

function changeHeat(time:real):real;
begin
{     if rate <> 0 then changeHeat:=current+(rate)
     else changeHeat:= (current-surroundTemp)*pwr(e,k)+surroundTemp;
}
        changeHeat:=(current+rate)-(current-((current-surroundTemp)*ek+surroundTemp));

end;

function truth(x:integer):real;
begin
{
        calc slope *
        find y (truth) for x value (temp)
        return truth
        fix y=mx+b

}
        if x=hot then
           begin
            if current > temp[hot,upper] then truth:=1;
            if current < temp[cold,lower] then truth:=0;
            if (current < temp[hot,upper]) and (current > temp[cold,lower]) then truth:=m[x]*current+b[x];
           end;
        if x=cold then
           begin
            if current < temp[cold,lower] then truth:=1;
            if current > temp[hot,upper] then truth:=0;
            if (current > temp[cold,lower]) and (current < temp[hot,upper]) then truth:=m[x]*current+b[x];
           end;
end;

function changeRate:real;
begin

     writeln('Truth cold: ',truth(cold));
     writeln('Truth hot : ',truth(hot));

     changeRate := truth(cold) - truth(hot);

     writeln('Changed rate (cold-hot): ', (truth(cold)-truth(hot)));

end;

procedure plot(x,y:real);
var
   x1,y1:integer;
begin

     x1:=round(x);
     y1:=round(y);
     putpixel(x1,y1,color);

end;

var
   time:real;
   s:string;
   action:integer;
   theEndOfTime : boolean;
   dummy : string;
   i:integer;

begin
     setUp;


     theEndOfTime := false;
     repeat
           clrscr;
           time:=1;
           current:=changeHeat(time);
           writeln('Current : ',current);
           writeln('Old Rate: ',rate);
           rate:=changeRate;
           writeln('Rate after changerate: ',rate);
           readln(dummy);

           {plot(current,time);}


     until theEndOfTime;


end.
