//
// GA Demo
//
// Copyright Cygron Ltd 1997.
//

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ga, ExtCtrls;

const
  MIN = 5;  // min objects
  MAX = 30; // max objects (if you have registered version you can increase it)
  THRESHOLD = 0.3;  // bag size is THRESHOLD*SUM

type
  TForm1 = class(TForm)
    GeneticAlg1: TGeneticAlg;
    Panel1: TPanel;
    ProgressBar1: TProgressBar;
    ButtonStep: TButton;
    ButtonReset: TButton;
    TrackBar1: TTrackBar;
    Label1: TLabel;
    Panel2: TPanel;
    ListBox1: TListBox;
    ListBox2: TListBox;
    Panel3: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    function GeneticAlg1Born: Pointer;
    function GeneticAlg1Fitness(x: Pointer): Double;
    procedure FormCreate(Sender: TObject);
    procedure ButtonResetClick(Sender: TObject);
    procedure ButtonStepClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
  public
    n: Word;  // number of objects
    objs: array[1..MAX,1..2] of Word; // object sizes and values
    sum: Word;  // sum of sizes
    procedure RandomObjs;
    procedure Show;
    procedure ShowInds;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

//////////////////////////////////////////////////////////////////////
// create random objects
procedure TForm1.RandomObjs;
var
  i: Word;
begin
  Randomize;
  sum := 0;
  for i := 1 to n do begin
    objs[i,1] := Random(100);  // size
    objs[i,2] := Random(100);  // value
    sum := sum + objs[i,1];
  end;
end;

//////////////////////////////////////////////////////////////////////
// show object's best individual
procedure TForm1.Show;
var
  s: String;
  i: Word;
  x: Word;
begin
  ListBox1.Clear;
  s := 'Size    Value   Pack this?';
  Listbox1.Items.Add(s);
  x := 0;
  for i := 1 to n do begin
    s := '';
    s := s + Format('%3d',[objs[i,1]]);
    s := s + Format('     %3d     ',[objs[i,2]]);
    if TFixStringInd(GeneticAlg1.Individuals[0]).GetGene(i)=1 then s := s+'Yes' else s:=s+'No';
    if TFixStringInd(GeneticAlg1.Individuals[0]).GetGene(i)=1
    then x := x + objs[i,1];
    Listbox1.Items.Add(s);
  end;
  Listbox1.Items.Add('');
  Listbox1.Items.Add('size limit = '+ Format('%.0f',[sum*THRESHOLD]));
  Listbox1.Items.Add('');
  Listbox1.Items.Add('sum of sizes = '+ Format('%d',[x]));
  Listbox1.Items.Add('sum of values = '+ Format('%.0f',[TFixStringInd(GeneticAlg1.Individuals[0]).m_Fitness]));
end;

//////////////////////////////////////////////////////////////////////
// show population
procedure TForm1.ShowInds;
var
  i: word;
  s: String;
  x: TFixStringInd;
begin
  ListBox2.Clear;
  for i := 1 to GeneticAlg1.Size do begin
    x := TFixStringInd(GeneticAlg1.Individuals[i-1]);
    s := x.toString('');
    s := s + ' :'+ Format('%.f',[x.m_Fitness]);
    ListBox2.Items.Add(s);
  end;
end;

//////////////////////////////////////////////////////////////////////
// OnBorn
function TForm1.GeneticAlg1Born: Pointer;
begin
  Result := TFixStringInd.Create(n,0,1);
end;

//////////////////////////////////////////////////////////////////////
// OnFitness
function TForm1.GeneticAlg1Fitness(x: Pointer): Double;
var
  i: Word;
  size,value: Word;
begin
  size := 0;
  value := 0;
  for i := 1 to n do begin
    if TFixStringInd(x).GetGene(i)=1
    then begin
      size := size + objs[i,1];
      value := value + objs[i,2];
    end;
  end;
  if size > sum*THRESHOLD
  then Result := 0
  else Result := value;
end;

//////////////////////////////////////////////////////////////////////
// FormCreate
procedure TForm1.FormCreate(Sender: TObject);
begin
  TrackBar1.Min := MIN;
  TrackBar1.Max := MAX;
  TrackBar1.Position := 5;
  TrackBar1Change(self);
end;

//////////////////////////////////////////////////////////////////////
// Reset the population
procedure TForm1.ButtonResetClick(Sender: TObject);
begin
  GeneticAlg1.Reset;
  Show;
  ShowInds;
end;

//////////////////////////////////////////////////////////////////////
// Step 10
procedure TForm1.ButtonStepClick(Sender: TObject);
var
  i: Integer;
begin
  for i := 1 to 10 do begin
    GeneticAlg1.Step;
    ProgressBar1.Position := 10*i;
  end;
  Show;
  ShowInds;
  ProgressBar1.Position := 0;
end;

//////////////////////////////////////////////////////////////////////
// TrackbarChange
procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  n := TrackBar1.Position;
  RandomObjs;
  ButtonResetClick(self);
  label1.Caption := 'N='+IntToStr(n);
end;

end.
